/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.jidesoft.swing.Gripper;
import com.mathworks.mlwidgets.actionbrowser.TearOffAble;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class DragableGripper
extends Gripper {
    private MPopup fTipPopup = null;
    private boolean fIsGripTooltipShowing = false;
    private boolean fDragInProgress = false;

    public DragableGripper(final TearOffAble tearOffAble, final String string) {
        this.setOrientation(1);
        this.setRolloverEnabled(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!DragableGripper.this.fDragInProgress) {
                    tearOffAble.makeFloating();
                    DragableGripper.this.fDragInProgress = true;
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (DragableGripper.this.fTipPopup == null || !DragableGripper.this.fIsGripTooltipShowing) {
                    MJLabel mJLabel = new MJLabel(string);
                    mJLabel.setOpaque(true);
                    mJLabel.setBorder(BorderFactory.createLineBorder(Color.black));
                    mJLabel.setBackground((Color)SystemColor.info);
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, (Component)((Object)DragableGripper.this));
                    DragableGripper.this.fTipPopup = MPopup.getPopup((Component)((Object)DragableGripper.this), (Component)mJLabel, (int)(point.x + 10), (int)(point.y + 10));
                    DragableGripper.this.fTipPopup.show();
                    DragableGripper.this.fIsGripTooltipShowing = true;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (DragableGripper.this.fDragInProgress) {
                    tearOffAble.floatingComplete();
                }
                DragableGripper.this.fDragInProgress = false;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (DragableGripper.this.fTipPopup != null && DragableGripper.this.fIsGripTooltipShowing) {
                    DragableGripper.this.fTipPopup.hide();
                    DragableGripper.this.fIsGripTooltipShowing = false;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!DragableGripper.this.fDragInProgress) {
                    tearOffAble.makeFloating();
                    DragableGripper.this.fDragInProgress = true;
                }
            }
        });
    }
}

