/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

class LightScrollBarUI
extends BasicScrollBarUI {
    private static Color TOOLTIPCOLOR = UIManager.getColor("ToolTip.background");

    LightScrollBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LightScrollBarUI();
    }

    @Override
    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
        this.thumbHighlightColor = TOOLTIPCOLOR;
        this.thumbLightShadowColor = TOOLTIPCOLOR;
        this.thumbDarkShadowColor = TOOLTIPCOLOR;
        this.thumbColor = TOOLTIPCOLOR;
        this.trackColor = Color.white;
        this.trackHighlightColor = TOOLTIPCOLOR;
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        MJButton mJButton = new MJButton((Icon)new ImageIcon(this.getClass().getResource("/com/mathworks/mlwidgets/actionbrowser/resources/downarrow.png")));
        mJButton.setOpaque(true);
        mJButton.setBackground(Color.white);
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return mJButton;
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        MJButton mJButton = new MJButton((Icon)new ImageIcon(this.getClass().getResource("/com/mathworks/mlwidgets/actionbrowser/resources/uparrow.png")));
        mJButton.setOpaque(true);
        mJButton.setBackground(Color.white);
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return mJButton;
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        Color color = Color.gray;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(color);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(TOOLTIPCOLOR);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

