/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class MACCornerGrip
extends JComponent {
    private static GhostWindow sGhostWindow = null;
    private static final int MAC_HEIGHT = 16;
    private static final int MAC_WIDTH = 16;
    private static final String UI_CLASS_ID = "MACCornerGripUI";
    private static final Color MAC_STRIPE_COLOR = new Color(125, 125, 125);
    private static String sWindowName;

    public static MACCornerGrip createAlwaysVisibleCornerGrip() {
        return new MACCornerGrip();
    }

    MACCornerGrip() {
        this.updateUI();
    }

    private Component getComponentToResize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Window) && !(container instanceof JInternalFrame); container = container.getParent()) {
        }
        return container;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    private static void tagGhostWindow(MJFrame mJFrame) {
        mJFrame.setName(sWindowName);
    }

    public static boolean isGhostWindow(MJFrame mJFrame) {
        return mJFrame != null && sGhostWindow != null && sWindowName.equals(mJFrame.getName());
    }

    static {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put(UI_CLASS_ID, "com.mathworks.mlwidgets.actionbrowser.MACCornerGrip$MacUI");
        sWindowName = "MACCornerGripWindow";
    }

    private static class GhostWindow
    extends MJFrame {
        GhostWindow() {
            this.setUndecorated(true);
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            ((JComponent)this.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.gray, 3));
            ((JComponent)this.getContentPane()).setOpaque(false);
            this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        }
    }

    public static class MacUI
    extends ComponentUI {
        protected MouseInputListener fMouseListener = new CornerMouseListener();

        @Override
        public void installUI(JComponent jComponent) {
            jComponent.addMouseListener(this.fMouseListener);
            jComponent.addMouseMotionListener(this.fMouseListener);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            jComponent.removeMouseListener(this.fMouseListener);
            jComponent.removeMouseMotionListener(this.fMouseListener);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return new MacUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return new Dimension(16, 16);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Color color = graphics.getColor();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.setColor(MAC_STRIPE_COLOR);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = n - 11;
            int n4 = n2 - 2;
            int n5 = n - 2;
            int n6 = n2 - 11;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n3, n4, n5, n6);
                n3 += 4;
                n6 += 4;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.setColor(color);
        }

        private static class CornerMouseListener
        extends MouseInputAdapter {
            private Point fLastPoint;
            private Component fResizeComponent;
            private boolean fChangedBounds;

            private CornerMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.fLastPoint = mouseEvent.getPoint();
                MACCornerGrip mACCornerGrip = (MACCornerGrip)mouseEvent.getSource();
                SwingUtilities.convertPointToScreen(this.fLastPoint, mACCornerGrip);
                this.fResizeComponent = mACCornerGrip.getComponentToResize();
                MJDialog mJDialog = (MJDialog)this.fResizeComponent;
                if (sGhostWindow == null) {
                    assert (EventQueue.isDispatchThread());
                    sGhostWindow = new GhostWindow();
                    MACCornerGrip.tagGhostWindow(sGhostWindow);
                }
                sGhostWindow.setBounds(mJDialog.getBounds());
                sGhostWindow.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (sGhostWindow != null) {
                    sGhostWindow.setVisible(false);
                    this.fResizeComponent.setBounds(sGhostWindow.getBounds());
                }
                if (this.fChangedBounds) {
                    this.fResizeComponent.invalidate();
                    this.fResizeComponent.validate();
                    this.fResizeComponent.repaint();
                    this.fChangedBounds = false;
                }
                this.fResizeComponent = null;
                this.fLastPoint = null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.fResizeComponent == null) {
                    return;
                }
                MACCornerGrip mACCornerGrip = (MACCornerGrip)mouseEvent.getSource();
                if (this.fLastPoint == null) {
                    this.fLastPoint = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(this.fLastPoint, mACCornerGrip);
                    return;
                }
                Point point = mouseEvent.getPoint();
                ++point.x;
                ++point.y;
                SwingUtilities.convertPointToScreen(point, mACCornerGrip);
                int n = sGhostWindow.getWidth();
                int n2 = sGhostWindow.getHeight();
                sGhostWindow.setSize(n += point.x - this.fLastPoint.x, n2 += point.y - this.fLastPoint.y);
                sGhostWindow.invalidate();
                sGhostWindow.validate();
                this.fChangedBounds = true;
                this.fLastPoint = point;
            }
        }
    }
}

