/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.EditableValue;
import com.mathworks.mlwidgets.array.RefreshableVariableLiteral;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IPrintingOpProvider;
import com.mathworks.widgets.spreadsheet.ISaveOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.print.MultiHeaderSpreadsheetPrinter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.util.List;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

abstract class AbstractMatlabTable
extends SpreadsheetTable
implements ISaveOpProvider,
IPrintingOpProvider,
EditableValue,
UpdatableData {
    private final MJAbstractAction fSaveAction;
    private final MJAbstractAction fPrintAction;
    private final MJAbstractAction fPrintSelectionAction;
    private final MJAbstractAction fPageSetupAction;
    protected AbstractMatlabTableModel fAMTM;
    private boolean fUseMinimalMenus = false;

    protected AbstractMatlabTable(AbstractMatlabTableModel abstractMatlabTableModel) {
        super((TableModel)((Object)abstractMatlabTableModel));
        this.fAMTM = abstractMatlabTableModel;
        this.setScheme(0);
        TableActionProvider tableActionProvider = new TableActionProvider();
        this.fSaveAction = ArrayUtils.getSaveAction(abstractMatlabTableModel.getVariableName(), tableActionProvider);
        this.fPrintAction = new ArrayUtils.PrintAction(tableActionProvider);
        this.fPrintSelectionAction = new ArrayUtils.PrintSelectionAction(tableActionProvider);
        this.fPageSetupAction = new ArrayUtils.PageSetupAction(tableActionProvider);
    }

    WorkspaceVariable getVariable() {
        return this.fAMTM.getVariable();
    }

    public void setUseMinimalMenus(boolean bl) {
        this.fUseMinimalMenus = bl;
    }

    protected boolean useMinimalMenus() {
        return this.fUseMinimalMenus;
    }

    String getVariableName() {
        return this.fAMTM.getVariableName();
    }

    public final Action getSaveAction() {
        return this.fSaveAction;
    }

    public final Action getPageSetupAction() {
        return this.fPageSetupAction;
    }

    public final Action getPrintAction() {
        return this.fPrintAction;
    }

    public final Action getPrintSelectionAction() {
        return this.fPrintSelectionAction;
    }

    @Override
    public void updateData() {
        this.fAMTM.updateData();
    }

    protected void restoreSelection(int[] nArray, int[] nArray2) {
        Object object2;
        List list = AbstractMatlabTable.getSelectionIntervals((int[])nArray);
        for (Object object2 : list) {
            this.addRowSelectionInterval(object2[0], (int)object2[1]);
        }
        List list2 = AbstractMatlabTable.getSelectionIntervals((int[])nArray2);
        object2 = list2.iterator();
        while (object2.hasNext()) {
            int[] nArray3 = (int[])object2.next();
            this.addColumnSelectionInterval(nArray3[0], nArray3[1]);
        }
    }

    protected void setupSelectionAsPerSpreadsheet() {
        super.setupSelectionAsPerSpreadsheet();
        this.setSelectionMode(2);
        this.getColumnModel().getSelectionModel().setSelectionMode(2);
    }

    protected void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier) {
        if (variableIdentifier.getVariable() != null || variableIdentifier.getExpression() != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RefreshableVariableLiteral.populateClipboardFromIdentifier(variableIdentifier, (ChangeListener)new SpreadsheetTable.CopyChangeListener((SpreadsheetTable)this, cursor));
        }
    }

    protected static String getMainHeaderText(String string) {
        return ArrayUtils.getResource("printing.pageTitle", string) + "\t" + ArrayUtils.getResource("printing.header.pg") + " ";
    }

    public boolean isSortEnabledForSelection() {
        return this.isSortEnabledForSelection(this.getColumnModel());
    }

    protected boolean isSortEnabledForSelection(TableColumnModel tableColumnModel) {
        TableModel tableModel;
        int[] nArray;
        boolean bl = false;
        if (tableColumnModel.getSelectedColumnCount() > 0 && null != (nArray = this.restrictRowColumnSpecToValidRegion(tableColumnModel.getSelectedColumns(), 1)) && nArray.length > 0 && (tableModel = this.getModel()) instanceof IDataBoundsSupplier) {
            IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)tableModel;
            int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
            int n = iDataBoundsSupplier.getLastDataRow() + 1;
            if (this.getSelectedRows().length == this.getRowCount() || n == nArray2.length) {
                bl = true;
            }
        }
        return bl;
    }

    private class TableActionProvider
    implements ArrayUtils.PrintActionProvider,
    ArrayUtils.SaveActionProvider {
        private TableActionProvider() {
        }

        @Override
        public void printSelection() {
            String string = AbstractMatlabTable.this.getVariableName();
            MultiHeaderSpreadsheetPrinter.printSelection((JTable)((Object)AbstractMatlabTable.this), (String)string, (String)AbstractMatlabTable.getMainHeaderText(string));
        }

        @Override
        public void print() {
            String string = AbstractMatlabTable.this.getVariableName();
            MultiHeaderSpreadsheetPrinter.print((JTable)((Object)AbstractMatlabTable.this), (String)string, (String)AbstractMatlabTable.getMainHeaderText(string), (Component)((Object)AbstractMatlabTable.this));
        }

        @Override
        public void pageSetup() {
            PrintUtils.showPageSetupDialog((String)ArrayUtils.getResource("printing.pageTitle"));
        }

        @Override
        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            AbstractMatlabTable.this.registerWithMapsUsingKeyBindingManager(mJAbstractAction);
        }

        @Override
        public Component getComponentForDialog() {
            return AbstractMatlabTable.this;
        }
    }
}

