/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.IWorkspaceUndoManagerProvider;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.widgets.spreadsheet.IColumnController;
import com.mathworks.widgets.spreadsheet.IDataClearer;
import com.mathworks.widgets.spreadsheet.IRegionController;
import com.mathworks.widgets.spreadsheet.IRowController;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import com.mathworks.widgets.spreadsheet.ResizingTableModelWrapper;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.util.List;
import javax.swing.table.TableModel;

abstract class AbstractMatlabTableModel
extends ResizingTableModelWrapper
implements IDataClearer,
IRowController,
IColumnController,
IRegionController,
UpdatableData,
IUndoManagerProvider,
ITableController {
    protected WorkspaceUndoManager fUndoManager = null;
    protected boolean fIsChar = false;
    private static final String INSERT = "insertrowsorcolumns";
    private static final String REMOVE = "removerowsorcolumns";
    private static final String TRANSPOSE = "transpose";
    private static final String SORTROWS = "sortrows";
    protected static final int END_INDEX = -17;
    protected static final int END_PLUS_1_INDEX = -100;
    private WorkspaceVariable fVariable;

    AbstractMatlabTableModel(TableModel tableModel, WorkspaceVariable workspaceVariable, boolean bl) {
        super(tableModel, bl);
        this.fVariable = workspaceVariable;
        if (this.fModel instanceof IWorkspaceUndoManagerProvider) {
            this.fUndoManager = ((IWorkspaceUndoManagerProvider)((Object)this.fModel)).getWorkspaceUndoManager();
        }
    }

    public WorkspaceVariable getVariable() {
        return this.fVariable;
    }

    public String getVariableName() {
        return this.fVariable.getVariableName();
    }

    protected void setVariableName(String string) {
        this.fVariable.setVariableName(string);
    }

    protected MatlabMCR getUserActionMCR() {
        return WorkspaceMCRProvider.getMCRForUserActions();
    }

    public String getColumnName(int n) {
        return Integer.toString(n + 1);
    }

    private static String invertInsertDeleteCommand(String string) {
        return string.equals(INSERT) ? REMOVE : INSERT;
    }

    private void executeDeleteInsertCommand(String string, String string2, String string3, int n) {
        if (string2 == null || string3 == null) {
            return;
        }
        new DeleteInsertDoer(string, string2, string3, n, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
    }

    private void executeTransposeCommand() {
        new TransposeDoer(WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
    }

    private void executeSortRowsCommand(String string) {
        if (string == null) {
            return;
        }
        new SortRowsDoer(string, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
    }

    private static String getDirectionString(int n) {
        if (n == 1) {
            return "'left/right'";
        }
        if (n == 0) {
            return "'up/down'";
        }
        return "'none'";
    }

    private static String createArrayArgFromRowsCols(int[] nArray) {
        if (nArray == null) {
            return "':'";
        }
        if (nArray.length == 0) {
            return null;
        }
        int n = nArray.length;
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < n; ++i) {
            stringBuffer = stringBuffer.append(Integer.toString(nArray[i] + 1));
            if (i >= n - 1) continue;
            stringBuffer = stringBuffer.append(", ");
        }
        stringBuffer = stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean isRegionInsertable(int[] nArray, int[] nArray2, int n) {
        return true;
    }

    public void insertRegion(int[] nArray, int[] nArray2, int n) {
        this.executeDeleteInsertCommand(INSERT, AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray2), n);
    }

    public boolean isRegionDeletable(int[] nArray, int[] nArray2, int n) {
        return true;
    }

    public void deleteRegion(int[] nArray, int[] nArray2, int n) {
        this.executeDeleteInsertCommand(REMOVE, AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray2), n);
    }

    public void clearRegion(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return;
        }
        new ClearRegionDoer(nArray, nArray2, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
    }

    protected abstract String getEmptyValueConstructor();

    public boolean areRowsDeletable(int[] nArray) {
        return true;
    }

    public void deleteRows(int[] nArray) {
        this.executeDeleteInsertCommand(REMOVE, AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), AbstractMatlabTableModel.createArrayArgFromRowsCols(null), 0);
    }

    public boolean areRowsInsertable(int[] nArray) {
        return true;
    }

    public void insertRows(int[] nArray) {
        this.executeDeleteInsertCommand(INSERT, AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), AbstractMatlabTableModel.createArrayArgFromRowsCols(null), 0);
    }

    public boolean areColumnsDeletable(int[] nArray) {
        return true;
    }

    public void deleteColumns(int[] nArray) {
        this.executeDeleteInsertCommand(REMOVE, AbstractMatlabTableModel.createArrayArgFromRowsCols(null), AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), 1);
    }

    public boolean areColumnsInsertable(int[] nArray) {
        return true;
    }

    public void insertColumns(int[] nArray) {
        this.executeDeleteInsertCommand(INSERT, AbstractMatlabTableModel.createArrayArgFromRowsCols(null), AbstractMatlabTableModel.createArrayArgFromRowsCols(nArray), 1);
    }

    @Override
    public void updateData() {
        if (this.fModel instanceof UpdatableData) {
            ((UpdatableData)((Object)this.fModel)).updateData();
        }
    }

    @Override
    public boolean isVariableTransposable() {
        return true;
    }

    @Override
    public void transpose() {
        this.executeTransposeCommand();
    }

    @Override
    public boolean isRowSortable() {
        return true;
    }

    @Override
    public void sortRows(int[] nArray) {
        this.sortRows(nArray, null);
    }

    @Override
    public void sortRows(int[] nArray, ITableController.SortDirection sortDirection) {
        String string = AbstractMatlabTableModel.createSortRowsParamString(nArray, sortDirection);
        if (string == null) {
            return;
        }
        this.executeSortRowsCommand(string);
    }

    public static String createSortRowsParamString(int[] nArray, ITableController.SortDirection sortDirection) {
        if (null == nArray) {
            return null;
        }
        if (nArray.length <= 0) {
            return null;
        }
        int[] nArray2 = (int[])nArray.clone();
        if (null != sortDirection) {
            nArray2 = AbstractMatlabTableModel.forceSortDirection(nArray2, sortDirection);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray2.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(nArray2[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static int[] forceSortDirection(int[] nArray, ITableController.SortDirection sortDirection) {
        if (null == nArray) {
            return null;
        }
        if (null == sortDirection) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        if (sortDirection == ITableController.SortDirection.ASCENDING) {
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = Math.abs(nArray[i]);
            }
        } else {
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1 * Math.abs(nArray[i]);
            }
        }
        return nArray2;
    }

    protected CompletionObserver getRefreshErrorDialogCOForFeval(CompletionObserver completionObserver) {
        return ArrayDialog.getErrorDialogCompletionObserver((CompletionObserver)new RefreshCompletionObserver(completionObserver), true);
    }

    protected CompletionObserver getRefreshErrorDialogCOForFeval(String string, CompletionObserver completionObserver) {
        return ArrayDialog.getErrorDialogCompletionObserver(string, new RefreshCompletionObserver(completionObserver), true);
    }

    protected CompletionObserver getRefreshErrorDialogCO(String string, CompletionObserver completionObserver) {
        return ArrayDialog.getErrorDialogCompletionObserver((CompletionObserver)new RefreshCompletionObserver(completionObserver), string);
    }

    public MUndoManager getUndoManager() {
        return this.fUndoManager;
    }

    public void cleanup() {
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).cleanup();
        }
        super.cleanup();
    }

    protected StringBuilder constructIndexingExpression(int n, int n2, String string, String string2) {
        String string3 = AbstractMatlabTableModel.indexToString(n);
        String string4 = AbstractMatlabTableModel.indexToString(n2);
        return new StringBuilder(this.getVariableName()).append(string).append(string3).append(", ").append(string4).append(string2);
    }

    protected StringBuilder constructIndexingExpression(int n, int n2) {
        return this.constructIndexingExpression(n, n2, this.getIndexingOpenToken(), this.getIndexingCloseToken());
    }

    protected StringBuilder constructIndexingExpression(int n, int n2, int n3, int n4, String string, String string2) {
        String string3 = AbstractMatlabTableModel.indexToString(n);
        String string4 = AbstractMatlabTableModel.indexToString(n2);
        String string5 = AbstractMatlabTableModel.indexToString(n3);
        String string6 = AbstractMatlabTableModel.indexToString(n4);
        return new StringBuilder(this.getVariableName()).append(string).append(string3).append(':').append(string4).append(", ").append(string5).append(':').append(string6).append(string2);
    }

    protected StringBuilder constructIndexingExpression(List<int[]> list, List<int[]> list2, String string, String string2) {
        return new StringBuilder(this.getVariableName()).append(string).append(SpreadsheetUtils.getSelectionString(list, (int)-1)).append(", ").append(SpreadsheetUtils.getSelectionString(list2, (int)-1)).append(string2);
    }

    protected StringBuilder constructIndexingExpression(int n, int n2, int n3, int n4) {
        return this.constructIndexingExpression(n, n2, n3, n4, this.getIndexingOpenToken(), this.getIndexingCloseToken());
    }

    private static String indexToString(int n) {
        if (n == -17) {
            return "end";
        }
        if (n == -100) {
            return "end+1";
        }
        if (n < 1) {
            throw new IllegalArgumentException("Indices for MATLAB expressions must be positive integers.");
        }
        return Integer.toString(n);
    }

    abstract String getIndexingOpenToken();

    abstract String getIndexingCloseToken();

    private class RefreshCompletionObserver
    implements CompletionObserver {
        private CompletionObserver iCO;

        RefreshCompletionObserver(CompletionObserver completionObserver) {
            this.iCO = completionObserver;
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0) {
                AbstractMatlabTableModel.this.updateData();
            }
            if (this.iCO != null) {
                this.iCO.completed(n, object);
            }
        }
    }

    private class ClearRegionUndoer
    extends ClearRegionRunnable {
        ClearRegionUndoer(int[] nArray, int[] nArray2, WorkspaceUndoManager.UndoKey undoKey) {
            super(nArray, nArray2, undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, AbstractMatlabTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new ClearRegionDoer(this.iRows, this.iCols, this.iKey);
        }
    }

    private class ClearRegionDoer
    extends ClearRegionRunnable {
        ClearRegionDoer(int[] nArray, int[] nArray2, WorkspaceUndoManager.UndoKey undoKey) {
            super(nArray, nArray2, undoKey);
        }

        private void runDefaultworkspaceChar() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, AbstractMatlabTableModel.this.getVariableName()) + AbstractMatlabTableModel.this.getVariableName() + " = " + AbstractMatlabTableModel.this.getEmptyValueConstructor() + ';', AbstractMatlabTableModel.this.getRefreshErrorDialogCO(null, new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager)));
        }

        private void runNonDefaultWorkspaceChar() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"clearRegion", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, AbstractMatlabTableModel.this.getRefreshErrorDialogCOForFeval(new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager)));
        }

        private void runDefaultWorkspace() {
            String string = SpreadsheetUtils.getSelectionString((List)SpreadsheetUtils.getSelectionIntervals((int[])this.iRows), (int)-1);
            String string2 = SpreadsheetUtils.getSelectionString((List)SpreadsheetUtils.getSelectionIntervals((int[])this.iCols), (int)-1);
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 2, AbstractMatlabTableModel.this.getVariableName() + ',' + string + ", " + string2 + ", " + AbstractMatlabTableModel.this.getEmptyValueConstructor());
            }
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, AbstractMatlabTableModel.this.getVariableName()) + AbstractMatlabTableModel.this.getVariableName() + '(' + string + ", " + string2 + ") = " + AbstractMatlabTableModel.this.getEmptyValueConstructor() + ';', AbstractMatlabTableModel.this.getRefreshErrorDialogCO(null, new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager)));
        }

        private void runNonDefaultWorkspace() {
            ArrayUtils.log(this.getClass(), 2, AbstractMatlabTableModel.this.fVariable.getVariableName() + ',' + this.iRows[0] + ", " + this.iCols[0] + ", " + AbstractMatlabTableModel.this.getEmptyValueConstructor());
            int[] nArray = (int[])this.iRows.clone();
            int n = 0;
            while (n < nArray.length) {
                int n2 = n++;
                nArray[n2] = nArray[n2] + 1;
            }
            int[] nArray2 = (int[])this.iCols.clone();
            int n3 = 0;
            while (n3 < nArray2.length) {
                int n4 = n3++;
                nArray2[n4] = nArray2[n4] + 1;
            }
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"clearRegion", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue(), nArray, nArray2}, 0, AbstractMatlabTableModel.this.getRefreshErrorDialogCOForFeval(new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fIsChar) {
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 2, AbstractMatlabTableModel.this.getVariableName() + ", " + AbstractMatlabTableModel.this.getEmptyValueConstructor());
                }
                if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                    this.runDefaultworkspaceChar();
                } else {
                    this.runNonDefaultWorkspaceChar();
                }
                return;
            }
            if (this.iRows.length > 0 && this.iCols.length > 0) {
                if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                    this.runDefaultWorkspace();
                } else {
                    this.runNonDefaultWorkspace();
                }
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new ClearRegionUndoer(this.iRows, this.iCols, this.iKey);
        }
    }

    private static abstract class ClearRegionRunnable
    implements InvertableRunnable {
        protected WorkspaceUndoManager.UndoKey iKey;
        protected final int[] iRows;
        protected final int[] iCols;

        ClearRegionRunnable(int[] nArray, int[] nArray2, WorkspaceUndoManager.UndoKey undoKey) {
            this.iRows = (int[])nArray.clone();
            this.iCols = (int[])nArray2.clone();
            this.iKey = undoKey;
        }
    }

    private class SortRowsUndoer
    extends SortRowsRunnable {
        SortRowsUndoer(String string, WorkspaceUndoManager.UndoKey undoKey) {
            super(string, undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, AbstractMatlabTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SortRowsDoer(this.iColArg, this.iKey);
        }
    }

    private class SortRowsDoer
    extends SortRowsRunnable {
        SortRowsDoer(String string, WorkspaceUndoManager.UndoKey undoKey) {
            super(string, undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, AbstractMatlabTableModel.this.getVariableName()) + AbstractMatlabTableModel.this.getVariableName() + " = arrayviewfunc(" + '\'' + AbstractMatlabTableModel.SORTROWS + "', " + AbstractMatlabTableModel.this.getVariableName() + ", " + this.iColArg + ");", (CompletionObserver)new DoerCompletionObserver((InvertableRunnable)this, AbstractMatlabTableModel.this.fUndoManager, ArrayUtils.getResource("status.SortError")));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"sortRows", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue(), this.iColArg}, 0, (CompletionObserver)new DoerCompletionObserver((InvertableRunnable)this, AbstractMatlabTableModel.this.fUndoManager, ArrayUtils.getResource("status.SortError")));
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, "sortrows, " + this.iColArg);
            }
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SortRowsUndoer(this.iColArg, this.iKey);
        }
    }

    private static abstract class SortRowsRunnable
    implements InvertableRunnable {
        protected String iColArg;
        protected WorkspaceUndoManager.UndoKey iKey;

        SortRowsRunnable(String string, WorkspaceUndoManager.UndoKey undoKey) {
            this.iColArg = string;
            this.iKey = undoKey;
        }
    }

    private class TransposeUndoer
    extends TransposeRunnable {
        TransposeUndoer(WorkspaceUndoManager.UndoKey undoKey) {
            super(undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, AbstractMatlabTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new TransposeDoer(this.iKey);
        }
    }

    private class TransposeDoer
    extends TransposeRunnable {
        TransposeDoer(WorkspaceUndoManager.UndoKey undoKey) {
            super(undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, AbstractMatlabTableModel.this.getVariableName()) + AbstractMatlabTableModel.this.getVariableName() + " = arrayviewfunc(" + '\'' + AbstractMatlabTableModel.TRANSPOSE + "', " + AbstractMatlabTableModel.this.getVariableName() + ");", (CompletionObserver)new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"doTranspose", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, AbstractMatlabTableModel.this.getRefreshErrorDialogCOForFeval(new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, AbstractMatlabTableModel.TRANSPOSE);
            }
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new TransposeUndoer(this.iKey);
        }
    }

    private static abstract class TransposeRunnable
    implements InvertableRunnable {
        protected WorkspaceUndoManager.UndoKey iKey;

        TransposeRunnable(WorkspaceUndoManager.UndoKey undoKey) {
            this.iKey = undoKey;
        }
    }

    private class DeleteInsertUndoer
    extends DeleteInsertRunnable {
        DeleteInsertUndoer(String string, String string2, String string3, int n, WorkspaceUndoManager.UndoKey undoKey) {
            super(string, string2, string3, n, undoKey);
        }

        private void runDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, AbstractMatlabTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue()}, 0, (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new DeleteInsertDoer(AbstractMatlabTableModel.invertInsertDeleteCommand(this.iCommand), this.iRowArg, this.iColArg, this.iDirection, this.iKey);
        }
    }

    private class DeleteInsertDoer
    extends DeleteInsertRunnable {
        DeleteInsertDoer(String string, String string2, String string3, int n, WorkspaceUndoManager.UndoKey undoKey) {
            super(string, string2, string3, n, undoKey);
        }

        private void runDefaultWorkspace(String string) {
            AbstractMatlabTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, AbstractMatlabTableModel.this.getVariableName()) + AbstractMatlabTableModel.this.getVariableName() + " = arrayviewfunc(" + '\'' + this.iCommand + "', " + AbstractMatlabTableModel.this.getVariableName() + ", " + this.iRowArg + ", " + this.iColArg + ", " + string + ", " + "[]" + ");", (CompletionObserver)new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace(String string) {
            AbstractMatlabTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"deleteInsert", AbstractMatlabTableModel.this.fVariable, this.iKey.stringValue(), this.iRowArg, this.iColArg, this.iCommand, string}, 0, (CompletionObserver)new DoerCompletionObserver(this, AbstractMatlabTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            String string = AbstractMatlabTableModel.getDirectionString(this.iDirection);
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, this.iCommand + ", " + this.iRowArg + ", " + this.iColArg + ", " + string);
            }
            if (AbstractMatlabTableModel.this.fUndoManager != null) {
                AbstractMatlabTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (AbstractMatlabTableModel.this.fVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace(string);
            } else {
                this.runNonDefaultWorkspace(string);
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new DeleteInsertUndoer(AbstractMatlabTableModel.invertInsertDeleteCommand(this.iCommand), this.iRowArg, this.iColArg, this.iDirection, this.iKey);
        }
    }

    private static abstract class DeleteInsertRunnable
    implements InvertableRunnable {
        protected String iCommand;
        protected String iRowArg;
        protected String iColArg;
        protected int iDirection;
        protected WorkspaceUndoManager.UndoKey iKey;

        DeleteInsertRunnable(String string, String string2, String string3, int n, WorkspaceUndoManager.UndoKey undoKey) {
            this.iCommand = string;
            this.iRowArg = string2;
            this.iColArg = string3;
            this.iDirection = n;
            this.iKey = undoKey;
        }
    }
}

