/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.data.CategoricalScalar;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

class CategoricalVariableEditor
extends AbstractCellEditor
implements TableCellEditor {
    private EditingComboBox fComboBox = new EditingComboBox();
    private KeyListener fKeyListener;

    CategoricalVariableEditor() {
        this.fComboBox.setCategoricalVariableEditor(this);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        int n;
        int n2;
        boolean bl;
        if (eventObject == null) {
            return true;
        }
        boolean bl2 = bl = !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= 2;
        if (!bl) {
            return false;
        }
        Object object = eventObject.getSource();
        if (!(object instanceof JTable)) {
            return false;
        }
        JTable jTable = (JTable)eventObject.getSource();
        if (eventObject instanceof MouseEvent) {
            n2 = jTable.rowAtPoint(((MouseEvent)eventObject).getPoint());
            n = jTable.columnAtPoint(((MouseEvent)eventObject).getPoint());
        } else {
            n2 = jTable.getSelectedRow();
            n = jTable.getSelectedColumn();
        }
        if (!(jTable.getModel() instanceof TabularObjectTableModel)) {
            return false;
        }
        int[] nArray = ((TabularObjectTableModel)((Object)jTable.getModel())).getVariableGridSize();
        return n2 >= 0 && n >= 0 && (n2 >= nArray[0] || jTable.getValueAt(n2, n) instanceof CategoricalScalar);
    }

    @Override
    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, int n, int n2) {
        String[] stringArray;
        this.fComboBox.removeAllItems();
        if (object instanceof CategoricalScalar) {
            stringArray = ((CategoricalScalar)object).getLabels();
        } else if (object == null && jTable.getValueAt(0, n2) instanceof CategoricalScalar) {
            stringArray = ((CategoricalScalar)jTable.getValueAt(0, n2)).getLabels();
        } else {
            return null;
        }
        for (String string : stringArray) {
            this.fComboBox.addItem(string);
        }
        if (object != null) {
            this.fComboBox.setSelectedItem(object.toString().replaceAll("'", ""));
        } else {
            this.fComboBox.setSelectedItem(0);
        }
        jTable.removeKeyListener(this.fKeyListener);
        if (this.fKeyListener == null) {
            this.fKeyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    keyEvent.setSource((Object)CategoricalVariableEditor.this.fComboBox);
                    CategoricalVariableEditor.this.fComboBox.requestFocus();
                    CategoricalVariableEditor.this.fComboBox.dispatchEvent(new KeyEvent((Component)((Object)CategoricalVariableEditor.this.fComboBox), 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                    CategoricalVariableEditor.this.fComboBox.dispatchEvent(new KeyEvent((Component)((Object)CategoricalVariableEditor.this.fComboBox), 402, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                    CategoricalVariableEditor.this.fComboBox.dispatchEvent(new KeyEvent((Component)((Object)CategoricalVariableEditor.this.fComboBox), 400, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                }
            };
        }
        jTable.addKeyListener(this.fKeyListener);
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
                jTable.removeKeyListener(CategoricalVariableEditor.this.fKeyListener);
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                jTable.removeKeyListener(CategoricalVariableEditor.this.fKeyListener);
            }
        });
        return this.fComboBox;
    }

    @Override
    public Object getCellEditorValue() {
        String[] stringArray;
        String[] stringArray2 = null;
        if (this.fComboBox.getSelectedItem() instanceof EditingComboBox.Prompt && !((stringArray = this.fComboBox.getEditor().getItem()) instanceof EditingComboBox.Prompt)) {
            stringArray2 = stringArray;
        }
        if (stringArray2 == null) {
            stringArray = new String[this.fComboBox.getItemCount() - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)this.fComboBox.getItemAt(i);
            }
        } else {
            stringArray = new String[this.fComboBox.getItemCount()];
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringArray[i] = (String)this.fComboBox.getItemAt(i);
            }
            stringArray[stringArray.length - 1] = (String)stringArray2;
        }
        if (stringArray2 != null) {
            return new CategoricalScalar((String)stringArray2, stringArray);
        }
        if (this.fComboBox.getSelectedItem() instanceof EditingComboBox.Prompt) {
            return new CategoricalScalar(this.fComboBox.getItemAt(0).toString(), stringArray);
        }
        return new CategoricalScalar(this.fComboBox.getSelectedItem().toString(), stringArray);
    }

    @Override
    public void fireEditingStopped() {
        if (this.fComboBox.getSelectedItem() instanceof EditingComboBox.Prompt && this.fComboBox.getEditor().getItem() instanceof EditingComboBox.Prompt) {
            this.fireEditingCanceled();
        } else {
            super.fireEditingStopped();
        }
    }

    private static class EditingComboBox
    extends MJComboBox {
        private boolean iPrompting = false;
        private CategoricalVariableEditor iCategoricalVariableEditor;

        EditingComboBox() {
            this.setEditor(new LightWeightComboBoxEditor());
            this.setRenderer(new LightWeightComboBoxRenderer());
            this.addItem(new Prompt());
            if (PlatformInfo.isMacintosh()) {
                this.setUI(new BasicComboBoxUI());
            }
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (EditingComboBox.this.iPrompting) {
                        ((JTextComponent)EditingComboBox.this.getEditor().getEditorComponent()).setText("");
                        EditingComboBox.this.getEditor().getEditorComponent().setForeground(Color.black);
                        EditingComboBox.this.iPrompting = false;
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (EditingComboBox.this.iCategoricalVariableEditor != null && keyEvent.getKeyCode() == 10) {
                        keyEvent.consume();
                        EditingComboBox.this.iCategoricalVariableEditor.fireEditingStopped();
                    }
                }
            };
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() != 1 || EditingComboBox.this.getSelectedIndex() < 0) {
                        return;
                    }
                    if (EditingComboBox.this.getItemCount() > 1 && EditingComboBox.this.getSelectedItem() instanceof Prompt) {
                        EditingComboBox.this.setEditable(true);
                        EditingComboBox.this.iPrompting = true;
                    } else {
                        EditingComboBox.this.setEditable(EditingComboBox.this.getSelectedItem() instanceof EditableTarget);
                    }
                }
            };
            this.setForeground(Color.lightGray);
            this.addItemListener(itemListener);
            this.getEditor().getEditorComponent().addKeyListener(keyAdapter);
        }

        public void addItem(Object object) {
            if (object instanceof Prompt || !(this.getItemAt(this.getItemCount() - 1) instanceof Prompt)) {
                super.addItem(object);
            } else {
                this.insertItemAt(object, this.getItemCount() - 1);
            }
            if (this.getSelectedItem() instanceof Prompt) {
                this.setSelectedIndex(0);
            } else {
                this.setForeground(Color.black);
            }
        }

        public void removeAllItems() {
            super.removeAllItems();
            this.addItem(new Prompt());
            this.setForeground(Color.lightGray);
        }

        void setCategoricalVariableEditor(CategoricalVariableEditor categoricalVariableEditor) {
            this.iCategoricalVariableEditor = categoricalVariableEditor;
        }

        private static class EditableTarget {
            private String iString;

            EditableTarget(String string) {
                this.iString = string;
            }

            public String toString() {
                return this.iString;
            }
        }

        private static class LightWeightComboBoxEditor
        extends BasicComboBoxEditor {
            private LightWeightComboBoxEditor() {
            }

            @Override
            public void setItem(Object object) {
                super.setItem(object);
                if (object instanceof Prompt) {
                    this.getEditorComponent().setForeground(Color.lightGray);
                    ((JTextComponent)this.getEditorComponent()).moveCaretPosition(0);
                    ((JTextComponent)this.getEditorComponent()).setCaretPosition(0);
                } else {
                    this.getEditorComponent().setForeground(Color.black);
                }
            }
        }

        private static class LightWeightComboBoxRenderer
        extends BasicComboBoxRenderer {
            private LightWeightComboBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Prompt) {
                    component.setForeground(Color.lightGray);
                } else {
                    component.setForeground(Color.black);
                }
                return component;
            }
        }

        private static class Prompt {
            private Prompt() {
            }

            public String toString() {
                return ArrayUtils.getResource("dataset.CategoryNewItem");
            }
        }
    }
}

