/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.MatlabDataTypeSupplier;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.widgets.spreadsheet.IMultipleBlockValueSetter;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;

public class MatlabArrayTableModel
extends AbstractMatlabTableModel
implements IMultipleBlockValueSetter {
    private MatlabDataTypeSupplier fMDTS = null;
    private int fOrigIncrement = this.fIncrementSize;
    private int fOrigBuffer = this.fBufferZoneSize;
    private static Map<Integer, String> sAssignmentHash = new Hashtable<Integer, String>();
    private static int sNextHashValue = 0;

    public MatlabArrayTableModel(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, true);
    }

    public MatlabArrayTableModel(WorkspaceVariable workspaceVariable, boolean bl) {
        this(new ValueTableModel(workspaceVariable, true), workspaceVariable, bl);
        this.fMDTS = new MatlabDataTypeSupplier(workspaceVariable);
    }

    public MatlabArrayTableModel(ValueTableModel valueTableModel, WorkspaceVariable workspaceVariable, boolean bl) {
        super(valueTableModel, workspaceVariable, bl);
    }

    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(this.validateEmpty(object), n, n2);
    }

    private Object validateEmpty(Object object) {
        if (object instanceof String && ((String)object).trim().isEmpty()) {
            return this.getEmptyValueConstructor();
        }
        return object;
    }

    void rename(String string) {
        this.setVariableName(string);
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).setVariableName(string);
        }
    }

    @Override
    public void cleanup() {
        if (this.fMDTS != null) {
            this.fMDTS.cleanup();
            this.fMDTS = null;
        }
        super.cleanup();
    }

    public void setValueAtPreMethod(int n, int n2) {
        boolean bl;
        super.setValueAtPreMethod(n, n2);
        boolean bl2 = bl = this.getMatlabDataType() == 1;
        if (bl) {
            if (n <= this.getLastDataRow() && n2 <= this.getLastDataColumn()) {
                bl = false;
            }
            if (n == 0 && this.getLastDataRow() == 0 && n2 == this.getLastDataColumn() + 1) {
                bl = false;
            }
            if (n2 == 0 && this.getLastDataColumn() == 0 && n == this.getLastDataRow() + 1) {
                bl = false;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("");
            if (n > this.getLastDataRow()) {
                stringBuilder = this.constructIndexingExpression(-100, n + 1, 1, -17).append(" = {''};");
            }
            StringBuilder stringBuilder2 = new StringBuilder("");
            if (n2 > this.getLastDataColumn()) {
                stringBuilder2 = this.constructIndexingExpression(1, -17, -100, n2 + 1).append(" = {''};");
            }
            String string = stringBuilder.append((CharSequence)stringBuilder2).toString();
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, string);
            }
            this.getUserActionMCR().evalNoOutput(string);
        }
    }

    public int getMatlabDataType() {
        return this.fMDTS.getDataType();
    }

    @Override
    protected String getEmptyValueConstructor() {
        if (this.getMatlabDataType() == 1) {
            return "{''}";
        }
        if (this.fIsChar) {
            return "''";
        }
        return "0";
    }

    public boolean areValuesSettable(int n, int n2, int n3, int n4) {
        return true;
    }

    private int createHashValueForPaste(Object[][] objectArray) {
        int n = this.getMatlabDataType();
        boolean bl = n == 4;
        boolean bl2 = MatlabArrayTableModel.isTypeNumeric(n);
        String string = "[";
        String string2 = "]";
        if (n == 1) {
            string = "{";
            string2 = "}";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray2 = objectArray[i];
            int n3 = objectArray2.length;
            for (int j = 0; j < n3; ++j) {
                Object object;
                String string3;
                if (bl) {
                    stringBuilder.append('\'');
                }
                String string4 = string3 = (object = objectArray2[j]) == null ? "null" : object.toString();
                if (!bl2 || string3.length() > 0) {
                    stringBuilder.append(string3);
                } else {
                    stringBuilder.append("0");
                }
                if (bl) {
                    stringBuilder.append('\'');
                }
                if (j < n3 - 1) {
                    stringBuilder.append(", ");
                    continue;
                }
                if (i >= n2 - 1) continue;
                stringBuilder.append(';');
            }
        }
        stringBuilder.append(string2);
        String string5 = stringBuilder.toString();
        return MatlabArrayTableModel.putStringIntoHashTable(string5);
    }

    private void setValuesAtDefaultWorkspace(Object[][] objectArray, int n, int n2) {
        int n3 = this.createHashValueForPaste(objectArray);
        boolean bl = this.getMatlabDataType() == 4;
        String string = bl ? "" : '(' + Integer.toString(n + 1) + ':' + Integer.toString(n + objectArray.length) + ',';
        String string2 = bl ? "" : Integer.toString(n2 + 1) + ':' + Integer.toString(n2 + objectArray[0].length) + ')';
        String string3 = this.getVariableName() + string + string2;
        if (ArrayUtils.isLogging()) {
            ArrayUtils.log(this.getClass(), 2, string3 + ", " + n3);
            ArrayUtils.log(this.getClass(), 3, string3 + " = eval(com.mathworks.mlwidgets.array.MatlabArrayTableModel.getHashedAssignmentRHS(" + n3 + ").toString);");
        }
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        new SetValuesAtDoer(this.getVariable(), string3, Integer.toString(n3), undoKey).run();
    }

    private void setValuesAtNonDefaultWorkspace(Object[][] objectArray, int n, int n2) {
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        arrayList.add(new int[]{n, n});
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        arrayList2.add(new int[]{n2, n2});
        new SetValuesAtDoer(this.getVariable(), objectArray, arrayList, arrayList2, undoKey).run();
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            if (this.getVariable().isDefaultWorkspace()) {
                this.setValuesAtDefaultWorkspace(objectArray, n, n2);
            } else {
                this.setValuesAtNonDefaultWorkspace(objectArray, n, n2);
            }
        }
    }

    private void setValuesAtDefaultWorkspace(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        int n = this.createHashValueForPaste(objectArray);
        boolean bl = this.getMatlabDataType() == 4;
        String string = bl ? this.getVariableName() : this.getVariableName() + "(" + SpreadsheetUtils.getSelectionString(list, (int)-1) + "," + SpreadsheetUtils.getSelectionString(list2, (int)-1) + ")";
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        new SetValuesAtDoer(this.getVariable(), string, Integer.toString(n), undoKey).run();
    }

    private void setValuesAtNonDefaultWorkspace(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        new SetValuesAtDoer(this.getVariable(), objectArray, list, list2, undoKey).run();
    }

    public void setValuesAt(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        if (objectArray != null && objectArray.length > 0) {
            if (list.size() == 1 && list2.size() == 1) {
                this.setValuesAt(objectArray, list.get(0)[0], list2.get(0)[0]);
                return;
            }
            if (this.getVariable().isDefaultWorkspace()) {
                this.setValuesAtDefaultWorkspace(objectArray, list, list2);
            } else {
                this.setValuesAtNonDefaultWorkspace(objectArray, list, list2);
            }
        }
    }

    private static boolean isTypeNumeric(int n) {
        return n == 6 || n == 7 || n == 8 || n == 9 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14 || n == 15;
    }

    private static int putStringIntoHashTable(String string) {
        int n = sNextHashValue++;
        sAssignmentHash.put(n, string);
        return n;
    }

    public static String getHashedAssignmentRHS(int n) {
        String string = sAssignmentHash.get(n);
        sAssignmentHash.remove(n);
        return string;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl;
        boolean bl2 = bl = tableModelEvent != null;
        if (!this.fIsChar) {
            if (this.getMatlabDataType() == 4) {
                this.fIsChar = true;
                this.fOrigIncrement = this.fIncrementSize;
                this.fOrigBuffer = this.fBufferZoneSize;
                this.fIncrementSize = 1;
                this.fBufferZoneSize = 0;
                this.fCurrentTableHeight = this.fModel.getRowCount();
                this.fCurrentTableWidth = this.fModel.getColumnCount();
                this.fireTableStructureChanged();
                bl = false;
            }
        } else if (this.getMatlabDataType() != 4) {
            this.fIsChar = false;
            this.fIncrementSize = this.fOrigIncrement;
            this.fBufferZoneSize = this.fOrigBuffer;
            this.fCurrentTableHeight = 16;
            this.fCurrentTableWidth = 16;
            this.fireTableStructureChanged();
            bl = false;
        }
        if (bl) {
            super.tableChanged(tableModelEvent);
        }
    }

    @Override
    protected String getIndexingOpenToken() {
        return "(";
    }

    @Override
    protected String getIndexingCloseToken() {
        return ")";
    }

    private class SetValuesAtUndoer
    extends SetValuesAtRunnable {
        SetValuesAtUndoer(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, string, string2, undoKey);
        }

        SetValuesAtUndoer(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, objectArray, list, list2, undoKey);
        }

        private void runDefaultWorkspace() {
            if (MatlabArrayTableModel.this.fUndoManager != null) {
                MatlabArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            MatlabArrayTableModel.this.getUserActionMCR().eval(this.iVariable.getVariableName() + " = arrayviewfunc('undoHashedAssignment', " + string + ");", MatlabArrayTableModel.this.getRefreshErrorDialogCO(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new UndoerCompletionObserver(MatlabArrayTableModel.this.fUndoManager)));
        }

        private void runNonDefaultWorkspace() {
            if (MatlabArrayTableModel.this.fUndoManager != null) {
                MatlabArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            MatlabArrayTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", this.iVariable, this.iKey.stringValue()}, 0, MatlabArrayTableModel.this.getRefreshErrorDialogCOForFeval(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new UndoerCompletionObserver(MatlabArrayTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (this.iVariable == null) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            if (this.iVariable.isDefaultWorkspace()) {
                return new SetValuesAtDoer(this.iVariable, this.iLHS, this.iHashValue, this.iKey);
            }
            return new SetValuesAtDoer(this.iVariable, this.iValues, this.iAList, this.iBList, this.iKey);
        }
    }

    private class SetValuesAtDoer
    extends SetValuesAtRunnable {
        SetValuesAtDoer(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, objectArray, list, list2, undoKey);
        }

        SetValuesAtDoer(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, string, string2, undoKey);
        }

        private void runDefaultWorkspace() {
            assert (this.iHashValue != null);
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, this.iLHS + ", " + this.iHashValue + ", " + this.iKey);
            }
            if (MatlabArrayTableModel.this.fUndoManager != null) {
                MatlabArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            MatlabArrayTableModel.this.getUserActionMCR().eval(this.iLHS + " = arrayviewfunc('doHashedAssignment', " + this.iVariable.getVariableName() + ", " + "eval(com.mathworks.mlwidgets.array.MatlabArrayTableModel.getHashedAssignmentRHS(" + this.iHashValue + ").toString), " + string + ");", MatlabArrayTableModel.this.getRefreshErrorDialogCO(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new DoerCompletionObserver(this, MatlabArrayTableModel.this.fUndoManager)));
        }

        private void runNonDefaultWorkspace() {
            if (MatlabArrayTableModel.this.fUndoManager != null) {
                MatlabArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            MatlabArrayTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"matmSetValuesAt", this.iVariable, this.iKey.stringValue(), this.iValues, this.iAList, this.iBList, true}, 0, MatlabArrayTableModel.this.getRefreshErrorDialogCOForFeval(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new DoerCompletionObserver(this, MatlabArrayTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            if (this.iVariable.isDefaultWorkspace()) {
                return new SetValuesAtUndoer(this.iVariable, this.iLHS, this.iHashValue, this.iKey);
            }
            return new SetValuesAtUndoer(this.iVariable, this.iValues, this.iAList, this.iBList, this.iKey);
        }
    }

    private static abstract class SetValuesAtRunnable
    implements InvertableRunnable {
        protected WorkspaceVariable iVariable;
        protected String iLHS;
        protected String iHashValue;
        protected Object[][] iValues;
        protected List<int[]> iAList;
        protected List<int[]> iBList;
        protected WorkspaceUndoManager.UndoKey iKey;

        private void assignValues(Object[][] objectArray) {
            int n = objectArray.length;
            int n2 = objectArray[0].length;
            this.iValues = new Object[n][n2];
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = new Object[n2];
                this.iValues[i] = objectArray2;
                System.arraycopy(objectArray[i], 0, objectArray2, 0, n2);
            }
        }

        SetValuesAtRunnable(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, WorkspaceUndoManager.UndoKey undoKey) {
            int n;
            this.iVariable = workspaceVariable;
            this.assignValues(objectArray);
            this.iAList = new ArrayList<int[]>(list);
            for (int[] nArray : this.iAList) {
                n = 0;
                while (n < nArray.length) {
                    int n2 = n++;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
            this.iBList = new ArrayList<int[]>(list2);
            for (int[] nArray : this.iBList) {
                n = 0;
                while (n < nArray.length) {
                    int n3 = n++;
                    nArray[n3] = nArray[n3] + 1;
                }
            }
            this.iKey = undoKey;
        }

        SetValuesAtRunnable(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            this.iVariable = workspaceVariable;
            this.iLHS = string;
            assert (string2 != null);
            this.iHashValue = string2;
            this.iKey = undoKey;
        }
    }
}

