/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.brushing;

import com.jidesoft.swing.JideToggleSplitButton;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.color.ColorPickerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class BrushingToggleButton
extends JideToggleSplitButton {
    private SplitColorChooser fColorChooser;
    private ColorIcon fIcon;
    private Vector<ActionListener> fColorSelectionListeners = new Vector();
    private ActionListener fSelectionListener;
    private ActionListener fColorSelectionListener;

    public BrushingToggleButton() {
        this.setIcon(new ImageIcon(BrushingToggleButton.class.getResource("/com/mathworks/page/datamgr/resources/tool_data_brush.png")));
        this.setEnabled(false);
        this.init();
    }

    public BrushingToggleButton(final ArrayEditorProvider arrayEditorProvider) {
        this.setText("");
        this.fIcon = new ColorIcon(new ImageIcon(BrushingToggleButton.class.getResource("/com/mathworks/page/datamgr/resources/tool_data_brush.png")), new Rectangle(10, 10, 5, 5));
        this.setIcon(this.fIcon);
        this.fColorChooser = new SplitColorChooser();
        this.add((Component)((Object)this.fColorChooser));
        this.fSelectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                arrayEditorProvider.setBrushMode(BrushingToggleButton.this.isButtonSelected(), BrushingToggleButton.this.getCurrentColor());
            }
        };
        this.fColorSelectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                arrayEditorProvider.setBrushMode(true, BrushingToggleButton.this.getCurrentColor());
            }
        };
        this.addActionListener(this.fSelectionListener);
        this.addColorSelectionAction(this.fColorSelectionListener);
        this.init();
        Action action = arrayEditorProvider.getBrushModeAction();
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("mode".equals(propertyChangeEvent.getPropertyName())) {
                    BrushingToggleButton.this.setButtonSelected((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public Action getAction() {
        return new ExpansionMenuAction();
    }

    public void updateUI() {
        try {
            super.updateUI();
        }
        catch (Error error) {
            this.setUI(UIManager.getUI(new JButton()));
            this.invalidate();
        }
    }

    private void init() {
        if (PlatformInfo.isMacintosh()) {
            this.setButtonStyle(0);
        } else {
            this.setButtonStyle(2);
        }
        this.setBackgroundOfState(2, SystemColor.control);
        this.setRolloverEnabled(false);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.page.datamgr.resources.RES_LinkedPlots");
        this.setToolTipText(resourceBundle.getString("BrushModeButton.Tooltip"));
        this.setButtonSelected(false);
    }

    public void cleanup() {
        this.removeActionListener(this.fSelectionListener);
        this.rmColorSelectionAction(this.fColorSelectionListener);
        this.fSelectionListener = null;
        this.fColorSelectionListener = null;
    }

    public Color getCurrentColor() {
        return this.fColorChooser.getCurrentColor();
    }

    private void addColorSelectionAction(ActionListener actionListener) {
        this.fColorSelectionListeners.add(actionListener);
    }

    private void rmColorSelectionAction(ActionListener actionListener) {
        this.fColorSelectionListeners.remove(actionListener);
    }

    static {
        MJUtilities.initJIDE();
    }

    private class ExpansionMenuAction
    extends AbstractAction {
        ExpansionMenuAction() {
            super("", BrushingToggleButton.this.fIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BrushingToggleButton.this.fSelectionListener != null) {
                BrushingToggleButton.this.setButtonSelected(!BrushingToggleButton.this.isButtonSelected());
                BrushingToggleButton.this.fSelectionListener.actionPerformed(actionEvent);
            }
        }
    }

    private static class ColorIcon
    implements Icon {
        private ImageIcon fBaseImage;
        private Color fColor = Color.red;
        private Rectangle fHotSpot;

        ColorIcon(ImageIcon imageIcon, Rectangle rectangle) {
            this.fBaseImage = imageIcon;
            this.fHotSpot = rectangle;
        }

        public void setColor(Color color) {
            this.fColor = color;
        }

        @Override
        public int getIconHeight() {
            return this.fBaseImage.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.fBaseImage.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.fBaseImage.paintIcon(component, graphics, n, n2);
            graphics.setColor(this.fColor);
            graphics.fillRect(this.fHotSpot.x + n, this.fHotSpot.y + n2, this.fHotSpot.width, this.fHotSpot.height);
        }
    }

    private class SplitColorChooser
    extends ColorPickerPanel {
        private SplitColorChooser() {
        }

        protected void setMatlabColor(Color color) {
            BrushingToggleButton.this.fIcon.setColor(color);
            BrushingToggleButton.this.doClickOnMenu();
            BrushingToggleButton.this.setButtonSelected(true);
            for (int i = 0; i < BrushingToggleButton.this.fColorSelectionListeners.size(); ++i) {
                ((ActionListener)BrushingToggleButton.this.fColorSelectionListeners.elementAt(i)).actionPerformed(new ActionEvent((Object)this, 1001, "ColorSelect"));
            }
            this.repaint();
        }

        protected void addSwatchSelectionListener(MJButton mJButton) {
            if (PlatformInfo.isMacintosh()) {
                mJButton.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        SplitColorChooser.this.fCurrentColor = ((ColorPickerPanel.SwatchButton)mouseEvent.getSource()).getColor();
                        SplitColorChooser.this.setMatlabColor(SplitColorChooser.this.fCurrentColor);
                    }
                });
            } else {
                super.addSwatchSelectionListener(mJButton);
            }
        }

        protected void addMoreColorsButtonListener(MJButton mJButton) {
            if (PlatformInfo.isMacintosh()) {
                mJButton.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        SplitColorChooser.this.showColorDialog();
                    }
                });
            } else {
                super.addMoreColorsButtonListener(mJButton);
            }
        }
    }
}

