/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.rmi.server.UID;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractFileConfiguration
implements Comparable<AbstractFileConfiguration> {
    public static final String NAME_PROP = "name";
    public static final String ASSOCIATED_FILE_PROP = "associatedFile";
    private final String fUniqueID;
    private String fName = "";
    private File fAssociatedFile;
    private transient PropertyChangeSupport fSupport;

    public AbstractFileConfiguration(String string, File file) {
        this(string, file, new UID().toString());
    }

    protected AbstractFileConfiguration(String string, File file, String string2) {
        this.checkName(string);
        this.checkFile(file);
        this.fName = string;
        this.fAssociatedFile = file;
        this.fUniqueID = string2;
    }

    public abstract Type getType();

    public abstract boolean isFileValid();

    private void checkName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The configurations name cannot be null.");
        }
    }

    private void checkFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The configurations file cannot be null.");
        }
    }

    public String getAssociatedFileName() {
        return this.getAssociatedFile().getName();
    }

    public String getAssociatedPathAndFileName() {
        return this.getAssociatedFile().getAbsolutePath();
    }

    public String getAssociatedFileNameWithoutExtension() {
        return FilenameUtils.removeExtension((String)this.getAssociatedFileName());
    }

    public boolean equals(Object object) {
        return object != null && object instanceof AbstractFileConfiguration && this.getUniqueID().equals(((AbstractFileConfiguration)object).getUniqueID());
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.checkName(string);
        String string2 = this.fName;
        this.fName = string;
        this.getSupport().firePropertyChange(NAME_PROP, string2, string);
    }

    public File getAssociatedFile() {
        return this.fAssociatedFile;
    }

    public void setAssociatedFile(File file) {
        this.checkFile(file);
        File file2 = this.fAssociatedFile;
        this.fAssociatedFile = file;
        this.getSupport().firePropertyChange(ASSOCIATED_FILE_PROP, file2, file);
    }

    public String getUniqueID() {
        return this.fUniqueID;
    }

    public PropertyChangeSupport getSupport() {
        if (this.fSupport == null) {
            this.fSupport = new PropertyChangeSupport(this);
        }
        return this.fSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getSupport().removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public int compareTo(AbstractFileConfiguration abstractFileConfiguration) {
        return this.fName.compareTo(abstractFileConfiguration.getName());
    }

    public static abstract class Type<E extends AbstractFileConfiguration> {
        public abstract String getName();

        public abstract E create(File var1);
    }
}

