/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.data;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.matchers.Matcher;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.io.File;
import java.util.Comparator;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;

public class ConfigurationNameUtils {
    private static final String GENERATED_NAME_DELIMITER = "_";
    private static final String GENERATED_NAME_REGEX = "_\\d+?";

    public static String generateConfigurationName(File file) {
        Object object;
        Object object2;
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        DisposableList<AbstractFileConfiguration> disposableList = ConfigurationManager.getInstance().getConfigurationsForFile(file);
        FilterList filterList = new FilterList(disposableList, ConfigurationNameUtils.getConfigurationAutoGeneratedNameMatcher(file));
        SortedList sortedList = new SortedList((EventList)filterList, ConfigurationNameUtils.getConfigurationNameSorter());
        String string = "";
        if (sortedList.size() > 0) {
            object2 = (AbstractFileConfiguration)sortedList.get(sortedList.size() - 1);
            object = ConfigurationNameUtils.getAutoGeneratedSuffix((AbstractFileConfiguration)object2);
            string = object == null ? string + "_2" : string + GENERATED_NAME_DELIMITER + ((Integer)object + 1);
        }
        object2 = FilenameUtils.removeExtension((String)file.getName());
        object = (String)object2 + string;
        disposableList.dispose();
        sortedList.dispose();
        filterList.dispose();
        return object;
    }

    private static Integer getAutoGeneratedSuffix(AbstractFileConfiguration abstractFileConfiguration) {
        Integer n = null;
        String[] stringArray = abstractFileConfiguration.getName().split(GENERATED_NAME_DELIMITER);
        if (stringArray.length > 0) {
            try {
                n = new Integer(stringArray[stringArray.length - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void renameAutoGeneratedConfiguration(AbstractFileConfiguration abstractFileConfiguration, String string) {
        String string2 = FilenameUtils.removeExtension((String)abstractFileConfiguration.getAssociatedFileName());
        string2 = "\\Q" + string2 + "\\E";
        String string3 = abstractFileConfiguration.getName();
        if (ConfigurationNameUtils.isAutoGenerated(abstractFileConfiguration)) {
            string = string.replace("\\", "\\\\");
            String string4 = string3.replaceFirst(string2, string);
            abstractFileConfiguration.setName(string4);
        }
    }

    public static boolean isAutoGenerated(AbstractFileConfiguration abstractFileConfiguration) {
        String string = abstractFileConfiguration.getAssociatedFileNameWithoutExtension();
        boolean bl = false;
        try {
            bl = string.matches(abstractFileConfiguration.getName()) || abstractFileConfiguration.getName().matches(string + GENERATED_NAME_REGEX);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return bl;
    }

    public static Comparator<AbstractFileConfiguration> getConfigurationNameSorter() {
        return new Comparator<AbstractFileConfiguration>(){

            @Override
            public int compare(AbstractFileConfiguration abstractFileConfiguration, AbstractFileConfiguration abstractFileConfiguration2) {
                Integer n = ConfigurationNameUtils.getAutoGeneratedSuffix(abstractFileConfiguration);
                Integer n2 = ConfigurationNameUtils.getAutoGeneratedSuffix(abstractFileConfiguration2);
                boolean bl = FileUtils.areFilesTheSame((File)abstractFileConfiguration.getAssociatedFile(), (File)abstractFileConfiguration2.getAssociatedFile());
                int n3 = bl && n != null && n2 != null ? n.compareTo(n2) : abstractFileConfiguration.getName().compareTo(abstractFileConfiguration2.getName());
                return n3;
            }
        };
    }

    private static Matcher<AbstractFileConfiguration> getConfigurationAutoGeneratedNameMatcher(final File file) {
        return new Matcher<AbstractFileConfiguration>(){

            public boolean matches(AbstractFileConfiguration abstractFileConfiguration) {
                boolean bl = false;
                if (file != null && abstractFileConfiguration.getName() != null) {
                    bl = file.getPath().equals(abstractFileConfiguration.getAssociatedFile().getPath()) && ConfigurationNameUtils.isAutoGenerated(abstractFileConfiguration);
                }
                return bl;
            }
        };
    }
}

