/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationExplorer;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupSelectionListener;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationUiUtils;
import com.mathworks.mwswing.MJPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigurationDetailsContainer
extends MJPanel {
    private static final String EMPTY_PANEL = "empty_panel";
    private final CardLayout fCardLayout = new CardLayout();
    private final ConfigurationExplorer fExplorer;
    private ConfigurationSelectionListener fConfigurationSelectionListener;
    private ConfigurationGroupSelectionListener fConfigurationGroupSelectionListener;
    private Map<AbstractFileConfiguration.Type, ComponentDetailsEditor> fEditors = new HashMap<AbstractFileConfiguration.Type, ComponentDetailsEditor>();

    public ConfigurationDetailsContainer(ConfigurationExplorer configurationExplorer) {
        this.fExplorer = configurationExplorer;
        this.init();
    }

    private void init() {
        this.initListeners();
        this.setLayout(this.fCardLayout);
        Set<AbstractFileConfiguration.Type> set = ConfigurationUiUtils.getTypesWithUiSupports();
        for (AbstractFileConfiguration.Type type : set) {
            String string = type.getName();
            ComponentDetailsEditor componentDetailsEditor = ConfigurationUiUtils.createEditorComponent(type);
            this.add(string, componentDetailsEditor.getEditorComponent());
            this.fEditors.put(type, componentDetailsEditor);
        }
        this.add(EMPTY_PANEL, (Component)new MJPanel());
    }

    private void initListeners() {
        this.fConfigurationSelectionListener = new ConfigurationSelectionListener(){

            @Override
            public void configurationSelected(AbstractFileConfiguration abstractFileConfiguration) {
                ConfigurationDetailsContainer.this.editConfiguration(abstractFileConfiguration);
            }
        };
        this.fExplorer.addConfigurationSelectionListener(this.fConfigurationSelectionListener);
        this.fConfigurationGroupSelectionListener = new ConfigurationGroupSelectionListener(){

            @Override
            public void configurationGroupSelected(AbstractConfigurationGroup.GroupingConfiguration groupingConfiguration) {
                ConfigurationDetailsContainer.this.editConfiguration(groupingConfiguration);
            }
        };
        this.fExplorer.addConfigurationGroupSelectionListener(this.fConfigurationGroupSelectionListener);
    }

    public void cleanup() {
        this.fExplorer.removeConfigurationSelectionListener(this.fConfigurationSelectionListener);
        this.fExplorer.removeConfigurationGroupListSelectionListener(this.fConfigurationGroupSelectionListener);
        Set<AbstractFileConfiguration.Type> set = this.fEditors.keySet();
        for (AbstractFileConfiguration.Type type : set) {
            this.fEditors.get(type).cleanup();
        }
        this.removeAll();
        this.fEditors.clear();
    }

    private <E extends AbstractFileConfiguration> void editConfiguration(E e) {
        if (e == null) {
            this.fCardLayout.show((Container)((Object)this), EMPTY_PANEL);
        } else {
            this.fCardLayout.show((Container)((Object)this), e.getType().getName());
            this.fEditors.get(e.getType()).edit(e);
        }
    }
}

