/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ActionRequestListener;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationDetailsContainer;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationExplorer;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupSelectionListener;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationUiUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ConfigurationEditor {
    private final MJFrame fFrame = new MJFrame(ConfigurationUtils.lookup("window.title"));
    private final ConfigurationExplorer fExplorer = new ConfigurationExplorer(ConfigurationManager.getInstance().getObservedConfigurations());
    private final ConfigurationDetailsContainer fDetails = new ConfigurationDetailsContainer(this.fExplorer);
    private final MJSplitPane fSplitPane = new MJSplitPane(1, (Component)((Object)this.fExplorer), (Component)((Object)this.fDetails));
    private final MJButton fHelpButton = new MJHelpButton();
    private final MJButton fCloseButton = new MJButton(ConfigurationUtils.lookup("close.button"));
    private final MJButton fActionButton = new MJButton();
    private JPanel fButtonPanel;
    private boolean fShouldActionButtonBeEnabled = true;
    private ActionRequestListener fActionRequestListener;
    private ConfigurationSelectionListener fConfigurationSelectionListener;
    private ConfigurationGroupSelectionListener fConfigurationGroupSelectionListener;
    private ActionListener fCloseButtonListener;
    private ActionListener fActionButtonListener;
    private ActionListener fHelpButtonListener;
    private WindowAdapter fWindowListener;

    public ConfigurationEditor(ActionRequestListener actionRequestListener) {
        this.fActionRequestListener = actionRequestListener;
        this.init();
    }

    private void init() {
        this.initNames();
        this.initButtonPanel();
        this.initListeners();
        this.fCloseButton.requestFocusInWindow();
        this.fFrame.getRootPane().setDefaultButton((JButton)this.fCloseButton);
        this.fSplitPane.setBorder(null);
        this.fSplitPane.setDividerLocation(0.27);
        this.fSplitPane.setContinuousLayout(true);
        if (!PlatformInfo.isMacintosh()) {
            this.fSplitPane.setDividerSize(8);
            ((BasicSplitPaneUI)this.fSplitPane.getUI()).getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
        FormLayout formLayout = new FormLayout("d:grow", "d:grow, 5dlu, d");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fFrame.getContentPane());
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.add((Component)this.fSplitPane, cellConstraints.xywh(1, 1, 1, 1, "fill, fill"));
        panelBuilder.add((Component)this.fButtonPanel, cellConstraints.xywh(1, 3, 1, 1, "fill, center"));
        ConfigurationEditor.setConfigurationEditorSize((Window)this.fFrame);
        this.fFrame.setDefaultCloseOperation(2);
        this.fFrame.setCloseOnEscapeEnabled(true);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        WindowUtils.setChildLocationWithinParent(desktop != null && desktop.hasMainFrame() ? desktop.getMainFrame() : null, (Window)this.fFrame);
    }

    private void initNames() {
        this.fFrame.setName("ConfigurationEditorPanel");
        this.fHelpButton.setName("HelpButton");
        this.fActionButton.setName("RunButton");
        this.fCloseButton.setName("DoneButton");
        this.fSplitPane.setName("SplitPane");
        this.fExplorer.setName("Explorer");
        this.fDetails.setName("DetailsPanel");
    }

    private void initButtonPanel() {
        this.fButtonPanel = PlatformInfo.isMacintosh() ? ButtonBarFactory.buildHelpBar((JButton)this.fHelpButton, (JButton)this.fCloseButton, (JButton)this.fActionButton) : ButtonBarFactory.buildRightAlignedBar((JButton)this.fCloseButton, (JButton)this.fActionButton, (JButton)this.fHelpButton);
    }

    private void initListeners() {
        this.fCloseButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationEditor.this.fFrame.dispose();
            }
        };
        this.fCloseButton.addActionListener(this.fCloseButtonListener);
        this.fActionButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigurationEditor.this.fActionRequestListener != null) {
                    ConfigurationEditor.this.fActionRequestListener.actionRequested(ConfigurationEditor.this.fExplorer.getSelectedConfiguration(), (Component)ConfigurationEditor.this.fFrame);
                }
            }
        };
        this.fActionButton.addActionListener(this.fActionButtonListener);
        this.fHelpButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConfigurationUiUtils.getHelpKey(ConfigurationEditor.this.fExplorer.getSelectedConfiguration());
                MLHelpServices.cshDisplayTopic((Object)ConfigurationEditor.this.fFrame, (String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh"), (String)string);
            }
        };
        this.fHelpButton.addActionListener(this.fHelpButtonListener);
        this.fConfigurationSelectionListener = new ConfigurationSelectionListener(){

            @Override
            public void configurationSelected(AbstractFileConfiguration abstractFileConfiguration) {
                ConfigurationEditor.this.fActionButton.setEnabled(abstractFileConfiguration != null && ConfigurationEditor.this.fShouldActionButtonBeEnabled);
                if (abstractFileConfiguration != null) {
                    ConfigurationEditor.this.fActionButton.setText(ConfigurationUiUtils.getConfigurationActionName(abstractFileConfiguration.getType()));
                }
            }
        };
        this.fExplorer.addConfigurationSelectionListener(this.fConfigurationSelectionListener);
        this.fConfigurationGroupSelectionListener = new ConfigurationGroupSelectionListener(){

            @Override
            public void configurationGroupSelected(AbstractConfigurationGroup.GroupingConfiguration groupingConfiguration) {
                ConfigurationEditor.this.fActionButton.setEnabled(false);
            }
        };
        this.fExplorer.addConfigurationGroupSelectionListener(this.fConfigurationGroupSelectionListener);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ConfigurationManager.getInstance().persist(false);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ConfigurationEditor.this.cleanup();
            }
        };
        this.fFrame.addWindowListener((WindowListener)this.fWindowListener);
    }

    private void cleanup() {
        this.fActionRequestListener = null;
        this.fFrame.removeWindowListener((WindowListener)this.fWindowListener);
        this.fCloseButton.removeActionListener(this.fCloseButtonListener);
        this.fActionButton.removeActionListener(this.fActionButtonListener);
        this.fHelpButton.removeActionListener(this.fHelpButtonListener);
        this.fExplorer.removeConfigurationSelectionListener(this.fConfigurationSelectionListener);
        this.fExplorer.removeConfigurationGroupListSelectionListener(this.fConfigurationGroupSelectionListener);
        this.fExplorer.cleanup();
        this.fDetails.cleanup();
    }

    public JFrame getFrame() {
        return this.fFrame;
    }

    public <E extends AbstractFileConfiguration> void showConfigurationsForFile(File file, AbstractFileConfiguration.Type<E> type) {
        E e = ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, type, false, false);
        if (e == null) {
            e = ConfigurationManager.getInstance().createAndAddConfigurationForFile(file, type);
        }
        this.fExplorer.setFilterText(file.getName());
        this.fExplorer.showConfigurationsForFile(file);
        this.setSelectedConfiguration((AbstractFileConfiguration)e);
    }

    public AbstractFileConfiguration getSelectedConfiguration() {
        return this.fExplorer.getSelectedConfiguration();
    }

    public void setSelectedConfiguration(AbstractFileConfiguration abstractFileConfiguration) {
        this.fExplorer.setSelectedConfiguration(abstractFileConfiguration);
    }

    public void setActionButtonEnabled(final boolean bl) {
        this.fShouldActionButtonBeEnabled = bl;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurationEditor.this.fActionButton.setEnabled(bl);
            }
        });
    }

    private static void setConfigurationEditorSize(Window window) {
        Font font = UIManager.getFont("Panel.font");
        FontMetrics fontMetrics = window.getFontMetrics(font);
        int n = PlatformInfo.isMacintosh() ? 66 : 90;
        int n2 = PlatformInfo.isMacintosh() ? 34 : 38;
        int n3 = fontMetrics.stringWidth("M") * n;
        int n4 = fontMetrics.getHeight() * n2;
        window.setSize(n3, n4);
    }

    static int getSubPanelHeight() {
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        return fontMetrics.getHeight() * 2;
    }
}

