/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.debug;

import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.debug.MatlabDebuggerActions;
import com.mathworks.mlwidgets.debug.StopIfDialog;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.debug.DebuggerManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class DebugActions {
    private static EventListenerList sClearBkptsListenerList = new EventListenerList();

    private DebugActions() {
    }

    public static Action getStepAction() {
        return DebugAction.STEP.getAction();
    }

    public static Action getStepNoEchoAction() {
        return DebugAction.STEP_NO_ECHO.getAction();
    }

    public static Action getStepInAction() {
        return DebugAction.STEP_IN.getAction();
    }

    public static Action getStepInNoEchoAction() {
        return DebugAction.STEP_IN_NO_ECHO.getAction();
    }

    public static Action getStepOutAction() {
        return DebugAction.STEP_OUT.getAction();
    }

    public static Action getStepOutNoEchoAction() {
        return DebugAction.STEP_OUT_NO_ECHO.getAction();
    }

    public static Action getContinueAction() {
        return DebugAction.CONTINUE.getAction();
    }

    public static Action getContinueNoEchoAction() {
        return DebugAction.CONTINUE_NO_ECHO.getAction();
    }

    public static Action getExitDebugAction() {
        return DebugAction.EXIT_DEBUG.getAction();
    }

    public static Action getClearAllBkptsAction() {
        return DebugAction.CLEAR_BREAKPOINTS.getAction();
    }

    public static Action getEnableGraphicalDebugAction() {
        return DebugAction.TOGGLE_GRAPHICAL_DEBUG.getAction();
    }

    public static Action getSetErrorBkptsAction() {
        return DebugAction.SET_ERROR_BREAKPOINTS.getAction();
    }

    public static void addClearBkptsListener(ClearBkptListener clearBkptListener) {
        sClearBkptsListenerList.add(ClearBkptListener.class, clearBkptListener);
    }

    public static void removeClearBkptsListener(ClearBkptListener clearBkptListener) {
        sClearBkptsListenerList.remove(ClearBkptListener.class, clearBkptListener);
    }

    public static void addDebugActionsToInputMap(ExtendedInputMap extendedInputMap, boolean bl) {
        for (DebugAction debugAction : DebugAction.values()) {
            if (!debugAction.shouldAddAction(bl)) continue;
            MatlabKeyBindings.getManager().addKeyBindings("MATLABDesktop", debugAction.getActionID(), extendedInputMap);
        }
    }

    public static void addDebugActionsToActionMap(ActionMap actionMap, boolean bl) {
        for (DebugAction debugAction : DebugAction.values()) {
            if (!debugAction.shouldAddAction(bl)) continue;
            actionMap.put(debugAction.getActionID(), (Action)debugAction.getAction());
        }
    }

    public static void debugModeChanged(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DebugAction debugAction : DebugAction.values()) {
                    debugAction.debugModeChanged(bl);
                }
                DebuggerManager.fireStateUpdate((DebuggerManager.DebuggerTransition)(bl ? DebuggerManager.DebuggerTransition.ENTERED : DebuggerManager.DebuggerTransition.EXITED), MatlabDebuggerActions.class);
            }
        });
    }

    static {
        DebugAction.initialize();
        MatlabDebugServices.addDefaultObserverListener((MatlabDebugObserver)new MatlabDebugAdapter(){

            public void doDebugMode(boolean bl) {
                DebugActions.debugModeChanged(bl);
            }
        });
    }

    private static enum DebugAction {
        STEP("debug-step", true, AddPolicy.ADD_ONLY_IF_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)1);
            }
        }
        ,
        STEP_NO_ECHO("debug-step", true, AddPolicy.ADD_ONLY_IF_NO_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommandNoEcho((int)1);
            }
        }
        ,
        STEP_IN("debug-step-in", true, AddPolicy.ADD_ONLY_IF_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)2);
            }
        }
        ,
        STEP_IN_NO_ECHO("debug-step-in", true, AddPolicy.ADD_ONLY_IF_NO_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommandNoEcho((int)2);
            }
        }
        ,
        STEP_OUT("debug-step-out", true, AddPolicy.ADD_ONLY_IF_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)3);
            }
        }
        ,
        STEP_OUT_NO_ECHO("debug-step-out", true, AddPolicy.ADD_ONLY_IF_NO_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommandNoEcho((int)3);
            }
        }
        ,
        CONTINUE("debug-continue", true, AddPolicy.ADD_ONLY_IF_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)4);
            }
        }
        ,
        CONTINUE_NO_ECHO("debug-continue", true, AddPolicy.ADD_ONLY_IF_NO_ECHO){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommandNoEcho((int)4);
            }
        }
        ,
        EXIT_DEBUG("exit-debug", true, AddPolicy.ALWAYS_ADD){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)5);
            }
        }
        ,
        CLEAR_BREAKPOINTS("clear-all-breakpoints", false, AddPolicy.ALWAYS_ADD){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.dbCommand((int)8);
                Object[] objectArray = sClearBkptsListenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != ClearBkptListener.class) continue;
                    ClearBkptListener clearBkptListener = (ClearBkptListener)objectArray[i + 1];
                    clearBkptListener.clearBkpts();
                }
            }
        }
        ,
        SET_ERROR_BREAKPOINTS("show-stop-if-dialog", false, AddPolicy.ALWAYS_ADD){

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                StopIfDialog stopIfDialog;
                if (actionEvent.getSource() instanceof Component) {
                    MJFrame mJFrame = ((Component)actionEvent.getSource()).getParent() instanceof JPopupMenu ? MJFrame.getFrame((Component)((JPopupMenu)((Component)actionEvent.getSource()).getParent()).getInvoker()) : MJFrame.getFrame((Component)((Component)actionEvent.getSource()));
                    stopIfDialog = new StopIfDialog(mJFrame);
                } else {
                    stopIfDialog = new StopIfDialog(null);
                }
                stopIfDialog.showDialog();
            }
        }
        ,
        TOGGLE_GRAPHICAL_DEBUG("toggle-graphical-debugging", false, AddPolicy.ALWAYS_ADD){

            @Override
            protected void intializeActionState() {
                final MJAbstractAction mJAbstractAction = this.getAction();
                mJAbstractAction.setSelected(MatlabDebugServices.isGraphicalDebuggingEnabled());
                mJAbstractAction.setEnabled(true);
                Prefs.addListener((PrefListener)new PrefListener(){

                    public void prefChanged(PrefEvent prefEvent) {
                        if (prefEvent.getPrefKey().equals(DebugAction.sGraphicalDebugKey)) {
                            mJAbstractAction.setSelected(MatlabDebugServices.isGraphicalDebuggingEnabled());
                        }
                    }
                }, (String)DebugAction.sGraphicalDebugKey);
            }

            @Override
            protected void doActionPerformed(ActionEvent actionEvent) {
                boolean bl = MatlabDebugServices.isGraphicalDebuggingEnabled();
                Prefs.setBooleanPref((String)DebugAction.sGraphicalDebugKey, (!bl ? 1 : 0) != 0);
            }
        };

        private static final String sGraphicalDebugKey = "EditorGraphicalDebugging";
        private final String fActionID;
        private final GenericDebugAction fAction;
        private final boolean fEnableInDebugModeOnly;
        private final AddPolicy fAddPolicy;

        private static void initialize() {
        }

        private DebugAction(String string2, boolean bl, AddPolicy addPolicy) {
            this.fEnableInDebugModeOnly = bl;
            this.fAddPolicy = addPolicy;
            this.fActionID = string2;
            this.fAction = new GenericDebugAction();
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", this.fActionID, (ExtendedAction)this.fAction);
            this.intializeActionState();
        }

        protected MJAbstractAction getAction() {
            return this.fAction;
        }

        private String getActionID() {
            return this.fActionID;
        }

        protected void intializeActionState() {
            this.fAction.setEnabled(!this.fEnableInDebugModeOnly);
        }

        private void debugModeChanged(boolean bl) {
            if (this.fEnableInDebugModeOnly) {
                this.getAction().setEnabled(bl);
            }
        }

        private boolean shouldAddAction(boolean bl) {
            return this.fAddPolicy == AddPolicy.ALWAYS_ADD || bl && this.fAddPolicy == AddPolicy.ADD_ONLY_IF_NO_ECHO || !bl && this.fAddPolicy == AddPolicy.ADD_ONLY_IF_ECHO;
        }

        protected abstract void doActionPerformed(ActionEvent var1);

        private class GenericDebugAction
        extends MJAbstractAction {
            private GenericDebugAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DebugAction.this.doActionPerformed(actionEvent);
            }

            public String toString() {
                return "DebugAction '" + DebugAction.this.fActionID + "' with add policy " + (Object)((Object)DebugAction.this.fAddPolicy);
            }
        }

        private static enum AddPolicy {
            ALWAYS_ADD,
            ADD_ONLY_IF_NO_ECHO,
            ADD_ONLY_IF_ECHO;

        }
    }

    public static interface ClearBkptListener
    extends EventListener {
        public void clearBkpts();
    }
}

