/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.debug;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.mcode.MLexer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StopIfDialog {
    public static final String DIALOG_STOP_IF_NAME = "StopIfDialog";
    public static final String TABBED_PANE_NAME = "TabbedPane";
    public static final String PANEL_ERROR_NAME = "StopIfErrorPanel";
    public static final String PANEL_CAUGHT_ERROR_NAME = "StopIfCaughtErrorPanel";
    public static final String PANEL_WARNINGS_NAME = "StopIfWarningsPanel";
    public static final String PANEL_NAN_INF_NAME = "StopIfNaNOrInfPanel";
    public static final String STOP_NEVER_NAME = "never-option";
    public static final String STOP_ALWAYS_NAME = "always-option";
    public static final String STOP_WITH_IDENTIFIER_NAME = "identifier-option";
    public static final String ADD_NAME = "add";
    public static final String REMOVE_NAME = "remove";
    public static final String EDIT_NAME = "edit";
    public static final String LISTBOX_NAME = "identifierList";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.debug.resources.RES_debug");
    private MJFrame fParentFrame;

    StopIfDialog(MJFrame mJFrame) {
        if (mJFrame == null) {
            mJFrame = MatlabDesktopServices.getDesktop().getMainFrame();
        }
        this.fParentFrame = mJFrame;
    }

    public void showDialog() {
        MJButton mJButton = new MJButton(MJUtilities.intlString((String)"labelHelp"));
        Object[] objectArray = new Object[]{MJUtilities.intlString((String)"labelOK"), MJUtilities.intlString((String)"labelCancel"), mJButton};
        StopIfPanel stopIfPanel = new StopIfPanel();
        MJOptionPane mJOptionPane = new MJOptionPane((Object)stopIfPanel.getComponent(), -1, -1, null, objectArray, objectArray[0]);
        final JDialog jDialog = mJOptionPane.createDialog((Component)this.fParentFrame, BUNDLE.getString("sidialog.title"));
        jDialog.setName(DIALOG_STOP_IF_NAME);
        stopIfPanel.setDialog(jDialog);
        jDialog.setMinimumSize(jDialog.getPreferredSize());
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLHelpServices.cshDisplayTopic((Object)jDialog, (String)MLHelpServices.getMapfileName((String)"matlab", (String)"helptargets"), (String)"matlab_env_error_breakpoints");
            }
        });
        mJOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = mJOptionPane.getValue();
        if (object != null && object.equals(MJUtilities.intlString((String)"labelOK"))) {
            int[] nArray = stopIfPanel.getStopIfInfo();
            String[] stringArray = stopIfPanel.getErrorIds();
            String[] stringArray2 = stopIfPanel.getCaughtIds();
            String[] stringArray3 = stopIfPanel.getWarningIds();
            MatlabDebugServices.MatlabStopIf matlabStopIf = new MatlabDebugServices.MatlabStopIf();
            matlabStopIf.setStopIfError(nArray[0], stringArray);
            matlabStopIf.setStopIfCaughtError(nArray[2], stringArray2);
            matlabStopIf.setStopIfWarning(nArray[1], stringArray3);
            matlabStopIf.setStopIfNanInf(nArray[3]);
            matlabStopIf.sendToMATLAB();
        }
    }

    private static class StopIfEntryDialog
    extends MJDialog
    implements ActionListener {
        private String fNewEntry;
        private JTextField fText;

        public StopIfEntryDialog(Dialog dialog, String string, String string2, boolean bl) {
            super(dialog, true);
            Dimension dimension;
            this.setTitle(string);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 3, 5);
            MJLabel mJLabel = new MJLabel(BUNDLE.getString("sidialog.labelIdentifier"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)mJLabel, gridBagConstraints);
            this.fText = new JTextField();
            if (string2 != null && string2.length() > 0) {
                this.fText.setText(string2);
                this.fText.selectAll();
            }
            this.fText.addActionListener(this);
            if (this.getFontMetrics(this.getFont()) != null) {
                dimension = this.fText.getMinimumSize();
                dimension.width = this.getFontMetrics(this.getFont()).stringWidth("exampleError:thisisjustforsize");
                this.fText.setMinimumSize(dimension);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.fText, gridBagConstraints);
            dimension = new MJButton(MJUtilities.intlString((String)"labelOK"));
            dimension.setName("OK");
            dimension.addActionListener(this);
            MJButton mJButton = new MJButton(MJUtilities.intlString((String)"labelCancel"));
            mJButton.addActionListener((ActionListener)this);
            Font font = UIManager.getFont("OptionPane.buttonFont");
            MJButton mJButton2 = new MJButton(MJUtilities.intlString((String)"labelHelp"));
            mJButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MLHelpServices.cshDisplayTopic((Object)StopIfEntryDialog.this, (String)MLHelpServices.getMapfileName((String)"matlab", (String)"helptargets"), (String)"matlab_env_message_identifiers");
                }
            });
            if (font != null) {
                dimension.setFont(font);
                mJButton.setFont(font);
                mJButton2.setFont(font);
            }
            gridBagConstraints.insets = new Insets(2, 5, 10, 5);
            gridBagConstraints.gridy = 1;
            MJLabel mJLabel2 = new MJLabel(BUNDLE.getString("sidialog.example"));
            jPanel.add((Component)mJLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 3, 3, 3);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            if (bl) {
                gridBagConstraints.gridx = 2;
                jPanel.add((Component)mJButton2, gridBagConstraints);
                gridBagConstraints.gridx = 3;
                jPanel.add((Component)mJButton, gridBagConstraints);
                gridBagConstraints.gridx = 4;
                jPanel.add((Component)((Object)dimension), gridBagConstraints);
            } else {
                gridBagConstraints.gridx = 2;
                jPanel.add((Component)((Object)dimension), gridBagConstraints);
                gridBagConstraints.gridx = 3;
                jPanel.add((Component)mJButton, gridBagConstraints);
                gridBagConstraints.gridx = 4;
                jPanel.add((Component)mJButton2, gridBagConstraints);
            }
            this.setFocusTarget(this.fText);
            this.getRootPane().setDefaultButton((JButton)((Object)dimension));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "Center");
            this.pack();
            this.addWindowListener(new StopIfWindowEventHandler());
            Rectangle rectangle = dialog.getBounds();
            rectangle.x += rectangle.width / 2 - this.getSize().width / 2;
            rectangle.y += rectangle.height / 2 - this.getSize().height / 2;
            this.setLocation(rectangle.x, rectangle.y);
            this.setResizable(false);
        }

        private void closeWindow() {
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JTextField) {
                String string = this.fText.getText();
                if (this.isValidIdentifier(string)) {
                    this.fNewEntry = string;
                    this.closeWindow();
                } else {
                    MJOptionPane.showMessageDialog((Component)((Object)this), (Object)BUNDLE.getString("sidialog.msgInvalidID"), (String)BUNDLE.getString("sidialog.titleEntryError"), (int)0);
                    this.fNewEntry = null;
                    this.fText.selectAll();
                }
            } else {
                String string = actionEvent.getActionCommand();
                if (string.equals(MJUtilities.intlString((String)"labelOK"))) {
                    String string2 = this.fText.getText();
                    if (this.isValidIdentifier(string2)) {
                        this.fNewEntry = string2;
                        this.closeWindow();
                    } else {
                        MJOptionPane.showMessageDialog((Component)((Object)this), (Object)BUNDLE.getString("sidialog.msgInvalidID"), (String)BUNDLE.getString("sidialog.titleEntryError"), (int)0);
                        this.fNewEntry = null;
                        this.fText.requestFocus();
                        this.fText.selectAll();
                    }
                } else if (string.equals(MJUtilities.intlString((String)"labelCancel"))) {
                    this.fNewEntry = null;
                    this.closeWindow();
                }
            }
        }

        private boolean isValidIdentifier(String string) {
            return MLexer.isValidMessageIdentifier((String)string);
        }

        String getNewEntry() {
            return this.fNewEntry;
        }

        private class StopIfWindowEventHandler
        extends WindowAdapter {
            private StopIfWindowEventHandler() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StopIfEntryDialog.this.closeWindow();
            }
        }
    }

    private static class StopIfPanel {
        static final int ERROR = 0;
        static final int WARNING = 1;
        static final int CAUGHT = 2;
        static final int NANINF = 3;
        private static final int TOTAL = 4;
        private MJRadioButton[] fAlways;
        private MJRadioButton[] fNever;
        private MJRadioButton[] fSelected;
        private MJButton[] fAddButton;
        private MJButton[] fRemoveButton;
        private MJButton[] fEditButton;
        private MJList[] fListBox;
        private static final String NO_SELECTIONS = StopIfDialog.access$500().getString("sidialog.noSelections");
        private Dialog fDialog;
        private MJTabbedPane fTabbedPane = new MJTabbedPane();
        private MJPanel fPanel = new MJPanel((LayoutManager)new BorderLayout());

        StopIfPanel() {
            this.fPanel.add((Component)this.fTabbedPane, (Object)"Center");
            this.fTabbedPane.setName(StopIfDialog.TABBED_PANE_NAME);
            this.fAlways = new MJRadioButton[4];
            this.fNever = new MJRadioButton[4];
            this.fSelected = new MJRadioButton[3];
            this.fListBox = new MJList[3];
            this.fAddButton = new MJButton[3];
            this.fRemoveButton = new MJButton[3];
            this.fEditButton = new MJButton[3];
            MJPanel mJPanel = this.createPanel(0, StopIfDialog.PANEL_ERROR_NAME, "sidialog.tabErrors");
            MJPanel mJPanel2 = this.createPanel(1, StopIfDialog.PANEL_WARNINGS_NAME, "sidialog.tabWarnings");
            MJPanel mJPanel3 = this.createPanel(2, StopIfDialog.PANEL_CAUGHT_ERROR_NAME, "sidialog.tabCaughtErrors");
            MJPanel mJPanel4 = this.createPanel(3, StopIfDialog.PANEL_NAN_INF_NAME, "sidialog.tabNanInf");
            this.fTabbedPane.add(BUNDLE.getString("sidialog.tabErrors"), (Component)mJPanel);
            this.fTabbedPane.add(BUNDLE.getString("sidialog.tabCaughtErrors"), (Component)mJPanel3);
            this.fTabbedPane.add(BUNDLE.getString("sidialog.tabWarnings"), (Component)mJPanel2);
            this.fTabbedPane.add(BUNDLE.getString("sidialog.tabNanInf"), (Component)mJPanel4);
            int[] nArray = new int[4];
            try {
                nArray[0] = MatlabDebugServices.getStopIfErrorState();
                nArray[1] = MatlabDebugServices.getStopIfWarningState();
                nArray[2] = MatlabDebugServices.getStopIfCaughtErrorState();
                nArray[3] = MatlabDebugServices.getStopIfNanInfState();
            }
            catch (IllegalStateException illegalStateException) {
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = 0;
                nArray[3] = 0;
            }
            for (int i = 0; i < 3; ++i) {
                if (nArray[i] == 2) {
                    this.setSelectionsExist(i, true);
                    StopIfPanel.populateListbox(i, this.fListBox[i]);
                    this.fListBox[i].setSelectedIndex(0);
                    this.fAddButton[i].setEnabled(true);
                    this.fRemoveButton[i].setEnabled(true);
                    this.fEditButton[i].setEnabled(true);
                } else {
                    this.setSelectionsExist(i, false);
                    this.setupForNoSelections(i);
                    this.fAddButton[i].setEnabled(false);
                    this.fEditButton[i].setEnabled(false);
                    this.fRemoveButton[i].setEnabled(false);
                }
                this.fAlways[i].addActionListener((ActionListener)new RadioButtonListener(i, false));
                this.fNever[i].addActionListener((ActionListener)new RadioButtonListener(i, false));
                this.fSelected[i].addActionListener((ActionListener)new RadioButtonListener(i, true));
                if (nArray[i] == 0) {
                    this.fNever[i].setSelected(true);
                } else if (nArray[i] == 1) {
                    this.fAlways[i].setSelected(true);
                } else {
                    this.fSelected[i].setSelected(true);
                }
                this.fAddButton[i].addActionListener((ActionListener)new Add(i, (JList)this.fListBox[i], (JButton)this.fRemoveButton[i], (JButton)this.fEditButton[i]));
                this.fRemoveButton[i].addActionListener((ActionListener)new Remove(i, (JList)this.fListBox[i], (JButton)this.fRemoveButton[i], (JButton)this.fEditButton[i]));
                this.fEditButton[i].addActionListener((ActionListener)new Edit(i, (JList)this.fListBox[i], (JButton)this.fRemoveButton[i], (JButton)this.fEditButton[i]));
                this.fListBox[i].addListSelectionListener((ListSelectionListener)new IdentifierListboxListener(i));
            }
            if (nArray[3] == 0) {
                this.fNever[3].setSelected(true);
            } else if (nArray[3] == 1) {
                this.fAlways[3].setSelected(true);
            } else {
                this.fSelected[3].setSelected(true);
            }
            this.fTabbedPane.getAccessibleContext().setAccessibleName(BUNDLE.getString("sidialog.tab.acc"));
        }

        public Component getComponent() {
            return this.fPanel;
        }

        private static void populateListbox(int n, MJList mJList) {
            String[] stringArray;
            try {
                stringArray = n == 0 ? MatlabDebugServices.getStopIfErrorIdentifiers() : (n == 1 ? MatlabDebugServices.getStopIfWarningIdentifiers() : MatlabDebugServices.getStopIfCaughtErrorIdentifiers());
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)mJList.getModel();
            for (String string : stringArray) {
                defaultListModel.addElement(string);
            }
        }

        private int[] getStopIfInfo() {
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = this.fAlways[i].isSelected() ? 1 : (this.fNever[i].isSelected() ? 0 : (this.getSelectionsExist(i) ? 2 : 1));
            }
            return nArray;
        }

        private String[] getErrorIds() {
            return this.getIds(0);
        }

        private String[] getCaughtIds() {
            return this.getIds(2);
        }

        private String[] getWarningIds() {
            return this.getIds(1);
        }

        private String[] getIds(int n) {
            if (this.fSelected[n].isSelected()) {
                int n2 = this.fListBox[n].getModel().getSize();
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = (String)this.fListBox[n].getModel().getElementAt(i);
                }
                return stringArray;
            }
            return null;
        }

        private MJPanel createPanel(int n, String string, String string2) {
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            mJPanel.setName(string);
            mJPanel.getAccessibleContext().setAccessibleName(BUNDLE.getString(string2));
            String string3 = this.getRadioButtonLabel(n, false);
            this.fNever[n] = new MJRadioButton(string3);
            this.fNever[n].setName(StopIfDialog.STOP_NEVER_NAME);
            String string4 = this.getRadioButtonLabel(n, true);
            this.fAlways[n] = new MJRadioButton(string4, false);
            this.fAlways[n].setName(StopIfDialog.STOP_ALWAYS_NAME);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.fNever[n]);
            buttonGroup.add((AbstractButton)this.fAlways[n]);
            FormLayout formLayout = new FormLayout(MJUtilities.getRadioButtonIndent() + "px, p:grow, 1dlu, p", "p, 1dlu, p, 1dlu, p, 1dlu, p, 1dlu, p, 1dlu, p, 1dlu, p:grow");
            CellConstraints cellConstraints = new CellConstraints();
            PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
            panelBuilder.setDefaultDialogBorder();
            panelBuilder.add((Component)this.fNever[n], cellConstraints.xywh(1, 1, 4, 1, "left, center"));
            panelBuilder.add((Component)this.fAlways[n], cellConstraints.xywh(1, 3, 4, 1, "left, center"));
            if (n != 3) {
                String string5 = this.getRadioButtonLabelForId(n);
                this.fSelected[n] = new MJRadioButton(string5);
                this.fSelected[n].setName(StopIfDialog.STOP_WITH_IDENTIFIER_NAME);
                buttonGroup.add((AbstractButton)this.fSelected[n]);
                DefaultListModel defaultListModel = new DefaultListModel();
                this.fListBox[n] = new MJList(defaultListModel);
                this.fListBox[n].setName(StopIfDialog.LISTBOX_NAME);
                this.fListBox[n].getAccessibleContext().setAccessibleName(BUNDLE.getString("sidialog.list.acc"));
                MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fListBox[n]);
                this.fAddButton[n] = new MJButton(BUNDLE.getString("sidialog.buttonAdd"));
                this.fAddButton[n].setName(StopIfDialog.ADD_NAME);
                this.fRemoveButton[n] = new MJButton(BUNDLE.getString("sidialog.buttonRemove"));
                this.fRemoveButton[n].setName(StopIfDialog.REMOVE_NAME);
                this.fEditButton[n] = new MJButton(BUNDLE.getString("sidialog.buttonEdit"));
                this.fEditButton[n].setName(StopIfDialog.EDIT_NAME);
                panelBuilder.add((Component)this.fSelected[n], cellConstraints.xywh(1, 5, 4, 1, "left, center"));
                panelBuilder.add((Component)mJScrollPane, cellConstraints.xywh(2, 7, 1, 7, "fill, fill"));
                panelBuilder.add((Component)this.fAddButton[n], cellConstraints.xywh(4, 7, 1, 1, "fill, top"));
                panelBuilder.add((Component)this.fRemoveButton[n], cellConstraints.xywh(4, 9, 1, 1, "fill, top"));
                panelBuilder.add((Component)this.fEditButton[n], cellConstraints.xywh(4, 11, 1, 1, "fill, top"));
            }
            return mJPanel;
        }

        private String getRadioButtonLabel(int n, boolean bl) {
            if (bl) {
                if (n == 0) {
                    return BUNDLE.getString("sidialog.radiobuttonAlwaysError");
                }
                if (n == 2) {
                    return BUNDLE.getString("sidialog.radiobuttonAlwaysCaughtError");
                }
                if (n == 1) {
                    return BUNDLE.getString("sidialog.radiobuttonAlwaysWarning");
                }
                return BUNDLE.getString("sidialog.radiobuttonAlwaysNanInf");
            }
            if (n == 0) {
                return BUNDLE.getString("sidialog.radiobuttonNeverError");
            }
            if (n == 2) {
                return BUNDLE.getString("sidialog.radiobuttonNeverCaughtError");
            }
            if (n == 1) {
                return BUNDLE.getString("sidialog.radiobuttonNeverWarning");
            }
            return BUNDLE.getString("sidialog.radiobuttonNeverNanInf");
        }

        private String getRadioButtonLabelForId(int n) {
            String string = n == 0 ? BUNDLE.getString("sidialog.id1") : (n == 2 ? BUNDLE.getString("sidialog.id2") : BUNDLE.getString("sidialog.id3"));
            return BUNDLE.getString("sidialog.radiobuttonId") + string;
        }

        private void setupForNoSelections(int n) {
            DefaultListModel defaultListModel = (DefaultListModel)this.fListBox[n].getModel();
            defaultListModel.addElement(NO_SELECTIONS);
            this.setRemoveAndEditButtons(n, false);
            this.fListBox[n].setEnabled(false);
        }

        private void setRemoveAndEditButtons(int n, boolean bl) {
            if (bl && this.getSelectionsExist(n)) {
                this.fListBox[n].setSelectedIndex(0);
                this.fRemoveButton[n].setEnabled(true);
                this.fEditButton[n].setEnabled(true);
                this.fListBox[n].setEnabled(true);
            } else {
                this.fRemoveButton[n].setEnabled(false);
                this.fEditButton[n].setEnabled(false);
                this.fListBox[n].setEnabled(false);
                this.fListBox[n].clearSelection();
            }
        }

        private boolean getSelectionsExist(int n) {
            Integer n2 = (Integer)this.fListBox[n].getClientProperty((Object)"selectionsExists");
            return n2 == 1;
        }

        private void setSelectionsExist(int n, boolean bl) {
            int n2 = bl ? 1 : 0;
            this.fListBox[n].putClientProperty((Object)"selectionsExists", (Object)n2);
        }

        private void setDialog(Dialog dialog) {
            this.fDialog = dialog;
        }

        private class Edit
        implements ActionListener {
            int fType;
            JList fList;
            JButton fRemove;
            JButton fEdit;

            Edit(int n, JList jList, JButton jButton, JButton jButton2) {
                this.fType = n;
                this.fList = jList;
                this.fRemove = jButton;
                this.fEdit = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)this.fList.getModel();
                String string = (String)this.fList.getSelectedValue();
                String string2 = BUNDLE.getString("sidialog.titleEditEntry");
                StopIfEntryDialog stopIfEntryDialog = new StopIfEntryDialog(StopIfPanel.this.fDialog, string2, string, PlatformInfo.isMacintosh());
                stopIfEntryDialog.show();
                String string3 = stopIfEntryDialog.getNewEntry();
                if (string3 != null && string3.length() > 0) {
                    defaultListModel.set(this.fList.getSelectedIndex(), string3);
                }
            }
        }

        private class Remove
        implements ActionListener {
            private int fType;
            private JList fList;
            private JButton fRemove;
            private JButton fEdit;

            Remove(int n, JList jList, JButton jButton, JButton jButton2) {
                this.fType = n;
                this.fList = jList;
                this.fRemove = jButton;
                this.fEdit = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = this.fList.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)this.fList.getModel();
                if (nArray == null || nArray.length == 0) {
                    StopIfPanel.this.setSelectionsExist(this.fType, false);
                } else {
                    int n;
                    for (n = nArray.length - 1; n >= 0; --n) {
                        defaultListModel.remove(nArray[n]);
                    }
                    if (this.fList.getModel().getSize() == 0) {
                        StopIfPanel.this.setSelectionsExist(this.fType, false);
                    } else {
                        n = nArray[0] <= this.fList.getModel().getSize() - 1 ? nArray[0] : this.fList.getModel().getSize() - 1;
                        this.fList.setSelectedIndex(n);
                    }
                }
                if (!StopIfPanel.this.getSelectionsExist(this.fType)) {
                    StopIfPanel.this.setupForNoSelections(this.fType);
                }
            }
        }

        private class Add
        implements ActionListener {
            private int fType;
            private JList fList;
            private JButton fRemove;
            private JButton fEdit;

            Add(int n, JList jList, JButton jButton, JButton jButton2) {
                this.fType = n;
                this.fList = jList;
                this.fRemove = jButton;
                this.fEdit = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = BUNDLE.getString("sidialog.titleAddEntry");
                StopIfEntryDialog stopIfEntryDialog = new StopIfEntryDialog(StopIfPanel.this.fDialog, string, null, PlatformInfo.isMacintosh());
                stopIfEntryDialog.show();
                String string2 = stopIfEntryDialog.getNewEntry();
                if (string2 != null && string2.length() > 0) {
                    DefaultListModel defaultListModel = (DefaultListModel)this.fList.getModel();
                    if (!StopIfPanel.this.getSelectionsExist(this.fType)) {
                        defaultListModel.remove(0);
                        StopIfPanel.this.setSelectionsExist(this.fType, true);
                        this.fList.setEnabled(true);
                    }
                    defaultListModel.addElement(string2);
                    this.fList.setSelectedIndex(defaultListModel.size() - 1);
                    this.fList.ensureIndexIsVisible(defaultListModel.size() - 1);
                    this.fRemove.setEnabled(true);
                    this.fEdit.setEnabled(true);
                }
            }
        }

        private class IdentifierListboxListener
        implements ListSelectionListener {
            private int fType;

            IdentifierListboxListener(int n) {
                this.fType = n;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                int[] nArray = jList.getSelectedIndices();
                if (nArray.length != 1) {
                    StopIfPanel.this.fEditButton[this.fType].setEnabled(false);
                } else {
                    StopIfPanel.this.fEditButton[this.fType].setEnabled(true);
                }
            }
        }

        private class RadioButtonListener
        implements ActionListener {
            private int fType;
            private boolean fEnableOption;

            RadioButtonListener(int n, boolean bl) {
                this.fType = n;
                this.fEnableOption = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StopIfPanel.this.fAddButton[this.fType].setEnabled(this.fEnableOption);
                StopIfPanel.this.setRemoveAndEditButtons(this.fType, this.fEnableOption);
            }
        }
    }
}

