/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PathUpdateDialog {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.dialog.resources.RES_dialog");
    private static final String PREFIX = "PathUpdateDialog.";
    public static final int CHOICE_CHANGEPATH = 1;
    public static final int CHOICE_ADDPATHTOP = 2;
    public static final int CHOICE_CANCEL = 4;
    private static final Option ADD_TO_PATH_OPTION = new Option(sRes.getString("PathUpdateDialog.button.addToPath"), 2);
    private static final Option CHANGE_DIR_OPTION = new Option(sRes.getString("PathUpdateDialog.button.changeDirectory"), 1);
    public static final int FILE_NOT_ON_PATH = 0;
    public static final int FILE_WILL_RUN = 1;
    public static final int FILE_SHADOWED_BY_PWD = 2;
    public static final int FILE_SHADOWED_BY_TBX = 3;
    public static final int FILE_SHADOWED_BY_PFILE = 4;
    public static final int FILE_SHADOWED_BY_MEXFILE = 5;
    public static final String HELP_TOPIC_NOT_ON_PATH = "ml_env_ed_notonpath";
    public static final String HELP_TOPIC_SHADOWED = "ml_env_ed_shadowed";
    private static final int MESSAGE_COLUMNS = 80;
    private static final int BOLD_MESSAGE_COLUMNS = 65;
    private static final int LARGE_VERTICAL_GAP = 12;
    private final String fProblem;
    private final String fTitle;
    private final String fSolutionStart;
    private final String fHelpTopic;
    private final Frame fParentFrame;
    private final boolean fEnableAddPath;
    private JDialog fDialog;

    public PathUpdateDialog(Frame frame, String string, String string2, String string3, int n) {
        this(frame, string, string2, string3, PathUpdateDialog.getHelpTopic(n), n);
    }

    private static String getHelpTopic(int n) {
        assert (n == 0 || n == 3 || n == 2);
        return n == 0 ? HELP_TOPIC_NOT_ON_PATH : HELP_TOPIC_SHADOWED;
    }

    public PathUpdateDialog(Frame frame, String string, String string2, String string3, String string4, int n) {
        String string5;
        if (frame == null) {
            throw new IllegalArgumentException("'frame' cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("'title' cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("'filename' cannot be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("'solutionStart' cannot be null");
        }
        this.fTitle = string;
        this.fParentFrame = frame;
        switch (n) {
            case 0: {
                string5 = "message.notOnPath";
                break;
            }
            case 2: {
                string5 = "message.shadowedByPwd";
                break;
            }
            case 3: {
                string5 = "message.shadowedByPath";
                break;
            }
            default: {
                throw new IllegalArgumentException("'option' must be one of FILE_NOT_ON_PATH, FILE_SHADOWED_BY_PWD, or FILE_SHADOWED_BY_TBX");
            }
        }
        this.fProblem = MessageFormat.format(sRes.getString(PREFIX + string5), FileUtils.truncatePathname((String)string2, (int)45));
        this.fHelpTopic = string4;
        this.fEnableAddPath = n != 2;
        this.fSolutionStart = string3;
    }

    public int showDialog() {
        return this.showDialogCustomCancel(MJOptionPane.CANCEL_STRING);
    }

    public int showDialogCustomCancel(String string) {
        JComponent jComponent = this.buildPanel();
        Object[] objectArray = this.buildOptions(string);
        MJOptionPane mJOptionPane = new MJOptionPane((Object)jComponent, 1, 2, null, objectArray, (Object)CHANGE_DIR_OPTION);
        this.fDialog = mJOptionPane.createDialog((Component)this.fParentFrame, this.fTitle);
        this.fDialog.setResizable(false);
        this.fDialog.show();
        this.fDialog.dispose();
        Object object = mJOptionPane.getValue();
        return object == null || object instanceof Integer ? 4 : ((Option)object).getChoice();
    }

    private JComponent buildPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        MJMultilineLabel mJMultilineLabel = PathUpdateDialog.createSizedLabel(this.fProblem, 65);
        mJMultilineLabel.setFont(mJMultilineLabel.getFont().deriveFont(1));
        jPanel.add((Component)mJMultilineLabel, "North");
        String string = this.fEnableAddPath ? MessageFormat.format(sRes.getString("PathUpdateDialog.label.solutionChangeOrAdd"), this.fSolutionStart) : MessageFormat.format(sRes.getString("PathUpdateDialog.label.solutionChangeDir"), this.fSolutionStart);
        jPanel.add((Component)PathUpdateDialog.createSizedLabel(string, 80), "Center");
        return jPanel;
    }

    private static MJMultilineLabel createSizedLabel(String string, int n) {
        String string2 = StringUtils.insertLineBreaks((String)string, (int)n);
        return new MJMultilineLabel(string2, false);
    }

    private Object[] buildOptions(String string) {
        Option option = new Option(string, 4);
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(MJUtilities.intlString((String)"labelHelp")){

            public void actionPerformed(ActionEvent actionEvent) {
                PathUpdateDialog.this.showHelp();
            }
        });
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (PlatformInfo.isMacintosh()) {
            arrayList.add(mJButton);
            if (this.fEnableAddPath) {
                arrayList.add(ADD_TO_PATH_OPTION);
            }
            arrayList.add(CHANGE_DIR_OPTION);
            arrayList.add(option);
        } else {
            arrayList.add(CHANGE_DIR_OPTION);
            if (this.fEnableAddPath) {
                arrayList.add(ADD_TO_PATH_OPTION);
            }
            arrayList.add(option);
            arrayList.add(mJButton);
        }
        return arrayList.toArray();
    }

    private void showHelp() {
        MLHelpServices.cshDisplayTopic((Object)this.fDialog, (String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)this.fHelpTopic);
    }

    private static class Option {
        private final String fLabel;
        private final int fChoice;

        public Option(String string, int n) {
            this.fLabel = string;
            this.fChoice = n;
        }

        public int getChoice() {
            return this.fChoice;
        }

        public String toString() {
            return this.fLabel;
        }
    }
}

