/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ArchiveType {
    TAR("tar", "untar", ".tar"),
    COMPRESSED_TAR("tar", "untar", ".tar.gz", ".tgz"),
    ZIP("zip", "unzip", ".zip");

    private final String fExtractCommand;
    private final String fCreateCommand;
    private final List<String> fExtensions;

    private ArchiveType(String string2, String string3, String ... stringArray) {
        this.fCreateCommand = string2;
        this.fExtractCommand = string3;
        this.fExtensions = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public String getCreateCommand() {
        return this.fCreateCommand;
    }

    public String getExtractCommand() {
        return this.fExtractCommand;
    }

    public String[] getExtensions() {
        return this.fExtensions.toArray(new String[this.fExtensions.size()]);
    }

    public static ArchiveType get(FileSystemEntry fileSystemEntry) {
        if (!fileSystemEntry.isFolder()) {
            for (ArchiveType archiveType : ArchiveType.values()) {
                if (!fileSystemEntry.getLocation().checkExtension(archiveType.getExtensions())) continue;
                return archiveType;
            }
        }
        return null;
    }
}

