/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileDetailPanelData;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.explorer.extensions.matlab.Variable;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Converter;
import com.mathworks.widgets.datatransfer.MATFileVariableReference;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.RightClickSelectionHandler;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.SendHandler;
import com.mathworks.widgets.grouptable.transfer.Transfer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MATFileDetailPanel
implements DetailPanel {
    private final FileSystemEntry fFile;
    private final MATFileDetailPanelData fData;
    private final Status fStatus;
    private final GroupingTable<Variable> fTable;

    public MATFileDetailPanel(FileSystemEntry fileSystemEntry) {
        Status status;
        this.fFile = fileSystemEntry;
        this.fData = new MATFileDetailPanelData(this.fFile);
        try {
            status = this.fData.startLoading();
        }
        catch (IOException iOException) {
            status = Status.COMPLETED;
        }
        this.fStatus = status;
        GroupingTableColumn groupingTableColumn = new GroupingTableColumn("name", ExplorerResources.getString("matprovider.variable.name"), true, (Converter)new Converter<Variable, String>(){

            public String convert(Variable variable) {
                return variable.getName();
            }
        });
        GroupingTableColumn groupingTableColumn2 = new GroupingTableColumn("value", ExplorerResources.getString("matprovider.variable.value"), true, (Converter)new Converter<Variable, String>(){

            public String convert(Variable variable) {
                return variable.getSimpleValue();
            }
        });
        GroupingMode<Variable> groupingMode = new GroupingMode<Variable>(){

            public String getKey() {
                return "icon";
            }

            public String getName() {
                return ExplorerResources.getString("matprovider.variable.type");
            }

            public List<Group<Variable>> getGroups(List<Variable> list) {
                return GroupingTableUtils.generateDirectGrouping(list, (Converter)new Converter<Variable, String>(){

                    public String convert(Variable variable) {
                        return variable.getType();
                    }
                });
            }
        };
        GroupingTableColumn groupingTableColumn3 = new GroupingTableColumn("icon", ExplorerResources.getString("matprovider.variable.icon"), true, Icon.class, MATFileDetailPanel.createGrayWorkspaceIcon(), (Converter)new Converter<Variable, Icon>(){

            public Icon convert(Variable variable) {
                return WorkspaceIcon.getIcon(variable.getType());
            }
        }, null, (Comparator)new Comparator<Variable>(){

            @Override
            public int compare(Variable variable, Variable variable2) {
                return variable.getType().compareTo(variable2.getType());
            }
        }, new GroupingMode[]{groupingMode});
        List<GroupingTableColumn> list = Arrays.asList(groupingTableColumn3, groupingTableColumn, groupingTableColumn2);
        Vector vector = new Vector();
        GroupingTableConfiguration groupingTableConfiguration = new GroupingTableConfiguration(list, vector);
        groupingTableConfiguration.setFixedColumnSize(groupingTableColumn3, 22);
        final GroupingTableModel groupingTableModel = new GroupingTableModel(groupingTableConfiguration, null);
        this.fTable = new GroupingTable(groupingTableModel);
        File file = new File(this.fFile.getLocation().toString());
        MATFileTransferHandler mATFileTransferHandler = new MATFileTransferHandler(file, (Component)this.fTable);
        this.fTable.setIndent(0);
        this.fTable.addSendHandler((SendHandler)mATFileTransferHandler);
        this.fTable.addReceiveHandler((ReceiveHandler)mATFileTransferHandler);
        new RightClickSelectionHandler(this.fTable);
        this.fData.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Variable variable = (Variable)changeEvent.getSource();
                GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
                groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)variable);
                groupingTableModel.change(groupingTableTransaction);
            }
        });
        GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
        for (Variable object2 : this.fData.getVariables()) {
            groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)object2);
        }
        groupingTableModel.change(groupingTableTransaction);
        this.fTable.setShowGrid(false);
        this.fTable.setAddedToClient();
        Iterator<Variable> iterator = new MJAbstractAction(ExplorerResources.getString("matmenu.load.simple")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FileSystemEntry fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(MATFileDetailPanel.this.fFile);
                    File file = new File(fileSystemEntry.getLocation().toString());
                    MATFileUtils.load(file, MATFileUtils.getNames(MATFileDetailPanel.this.fTable.getSelectedItems()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.fTable.addMouseListener((MouseListener)new MouseAdapter((MJAbstractAction)iterator){
            final /* synthetic */ MJAbstractAction val$loadAction;
            {
                this.val$loadAction = mJAbstractAction;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent)) {
                    this.val$loadAction.actionPerformed(null);
                }
            }
        });
        InputMap inputMap = this.fTable.getInputMap(0);
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(inputMap);
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("Explorer", "open-selection", iterator);
        this.fTable.getActionMap().put("open-selection", (Action)((Object)iterator));
        MatlabKeyBindings.getManager().addKeyBindings("Explorer", "open-selection", (ExtendedInputMap)mInputMap);
        this.fTable.setInputMap(0, (InputMap)mInputMap);
    }

    public JComponent getComponent() {
        return this.fTable;
    }

    public Status getLoadStatus() {
        return this.fStatus;
    }

    public boolean isScrollBarNeeded() {
        return true;
    }

    private static Icon createGrayWorkspaceIcon() {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(100, 100, 102));
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
        graphics2D.draw(new Line2D.Double(8.0, 0.0, 8.0, 15.0));
        graphics2D.draw(new Line2D.Double(0.0, 8.0, 15.0, 8.0));
        return new ImageIcon(bufferedImage);
    }

    private static class MATFileTransferHandler
    implements SendHandler<Variable>,
    ReceiveHandler<Variable> {
        private final File fFile;
        private final Component fParent;

        MATFileTransferHandler(File file, Component component) {
            this.fFile = file;
            this.fParent = component;
        }

        public boolean accept(List<Variable> list) {
            return true;
        }

        public boolean moveByDefault() {
            return false;
        }

        public boolean supportsMove() {
            return false;
        }

        public boolean supportsCopy() {
            return true;
        }

        public Transferable wrap(GroupingTable<Variable> groupingTable, List<Variable> list, boolean bl) {
            Vector<MATFileVariableReference> vector = new Vector<MATFileVariableReference>();
            for (Variable object2 : list) {
                vector.add(new MATFileVariableReference(this.fFile, object2.getName()));
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Variable> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return MJTransferable.getCombinedTransferable((Transferable[])new Transferable[]{new StringSelection(stringBuilder.toString()), MLDataFlavor.encodeMatReferenceListFlavor((MATFileVariableReference[])vector.toArray(new MATFileVariableReference[vector.size()]))});
        }

        public boolean accept(Variable variable, Transfer transfer, boolean bl) {
            return variable == null && transfer.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor);
        }

        public boolean shouldForceCopy(Transfer transfer) {
            return false;
        }

        public Status transfer(GroupingTable<Variable> groupingTable, Variable variable, Transfer transfer, boolean bl, boolean bl2, boolean bl3) {
            List list;
            assert (variable == null);
            if (transfer.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) && MATFileUtils.confirmOverwriteFileIfNecessary(this.fParent, list = transfer.getTransferList(MLDataFlavor.simpleVariableListFlavor), this.fFile)) {
                MATFileUtils.save(this.fParent, this.fFile, MATFileUtils.getVariableNames(list), false);
            }
            return Status.COMPLETED;
        }
    }
}

