/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.common.icons.ReportIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.util.MatlabUtils;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import javax.swing.Icon;

public final class ReportActionProvider
implements ActionProvider {
    private static final ActionDefinition MLINT_REPORT = ReportActionProvider.create("reports.mlint", ReportIcon.MLINT);
    private static final ActionDefinition TODO_REPORT = ReportActionProvider.create("reports.todo", ReportIcon.TODO);
    private static final ActionDefinition HELP_REPORT = ReportActionProvider.create("reports.help", ReportIcon.HELP);
    private static final ActionDefinition CONTENTS_REPORT = ReportActionProvider.create("reports.contents", ReportIcon.CONTENTS);
    private static final ActionDefinition DEPENDENCY_REPORT = ReportActionProvider.create("reports.depen", ReportIcon.DEPENDENCY);
    private static final ActionDefinition COVERAGE_REPORT = ReportActionProvider.create("reports.cov", ReportIcon.PROFILER);

    private static ActionDefinition create(String string, ReportIcon reportIcon) {
        return new ActionDefinition(string, CoreMenuSection.REPORTS.getSection(), ExplorerResources.getString("context.submenu." + string), (Icon)reportIcon.getIcon());
    }

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(MLINT_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                Status status = new Status();
                String string = MLintPrefsUtils.getActiveConfiguration().getFile().getAbsolutePath();
                MatlabUtils.getMatlab().evalConsoleOutput("mlintrpt(cd, 'dir', '" + StringUtils.quoteSingleQuotes((String)string) + "')", (CompletionObserver)new CompletionNotifier(status));
                return status;
            }
        });
        actionRegistry.defineAction(TODO_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new ReportRunner("dofixrpt"));
        actionRegistry.defineAction(HELP_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new ReportRunner("helprpt"));
        actionRegistry.defineAction(CONTENTS_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new ReportRunner("contentsrpt"));
        actionRegistry.defineAction(DEPENDENCY_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new ReportRunner("deprpt"));
        actionRegistry.defineAction(COVERAGE_REPORT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new ReportRunner("coveragerpt"));
    }

    private static final class CompletionNotifier
    implements CompletionObserver {
        private final Status iStatus;

        CompletionNotifier(Status status) {
            this.iStatus = status;
        }

        public void completed(int n, Object object) {
            this.iStatus.markCompleted();
        }
    }

    private static final class ReportRunner
    implements StatusRunnable<ActionInput> {
        private final String iReportCommand;

        ReportRunner(String string) {
            this.iReportCommand = string;
        }

        public Status run(ActionInput actionInput) {
            Status status = new Status();
            MatlabUtils.getMatlab().evalConsoleOutput("runreport('" + this.iReportCommand + "')", (CompletionObserver)new CompletionNotifier(status));
            return status;
        }
    }
}

