/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.services.FontPrefs;
import com.mathworks.services.FontPrefsComponent;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public enum ExplorerPrefs {
    CONFIRM_MAT_REPLACE("true"),
    CONFIRM_MAT_WORKSPACE_REPLACE("true"),
    NO_PERMISSION_CHECK("false"),
    NO_PLUGINS("false"),
    NO_NATIVE_ICONS("false");

    public static final SettingPath CFBNode;
    public static final Setting<Boolean> ShowHiddenFiles;
    public static final Setting<Integer> HistorySize;
    public static final Setting<String[]> History;
    public static final SettingPath RefreshNode;
    public static final Setting<Boolean> AutoRefresh;
    public static final Setting<Integer> AutoRefreshInterval;
    public static final SettingPath LastFolderNode;
    public static final Setting<String> LastFolderGroupColumn;
    public static final Setting<String> LastFolderGroupMode;
    public static final Setting<String> LastFolderSortColumn;
    public static final Setting<Boolean> LastFolderSortDescending;
    public static final Setting<String[]> LastFolderOpenGroups;
    public static final Setting<String[]> LastFolderClosedGroups;
    public static final Setting<String[]> LastFolderColumnSizes;
    public static final Setting<String[]> LastFolderVisibleColumns;
    public static final Setting<String[]> LastFolderColumnOrder;
    public static final SettingPath LastSearchNode;
    public static final Setting<String> LastSearchGroupColumn;
    public static final Setting<String> LastSearchGroupMode;
    public static final Setting<String> LastSearchSortColumn;
    public static final Setting<Boolean> LastSearchSortDescending;
    public static final Setting<String[]> LastSearchOpenGroups;
    public static final Setting<String[]> LastSearchClosedGroups;
    public static final Setting<String[]> LastSearchColumnSizes;
    public static final Setting<String[]> LastSearchVisibleColumns;
    public static final Setting<String[]> LastSearchColumnOrder;
    public static final SettingPath PathAffordanceNode;
    public static final Setting<Boolean> PathAffordanceEnabled;
    public static final Setting<Integer> PathAffordanceTransparency;
    public static final Setting<Integer> CurrentFolderSize;
    private final String fDefault;
    private final List<ChangeListener> fListeners;

    private static <T> Setting<T> getSetting(SettingPath settingPath, Class<T> clazz, String string) {
        try {
            return new Setting(settingPath, clazz, string);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private static SettingPath getSettingPath(String ... stringArray) {
        try {
            return new SettingPath(new SettingPath(), stringArray);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private ExplorerPrefs(String string2) {
        this.fDefault = string2;
        this.fListeners = new Vector<ChangeListener>();
        Prefs.addListener((PrefListener)new PrefListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void prefChanged(PrefEvent prefEvent) {
                Vector vector;
                Object object = ExplorerPrefs.this.fListeners;
                synchronized (object) {
                    vector = new Vector(ExplorerPrefs.this.fListeners);
                }
                object = new ChangeEvent(this);
                for (ChangeListener changeListener : vector) {
                    changeListener.stateChanged((ChangeEvent)object);
                }
            }
        }, (String)this.getKey());
    }

    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Documents");
        boolean bl = true;
        String string = this.toString();
        for (int i = 0; i < string.length(); ++i) {
            if (bl) {
                stringBuilder.append(string.charAt(i));
                bl = false;
                continue;
            }
            if (string.charAt(i) == '_') {
                bl = true;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public boolean getBoolean() {
        return Prefs.getBooleanPref((String)this.getKey(), (boolean)Boolean.parseBoolean(this.fDefault));
    }

    static {
        CFBNode = ExplorerPrefs.getSettingPath("matlab", "desktop", "currentfolder");
        ShowHiddenFiles = ExplorerPrefs.getSetting(CFBNode, Boolean.class, "ShowHiddenFiles");
        HistorySize = ExplorerPrefs.getSetting(CFBNode, Integer.class, "HistorySize");
        History = ExplorerPrefs.getSetting(CFBNode, String[].class, "History");
        RefreshNode = ExplorerPrefs.getSettingPath("matlab", "desktop", "currentfolder", "autorefresh");
        AutoRefresh = ExplorerPrefs.getSetting(RefreshNode, Boolean.class, "Enabled");
        AutoRefreshInterval = ExplorerPrefs.getSetting(RefreshNode, Integer.class, "Interval");
        LastFolderNode = ExplorerPrefs.getSettingPath("matlab", "desktop", "currentfolder", "lastfolder");
        LastFolderGroupColumn = ExplorerPrefs.getSetting(LastFolderNode, String.class, "GroupColumn");
        LastFolderGroupMode = ExplorerPrefs.getSetting(LastFolderNode, String.class, "GroupMode");
        LastFolderSortColumn = ExplorerPrefs.getSetting(LastFolderNode, String.class, "SortColumn");
        LastFolderSortDescending = ExplorerPrefs.getSetting(LastFolderNode, Boolean.class, "SortDescending");
        LastFolderOpenGroups = ExplorerPrefs.getSetting(LastFolderNode, String[].class, "OpenGroups");
        LastFolderClosedGroups = ExplorerPrefs.getSetting(LastFolderNode, String[].class, "ClosedGroups");
        LastFolderColumnSizes = ExplorerPrefs.getSetting(LastFolderNode, String[].class, "ColumnSizes");
        LastFolderVisibleColumns = ExplorerPrefs.getSetting(LastFolderNode, String[].class, "VisibleColumns");
        LastFolderColumnOrder = ExplorerPrefs.getSetting(LastFolderNode, String[].class, "ColumnOrder");
        LastSearchNode = ExplorerPrefs.getSettingPath("matlab", "desktop", "currentfolder", "lastsearch");
        LastSearchGroupColumn = ExplorerPrefs.getSetting(LastSearchNode, String.class, "GroupColumn");
        LastSearchGroupMode = ExplorerPrefs.getSetting(LastSearchNode, String.class, "GroupMode");
        LastSearchSortColumn = ExplorerPrefs.getSetting(LastSearchNode, String.class, "SortColumn");
        LastSearchSortDescending = ExplorerPrefs.getSetting(LastSearchNode, Boolean.class, "SortDescending");
        LastSearchOpenGroups = ExplorerPrefs.getSetting(LastSearchNode, String[].class, "OpenGroups");
        LastSearchClosedGroups = ExplorerPrefs.getSetting(LastSearchNode, String[].class, "ClosedGroups");
        LastSearchColumnSizes = ExplorerPrefs.getSetting(LastSearchNode, String[].class, "ColumnSizes");
        LastSearchVisibleColumns = ExplorerPrefs.getSetting(LastSearchNode, String[].class, "VisibleColumns");
        LastSearchColumnOrder = ExplorerPrefs.getSetting(LastSearchNode, String[].class, "ColumnOrder");
        PathAffordanceNode = ExplorerPrefs.getSettingPath("matlab", "desktop", "currentfolder", "pathaffordance");
        PathAffordanceEnabled = ExplorerPrefs.getSetting(PathAffordanceNode, Boolean.class, "Enabled");
        PathAffordanceTransparency = ExplorerPrefs.getSetting(PathAffordanceNode, Integer.class, "Transparency");
        CurrentFolderSize = ExplorerPrefs.getSetting(CFBNode, Integer.class, "CurrentFolderSize");
    }

    public static class ExplorerFontPrefs
    implements FontPrefsComponent {
        public String getDisplayName() {
            return ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CurrentDirectory");
        }

        public String getFontPrefsTagName() {
            return "CurrentFolder";
        }

        public FontPrefs.FontType getDefaultFont() {
            return FontPrefs.FontType.TEXT;
        }
    }
}

