/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class DefaultActionInput
implements ActionInput {
    private final JComponent fComponent;
    private final ExtensionRegistry fExtensions;
    private final List<FileSystemEntry> fSelection;

    public DefaultActionInput(JComponent jComponent, File ... fileArray) {
        this(jComponent, ExplorerExtensionRegistry.getInstance(), DefaultActionInput.getEntries(fileArray));
    }

    public DefaultActionInput(JComponent jComponent, ExtensionRegistry extensionRegistry, List<FileSystemEntry> list) {
        if (extensionRegistry == null) {
            throw new IllegalArgumentException("The extension registry cannot be null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("The selection cannot be null.");
        }
        this.fComponent = jComponent;
        this.fExtensions = extensionRegistry;
        this.fSelection = new ArrayList<FileSystemEntry>(list);
    }

    public boolean isSearching() {
        return true;
    }

    public FileSystemEntry getLocation() {
        FileLocation fileLocation = MatlabPathModel.getInstance().getCurrentFolder();
        if (fileLocation != null) {
            try {
                return RealFileSystem.getInstance().getEntry(fileLocation);
            }
            catch (IOException iOException) {
                return new FileSystemEntry(RealFileSystem.getInstance(), fileLocation, true, true, 0L, 0L, 0L);
            }
        }
        return null;
    }

    public List<FileSystemEntry> getSelection() {
        return new ArrayList<FileSystemEntry>(this.fSelection);
    }

    public FileSystemEntry[] getSelectionArray() {
        return this.fSelection.toArray(new FileSystemEntry[this.fSelection.size()]);
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration) {
        return UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, fileDecoration, this.fExtensions);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private static List<FileSystemEntry> getEntries(File[] fileArray) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>(fileArray.length);
        for (File file : fileArray) {
            try {
                arrayList.add(RealFileSystem.getInstance().getEntry(new FileLocation(file)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }
}

