/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.TableConfigurationSerializer;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class ExplorerTableConfigurationSerializer
implements TableConfigurationSerializer<FileSystemEntry> {
    private final Setting<String> fGroupColumnPref;
    private final Setting<String> fGroupModePref;
    private final Setting<String> fSortColumnPref;
    private final Setting<Boolean> fSortDescendingPref;
    private final Setting<String[]> fVisibleColumnsPref;
    private final Setting<String[]> fColumnOrderPref;
    private final Setting<String[]> fColumnSizesPref;
    private final Setting<String[]> fExpandedGroupsPref;
    private final Setting<String[]> fCollapsedGroupsPref;

    public ExplorerTableConfigurationSerializer(Setting<String> setting, Setting<String> setting2, Setting<String> setting3, Setting<Boolean> setting4, Setting<String[]> setting5, Setting<String[]> setting6, Setting<String[]> setting7, Setting<String[]> setting8, Setting<String[]> setting9) {
        this.fGroupColumnPref = setting;
        this.fGroupModePref = setting2;
        this.fSortColumnPref = setting3;
        this.fSortDescendingPref = setting4;
        this.fVisibleColumnsPref = setting5;
        this.fColumnOrderPref = setting6;
        this.fColumnSizesPref = setting7;
        this.fExpandedGroupsPref = setting8;
        this.fCollapsedGroupsPref = setting9;
    }

    public void save(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        this.saveGroupMode(groupingTableConfiguration);
        this.saveSortMode(groupingTableConfiguration);
        this.saveVisibleColumns(groupingTableConfiguration);
        this.saveColumnOrder(groupingTableConfiguration);
        this.saveColumnSizes(groupingTableConfiguration);
        this.saveExpandedGroups(groupingTableConfiguration);
        this.saveCollapsedGroups(groupingTableConfiguration);
    }

    public void load(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        this.loadGroupMode(groupingTableConfiguration);
        this.loadSortMode(groupingTableConfiguration);
        this.loadVisibleColumns(groupingTableConfiguration);
        this.loadColumnOrder(groupingTableConfiguration);
        this.loadColumnSizes(groupingTableConfiguration);
        this.loadExpandedGroups(groupingTableConfiguration);
        this.loadCollapsedGroups(groupingTableConfiguration);
    }

    private void saveGroupMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fGroupColumnPref.set((Object)ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getGroupColumn()));
            this.fGroupModePref.set((Object)ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getGroupMode()));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadGroupMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            GroupingTableColumn<FileSystemEntry> groupingTableColumn = ExplorerTableConfigurationSerializer.findColumn(groupingTableConfiguration, (String)this.fGroupColumnPref.get());
            GroupingMode<FileSystemEntry> groupingMode = ExplorerTableConfigurationSerializer.findMode(groupingTableColumn, (String)this.fGroupModePref.get());
            groupingTableConfiguration.setGroupMode(groupingTableColumn, groupingMode);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveSortMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fSortColumnPref.set((Object)ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getSortColumn()));
            this.fSortDescendingPref.set((Object)groupingTableConfiguration.isSortedDescending());
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadSortMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            GroupingTableColumn<FileSystemEntry> groupingTableColumn = ExplorerTableConfigurationSerializer.findColumn(groupingTableConfiguration, (String)this.fSortColumnPref.get());
            if (groupingTableColumn != null) {
                groupingTableConfiguration.setSortColumnAndDescending(groupingTableColumn, ((Boolean)this.fSortDescendingPref.get()).booleanValue());
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveVisibleColumns(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ArrayList arrayList = new ArrayList();
        for (VerticalAttribute verticalAttribute : groupingTableConfiguration.getAllVerticalAttributes()) {
            if (!groupingTableConfiguration.isVerticalAttributeOrColumnVisible(verticalAttribute)) continue;
            arrayList.add(verticalAttribute);
        }
        try {
            this.fVisibleColumnsPref.set((Object)ExplorerTableConfigurationSerializer.getKeys(groupingTableConfiguration.getVisibleColumns(), arrayList));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadVisibleColumns(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList((Object[])this.fVisibleColumnsPref.get()));
            if (!hashSet.isEmpty()) {
                for (GroupingTableColumn groupingTableColumn : groupingTableConfiguration.getAllColumns()) {
                    groupingTableConfiguration.setColumnVisible(groupingTableColumn, hashSet.contains(groupingTableColumn.getKey()));
                }
                for (GroupingTableColumn groupingTableColumn : groupingTableConfiguration.getAllVerticalAttributes()) {
                    groupingTableConfiguration.setVerticalAttributeVisible((VerticalAttribute)groupingTableColumn, hashSet.contains(groupingTableColumn.getKey()));
                }
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveColumnOrder(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fColumnOrderPref.set((Object)ExplorerTableConfigurationSerializer.getKeys(groupingTableConfiguration.getAllColumns()));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadColumnOrder(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            String[] stringArray = (String[])this.fColumnOrderPref.get();
            if (stringArray.length > 0) {
                groupingTableConfiguration.setColumnDisplayOrderByKeys(Arrays.asList(stringArray));
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveColumnSizes(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fColumnSizesPref.set((Object)ExplorerTableConfigurationSerializer.getSizesToSave(groupingTableConfiguration, groupingTableConfiguration.getAllColumns()));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadColumnSizes(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            String[] stringArray = (String[])this.fColumnSizesPref.get();
            List list = groupingTableConfiguration.getAllColumns();
            HashMap hashMap = new HashMap();
            if (stringArray.length == list.size()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(list.get(i), Integer.parseInt(stringArray[i]));
                }
            }
            groupingTableConfiguration.setColumnSizes(hashMap);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveExpandedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fExpandedGroupsPref.set((Object)ExplorerTableConfigurationSerializer.getGroupKeys(groupingTableConfiguration.getExpandedGroups()));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void saveCollapsedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            this.fCollapsedGroupsPref.set((Object)ExplorerTableConfigurationSerializer.getGroupKeys(groupingTableConfiguration.getCollapsedGroups()));
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadExpandedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            for (String string : (String[])this.fExpandedGroupsPref.get()) {
                groupingTableConfiguration.setExpanded(new Group(string, ""), true);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void loadCollapsedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        try {
            for (String string : (String[])this.fCollapsedGroupsPref.get()) {
                groupingTableConfiguration.setExpanded(new Group(string, ""), false);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private static <T> GroupingTableColumn<T> findColumn(GroupingTableConfiguration<T> groupingTableConfiguration, String string) {
        return string == null || string.trim().length() == 0 ? null : groupingTableConfiguration.getColumnByKey(string);
    }

    private static <T> GroupingMode<T> findMode(GroupingTableColumn<T> groupingTableColumn, String string) {
        return groupingTableColumn == null || string == null || string.trim().length() == 0 ? null : groupingTableColumn.getGroupingModeByKey(string);
    }

    private static <T> String getKeyToSave(GroupingTableColumn<T> groupingTableColumn) {
        return groupingTableColumn == null ? "" : groupingTableColumn.getKey();
    }

    private static <T> String getKeyToSave(GroupingMode<T> groupingMode) {
        return groupingMode == null ? "" : groupingMode.getKey();
    }

    private static <T> String[] getGroupKeys(Collection<Group<T>> collection) {
        String[] stringArray = new String[collection.size()];
        Iterator<Group<T>> iterator = collection.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().getKey();
        }
        return stringArray;
    }

    private static <T> String[] getKeys(List<GroupingTableColumn<T>> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getKey();
        }
        return stringArray;
    }

    private static <T> String[] getKeys(List<GroupingTableColumn<T>> list, List<VerticalAttribute<T>> list2) {
        String[] stringArray = new String[list.size() + list2.size()];
        int n = 0;
        for (GroupingTableColumn<T> verticalAttribute : list) {
            stringArray[n++] = verticalAttribute.getKey();
        }
        for (VerticalAttribute verticalAttribute : list2) {
            stringArray[n++] = verticalAttribute.getKey();
        }
        return stringArray;
    }

    private static <T> String[] getSizesToSave(GroupingTableConfiguration<T> groupingTableConfiguration, List<GroupingTableColumn<T>> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            GroupingTableConfiguration.ColumnSize columnSize = groupingTableConfiguration.getColumnSize(list.get(i));
            stringArray[i] = columnSize.isConfigured() ? String.valueOf(columnSize.getSize()) : "0";
        }
        return stringArray;
    }
}

