/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.PathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLPathUtils;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.ColorStyle;
import com.mathworks.widgets.grouptable.DisplayEffects;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PathAffordance
implements Affordance<FileSystemEntry> {
    private final FileSystemExpansionProvider fProvider;
    private final MulticastChangeListener fListener;
    private final ColorStyle fGrayedOutStyle = new GrayedOutStyle();
    private final Object fLock;
    private final RequestFilter fPathUpdater;
    private final PropertyChangeListener fPathListener;
    private final PathModel fModel;
    private Map<FileLocation, FileSystemEntry> fRawPathToResolvedPath;
    private Set<FileLocation> fCompletePath;
    private boolean fDisposed;
    private Integer fOverrideTransparencyPercent;
    private static final String TOOL_TIP_NAME = "PathAffordance";
    private static volatile int sTransparencyPercent;
    private static final ClosableToolTipData sPrivateToolTip;

    public static boolean isToolTipEnabled() {
        return !sPrivateToolTip.isPreferenceSetToClose();
    }

    public static void setToolTipEnabled(boolean bl) {
        sPrivateToolTip.setPreferenceToClose(!bl);
    }

    public PathAffordance(PathModel pathModel, FileSystemExpansionProvider fileSystemExpansionProvider) {
        this.fModel = pathModel;
        this.fProvider = fileSystemExpansionProvider;
        this.fCompletePath = new LinkedHashSet<FileLocation>();
        this.fRawPathToResolvedPath = new HashMap<FileLocation, FileSystemEntry>();
        this.fListener = new MulticastChangeListener();
        this.fLock = new Object();
        try {
            ExplorerPrefs.PathAffordanceTransparency.addListener((SettingListener)new SettingAdapter(){

                public void settingChanged(SettingChangeEvent settingChangeEvent) {
                    PathAffordance.this.fListener.stateChanged(new ChangeEvent((Object)this));
                }
            });
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        this.fPathUpdater = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                if (PathAffordance.this.fModel.isActive()) {
                    PathAffordance.this.updateCompletePath();
                }
            }
        });
        this.fPathUpdater.setName("PathAffordance path resolver");
        this.fPathUpdater.request();
        this.fPathListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PathAffordance.this.fPathUpdater.request();
            }
        };
        this.fModel.addPropertyChangeListener("current-folder", this.fPathListener);
        this.fModel.addPropertyChangeListener("path", this.fPathListener);
    }

    public void dispose() {
        this.fDisposed = true;
        this.fModel.removePropertyChangeListener("current-folder", this.fPathListener);
        this.fModel.removePropertyChangeListener("path", this.fPathListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FileLocation> getCompletePath() {
        Object object = this.fLock;
        synchronized (object) {
            return new LinkedHashSet<FileLocation>(this.fCompletePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompletePath() {
        Object object;
        HashMap<FileLocation, FileSystemEntry> hashMap;
        FileLocation fileLocation = this.fModel.getCurrentFolder();
        HashMap<FileLocation, FileSystemEntry> hashMap2 = new HashMap<FileLocation, FileSystemEntry>();
        LinkedHashSet<FileLocation> linkedHashSet = new LinkedHashSet<FileLocation>();
        LinkedHashSet<FileLocation> linkedHashSet2 = new LinkedHashSet<FileLocation>();
        Iterator iterator = this.fLock;
        synchronized (iterator) {
            hashMap = new HashMap<FileLocation, FileSystemEntry>(this.fRawPathToResolvedPath);
        }
        linkedHashSet.add(this.fModel.getCurrentFolder());
        linkedHashSet.addAll(this.fModel.getPath());
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            object = (FileLocation)iterator.next();
            FileSystemEntry fileSystemEntry = (FileSystemEntry)hashMap.get(object);
            linkedHashSet2.add((FileLocation)object);
            if (fileSystemEntry == null) continue;
            linkedHashSet2.add(fileSystemEntry.getLocation());
            hashMap2.put((FileLocation)object, fileSystemEntry);
            iterator.remove();
        }
        object = this.fLock;
        synchronized (object) {
            this.fCompletePath = new LinkedHashSet<FileLocation>(linkedHashSet2);
        }
        this.fListener.stateChanged(new ChangeEvent(this));
        for (FileLocation fileLocation2 : linkedHashSet) {
            if (this.fDisposed || !this.currentDirectoryIsStillTheSame(fileLocation)) break;
            try {
                FileSystemEntry fileSystemEntry = this.fProvider.getSystem().getEntry(fileLocation2);
                FileSystemEntry fileSystemEntry2 = fileSystemEntry.isReal() ? RealFileSystem.resolve(fileSystemEntry) : fileSystemEntry;
                linkedHashSet2.add(fileSystemEntry2.getLocation());
                hashMap2.put(fileLocation2, fileSystemEntry2);
            }
            catch (IOException iOException) {}
        }
        object = this.fLock;
        synchronized (object) {
            this.fCompletePath = linkedHashSet2;
            this.fRawPathToResolvedPath = hashMap2;
        }
        if (!linkedHashSet.isEmpty()) {
            this.fListener.stateChanged(new ChangeEvent(this));
        }
    }

    private boolean currentDirectoryIsStillTheSame(FileLocation fileLocation) {
        FileLocation fileLocation2 = this.fModel.getCurrentFolder();
        return fileLocation == null && fileLocation2 == null || fileLocation != null && fileLocation2 != null && fileLocation.equals((Object)fileLocation2);
    }

    public Map<FileSystemEntry, DisplayEffects> getDisplayEffects(List<FileSystemEntry> list) {
        HashMap<FileSystemEntry, DisplayEffects> hashMap = new HashMap<FileSystemEntry, DisplayEffects>();
        if (!this.fModel.isActive()) {
            return hashMap;
        }
        Map<FileSystemEntry, FileSystemEntry> map = FileSystemUtils.getUnderlyingEntriesToOriginalEntries(list);
        FileLocation fileLocation = this.fModel.getCurrentFolder();
        Set<FileLocation> set = this.getCompletePath();
        HashMap<FileLocation, FileSystemEntry> hashMap2 = new HashMap<FileLocation, FileSystemEntry>();
        HashMap<FileLocation, FileSystemEntry> hashMap3 = new HashMap<FileLocation, FileSystemEntry>();
        for (FileSystemEntry object : list) {
            hashMap3.put(object.getLocation(), object);
        }
        for (Map.Entry entry : map.entrySet()) {
            FileLocation fileLocation2;
            if (this.fDisposed || !this.currentDirectoryIsStillTheSame(fileLocation)) break;
            if (!this.shouldEverShowAffordance(hashMap3, (FileSystemEntry)entry.getKey()) || this.isOnPath(set, hashMap2, (FileSystemEntry)entry.getKey())) continue;
            String string = this.getSpecialToolTip(hashMap3, (FileSystemEntry)entry.getKey());
            DisplayEffects displayEffects = string != null ? new DisplayEffects(new ClosableToolTipData(TOOL_TIP_NAME, string), this.fGrayedOutStyle) : ((fileLocation2 = MLPathUtils.getAddableFolder(this.fModel, (FileSystemEntry)entry.getKey())) == null ? new DisplayEffects(sPrivateToolTip, this.fGrayedOutStyle) : new DisplayEffects((ReturnRunnable)new PathToolTipGenerator(fileLocation2.getName(), fileLocation2.equals((Object)((FileSystemEntry)entry.getKey()).getLocation())), this.fGrayedOutStyle));
            hashMap.put((FileSystemEntry)entry.getValue(), displayEffects);
        }
        return hashMap;
    }

    private static FileSystemEntry getParent(Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
        try {
            FileSystemEntry fileSystemEntry2 = map.get(fileSystemEntry.getLocation().getParent());
            if (fileSystemEntry2 == null && fileSystemEntry.getLocation().getParent() != null) {
                fileSystemEntry2 = fileSystemEntry.getSystem().getEntry(fileSystemEntry.getLocation().getParent());
                map.put(fileSystemEntry2.getLocation(), fileSystemEntry2);
            }
            return fileSystemEntry2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected boolean shouldEverShowAffordance(Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
        if (!fileSystemEntry.isFolder()) {
            FileSystemEntry fileSystemEntry2 = PathAffordance.getParent(map, fileSystemEntry);
            return fileSystemEntry2 != null && (Boolean)this.fProvider.getDecoration(fileSystemEntry2, CoreFileDecoration.APPROPRIATE_ON_PATH) != false;
        }
        return (Boolean)this.fProvider.getDecoration(fileSystemEntry, CoreFileDecoration.APPROPRIATE_ON_PATH);
    }

    protected boolean isOnPath(Set<FileLocation> set, Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
        return MLPathUtils.isOnPath(this.fModel, set, fileSystemEntry) || MLPathUtils.isOnPath(this.fModel, set, this.resolve(fileSystemEntry, map));
    }

    protected String getSpecialToolTip(Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
        String string = (String)this.fProvider.getDecoration(fileSystemEntry, CoreFileDecoration.SPECIAL_PATH_TOOLTIP_TEXT);
        if (string == null && !fileSystemEntry.isFolder()) {
            string = (String)this.fProvider.getDecoration(PathAffordance.getParent(map, fileSystemEntry), CoreFileDecoration.SPECIAL_PATH_TOOLTIP_TEXT);
        }
        return string;
    }

    public void setPercent(int n) {
        this.fOverrideTransparencyPercent = n;
        this.fListener.stateChanged(new ChangeEvent(this));
    }

    private double getPercent() {
        return this.fOverrideTransparencyPercent != null ? this.fOverrideTransparencyPercent : sTransparencyPercent;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListener.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListener.removeChangeListener(changeListener);
    }

    private FileSystemEntry resolve(FileSystemEntry fileSystemEntry, Map<FileLocation, FileSystemEntry> map) {
        try {
            FileLocation fileLocation;
            FileSystemEntry fileSystemEntry2;
            if (fileSystemEntry.isFolder()) {
                FileSystemEntry fileSystemEntry3 = map.get(fileSystemEntry.getLocation());
                if (fileSystemEntry3 == null) {
                    fileSystemEntry3 = fileSystemEntry.isReal() ? RealFileSystem.resolve(fileSystemEntry) : fileSystemEntry;
                    map.put(fileSystemEntry.getLocation(), fileSystemEntry3);
                }
                return fileSystemEntry3;
            }
            if (!fileSystemEntry.isReal()) {
                return fileSystemEntry;
            }
            if (!fileSystemEntry.isFolder() && (fileSystemEntry2 = map.get(fileLocation = fileSystemEntry.getLocation().getParent())) != null) {
                return this.fProvider.getSystem().getEntry(new FileLocation(fileSystemEntry2.getLocation(), fileSystemEntry.getName()));
            }
            fileLocation = map.get(fileSystemEntry.getLocation());
            return fileLocation == null && fileSystemEntry.isReal() ? RealFileSystem.resolve(fileSystemEntry) : fileLocation;
        }
        catch (IOException iOException) {
            return fileSystemEntry;
        }
    }

    static {
        sPrivateToolTip = new ClosableToolTipData(TOOL_TIP_NAME, ExplorerResources.getString("tooltip.private"), (Icon)DialogIcon.INFO.getIcon());
        try {
            ExplorerPrefs.PathAffordanceTransparency.addListener((SettingListener)new SettingAdapter(){

                public void settingChanged(SettingChangeEvent settingChangeEvent) {
                    try {
                        sTransparencyPercent = (Integer)ExplorerPrefs.PathAffordanceTransparency.get();
                    }
                    catch (SettingException settingException) {
                        throw new RuntimeException(settingException);
                    }
                }
            });
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        try {
            sTransparencyPercent = (Integer)ExplorerPrefs.PathAffordanceTransparency.get();
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private class GrayedOutStyle
    implements ColorStyle {
        private GrayedOutStyle() {
        }

        public Color getForegroundColor(JComponent jComponent) {
            Color color = jComponent.getForeground();
            Color color2 = jComponent.getBackground();
            int n = color2.getRed() - color.getRed();
            int n2 = color2.getGreen() - color.getGreen();
            int n3 = color2.getBlue() - color.getBlue();
            double d = PathAffordance.this.getPercent();
            return new Color(color.getRed() + (int)((double)n * (d / 100.0)), color.getGreen() + (int)((double)n2 * (d / 100.0)), color.getBlue() + (int)((double)n3 * (d / 100.0)));
        }

        public Icon getIcon(JComponent jComponent, Icon icon) {
            double d = PathAffordance.this.getPercent();
            float f = (float)(-0.002083 * (d * d) + 1.208 * d + 1.971E-14);
            return IconUtils.createGhostedIcon((Icon)icon, (float)f);
        }
    }

    private static class PathToolTipGenerator
    implements ReturnRunnable<ClosableToolTipData> {
        private final String fFolderName;
        private final boolean fOnActualFolder;

        PathToolTipGenerator(String string, boolean bl) {
            this.fFolderName = string;
            this.fOnActualFolder = bl;
        }

        public ClosableToolTipData run() {
            String string = this.fOnActualFolder ? "tooltip.notOnPath.direct" : "tooltip.notOnPath.indirect";
            return new ClosableToolTipData(PathAffordance.TOOL_TIP_NAME, MessageFormat.format(ExplorerResources.getString(string), this.fFolderName), (Icon)DialogIcon.INFO.getIcon());
        }
    }
}

