/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.vfs;

import com.mathworks.matlab.api.explorer.AutoMounter;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.MountLevel;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.LocationMap;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileList;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualTarget;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualTransaction;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VirtualFileSystem
implements FileSystem {
    private final FileSystem fBase;
    private final Object fMountLock;
    private final LocationMap<MountPoint> fMounts;
    private final List<AutoMounter> fAutoMounters;
    private final FileLocation fMountBlockedLocation;

    public VirtualFileSystem() {
        this(RealFileSystem.getInstance());
    }

    public VirtualFileSystem(FileSystem fileSystem) {
        this(fileSystem, new Object(), new LocationMap<MountPoint>(), new ArrayList<AutoMounter>(), null);
    }

    private VirtualFileSystem(FileSystem fileSystem, Object object, LocationMap<MountPoint> locationMap, List<AutoMounter> list, FileLocation fileLocation) {
        this.fBase = fileSystem;
        this.fMountLock = object;
        this.fMounts = locationMap;
        this.fAutoMounters = list;
        this.fMountBlockedLocation = fileLocation;
    }

    public void addAutoMounter(AutoMounter autoMounter) {
        this.fAutoMounters.add(autoMounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mount(FileLocation fileLocation, AutoMounter autoMounter, MountLevel mountLevel, FileSystem fileSystem) {
        Object object = this.fMountLock;
        synchronized (object) {
            this.fMounts.put(fileLocation, new MountPoint(autoMounter, mountLevel, fileSystem));
        }
    }

    public void mount(FileLocation fileLocation, FileSystem fileSystem) {
        this.mount(fileLocation, null, MountLevel.LOCK_FREE, fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MountLevel getMountLevel(FileLocation fileLocation) {
        Object object = this.fMountLock;
        synchronized (object) {
            MountPoint mountPoint = this.fMounts.get(fileLocation, true);
            return mountPoint != null ? mountPoint.getLevel() : MountLevel.LOCK_FREE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMountLevel(FileLocation fileLocation, MountLevel mountLevel) {
        Object object = this.fMountLock;
        synchronized (object) {
            if (this.getMountLevel(fileLocation).equals((Object)mountLevel)) {
                return;
            }
            this.unmount(fileLocation);
            VirtualFileSystem virtualFileSystem = new VirtualFileSystem(this.fBase, this.fMountLock, this.fMounts, this.fAutoMounters, fileLocation);
            for (AutoMounter autoMounter : this.fAutoMounters) {
                FileSystem fileSystem = autoMounter.open((FileSystem)virtualFileSystem, fileLocation, mountLevel);
                if (fileSystem == null) continue;
                this.mount(fileLocation, autoMounter, mountLevel, fileSystem);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmount(FileLocation fileLocation) {
        Object object = this.fMountLock;
        synchronized (object) {
            MountPoint mountPoint = this.fMounts.remove(fileLocation);
            if (mountPoint != null) {
                mountPoint.dispose();
            }
        }
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        VirtualTarget virtualTarget = this.getTarget(fileLocation);
        FileSystemEntry fileSystemEntry = virtualTarget.getSystem().getEntry(virtualTarget.getLocation());
        return new FileSystemEntry(fileSystemEntry, fileLocation, (FileSystem)this);
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        VirtualTarget virtualTarget = this.getTarget(fileLocation);
        return virtualTarget.getSystem().getInputStream(virtualTarget.getLocation());
    }

    public boolean exists(FileLocation fileLocation) {
        VirtualTarget virtualTarget = this.getUnderlyingTarget(fileLocation);
        boolean bl = virtualTarget.getSystem().exists(virtualTarget.getLocation());
        if (!bl) {
            this.unmount(fileLocation);
        }
        return bl;
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        FileSystemEntry fileSystemEntry2 = this.toInternalEntry(fileSystemEntry);
        return fileSystemEntry2.getSystem().followShortcutOrLink(fileSystemEntry2);
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        VirtualTarget virtualTarget = this.getTarget(fileLocation);
        return new VirtualFileList(this, virtualTarget, fileLocation, virtualTarget.getSystem().getList(virtualTarget.getLocation()));
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        VirtualTarget virtualTarget = this.getTarget(fileLocation);
        return new VirtualFileList(this, virtualTarget, fileLocation, virtualTarget.getSystem().search(virtualTarget.getLocation(), searchCriteria, predicate));
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        VirtualTarget virtualTarget = this.getTarget(fileLocation);
        return virtualTarget.getSystem().isReadOnly(virtualTarget.getLocation());
    }

    public FileSystemTransaction createTransaction() throws IOException {
        return new VirtualTransaction(this);
    }

    public String encodeName(String string) {
        return this.fBase.encodeName(string);
    }

    public String decodeName(String string) {
        return this.fBase.decodeName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMountPoint(FileLocation fileLocation) {
        Object object = this.fMountLock;
        synchronized (object) {
            return !this.isMountBlocked(fileLocation) && !this.getTarget(fileLocation).getSystem().equals(this.fBase) && this.fMounts.get(fileLocation, true) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void garbageCollectAutoMounts(Predicate<FileLocation> predicate) {
        Object object = this.fMountLock;
        synchronized (object) {
            for (FileLocation fileLocation : this.fMounts.getKeys()) {
                if (!predicate.accept((Object)fileLocation)) continue;
                MountPoint mountPoint = this.fMounts.remove(fileLocation);
                mountPoint.dispose();
            }
        }
    }

    public static FileSystemEntry getUnderlyingEntryIfMountPoint(FileSystemEntry fileSystemEntry) {
        VirtualFileSystem virtualFileSystem;
        if (fileSystemEntry.getSystem() instanceof VirtualFileSystem && (virtualFileSystem = (VirtualFileSystem)fileSystemEntry.getSystem()).isMountPoint(fileSystemEntry.getLocation())) {
            VirtualTarget virtualTarget = virtualFileSystem.getTarget(fileSystemEntry.getLocation().getParent());
            if (virtualTarget.getSystem().equals(virtualFileSystem.fBase)) {
                try {
                    FileLocation fileLocation = new FileLocation(virtualTarget.getLocation(), fileSystemEntry.getLocation().getName());
                    return virtualTarget.getSystem().getEntry(fileLocation);
                }
                catch (IOException iOException) {
                    return fileSystemEntry;
                }
            }
            try {
                LocationMap<MountPoint> locationMap = new LocationMap<MountPoint>(virtualFileSystem.fMounts);
                locationMap.remove(fileSystemEntry.getLocation());
                VirtualFileSystem virtualFileSystem2 = new VirtualFileSystem(virtualFileSystem.fBase, new Object(), locationMap, virtualFileSystem.fAutoMounters, fileSystemEntry.getLocation());
                return virtualFileSystem2.getEntry(fileSystemEntry.getLocation());
            }
            catch (IOException iOException) {
                return fileSystemEntry;
            }
        }
        return fileSystemEntry;
    }

    private boolean isMountBlocked(FileLocation fileLocation) {
        return this.fMountBlockedLocation != null && fileLocation.hasPrefix(this.fMountBlockedLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualTarget getUnderlyingTarget(FileLocation fileLocation) {
        Object object = this.fMountLock;
        synchronized (object) {
            if (fileLocation.equals((Object)FileLocation.ROOT) || !this.isMountPoint(fileLocation)) {
                return this.getTarget(fileLocation);
            }
            VirtualTarget virtualTarget = this.getTarget(fileLocation.getParent());
            return new VirtualTarget(virtualTarget.getSystem(), new FileLocation(virtualTarget.getLocation(), fileLocation.getName()), virtualTarget.getMountPoint());
        }
    }

    VirtualTarget getTarget(FileLocation fileLocation) {
        try {
            return this.resolveLocation(fileLocation);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualTarget resolveLocation(FileLocation fileLocation) throws IOException {
        Object object = this.fMountLock;
        synchronized (object) {
            if (!fileLocation.equals((Object)FileLocation.ROOT)) {
                this.getTarget(fileLocation.getParent());
            }
            Map.Entry<FileLocation, MountPoint> entry = this.fMounts.getNearestEntry(fileLocation, this.fMountBlockedLocation);
            if (!(this.isMountBlocked(fileLocation) || entry != null && entry.getKey().equals((Object)fileLocation))) {
                VirtualFileSystem virtualFileSystem = new VirtualFileSystem(this.fBase, this.fMountLock, this.fMounts, this.fAutoMounters, fileLocation);
                for (AutoMounter autoMounter : this.fAutoMounters) {
                    FileSystem fileSystem = autoMounter.open((FileSystem)virtualFileSystem, fileLocation, MountLevel.LOCK_FREE);
                    if (fileSystem == null) continue;
                    this.mount(fileLocation, autoMounter, MountLevel.LOCK_FREE, fileSystem);
                    return new VirtualTarget(fileSystem, FileLocation.ROOT, fileLocation);
                }
            }
            if (entry == null) {
                return new VirtualTarget(this.fBase, fileLocation, FileLocation.ROOT);
            }
            return new VirtualTarget(entry.getValue().getSystem(), fileLocation.stripPrefix(entry.getKey()), entry.getKey());
        }
    }

    FileSystemEntry toExternalEntry(VirtualTarget virtualTarget, FileSystemEntry fileSystemEntry) {
        FileLocation fileLocation = new FileLocation(virtualTarget.getMountPoint(), fileSystemEntry.getLocation().toString());
        return this.toExternalEntry(fileLocation, fileSystemEntry);
    }

    FileSystemEntry toExternalEntry(FileLocation fileLocation, FileSystemEntry fileSystemEntry) {
        try {
            return this.isMountPoint(fileLocation) ? this.getEntry(fileLocation) : new FileSystemEntry(fileSystemEntry, fileLocation, (FileSystem)this);
        }
        catch (IOException iOException) {
            return new FileSystemEntry(fileSystemEntry, fileLocation, (FileSystem)this);
        }
    }

    List<FileSystemEntry> toExternalEntries(VirtualTarget virtualTarget, List<FileSystemEntry> list) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : list) {
            arrayList.add(this.toExternalEntry(virtualTarget, fileSystemEntry));
        }
        return arrayList;
    }

    FileSystemEntry toInternalEntry(FileSystemEntry fileSystemEntry) {
        VirtualTarget virtualTarget = this.getTarget(fileSystemEntry.getLocation());
        return new FileSystemEntry(fileSystemEntry, virtualTarget.getLocation(), virtualTarget.getSystem());
    }

    private class MountPoint {
        private final AutoMounter iMounter;
        private final MountLevel fLevel;
        private final FileSystem iSystem;

        MountPoint(AutoMounter autoMounter, MountLevel mountLevel, FileSystem fileSystem) {
            this.iMounter = autoMounter;
            this.fLevel = mountLevel;
            this.iSystem = fileSystem;
        }

        public FileSystem getSystem() {
            return this.iSystem;
        }

        public MountLevel getLevel() {
            return this.fLevel;
        }

        public void dispose() {
            if (this.iMounter != null) {
                this.iMounter.close(this.iSystem);
            }
        }
    }
}

