/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.vfs;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualTarget;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualTransactionTarget;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class VirtualTransaction
implements FileSystemTransaction {
    private final VirtualFileSystem fSystem;
    private final Object fTransactionLock;
    private final Map<FileSystem, FileSystemTransaction> fTransactions;
    private boolean fClosed;

    VirtualTransaction(VirtualFileSystem virtualFileSystem) {
        this.fSystem = virtualFileSystem;
        this.fTransactionLock = new Object();
        this.fTransactions = new HashMap<FileSystem, FileSystemTransaction>();
    }

    public FileSystem getSystem() {
        return this.fSystem;
    }

    public OutputStream getOutputStream(FileLocation fileLocation) throws IOException {
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(fileLocation.getParent());
        OutputStream outputStream = virtualTransactionTarget.getTransaction().getOutputStream(new FileLocation(virtualTransactionTarget.getLocation(), fileLocation.getName()));
        return outputStream;
    }

    public void setPermissions(FileLocation fileLocation, long l) throws IOException {
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(fileLocation);
        virtualTransactionTarget.getTransaction().setPermissions(virtualTransactionTarget.getLocation(), l);
    }

    public void createDirectory(FileLocation fileLocation) throws IOException {
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(fileLocation);
        virtualTransactionTarget.getTransaction().createDirectory(virtualTransactionTarget.getLocation());
    }

    public void delete(FileLocation fileLocation, boolean bl) throws IOException {
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(fileLocation);
        virtualTransactionTarget.getTransaction().delete(virtualTransactionTarget.getLocation(), bl);
        this.fSystem.unmount(fileLocation);
    }

    public void delete(Component component, List<FileLocation> list, boolean bl, Predicate<FileSystemEntry> predicate, final AsyncReceiver<FileLocation> asyncReceiver) throws IOException {
        final HashMap<FileLocation, FileLocation> hashMap = new HashMap<FileLocation, FileLocation>();
        Map<FileSystemTransaction, List<FileLocation>> map = this.groupByUnderlyingTarget(list, hashMap);
        FileSystemUtils.delete(component, map, bl, predicate, new AsyncReceiver<FileLocation>(){

            public boolean receive(FileLocation fileLocation) {
                FileLocation fileLocation2 = (FileLocation)hashMap.get(fileLocation);
                if (fileLocation2 != null) {
                    VirtualTransaction.this.fSystem.unmount(fileLocation2);
                    return asyncReceiver.receive((Object)fileLocation2);
                }
                return true;
            }

            public void finished() {
                asyncReceiver.finished();
            }
        });
    }

    public void move(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        VirtualTarget virtualTarget = this.fSystem.getUnderlyingTarget(fileLocation);
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(this.fSystem.getUnderlyingTarget(fileLocation2));
        if (virtualTarget.getSystem().equals(virtualTransactionTarget.getSystem())) {
            virtualTransactionTarget.getTransaction().move(virtualTarget.getLocation(), virtualTransactionTarget.getLocation());
        } else {
            FileSystemUtils.move(virtualTarget.getSystem(), virtualTarget.getLocation(), virtualTransactionTarget.getTransaction(), virtualTransactionTarget.getLocation());
        }
    }

    public void copy(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        VirtualTarget virtualTarget = this.fSystem.getUnderlyingTarget(fileLocation);
        VirtualTransactionTarget virtualTransactionTarget = this.getTarget(this.fSystem.getUnderlyingTarget(fileLocation2));
        if (virtualTarget.getSystem().equals(virtualTransactionTarget.getSystem())) {
            virtualTransactionTarget.getTransaction().copy(virtualTarget.getLocation(), virtualTransactionTarget.getLocation());
        } else {
            final VirtualTarget virtualTarget2 = this.fSystem.getUnderlyingTarget(fileLocation2);
            FileSystemUtils.copy(virtualTarget.getSystem(), virtualTarget.getLocation(), virtualTransactionTarget.getTransaction(), virtualTransactionTarget.getLocation(), new Predicate<FileLocation>(){

                public boolean accept(FileLocation fileLocation) {
                    return !fileLocation.equals((Object)virtualTarget2.getMountPoint());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.fTransactionLock;
        synchronized (object) {
            this.fClosed = true;
            for (FileSystemTransaction fileSystemTransaction : this.fTransactions.values()) {
                fileSystemTransaction.close();
            }
        }
    }

    private VirtualTransactionTarget getTarget(FileLocation fileLocation) throws IOException {
        VirtualTarget virtualTarget = this.fSystem.getTarget(fileLocation);
        return this.getTarget(virtualTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualTransactionTarget getTarget(VirtualTarget virtualTarget) throws IOException {
        Object object = this.fTransactionLock;
        synchronized (object) {
            if (this.fClosed) {
                throw new IllegalStateException();
            }
            FileSystemTransaction fileSystemTransaction = this.fTransactions.get(virtualTarget.getSystem());
            if (fileSystemTransaction == null) {
                fileSystemTransaction = virtualTarget.getSystem().createTransaction();
                this.fTransactions.put(virtualTarget.getSystem(), fileSystemTransaction);
            }
            return new VirtualTransactionTarget(virtualTarget.getSystem(), virtualTarget.getLocation(), virtualTarget.getMountPoint(), fileSystemTransaction);
        }
    }

    private Map<FileSystemTransaction, List<FileLocation>> groupByUnderlyingTarget(Collection<FileLocation> collection, Map<FileLocation, FileLocation> map) throws IOException {
        HashMap<FileSystemTransaction, List<FileLocation>> hashMap = new HashMap<FileSystemTransaction, List<FileLocation>>();
        for (FileLocation fileLocation : collection) {
            VirtualTransactionTarget virtualTransactionTarget = this.getTarget(this.fSystem.getUnderlyingTarget(fileLocation));
            ArrayList<FileLocation> arrayList = (ArrayList<FileLocation>)hashMap.get(virtualTransactionTarget.getTransaction());
            if (arrayList == null) {
                arrayList = new ArrayList<FileLocation>();
                hashMap.put(virtualTransactionTarget.getTransaction(), arrayList);
            }
            arrayList.add(virtualTransactionTarget.getLocation());
            map.put(virtualTransactionTarget.getLocation(), fileLocation);
        }
        return hashMap;
    }
}

