/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.util.FileSystemFilter;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestQueue;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.Icon;

public final class UiFileSystemUtils {
    private static final RequestQueue sDecorationRequestQueue = new RequestQueue("FileSystemUtils decoration request queue");

    private UiFileSystemUtils() {
    }

    public static <T> void getDecoration(ExtensionRegistry extensionRegistry, FileDecoration<T> fileDecoration, FileSystemEntry fileSystemEntry, ParameterRunnable<T> parameterRunnable) {
        List list = extensionRegistry.getInfoProviders();
        FileDecorationModel fileDecorationModel = new FileDecorationModel(extensionRegistry, sDecorationRequestQueue, fileSystemEntry);
        for (FileInfoProvider fileInfoProvider : list) {
            fileInfoProvider.configureDecorations(fileSystemEntry, fileDecorationModel.getDecorators(), fileDecorationModel.getDecorations());
        }
        fileDecorationModel.getDecorations().get(fileDecoration, false, parameterRunnable);
    }

    public static <T> void getDecorationAndSendToEDT(ExtensionRegistry extensionRegistry, FileDecoration<T> fileDecoration, FileSystemEntry fileSystemEntry, final ParameterRunnable<T> parameterRunnable) {
        FileDecorationModel fileDecorationModel = new FileDecorationModel(extensionRegistry, sDecorationRequestQueue, fileSystemEntry);
        fileDecorationModel.getDecorations().get(fileDecoration, false, new ParameterRunnable<T>(){

            public void run(T t) {
                MJUtilities.runOnEventDispatchThread((ParameterRunnable)parameterRunnable, t);
            }
        });
    }

    public static <T> T getDecorationSynchronously(UiFileList uiFileList, FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration, boolean bl, ExtensionRegistry extensionRegistry) {
        return UiFileSystemUtils.getDecorationSynchronously(uiFileList.getDecorations(fileSystemEntry, extensionRegistry), bl, fileDecoration);
    }

    public static <T> T getDecorationSynchronously(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration, ExtensionRegistry extensionRegistry) {
        return UiFileSystemUtils.getDecorationSynchronously(new FileDecorationModel(extensionRegistry, sDecorationRequestQueue, fileSystemEntry).getDecorations(), false, fileDecoration);
    }

    public static <T> T getDecorationSynchronously(FileDecorations fileDecorations, boolean bl, FileDecoration<T> fileDecoration) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Holder holder = new Holder();
        fileDecorations.get(fileDecoration, bl, new ParameterRunnable<T>(){

            public void run(T t) {
                holder.set(t);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        return (T)holder.get();
    }

    public static Icon getIconEvenIfNonExistent(FileSystem fileSystem, FileLocation fileLocation, ExtensionRegistry extensionRegistry) {
        FileSystemEntry fileSystemEntry;
        try {
            fileSystemEntry = fileSystem.getEntry(fileLocation);
        }
        catch (IOException iOException) {
            return FileTypeIcon.GENERIC.getIcon();
        }
        try {
            FileDecorationModel fileDecorationModel = new FileDecorationModel(extensionRegistry, sDecorationRequestQueue, fileSystemEntry);
            return (Icon)UiFileSystemUtils.getDecorationSynchronously(fileDecorationModel.getDecorations(), false, CoreFileDecoration.ICON);
        }
        catch (Exception exception) {
            if (fileSystemEntry.isFolder()) {
                try {
                    FileSystemEntry fileSystemEntry2 = RealFileSystem.getInstance().getEntry(new FileLocation(System.getProperty("user.dir")));
                    FileDecorationModel fileDecorationModel = new FileDecorationModel(extensionRegistry, sDecorationRequestQueue, fileSystemEntry2);
                    return (Icon)UiFileSystemUtils.getDecorationSynchronously(fileDecorationModel.getDecorations(), false, CoreFileDecoration.ICON);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return FileTypeIcon.GENERIC.getIcon();
        }
    }

    public static void createNewFolder(final FileSystem fileSystem, final FileLocation fileLocation, final ParameterRunnable<FileSystemEntry> parameterRunnable, final ParameterRunnable<IOException> parameterRunnable2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String string = "New Folder";
                for (int i = 2; fileSystem.exists(new FileLocation(fileLocation, string)) && i < Integer.MAX_VALUE; ++i) {
                    string = "New Folder (" + i + ")";
                }
                final FileLocation fileLocation2 = new FileLocation(fileLocation, string);
                try {
                    FileSystemUtils.withTransaction(fileSystem, new TransactionLogic(){

                        @Override
                        public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                            fileSystemTransaction.createDirectory(fileLocation2);
                        }

                        @Override
                        public void afterClose() throws IOException {
                            MJUtilities.runOnEventDispatchThread((ParameterRunnable)parameterRunnable, (Object)fileSystem.getEntry(fileLocation2));
                        }
                    });
                }
                catch (IOException iOException) {
                    MJUtilities.runOnEventDispatchThread((ParameterRunnable)parameterRunnable2, (Object)iOException);
                }
            }
        }).start();
    }

    public static void createNewFile(final NewFileTemplate newFileTemplate, final FileSystem fileSystem, final FileLocation fileLocation, final ParameterRunnable<FileSystemEntry> parameterRunnable, final ParameterRunnable<IOException> parameterRunnable2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String string = newFileTemplate.getDefaultFileName(fileSystem, fileLocation);
                int n = string.lastIndexOf(46);
                String string2 = string;
                String string3 = "";
                if (n >= 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n);
                }
                final FileLocation fileLocation2 = FileSystemUtils.getNextNamedFile(fileSystem, fileLocation, string2, string3, false, "", new FileSystemFilter[0]);
                try {
                    FileSystemUtils.withTransaction(fileSystem, new TransactionLogic(){

                        @Override
                        public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                            newFileTemplate.writeDefaultContent(fileSystemTransaction, fileLocation2);
                        }

                        @Override
                        public void afterClose() throws IOException {
                            MJUtilities.runOnEventDispatchThread((ParameterRunnable)parameterRunnable, (Object)fileSystem.getEntry(fileLocation2));
                        }
                    });
                }
                catch (IOException iOException) {
                    MJUtilities.runOnEventDispatchThread((ParameterRunnable)parameterRunnable2, (Object)iOException);
                }
            }
        }).start();
    }

    public static void updateNewFile(final FileSystemEntry fileSystemEntry, final NewFileTemplate newFileTemplate) throws IOException {
        FileSystemUtils.withTransaction(fileSystemEntry.getSystem(), new TransactionLogic(){

            @Override
            public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                newFileTemplate.writeDefaultContent(fileSystemTransaction, fileSystemEntry.getLocation());
            }
        });
    }

    public static MJLabel createIconLabel(FileSystemEntry fileSystemEntry, ExtensionRegistry extensionRegistry) {
        final MJLabel mJLabel = new MJLabel((Icon)FileTypeIcon.DOCUMENT.getIcon());
        UiFileSystemUtils.getDecorationAndSendToEDT(extensionRegistry, CoreFileDecoration.ICON, fileSystemEntry, new ParameterRunnable<Icon>(){

            public void run(Icon icon) {
                mJLabel.setIcon(icon);
            }
        });
        return mJLabel;
    }

    public static Comparator<FileSystemEntry> separateFoldersFromFiles(final Comparator<FileSystemEntry> comparator) {
        return new Comparator<FileSystemEntry>(){

            @Override
            public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
                if (fileSystemEntry.isFolder() && !fileSystemEntry2.isFolder()) {
                    return -1;
                }
                if (!fileSystemEntry.isFolder() && fileSystemEntry2.isFolder()) {
                    return 1;
                }
                return comparator.compare(fileSystemEntry, fileSystemEntry2);
            }
        };
    }

    public static Comparator<FileSystemEntry> sortByNameTieBreaker(final Comparator<FileSystemEntry> comparator) {
        return new Comparator<FileSystemEntry>(){

            @Override
            public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
                int n = comparator.compare(fileSystemEntry, fileSystemEntry2);
                if (n == 0) {
                    n = fileSystemEntry.getName().compareToIgnoreCase(fileSystemEntry2.getName());
                }
                return n;
            }
        };
    }

    public static Comparator<File> sortAlphabetically() {
        return new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
            }
        };
    }

    public static String getNearestParentFolder(Set<String> set, String string) {
        String string2 = string;
        int n = string2.lastIndexOf(File.separator);
        while (n >= 0) {
            if (set.contains(string2 = string2.substring(0, n))) {
                return string2;
            }
            n = string2.lastIndexOf(File.separator);
        }
        return null;
    }

    public static int compareFileNamesForDisplay(String string, String string2) {
        NameTokenizer nameTokenizer = new NameTokenizer(string);
        NameTokenizer nameTokenizer2 = new NameTokenizer(string2);
        while (nameTokenizer.hasMoreTokens() && nameTokenizer2.hasMoreTokens()) {
            String string3 = nameTokenizer.nextToken();
            String string4 = nameTokenizer2.nextToken();
            int n = nameTokenizer.isCurrentTokenNumeric() && nameTokenizer2.isCurrentTokenNumeric() ? new BigInteger(string3).compareTo(new BigInteger(string4)) : string3.compareToIgnoreCase(string4);
            if (n == 0) continue;
            return n;
        }
        return nameTokenizer.hasMoreTokens() ? 1 : -1;
    }

    private static class NameTokenizer {
        private final char[] fText;
        private boolean fCurrentTokenNumeric;
        private int fPosition;

        NameTokenizer(String string) {
            this.fText = string.toCharArray();
        }

        public boolean hasMoreTokens() {
            return this.fPosition < this.fText.length;
        }

        public String nextToken() {
            int n;
            char c = this.fText[this.fPosition];
            if (c == '.') {
                this.fCurrentTokenNumeric = false;
                ++this.fPosition;
                return ".";
            }
            this.fCurrentTokenNumeric = Character.isDigit(c);
            for (n = this.fPosition; n < this.fText.length && (n <= this.fPosition || this.fText[n] != '.' && !(this.fCurrentTokenNumeric ^ Character.isDigit(this.fText[n]))); ++n) {
            }
            String string = new String(this.fText, this.fPosition, n - this.fPosition);
            this.fPosition = n;
            return string;
        }

        public boolean isCurrentTokenNumeric() {
            return this.fCurrentTokenNumeric;
        }
    }
}

