/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.AntialiasedFontPrefs;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class PaintingUtils {
    private PaintingUtils() {
    }

    static boolean isBlackBackground() {
        return UIManager.getColor("Button.background").equals(Color.BLACK);
    }

    static void paintHoveredButton(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, String string, Font font, boolean bl, boolean bl2) {
        Icon icon3 = bl ? icon2 : icon;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (MJUtilities.isHighContrast()) {
            PaintingUtils.paintHighContrastHover(graphics2D, jComponent);
        } else if (bl) {
            PaintingUtils.paintRegularPressedHover(graphics2D, jComponent);
        } else {
            PaintingUtils.paintRegularHover(graphics2D, jComponent);
        }
        graphics2D.setColor(PaintingUtils.isBlackBackground() ? Color.WHITE : Color.BLACK);
        if (string != null) {
            graphics2D.setFont(font);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (AntialiasedFontPrefs.isDesktopFontAntialiased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else if (AntialiasedFontPrefs.isJavaUsingSystemAntialiasing() && GraphicsUtils.getAntialiasingRenderingHints() != null) {
                graphics2D.addRenderingHints(GraphicsUtils.getAntialiasingRenderingHints());
            }
            graphics2D.drawString(string, 3.0f, (float)(jComponent.getHeight() / 2 + graphics2D.getFontMetrics().getAscent() / 2 - 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        graphics2D.setColor(new Color(190, 190, 192));
        graphics2D.drawLine(0, 0, 0, jComponent.getHeight());
        if (bl2) {
            graphics2D.drawLine(jComponent.getWidth() - 1, 0, jComponent.getWidth() - 1, jComponent.getHeight());
        }
        if (icon3 != null) {
            if (string != null) {
                graphics2D.drawLine(jComponent.getWidth() - icon3.getIconWidth() + 1, 0, jComponent.getWidth() - icon3.getIconWidth() + 1, jComponent.getHeight());
            }
            icon3.paintIcon(jComponent, graphics, jComponent.getWidth() - icon3.getIconWidth(), jComponent.getHeight() / 2 - icon3.getIconHeight() / 2);
        }
    }

    private static void paintHighContrastHover(Graphics2D graphics2D, JComponent jComponent) {
        if (PaintingUtils.isBlackBackground()) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, jComponent.getWidth(), jComponent.getHeight()));
            graphics2D.setColor(Color.WHITE);
            graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, jComponent.getWidth() - 1, jComponent.getHeight() - 1));
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, jComponent.getWidth(), jComponent.getHeight()));
        }
    }

    private static void paintRegularPressedHover(Graphics2D graphics2D, JComponent jComponent) {
        Paint paint = graphics2D.getPaint();
        Color color = ColorUtils.convertToCurrentColorScheme((Color)new Color(255, 241, 215), (Color)UIManager.getColor("control"));
        Color color2 = ColorUtils.convertToCurrentColorScheme((Color)new Color(156, 151, 141), (Color)UIManager.getColor("control"));
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, jComponent.getHeight(), color2));
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, jComponent.getWidth(), jComponent.getHeight()));
        graphics2D.setPaint(paint);
    }

    private static void paintRegularHover(Graphics2D graphics2D, JComponent jComponent) {
        Paint paint = graphics2D.getPaint();
        Color color = ColorUtils.convertToCurrentColorScheme((Color)new Color(255, 250, 241), (Color)UIManager.getColor("control"));
        Color color2 = ColorUtils.convertToCurrentColorScheme((Color)new Color(187, 183, 176), (Color)UIManager.getColor("control"));
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, jComponent.getHeight(), color2));
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, jComponent.getWidth(), jComponent.getHeight()));
        graphics2D.setPaint(paint);
    }
}

