/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonPanel;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarTextFieldUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.IconLabel;
import com.mathworks.mlwidgets.explorer.widgets.address.TitleChangeListener;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.RequestFilter;
import com.mathworks.widgets.BusyAffordance;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

final class SearchModeComponent
implements AddressBarModeComponent {
    private final AddressBar fAddressBar;
    private final MJPanel fComponent;
    private final MJTextField fTextField;
    private final MulticastChangeListener fListeners;
    private final List<TitleChangeListener> fUpdateTitleListeners;
    private final AddressBarButtonPanel fButtons;
    private final IconLabel fIconLabel;
    private final BusyAffordance fBusyAffordance;
    private final RequestFilter fChangeNotification;
    private boolean fSuppressSelectAllOnFocus;

    SearchModeComponent(AddressBar addressBar) {
        this.fAddressBar = addressBar;
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("center:20px, 1dlu, fill:d:grow, fill:d", "fill:p:grow"));
        this.fListeners = new MulticastChangeListener();
        this.fBusyAffordance = this.fAddressBar.createBusyAffordance();
        this.fBusyAffordance.setPaintsWhenStopped(true);
        this.fIconLabel = new IconLabel();
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.setBackground(UIManager.getColor("TextArea.background"));
        this.fTextField = new MJTextField();
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fTextField, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"Explorer");
        this.fTextField.setName("FileSearchField");
        this.fTextField.setSelectAllOnFocus(false);
        this.fTextField.setBorder(null);
        this.fComponent.add((Component)this.fIconLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
        this.fComponent.add((Component)this.fTextField, (Object)cellConstraints.xy(3, 1));
        this.fButtons = new AddressBarButtonPanel();
        this.fUpdateTitleListeners = new Vector<TitleChangeListener>();
        this.fChangeNotification = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                SearchModeComponent.this.fListeners.stateChanged(new ChangeEvent(SearchModeComponent.this));
            }
        }, 300);
        AddressBarTextFieldUtils.switchModeOnEscapePress(this.fTextField, addressBar);
        this.fTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchModeComponent.this.fChangeNotification.request();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchModeComponent.this.fChangeNotification.request();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        addressBar.getContext().addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
                if (searchCriteria.getSearchText() != null) {
                    String string = "Searching for " + searchCriteria.getSearchText() + " ...";
                    MatlabDesktopServices.getDesktop().setStatusText(string, true);
                    SearchModeComponent.this.notifyUpdateTitleListeners(string);
                }
                SearchModeComponent.this.rebuildInActiveMode();
            }

            @Override
            public void searchEnded() {
                MatlabDesktopServices.getDesktop().setStatusText("", true);
                SearchModeComponent.this.notifyUpdateTitleListeners(ExplorerResources.getString("title"));
                SearchModeComponent.this.rebuildInInactiveMode();
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!SearchModeComponent.this.fSuppressSelectAllOnFocus) {
                    SearchModeComponent.this.fTextField.selectAll();
                }
                SearchModeComponent.this.fSuppressSelectAllOnFocus = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!SearchModeComponent.this.fAddressBar.getSearchButton().getComponent().equals(focusEvent.getOppositeComponent()) && SearchModeComponent.this.fTextField.getText().equals(ExplorerResources.getString("searchbox.default"))) {
                    SearchModeComponent.this.fAddressBar.setMode(SearchModeComponent.this.fAddressBar.getDefaultMode());
                }
            }
        });
        this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && FileLocation.isPathString((String)SearchModeComponent.this.fTextField.getText())) {
                    try {
                        if (SearchModeComponent.this.fAddressBar.getContext().isSearching()) {
                            SearchModeComponent.this.fAddressBar.getContext().endSearch();
                        }
                        SearchModeComponent.this.fAddressBar.getContext().setLocation(new FileLocation(SearchModeComponent.this.fTextField.getText()));
                        SearchModeComponent.this.fAddressBar.setMode(SearchModeComponent.this.fAddressBar.getDefaultMode());
                    }
                    catch (InvalidLocationException invalidLocationException) {
                        MJOptionPane.showMessageDialog((Component)SearchModeComponent.this.fComponent, (Object)MessageFormat.format(ExplorerResources.getString("changedir.error"), "'" + SearchModeComponent.this.fTextField.getText() + "'"), (String)ExplorerResources.getString("changedir.error.title"), (int)2);
                    }
                }
            }
        });
        this.rebuildInInactiveMode();
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void notifyResized() {
    }

    @Override
    public void notifyDataChanged() {
        boolean bl = this.fAddressBar.getWorkMonitor().isBusy();
        this.fComponent.remove((Component)this.fIconLabel.getComponent());
        this.fComponent.remove((Component)this.fBusyAffordance.getComponent());
        this.fComponent.revalidate();
        this.fComponent.repaint();
        CellConstraints cellConstraints = new CellConstraints();
        if (bl) {
            this.fComponent.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(1, 1));
        } else {
            if (this.fAddressBar.getContext().isSearching() && this.getText() != null) {
                MatlabDesktopServices.getDesktop().setStatusText("Search Results");
                this.notifyUpdateTitleListeners("Search Results");
            }
            this.fComponent.add((Component)this.fIconLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    @Override
    public void notifyActivating(MouseEvent mouseEvent) {
    }

    @Override
    public void notifyActivated(boolean bl) {
        this.fSuppressSelectAllOnFocus = bl;
        this.fTextField.setText(ExplorerResources.getString("searchbox.default"));
        this.fIconLabel.setIcon(AddressBarButtonUtils.getCurrentLocationIcon(this.fAddressBar));
        this.rebuildInInactiveMode();
        if (this.fSuppressSelectAllOnFocus) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = SearchModeComponent.this.fTextField.getText();
                    SearchModeComponent.this.fTextField.setSelectionStart(string.length());
                    SearchModeComponent.this.fTextField.setSelectionEnd(string.length());
                    SearchModeComponent.this.fTextField.setCaretPosition(string.length());
                }
            });
        }
    }

    public void suppressSelectAllOnFocus() {
        this.fSuppressSelectAllOnFocus = true;
    }

    private void rebuildInInactiveMode() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchModeComponent.this.fComponent.remove((Component)SearchModeComponent.this.fButtons.getComponent());
                SearchModeComponent.this.fComponent.revalidate();
                SearchModeComponent.this.fComponent.repaint();
                CellConstraints cellConstraints = new CellConstraints();
                SearchModeComponent.this.fComponent.add((Component)SearchModeComponent.this.fIconLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
                SearchModeComponent.this.fComponent.revalidate();
                SearchModeComponent.this.fComponent.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchModeComponent.this.fTextField.requestFocus();
                    }
                });
            }
        });
    }

    private void rebuildInActiveMode() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FileList fileList = SearchModeComponent.this.fAddressBar.getContext().getList();
                SearchModeComponent.this.fComponent.remove((Component)SearchModeComponent.this.fIconLabel.getComponent());
                SearchModeComponent.this.fComponent.remove((Component)SearchModeComponent.this.fButtons.getComponent());
                CellConstraints cellConstraints = new CellConstraints();
                SearchModeComponent.this.fComponent.revalidate();
                SearchModeComponent.this.fComponent.repaint();
                SearchModeComponent.this.fComponent.add((Component)SearchModeComponent.this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(1, 1));
                SearchModeComponent.this.fComponent.revalidate();
                SearchModeComponent.this.fComponent.repaint();
            }
        });
    }

    public void addUpdateTitleListener(TitleChangeListener titleChangeListener) {
        this.fUpdateTitleListeners.add(titleChangeListener);
    }

    public void notifyUpdateTitleListeners(String string) {
        for (TitleChangeListener titleChangeListener : this.fUpdateTitleListeners) {
            titleChangeListener.updateTitle(string);
        }
    }

    public void addSearchTextListener(ChangeListener changeListener) {
        this.fListeners.addChangeListener(changeListener);
    }

    public void removeSearchTextListener(ChangeListener changeListener) {
        this.fListeners.removeChangeListener(changeListener);
    }

    public String getText() {
        String string = this.fTextField.getText().trim();
        if (string.equals(ExplorerResources.getString("searchbox.default"))) {
            return null;
        }
        return string;
    }

    public void setText(String string) {
        this.fTextField.setText(string);
        if (string.length() > 0) {
            this.rebuildInActiveMode();
        }
    }
}

