/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.table;

import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MountLevel;
import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.mlwidgets.explorer.model.actions.ActionManager;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.table.FileCellViewerCustomizer;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.CellViewerUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.mwswing.TableCell;
import com.mathworks.util.Converter;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.ClosableToolTip;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.grouptable.EditOnClickHandler;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableSelectionListener;
import com.mathworks.widgets.grouptable.RightClickSelectionHandler;
import com.mathworks.widgets.grouptable.SelectOnTypeHandler;
import com.mathworks.widgets.grouptable.ToolTipSupport;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

public class FileTable
extends GroupingTable<FileSystemEntry>
implements ActionInputSource {
    private final NavigationContext fContext;
    private final Runnable fFileSearchStarter;
    private final FileCellViewerCustomizer fCellViewerCustomizer;
    private final GroupingTableColumn<FileSystemEntry> fNameColumn;
    private final RequestQueue fRequestQueue;
    private final MulticastChangeListener fInputChangeListeners;
    private final SelectOnTypeHandler<FileSystemEntry> fSelectOnTypeHandler;
    private ActionManager fActionManager;
    private CellViewerUtils.Context fCellViewerContext;

    public FileTable(NavigationContext navigationContext, WorkMonitor workMonitor, Runnable runnable, GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        super(new GroupingTableModel(groupingTableConfiguration, workMonitor));
        this.fFileSearchStarter = runnable;
        this.fContext = navigationContext;
        this.fInputChangeListeners = new MulticastChangeListener();
        this.fRequestQueue = new RequestQueue("FileTable request queue for decorations not obtained via FileList");
        this.fNameColumn = groupingTableConfiguration.getColumnByKey("name");
        this.setLocationNowAndOnChange();
        this.openSelectedFileSystemEntrysOnDoubleClick();
        this.putClientProperty("JTable.autoStartsEdit", false);
        this.fSelectOnTypeHandler = new SelectOnTypeHandler((GroupingTable)this, (Converter)new Converter<FileSystemEntry, String>(){

            public String convert(FileSystemEntry fileSystemEntry) {
                return fileSystemEntry.getName();
            }
        });
        this.setEditOnClickHandler(new EditOnClickHandler((GroupingTable)this, (ParameterRunnable)new ParameterRunnable<Integer>(){

            public void run(Integer n) {
                FileTable.this.rename(n);
            }
        }));
        new RightClickSelectionHandler((Component)((Object)this));
        this.fCellViewerCustomizer = new FileCellViewerCustomizer(this);
        this.fCellViewerContext = CellViewerUtils.installCellViewer((JTable)((Object)this), (CellViewerCustomizer)this.fCellViewerCustomizer);
        this.suppressAutoRenameOnFocusGained();
        this.configureInputChangeEvents();
        this.configureMountLevelChanger();
    }

    public ClosableToolTipData getToolTipData(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n > -1 && n2 > -1 && this.fCellViewerCustomizer.shouldShowCellViewer(new TableCell(n, n2))) {
            return null;
        }
        return super.getToolTipData(mouseEvent);
    }

    private void openSelectedFileSystemEntrysOnDoubleClick() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent) && FileTable.this.isRightOfIndentation(mouseEvent.getPoint())) {
                    FileTable.this.openSelectedFileSystemEntrys();
                }
            }
        });
    }

    private void suppressAutoRenameOnFocusGained() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FileTable.this.getEditOnClickHandler().setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileTable.this.getEditOnClickHandler().setEnabled(true);
                    }
                });
            }
        });
    }

    private void setLocationNowAndOnChange() {
        this.getGroupingModel().setLocation((Object)this.fContext.getLocationEntry());
        this.fContext.addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, final FileLocation fileLocation2) {
                FileTable.this.setMessageText(null);
                if (FileTable.this.getCellEditor() != null && !FileTable.this.getCellEditor().stopCellEditing()) {
                    FileTable.this.getCellEditor().cancelCellEditing();
                }
                FileTable.this.clearSelection();
                FileTable.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                FileTable.this.getGroupingModel().setLocation((Object)FileTable.this.fContext.getLocationEntry());
                if (FileTable.this.fContext.getSystem() instanceof VirtualFileSystem) {
                    ((VirtualFileSystem)FileTable.this.fContext.getSystem()).garbageCollectAutoMounts(new Predicate<FileLocation>(){

                        public boolean accept(FileLocation fileLocation) {
                            return !fileLocation.hasPrefix(fileLocation2);
                        }
                    });
                }
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
                FileTable.this.clearSelection();
                FileTable.this.setMessageText(null);
                FileTable.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                FileTable.this.getGroupingModel().setLocation((Object)FileTable.this.fContext.getLocationEntry());
            }

            @Override
            public void searchEnded() {
                this.navigationChange(FileTable.this.fContext.getLocation(), FileTable.this.fContext.getLocation());
            }
        });
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FileTable.super.dispose();
                FileTable.this.getContext().getList().close();
                if (FileTable.this.fActionManager != null) {
                    FileTable.this.fActionManager.dispose();
                }
                FileTable.this.fSelectOnTypeHandler.destroy();
                FileTable.this.fContext.getRefreshDaemon().dispose();
            }
        });
    }

    public void startFileSearch() {
        this.fFileSearchStarter.run();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(this.fCellViewerContext.adjustMouseEvent(mouseEvent));
    }

    public void setActionManager(ActionManager actionManager) {
        this.fActionManager = actionManager;
    }

    public ActionManager getActionManager() {
        return this.fActionManager;
    }

    public NavigationContext getContext() {
        return this.fContext;
    }

    public void renameNewDirectory(FileSystemEntry fileSystemEntry) {
        this.renameNewFile(fileSystemEntry, null);
    }

    public void renameNewFile(final FileSystemEntry fileSystemEntry, final NewFileTemplate newFileTemplate) {
        this.startRenameMode(fileSystemEntry);
        if (newFileTemplate != null) {
            this.runAfterNextEdit((ParameterRunnable)new ParameterRunnable<FileSystemEntry>(){

                public void run(FileSystemEntry fileSystemEntry2) {
                    try {
                        if (fileSystemEntry2 != null) {
                            UiFileSystemUtils.updateNewFile(fileSystemEntry2, newFileTemplate);
                        }
                    }
                    catch (IOException iOException) {
                        MJOptionPane.showMessageDialog((Component)((Object)FileTable.this), (Object)ExplorerResources.getString("newfile.rename.error"), (String)ExplorerResources.getString("rename.error.title"), (int)0);
                        try {
                            MLFileSystemUtils.rename((Component)((Object)FileTable.this), fileSystemEntry2, fileSystemEntry.getName());
                            FileTable.this.continueAfterPendingTransactions(new Runnable(){

                                @Override
                                public void run() {
                                    int n = FileTable.this.getGroupingModel().rowIndexOf((Object)fileSystemEntry);
                                    if (n > -1) {
                                        FileTable.this.getSelectionModel().setSelectionInterval(n, n);
                                    }
                                }
                            });
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public void rename(FileSystemEntry fileSystemEntry) {
        this.startRenameMode(fileSystemEntry);
    }

    public void doWhenReady(final FileSystemEntry fileSystemEntry, final ParameterRunnable<Integer> parameterRunnable) {
        final UiFileList uiFileList = this.getFileSystemExpansionProvider().getList(fileSystemEntry);
        if (uiFileList == null) {
            return;
        }
        uiFileList.refresh();
        uiFileList.getRequestQueue().request(new Runnable(){

            @Override
            public void run() {
                uiFileList.getDecorations(fileSystemEntry, FileTable.this.fContext.getExtensions()).get(CoreFileDecoration.ICON, false, (ParameterRunnable)new ParameterRunnable<Icon>(){

                    public void run(Icon icon) {
                        FileTable.this.continueAfterPendingTransactions(new Runnable(){

                            @Override
                            public void run() {
                                GroupingTableModel groupingTableModel = FileTable.this.getGroupingModel();
                                Group group = groupingTableModel.getGroup((Object)fileSystemEntry);
                                if (group != null) {
                                    FileTable.this.getConfiguration().setExpanded(group, true);
                                }
                                FileTable.this.continueAfterPendingTransactions(new Runnable(){

                                    @Override
                                    public void run() {
                                        int n = FileTable.this.getGroupingModel().rowIndexOf((Object)fileSystemEntry);
                                        if (n >= 0) {
                                            parameterRunnable.run((Object)n);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void startRenameMode(FileSystemEntry fileSystemEntry) {
        this.doWhenReady(fileSystemEntry, new ParameterRunnable<Integer>(){

            public void run(Integer n) {
                FileTable.this.rename(n);
            }
        });
    }

    public void rename(final int n) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolTipSupport.hideTip((GroupingTable)FileTable.this);
                final FileSystemEntry fileSystemEntry = (FileSystemEntry)FileTable.this.getItem(n);
                FileTable.this.getSelectionModel().setSelectionInterval(n, n);
                int n2 = FileTable.this.convertColumnIndexToView(FileTable.this.getConfiguration().getVisibleColumns().indexOf(FileTable.this.fNameColumn));
                FileTable.this.scrollRowToVisible(n);
                FileTable.this.editCellAt(n, n2);
                final JTextField jTextField = FileTable.this.getEditorTextField();
                jTextField.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jTextField.setText(FileTable.this.trimDirtyFlag(jTextField.getText(), fileSystemEntry));
                        int n = jTextField.getText().lastIndexOf(46);
                        if (jTextField.getText().toLowerCase().endsWith(".tar.gz")) {
                            n = jTextField.getText().length() - 7;
                        }
                        if (n == -1 || fileSystemEntry != null && VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry).isFolder()) {
                            jTextField.setCaretPosition(jTextField.getText().length());
                            jTextField.selectAll();
                        } else {
                            jTextField.setCaretPosition(n);
                            jTextField.setSelectionStart(0);
                            jTextField.setSelectionEnd(n);
                        }
                    }
                });
            }
        });
    }

    private String trimDirtyFlag(String string, FileSystemEntry fileSystemEntry) {
        if (string.length() == 0 || !((Boolean)this.getDecoration(fileSystemEntry, CoreFileDecoration.IS_DIRTY_FLAG)).booleanValue() || string.lastIndexOf(42) != string.length() - 1) {
            return string;
        }
        return (String)string.subSequence(0, string.length() - 1);
    }

    public void openSelectedFileSystemEntrys() {
        MJAbstractAction mJAbstractAction;
        if (this.fActionManager != null && (mJAbstractAction = this.fActionManager.getAction(CoreActionID.OPEN)).isEnabled()) {
            mJAbstractAction.actionPerformed(null);
        }
    }

    public FileSystemEntry getTargetedDirectory() {
        List list = this.getSelectedItems();
        if (list.size() == 1 && ((FileSystemEntry)list.get(0)).isFolder()) {
            return (FileSystemEntry)list.get(0);
        }
        return this.fContext.getLocationEntry();
    }

    public GroupingTableRow<FileSystemEntry> getTargetedDirectoryRow() {
        List list = this.getSelectedItems();
        return list.size() == 1 && ((FileSystemEntry)list.get(0)).isFolder() ? this.getRowAt(this.getSelectedRows()[0]) : null;
    }

    public void stopSearchingIfNecessaryToShow(FileSystemEntry fileSystemEntry) {
        SearchCriteria searchCriteria = null;
        if (this.fContext.isSearching()) {
            searchCriteria = this.fContext.getSearchCriteria();
        }
        if (searchCriteria != null && !searchCriteria.accept(fileSystemEntry)) {
            try {
                this.fContext.endSearch();
            }
            catch (InvalidLocationException invalidLocationException) {
                // empty catch block
            }
        }
    }

    public void createNewFile(final NewFileTemplate newFileTemplate) {
        final WorkMonitor.Task task = this.getWorkMonitor().startTask(MessageFormat.format(ExplorerResources.getString("progress.newfile"), newFileTemplate.getName()), true);
        final GroupingTableRow<FileSystemEntry> groupingTableRow = this.getTargetedDirectoryRow();
        FileSystemEntry fileSystemEntry = this.getTargetedDirectory();
        NewFileTemplate newFileTemplate2 = newFileTemplate;
        UiFileSystemUtils.createNewFile(newFileTemplate, fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), new ParameterRunnable<FileSystemEntry>(){

            public void run(FileSystemEntry fileSystemEntry) {
                FileTable.this.finishCreation(task, fileSystemEntry, newFileTemplate, (GroupingTableRow<FileSystemEntry>)groupingTableRow);
            }
        }, new ParameterRunnable<IOException>(){

            public void run(IOException iOException) {
                task.finished();
                MJOptionPane.showMessageDialog((Component)((Object)FileTable.this), (Object)ExplorerResources.getString("newfile.error"), (String)ExplorerResources.getString("newfile.error.title"), (int)0);
            }
        });
    }

    public void createNewFolder() {
        final WorkMonitor.Task task = this.getWorkMonitor().startTask(ExplorerResources.getString("progress.newfolder"), true);
        FileSystemEntry fileSystemEntry = this.getTargetedDirectory();
        final GroupingTableRow<FileSystemEntry> groupingTableRow = this.getTargetedDirectoryRow();
        UiFileSystemUtils.createNewFolder(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), new ParameterRunnable<FileSystemEntry>(){

            public void run(FileSystemEntry fileSystemEntry) {
                FileTable.this.finishCreation(task, fileSystemEntry, null, (GroupingTableRow<FileSystemEntry>)groupingTableRow);
            }
        }, new ParameterRunnable<IOException>(){

            public void run(IOException iOException) {
                task.finished();
                MJOptionPane.showMessageDialog((Component)((Object)FileTable.this), (Object)ExplorerResources.getString("newfolder.error"), (String)ExplorerResources.getString("newfolder.error.title"), (int)0);
            }
        });
    }

    public void selectNewFile(final FileSystemEntry fileSystemEntry, final boolean bl, final boolean bl2) {
        if (bl2) {
            this.stopSearchingIfNecessaryToShow(fileSystemEntry);
        }
        this.continueAfterPendingTransactions(new Runnable(){

            @Override
            public void run() {
                Group group;
                int n = FileTable.this.getGroupingModel().rowIndexOf((Object)fileSystemEntry);
                FileTable.this.scrollRowToVisible(n);
                if (n < 0 && bl2 && (group = FileTable.this.getGroupingModel().getGroup((Object)fileSystemEntry)) != null && !FileTable.this.getConfiguration().isGroupExpanded(group)) {
                    FileTable.this.getConfiguration().setExpanded(group, true);
                    FileTable.this.continueAfterPendingTransactions(this);
                }
                if (n >= 0) {
                    if (bl) {
                        FileTable.this.clearSelection();
                    }
                    FileTable.this.getSelectionModel().addSelectionInterval(n, n);
                }
            }
        });
    }

    private void finishCreation(final WorkMonitor.Task task, final FileSystemEntry fileSystemEntry, final NewFileTemplate newFileTemplate, final GroupingTableRow<FileSystemEntry> groupingTableRow) {
        this.stopSearchingIfNecessaryToShow(fileSystemEntry);
        this.continueAfterPendingTransactions(new Runnable(){

            @Override
            public void run() {
                task.finished();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (newFileTemplate != null) {
                            FileTable.this.renameNewFile(fileSystemEntry, newFileTemplate);
                        } else {
                            FileTable.this.renameNewDirectory(fileSystemEntry);
                        }
                    }
                };
                if (groupingTableRow != null && !groupingTableRow.isExpanded()) {
                    FileTable.this.expandAndContinueLater((GroupingTableRow<FileSystemEntry>)groupingTableRow, runnable);
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    private void expandAndContinueLater(final GroupingTableRow<FileSystemEntry> groupingTableRow, final Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                groupingTableRow.setExpanded(true);
                FileTable.this.continueAfterPendingTransactions(runnable);
            }
        });
    }

    public void continueAfterPendingTransactions(final Runnable runnable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileTable.this.getGroupingModel().waitForPendingTransactions();
                SwingUtilities.invokeLater(runnable);
            }
        }).start();
    }

    private FileSystemExpansionProvider getFileSystemExpansionProvider() {
        for (ExpansionProvider expansionProvider : this.getConfiguration().getExpansionProviders()) {
            if (!(expansionProvider instanceof FileSystemExpansionProvider)) continue;
            return (FileSystemExpansionProvider)expansionProvider;
        }
        return null;
    }

    public UiFileList getList(FileSystemEntry fileSystemEntry) {
        FileSystemExpansionProvider fileSystemExpansionProvider = this.getFileSystemExpansionProvider();
        return fileSystemExpansionProvider == null ? null : fileSystemExpansionProvider.getList(fileSystemEntry);
    }

    public <T> void getDecorationAsynchronously(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration, ParameterRunnable<T> parameterRunnable) {
        FileSystemExpansionProvider fileSystemExpansionProvider = this.getFileSystemExpansionProvider();
        if (fileSystemExpansionProvider == null) {
            new FileDecorationModel(this.fContext.getExtensions(), this.fRequestQueue, fileSystemEntry).getDecorations().get(fileDecoration, false, parameterRunnable);
        } else {
            fileSystemExpansionProvider.getDecorationAsynchronously(fileSystemEntry, fileDecoration, parameterRunnable);
        }
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, boolean bl, FileDecoration<T> fileDecoration) {
        FileSystemExpansionProvider fileSystemExpansionProvider = this.getFileSystemExpansionProvider();
        return fileSystemExpansionProvider == null ? UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, fileDecoration, this.fContext.getExtensions()) : fileSystemExpansionProvider.getDecoration(fileSystemEntry, bl, fileDecoration);
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration) {
        return this.getDecoration(fileSystemEntry, true, fileDecoration);
    }

    public JComponent getDefaultComponent() {
        return this;
    }

    public TableActionInput getCurrentInput() {
        return new TableActionInput(this);
    }

    public ActionInput createInput(List<FileSystemEntry> list) {
        return new TableActionInput(this, list);
    }

    public void notifyActionPerformed(ActionDefinition actionDefinition, Status status) {
        this.addToWorkMonitor(status);
    }

    public void addInputChangeListener(ChangeListener changeListener) {
        this.fInputChangeListeners.addChangeListener(changeListener);
    }

    public void removeInputChangeListener(ChangeListener changeListener) {
        this.fInputChangeListeners.removeChangeListener(changeListener);
    }

    public boolean prepareToShowContextMenu(JComponent jComponent, MouseEvent mouseEvent) {
        this.stopOrCancelEditing();
        return !this.getGroupingModel().getGroupRows().keySet().contains(this.rowAtPoint(mouseEvent.getPoint()));
    }

    private void configureInputChangeEvents() {
        this.fContext.addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                FileTable.this.fInputChangeListeners.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
                FileTable.this.fInputChangeListeners.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void searchEnded() {
                FileTable.this.fInputChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
        this.addSelectionListener((GroupingTableSelectionListener)new GroupingTableSelectionListener<FileSystemEntry>(){

            public void valueChanged(List<FileSystemEntry> list) {
                FileTable.this.fInputChangeListeners.stateChanged(new ChangeEvent(this));
                FileTable.this.repaint();
            }
        });
    }

    private void configureMountLevelChanger() {
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                this.changeMountLevelForPath(treeExpansionEvent, MountLevel.LOCK_ALLOWED);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                this.changeMountLevelForPath(treeExpansionEvent, MountLevel.LOCK_FREE);
            }

            private void changeMountLevelForPath(TreeExpansionEvent treeExpansionEvent, MountLevel mountLevel) {
                GroupingTableRow groupingTableRow = (GroupingTableRow)treeExpansionEvent.getPath().getLastPathComponent();
                FileSystem fileSystem = FileTable.this.getContext().getSystem();
                if (groupingTableRow.getItem() != null && fileSystem instanceof VirtualFileSystem) {
                    ((VirtualFileSystem)fileSystem).changeMountLevel(((FileSystemEntry)groupingTableRow.getItem()).getLocation(), mountLevel);
                    groupingTableRow.reset();
                }
            }
        });
    }

    static {
        MJUtilities.initJIDE();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ClosableToolTip.preInit();
            }
        });
    }
}

