/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerRenderer;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

abstract class PlotItemCellRenderer
extends PlotPickerRenderer {
    protected static Color BACKGROUND_COLOR = new Color(240, 240, 240);
    protected Rectangle fSwapLabelBounds;
    protected Rectangle fIconLabelBounds;
    protected volatile String[] fVarNames;
    protected PlotActionRenderer fPlotActionRenderer = new PlotActionRenderer();
    protected static Color FOREGROUND_COLOR = new Color(76, 83, 92);
    protected static ImageIcon XY_WATERMARK = new ImageIcon(PlotPicker.class.getResource("resources/xy_watermark_dark.png"));
    protected static ImageIcon YX_WATERMARK = new ImageIcon(PlotPicker.class.getResource("resources/yx_watermark_dark.png"));
    protected static ImageIcon XY_BUTTON = new ImageIcon(PlotPicker.class.getResource("resources/xy_button.png"));
    protected static ImageIcon YX_BUTTON = new ImageIcon(PlotPicker.class.getResource("resources/yx_button.png"));
    protected static ImageIcon XY_BUTTONPRESSED = new ImageIcon(PlotPicker.class.getResource("resources/xy_button_pressed.png"));
    protected static ImageIcon YX_BUTTONPRESSED = new ImageIcon(PlotPicker.class.getResource("resources/yx_button_pressed.png"));
    protected static ImageIcon XY_BUTTONHOVER = new ImageIcon(PlotPicker.class.getResource("resources/xy_button_hoverover.png"));
    protected static ImageIcon YX_BUTTONHOVER = new ImageIcon(PlotPicker.class.getResource("resources/yx_button_hoverover.png"));

    PlotItemCellRenderer() {
    }

    private static void setHighContast(boolean bl) {
        sIsHighContrast = bl;
        if (sIsHighContrast) {
            BACKGROUND_COLOR = Color.black;
            FOREGROUND_COLOR = Color.white;
        }
    }

    Rectangle getSwapLabelBounds() {
        return this.fSwapLabelBounds;
    }

    Rectangle getIconLabelBounds() {
        return this.fIconLabelBounds;
    }

    void setVarNames(String[] stringArray) {
        this.fVarNames = stringArray;
    }

    String[] getVarNames() {
        return this.fVarNames;
    }

    static void resetLabelForeground(StyledLabel styledLabel) {
        styledLabel.setForeground(FOREGROUND_COLOR);
    }

    @Override
    protected Font getFont() {
        return this.fPlotActionRenderer.iNameLabel.getFont();
    }

    @Override
    protected Color getForeground() {
        return this.fPlotActionRenderer.iNameLabel.getForeground();
    }

    @Override
    protected void hilight() {
        StyleRange[] styleRangeArray = this.getHiLightedStyleRanges(this.fPlotActionRenderer.iNameLabel.getText());
        this.fPlotActionRenderer.iNameLabel.setStyleRanges(styleRangeArray);
        styleRangeArray = this.getHiLightedStyleRanges(this.fPlotActionRenderer.iDescriptionLabel.getText());
        this.fPlotActionRenderer.iDescriptionLabel.setStyleRanges(styleRangeArray);
    }

    protected void clearhilight() {
        this.fPlotActionRenderer.iNameLabel.clearStyleRanges();
        this.fPlotActionRenderer.iDescriptionLabel.clearStyleRanges();
    }

    static {
        PlotItemCellRenderer.setHighContast(sIsHighContrast);
    }

    protected class PlotActionRenderer
    extends MJPanel {
        protected PlotPickerRenderer.TranslucentLabel iIconLabel;
        protected PlotPickerRenderer.TranslucentLabel iNameLabel;
        protected PlotPickerRenderer.TranslucentLabel iDescriptionLabel;
        protected MJLabel iSwapLabel;

        PlotActionRenderer() {
            super((LayoutManager)new BorderLayout(15, 5));
            this.iIconLabel = new PlotPickerRenderer.TranslucentLabel(new PlotPickerRenderer.PlotIcon(new ImageIcon(PlotPicker.class.getResource("resources/plottype-bar.gif"))));
            this.iNameLabel = new PlotPickerRenderer.TranslucentLabel();
            this.iDescriptionLabel = new PlotPickerRenderer.TranslucentLabel();
            this.iSwapLabel = new MJLabel((Icon)XY_BUTTON);
            this.iNameLabel.setFont(this.iNameLabel.getFont().deriveFont(1, this.iNameLabel.getFont().getSize()));
            this.setOpaque(true);
            this.iIconLabel.setBackground(Color.white);
            this.add((Component)((Object)this.iIconLabel), "West");
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel.setOpaque(false);
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(1, 1));
            mJPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            mJPanel2.setOpaque(false);
            MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            mJPanel3.setOpaque(false);
            mJPanel3.add((Component)((Object)this.iNameLabel), (Object)"West");
            MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout(2, 2));
            mJPanel4.setOpaque(false);
            mJPanel4.add((Component)this.iSwapLabel, (Object)"Center");
            mJPanel3.add((Component)mJPanel4, (Object)"East");
            mJPanel2.add((Component)mJPanel3, (Object)"North");
            mJPanel2.add((Component)((Object)this.iDescriptionLabel), (Object)"Center");
            mJPanel.add((Component)mJPanel2, (Object)"North");
            this.add((Component)mJPanel, "Center");
            this.resetLabelsForeground();
        }

        MJLabel getSwapLabel() {
            return this.iSwapLabel;
        }

        PlotPickerRenderer.TranslucentLabel getIconLabel() {
            return this.iIconLabel;
        }

        public void setForeground(Color color) {
            if (this.iNameLabel != null) {
                this.iNameLabel.setForeground(color);
            }
            if (this.iDescriptionLabel != null) {
                this.iDescriptionLabel.setForeground(color);
            }
            super.setForeground(color);
        }

        public void setEnabled(boolean bl) {
            this.iNameLabel.setActive(bl);
            this.iDescriptionLabel.setActive(bl);
            this.iIconLabel.setActive(bl);
            super.setEnabled(bl);
        }

        void resetLabelsForeground() {
            PlotItemCellRenderer.resetLabelForeground(this.iNameLabel);
            PlotItemCellRenderer.resetLabelForeground(this.iDescriptionLabel);
        }

        void setIcon(ImageIcon imageIcon) {
            this.iIconLabel.setIcon(new PlotPickerRenderer.PlotIcon(imageIcon));
        }

        void setDescription(String string) {
            this.iDescriptionLabel.setText(string);
            this.iDescriptionLabel.setPreferredSize(new Dimension(1, this.iDescriptionLabel.getPreferredSize().height));
        }

        void setPlotName(String string) {
            this.iNameLabel.setText(string);
        }

        String getPlotName() {
            if (this.iNameLabel != null) {
                return this.iNameLabel.getText();
            }
            return null;
        }

        String getDescription() {
            if (this.iDescriptionLabel != null) {
                return this.iDescriptionLabel.getText();
            }
            return null;
        }

        Rectangle getButtonBounds(JLabel jLabel) {
            if (jLabel != null && jLabel.isValid()) {
                Point point = jLabel.getLocation();
                point = SwingUtilities.convertPoint(jLabel.getParent(), point, (Component)((Object)this));
                return new Rectangle(point.x, point.y, jLabel.getBounds().width, jLabel.getBounds().height);
            }
            return null;
        }

        public void validate() {
            super.validate();
            if (this.iSwapLabel.isVisible()) {
                PlotItemCellRenderer.this.fSwapLabelBounds = this.getButtonBounds((JLabel)this.iSwapLabel);
            }
            PlotItemCellRenderer.this.fIconLabelBounds = this.getButtonBounds((JLabel)((Object)this.iIconLabel));
        }
    }

    public static enum CurrentButton {
        SWAP,
        ICON,
        STAR,
        NONE;

    }
}

