/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.grid.Row;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerRenderer;
import com.mathworks.mlwidgets.graphics.PlotPickerTableModel;
import com.mathworks.mlwidgets.graphics.PlotPickerTreeTable;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

final class PlotPickerCategoryRenderer
extends PlotPickerRenderer
implements TableCellRenderer {
    private static Color BACKGROUND_COLOR = new Color(209, 213, 216);
    private static ImageIcon MOVETOTOP = new ImageIcon(PlotPicker.class.getResource("resources/moveTop_up.png"));
    private static ImageIcon MOVETOTOPSELECTED = new ImageIcon(PlotPicker.class.getResource("resources/moveTop_hoverover.png"));
    private static ImageIcon FAVORITE_TITLEICON = new ImageIcon(PlotPicker.class.getResource("resources/star_title.png"));
    private Rectangle fMoveToTopPanelBounds;
    private CategoryRendererPanel fCategoryRenderer = new CategoryRendererPanel();
    private boolean fMoveToTopPanelHighlighted = false;

    PlotPickerCategoryRenderer() {
        if (sIsHighContrast) {
            BACKGROUND_COLOR = Color.black;
        }
    }

    void mouseMovedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent) {
        boolean bl = PlotPickerCategoryRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fMoveToTopPanelBounds, mouseEvent.getPoint());
        if (!this.fMoveToTopPanelHighlighted && bl) {
            this.fMoveToTopPanelHighlighted = true;
            plotPickerTreeTable.setToolTipText(PlotPicker.getResourceString("PlotPickerCategoryRenderer", "MoveCatTop"));
            plotPickerTreeTable.repaint();
        } else if (this.fMoveToTopPanelHighlighted && !bl) {
            this.fMoveToTopPanelHighlighted = false;
            plotPickerTreeTable.setToolTipText("");
            plotPickerTreeTable.repaint();
        }
    }

    void mouseClickedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent, PlotPickerTableModel.Category category) {
        if (PlotPickerCategoryRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fMoveToTopPanelBounds, mouseEvent.getPoint()) && PlotPickerCategoryRenderer.isCategoryMovable(category)) {
            plotPickerTreeTable.moveCategoryToTop(category);
            plotPickerTreeTable.repaint();
        }
    }

    void setPreferredSize(Dimension dimension) {
        this.fCategoryRenderer.setPreferredSize(dimension);
    }

    private static boolean isCategoryMovable(PlotPickerTableModel.Category category) {
        return category.getPosition() >= 1;
    }

    @Override
    protected Font getFont() {
        return this.fCategoryRenderer.getNameLabel().getFont();
    }

    @Override
    protected Color getForeground() {
        return this.fCategoryRenderer.getNameLabel().getForeground();
    }

    @Override
    protected void hilight() {
        StyleRange[] styleRangeArray = this.getHiLightedStyleRanges(this.fCategoryRenderer.getNameLabel().getText());
        this.fCategoryRenderer.getNameLabel().setStyleRanges(styleRangeArray);
        styleRangeArray = this.getHiLightedStyleRanges(this.fCategoryRenderer.getNameLabel().getText());
        this.fCategoryRenderer.getNameLabel().setStyleRanges(styleRangeArray);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PlotPickerTreeTable plotPickerTreeTable = (PlotPickerTreeTable)((Object)jTable);
        Row row = plotPickerTreeTable.getRowAt(n);
        PlotPickerTableModel.Category category = (PlotPickerTableModel.Category)row;
        this.fCategoryRenderer.setTopItemEnabled(PlotPickerCategoryRenderer.isCategoryMovable(category));
        if (row instanceof PlotPickerTableModel.FavoriteCategory) {
            this.fCategoryRenderer.getNameLabel().setIcon((Icon)FAVORITE_TITLEICON);
            this.fCategoryRenderer.setTopItemVisible(false);
        } else {
            this.fCategoryRenderer.getNameLabel().setIcon(null);
            this.fCategoryRenderer.setTopItemVisible(true);
        }
        this.fCategoryRenderer.getNameLabel().setText((String)row.getValueAt(n2));
        this.fCategoryRenderer.setHighlighted(PlotPickerCategoryRenderer.isCategoryMovable(category) && bl && this.fMoveToTopPanelHighlighted);
        if (plotPickerTreeTable.getDragTargetRow() == n) {
            this.fCategoryRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black), BorderFactory.createEmptyBorder(2, 5, 1, 0)));
        } else if (n > 0 && plotPickerTreeTable.getDragTargetRow() + 1 == n) {
            this.fCategoryRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black), BorderFactory.createEmptyBorder(1, 5, 2, 0)));
        } else if (!sIsHighContrast) {
            this.fCategoryRenderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        } else {
            this.fCategoryRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white), BorderFactory.createEmptyBorder(1, 5, 2, 0)));
        }
        if (!plotPickerTreeTable.hasFocus() || !bl) {
            this.hilight();
        } else {
            this.fCategoryRenderer.getNameLabel().setStyleRanges(null);
        }
        return this.fCategoryRenderer;
    }

    private class CategoryRendererPanel
    extends MJPanel {
        private StyledLabel iNameLabel;
        private MJLabel iTopLabel;
        private MJLabel iTopIconLabel;
        private MJPanel iMoveToTopPanel;

        CategoryRendererPanel() {
            super((LayoutManager)new BorderLayout());
            this.iNameLabel = new StyledLabel();
            this.iTopLabel = new MJLabel(PlotPicker.getResourceString("PlotPickerCategoryRenderer", "Top"));
            this.iTopIconLabel = new MJLabel((Icon)MOVETOTOP);
            this.setOpaque(true);
            this.iNameLabel.setHorizontalAlignment(2);
            this.add((Component)this.iNameLabel, "West");
            this.iMoveToTopPanel = new MJPanel((LayoutManager)new BorderLayout(2, 0));
            this.iMoveToTopPanel.setOpaque(false);
            this.iMoveToTopPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            switch (HelpUtils.getLanguageLocale()) {
                case ENGLISH: {
                    this.iTopLabel.setFont(new Font("Arial", 1, 8));
                    break;
                }
            }
            this.iMoveToTopPanel.add((Component)this.iTopLabel, (Object)"West");
            this.iMoveToTopPanel.add((Component)this.iTopIconLabel, (Object)"East");
            this.add((Component)this.iMoveToTopPanel, "East");
            if (PlotPickerRenderer.sIsHighContrast) {
                this.iNameLabel.setForeground(Color.white);
            } else {
                this.iNameLabel.setForeground(Color.black);
            }
            this.iNameLabel.setFont(this.getFont().deriveFont(1));
            if (PlotPickerRenderer.sIsHighContrast) {
                this.iTopLabel.setForeground(Color.white);
                this.setBackground(Color.black);
            } else {
                this.iTopLabel.setForeground(new Color(157, 179, 200));
                this.setBackground(BACKGROUND_COLOR);
            }
        }

        StyledLabel getNameLabel() {
            return this.iNameLabel;
        }

        MJLabel getTopLabel() {
            return this.iTopLabel;
        }

        MJLabel getTopIconLabel() {
            return this.iTopLabel;
        }

        private void setTopItemEnabled(boolean bl) {
            this.iTopLabel.setEnabled(bl);
            this.iTopIconLabel.setEnabled(bl);
        }

        private void setTopItemVisible(boolean bl) {
            this.iTopLabel.setVisible(bl);
            this.iTopIconLabel.setVisible(bl);
        }

        private void setHighlighted(boolean bl) {
            if (bl) {
                this.iTopIconLabel.setIcon((Icon)MOVETOTOPSELECTED);
                this.iTopLabel.setFont(this.iTopLabel.getFont().deriveFont(1));
            } else {
                this.iTopIconLabel.setIcon((Icon)MOVETOTOP);
                this.iTopLabel.setFont(this.iTopLabel.getFont().deriveFont(0));
            }
        }

        public void validate() {
            super.validate();
            if (this.iMoveToTopPanel != null && this.iMoveToTopPanel.isValid()) {
                Point point = this.iMoveToTopPanel.getLocation();
                point = SwingUtilities.convertPoint(this.iMoveToTopPanel.getParent(), point, (Component)((Object)this));
                PlotPickerCategoryRenderer.this.fMoveToTopPanelBounds = new Rectangle(point.x, point.y, this.iMoveToTopPanel.getBounds().width, this.iMoveToTopPanel.getBounds().height);
            }
        }
    }
}

