/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jgoodies.forms.factories.Borders;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.graphics.EmptyPlotPanel;
import com.mathworks.mlwidgets.graphics.IPlotModelChangeListener;
import com.mathworks.mlwidgets.graphics.IPlotPickerTableListener;
import com.mathworks.mlwidgets.graphics.IPlotSelectionListener;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotActionEvent;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerDialog;
import com.mathworks.mlwidgets.graphics.PlotPickerTableModel;
import com.mathworks.mlwidgets.graphics.PlotPickerTreeTable;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SearchTextFieldIntelliHints;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;

final class PlotPickerPanel
extends MJPanel
implements ActionListener,
IPlotPickerTableListener,
WorkspaceObserver,
IPlotModelChangeListener {
    private PlotPickerTreeTable fFilteredResultsTable;
    private PlotPickerTreeTable fAllPlotResultsTable;
    private volatile StateNode fModelState;
    private Map<String, StateNode> fModelStateLookup;
    private EmptyPlotPanel fEmptyAllResultsPanel;
    private EmptyPlotPanel fEmptyFilteredResultsPanel;
    private SearchTextField fSearchBox;
    private SearchTextFieldIntelliHints fIntelliHints;
    private Timer fTimer;
    private MJTabbedPane fTabPanel;
    private volatile boolean fIsDirty = true;
    private List<IPlotSelectionListener> fPlotSelectionListenerVector = new ArrayList<IPlotSelectionListener>();
    private List<IPlotPickerTableListener> fPlotPickerTableListenerVector = new ArrayList<IPlotPickerTableListener>();
    private String[] fSelectedVars;
    private MJScrollPane fFilteredResultsPanel;
    private MJScrollPane fAllPlotResultsPanel;
    private PlotAction fLastInvokedAction;
    private String fCurrentSearchString = "";
    private CardLayout fAllPlotsCardLayout;
    private MJPanel fAllPlotsCardLayoutPanel;
    private CardLayout fFilteredPlotsCardLayout;
    private MJPanel fFilteredPlotsCardLayoutPanel;
    private static Color SEARCHPANEL_BACKGROUND = new Color(191, 205, 219);
    private static final String resStr = "com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker";
    private static final String key = "PlotPickerPanel.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker");
    private ModelStateFactory.InterruptibleMatlabWorker fWorker;
    private boolean fIsTableUpdateQueued = false;

    PlotPickerPanel() {
        super((LayoutManager)new BorderLayout(5, 0));
        this.init();
    }

    void setDirty(boolean bl) {
        this.fIsDirty = bl;
    }

    boolean isDirty() {
        return this.fIsDirty;
    }

    @Override
    public void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
        this.setDirty(true);
    }

    void fireVarSelectionSuceeded() {
        for (IPlotSelectionListener iPlotSelectionListener : this.fPlotSelectionListenerVector) {
            iPlotSelectionListener.selectionComplete(new PlotActionEvent(this, PlotActionEvent.SELECTION_SUCEEDED, this.fSelectedVars));
        }
    }

    void fireVarSelectionFailed() {
        for (IPlotSelectionListener iPlotSelectionListener : this.fPlotSelectionListenerVector) {
            iPlotSelectionListener.selectionComplete(new PlotActionEvent(this, PlotActionEvent.SELECTION_FAILED, this.fSelectedVars));
        }
    }

    void fireNoSelection() {
        for (IPlotSelectionListener iPlotSelectionListener : this.fPlotSelectionListenerVector) {
            iPlotSelectionListener.selectionComplete(new PlotActionEvent(this, PlotActionEvent.NOSELECTION, null));
        }
    }

    private void setAllResultsEmptyState(EmptyPlotPanel.State state) {
        this.fEmptyAllResultsPanel.setState(state);
        this.fAllPlotsCardLayout.show((Container)this.fAllPlotsCardLayoutPanel, "emptyResults");
    }

    private void setFilteredResultsEmptyState(EmptyPlotPanel.State state) {
        this.fEmptyFilteredResultsPanel.setState(state);
        this.fFilteredPlotsCardLayout.show((Container)this.fFilteredPlotsCardLayoutPanel, "emptyResults");
    }

    private void clearFilteredResultsEmptyState() {
        this.fFilteredPlotsCardLayout.show((Container)this.fFilteredPlotsCardLayoutPanel, "plotResults");
    }

    private void clearAllResultsEmptyState() {
        this.fAllPlotsCardLayout.show((Container)this.fAllPlotsCardLayoutPanel, "plotResults");
    }

    private void setCurrentSearchString(String string) {
        this.fCurrentSearchString = string;
    }

    private void updateAllPlotsTable(StateNode stateNode) {
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            this.fAllPlotResultsTable.setModel((TableModel)((Object)PlotPickerTableModel.createPlotPickerTableModel(stateNode, this.fCurrentSearchString, this.fSelectedVars, false)));
        } else {
            this.fAllPlotResultsTable.setModel((TableModel)((Object)PlotPickerTableModel.createPlotPickerTableModel(stateNode, this.fSelectedVars, false)));
        }
        this.fAllPlotResultsTable.calculateRowHeights();
    }

    private void updateFilteredPlotsTable(StateNode stateNode) {
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            this.fFilteredResultsTable.setModel((TableModel)((Object)PlotPickerTableModel.createPlotPickerTableModel(stateNode, this.fCurrentSearchString, this.fSelectedVars, true)));
        } else {
            this.fFilteredResultsTable.setModel((TableModel)((Object)PlotPickerTableModel.createPlotPickerTableModel(stateNode, this.fSelectedVars, true)));
        }
        this.fFilteredResultsTable.calculateRowHeights();
    }

    Object updateModelState(ModelStateFactory.InterruptibleMatlabWorker interruptibleMatlabWorker) {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            this.fModelState = ModelStateFactory.createModelState(this.fSelectedVars, interruptibleMatlabWorker);
            if (this.fModelState != null) {
                this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
                return ModelStateFactory.createModelStateForSearch(this.fModelState, this.fCurrentSearchString);
            }
            return null;
        }
        if (this.fSelectedVars != null && this.fSelectedVars.length > 0) {
            this.fModelState = ModelStateFactory.createModelState(this.fSelectedVars, interruptibleMatlabWorker);
            if (this.fModelState != null) {
                this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
            }
            return this.fModelState;
        }
        this.fModelState = ModelStateFactory.createNoSelectionModelState();
        this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
        return this.fModelState;
    }

    Map<String, StateNode> getModelStateLookupMap() {
        return this.fModelStateLookup;
    }

    boolean updateFunctionTables(Object object) {
        boolean bl = false;
        if (object != null && object instanceof StateNode && ((TreeNode)object).getChildCount() > 0) {
            this.updateAllPlotsTable((StateNode)object);
            this.updateFilteredPlotsTable((StateNode)object);
            this.clearAllResultsEmptyState();
            if (ModelStateFactory.countEnabledChildren((StateNode)object) == 0) {
                this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOTENABLED);
            } else {
                this.clearFilteredResultsEmptyState();
                bl = true;
            }
        } else {
            this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOSEARCH);
            this.setAllResultsEmptyState(EmptyPlotPanel.State.NOSEARCH);
        }
        if (!bl) {
            bl = this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2 && this.fModelState != null && ModelStateFactory.countEnabledChildren(this.fModelState) > 0;
        }
        this.fFilteredResultsTable.repaint();
        this.fAllPlotResultsTable.repaint();
        return bl;
    }

    void resetDefaultTab() {
        this.fTabPanel.setSelectedIndex(0);
    }

    private void setNoSelectionState() {
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            this.fModelState = ModelStateFactory.createNoSelectionModelState();
            this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
            StateNode stateNode = ModelStateFactory.createModelStateForSearch(this.fModelState, this.fCurrentSearchString);
            this.updateFunctionTables(stateNode);
            if (stateNode.getChildCount() == 0) {
                this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOSEARCH);
            }
        } else {
            this.fModelState = ModelStateFactory.createNoSelectionModelState();
            this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
            this.updateFunctionTables(this.fModelState);
        }
        this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOSELECTION);
    }

    private void setVariableSelection() {
        if (this.fWorker == null) {
            this.fWorker = new ModelStateFactory.InterruptibleMatlabWorker(){

                public void runOnAWTEventDispatchThread(Object object) {
                    if (PlotPickerPanel.this.fIsTableUpdateQueued) {
                        PlotPickerPanel.this.fIsTableUpdateQueued = false;
                        this.start();
                        return;
                    }
                    this.reset();
                    if (PlotPickerPanel.this.fSelectedVars == null || PlotPickerPanel.this.fSelectedVars.length == 0) {
                        PlotPickerPanel.this.fireNoSelection();
                    } else if (PlotPickerPanel.this.updateFunctionTables(object)) {
                        PlotPickerPanel.this.fireVarSelectionSuceeded();
                    } else {
                        PlotPickerPanel.this.fireVarSelectionFailed();
                    }
                    PlotPickerPanel.this.fIsDirty = false;
                }

                public Object runOnMatlabThread() {
                    try {
                        return PlotPickerPanel.this.updateModelState(this);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                        return null;
                    }
                }
            };
        }
        if (this.fSelectedVars == null || this.fSelectedVars.length == 0) {
            if (this.fWorker.isRunning()) {
                this.fWorker.interrupt();
            }
            this.setNoSelectionState();
            this.fireNoSelection();
            this.fIsDirty = false;
        } else {
            if (this.fWorker.isRunning()) {
                this.fWorker.interrupt();
                this.fIsTableUpdateQueued = true;
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!PlotPickerPanel.this.fWorker.isRunning()) {
                        PlotPickerPanel.this.fWorker.start();
                    } else {
                        PlotPickerPanel.this.fIsTableUpdateQueued = true;
                    }
                }
            });
        }
    }

    void refreshModel() {
        this.fModelState = ModelStateFactory.refreshModelStateNodes(this.fModelStateLookup);
        this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(this.fModelState);
        StateNode stateNode = this.fModelState;
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2 && this.fModelState != null) {
            stateNode = ModelStateFactory.createModelStateForSearch(this.fModelState, this.fCurrentSearchString);
        }
        if (stateNode != null && stateNode.getChildCount() > 0) {
            this.updateAllPlotsTable(stateNode);
            this.updateFilteredPlotsTable(stateNode);
            this.clearAllResultsEmptyState();
            if (ModelStateFactory.countEnabledChildren(stateNode) == 0) {
                this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOTENABLED);
            } else {
                this.clearFilteredResultsEmptyState();
            }
        } else {
            this.setFilteredResultsEmptyState(EmptyPlotPanel.State.NOSEARCH);
            this.setAllResultsEmptyState(EmptyPlotPanel.State.NOSEARCH);
        }
    }

    void clear(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() >= 2) {
            this.fSearchBox.setSearchText(string);
        } else {
            this.fSearchBox.setSearchText("");
        }
        this.find(string);
        this.setCurrentSearchString(string);
        this.fSearchBox.getComponent().requestFocusInWindow();
    }

    void setInitialFocus() {
        this.fSearchBox.requestFocus();
    }

    @Override
    public void invoked(AWTEvent aWTEvent) {
        this.fLastInvokedAction = (PlotAction)aWTEvent.getSource();
        for (IPlotPickerTableListener iPlotPickerTableListener : this.fPlotPickerTableListenerVector) {
            iPlotPickerTableListener.invoked(aWTEvent);
        }
    }

    @Override
    public void modelChanged(Object object) {
        if (Matlab.isMatlabAvailable()) {
            MatlabWorker matlabWorker = this.createModelUpdateWorker(object);
            matlabWorker.start();
        }
    }

    private MatlabWorker createModelUpdateWorker(final Object object) {
        return new MatlabWorker(){

            public void runOnAWTEventDispatchThread(Object object2) {
                if (object2 != null && object2 instanceof StateNode && ((StateNode)object2).getChildCount() > 0) {
                    PlotPickerPanel.this.fModelState = (StateNode)object2;
                    PlotPickerPanel.this.fModelStateLookup = ModelStateFactory.createStateNodeLookupMap(PlotPickerPanel.this.fModelState);
                    if (object == PlotPickerPanel.this.fAllPlotResultsTable.getPlotPickerTableModel()) {
                        PlotPickerPanel.this.updateFilteredPlotsTable(PlotPickerPanel.this.fModelState);
                    } else if (object == PlotPickerPanel.this.fFilteredResultsTable.getPlotPickerTableModel()) {
                        PlotPickerPanel.this.updateAllPlotsTable(PlotPickerPanel.this.fModelState);
                    } else if (object == ModelStateFactory.class || object == null) {
                        PlotPickerPanel.this.updateAllPlotsTable(PlotPickerPanel.this.fModelState);
                        PlotPickerPanel.this.updateFilteredPlotsTable(PlotPickerPanel.this.fModelState);
                    }
                }
            }

            public Object runOnMatlabThread() {
                return ModelStateFactory.createModelState(PlotPickerPanel.this.fSelectedVars, null);
            }
        };
    }

    StateNode getStateNode(PlotAction plotAction) {
        if (this.fModelStateLookup != null) {
            return this.fModelStateLookup.get(plotAction.getID());
        }
        return null;
    }

    String getLabelForPlotPickerButton(StateNode stateNode, String[] stringArray) {
        if (stateNode.isEnabledByUnswappedVariables()) {
            if (stateNode.getCustomLabelText() != null && stateNode.getCustomLabelText().length() > 0) {
                return stateNode.getCustomLabelText();
            }
            if (stateNode.getUserObject() instanceof PlotAction) {
                return ((PlotAction)stateNode.getUserObject()).getPlotLabel(stringArray);
            }
            return null;
        }
        if (stateNode.isEnabledBySwappedVariables()) {
            if (stateNode.getSwappedCustomLabelText() != null && stateNode.getSwappedCustomLabelText().length() > 0) {
                return stateNode.getSwappedCustomLabelText();
            }
            if (stateNode.getUserObject() instanceof PlotAction) {
                return ((PlotAction)stateNode.getUserObject()).getSwappedPlotLabel(stringArray);
            }
        }
        return null;
    }

    PlotAction getDefaultAction() {
        StateNode stateNode = this.fModelState;
        if (this.fLastInvokedAction != null && stateNode.containsPlotAction(this.fLastInvokedAction)) {
            return this.fLastInvokedAction;
        }
        return ModelStateFactory.getDefaultPlotAction(stateNode);
    }

    void addPlotSelectionListener(IPlotSelectionListener iPlotSelectionListener) {
        this.fPlotSelectionListenerVector.add(iPlotSelectionListener);
    }

    void removePlotSelectionListener(IPlotSelectionListener iPlotSelectionListener) {
        this.fPlotSelectionListenerVector.remove(iPlotSelectionListener);
    }

    void addPlotPickerTableListener(IPlotPickerTableListener iPlotPickerTableListener) {
        this.fPlotPickerTableListenerVector.add(iPlotPickerTableListener);
    }

    void removePlotPickerTableListener(IPlotPickerTableListener iPlotPickerTableListener) {
        this.fPlotPickerTableListenerVector.remove(iPlotPickerTableListener);
    }

    private void init() {
        if (MJUtilities.isHighContrast()) {
            SEARCHPANEL_BACKGROUND = Color.black;
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SEARCHPANEL_BACKGROUND));
        this.fFilteredResultsTable = new PlotPickerTreeTable(new PlotPickerTableModel());
        this.fFilteredResultsTable.addPlotPickerTableListener(this);
        this.fFilteredResultsTable.setName("PlotPickerPanel:FilteredPlotsTable");
        this.fAllPlotResultsTable = new PlotPickerTreeTable(new PlotPickerTableModel());
        this.fAllPlotResultsTable.setName("PlotPickerPanel:AllPlotTableTable");
        this.fAllPlotResultsTable.addPlotPickerTableListener(this);
        ModelStateFactory.addModelChangeListener(this);
        ScrollablePanel scrollablePanel = new ScrollablePanel((JTable)((Object)this.fFilteredResultsTable));
        MJLabel mJLabel = new MJLabel(PlotPicker.getResourceString("PlotPickerPanel", "OtherTab"), (Icon)CommonIcon.INFO.getIcon(), 2);
        mJLabel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), Borders.DLU2_BORDER));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(1, 1));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(20, 12, 20, 12));
        mJPanel.add((Component)mJLabel);
        mJLabel.setOpaque(true);
        mJLabel.setBackground(Color.white);
        scrollablePanel.add((Component)mJPanel, "South");
        this.fFilteredResultsPanel = new MJScrollPane((Component)((Object)scrollablePanel));
        JScrollBar jScrollBar = this.fFilteredResultsPanel.getVerticalScrollBar();
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (adjustmentEvent.getValue() != 0) {
                    if (PlotPickerPanel.this.fFilteredResultsTable.isToolTipShowing()) {
                        PlotPickerPanel.this.fFilteredResultsTable.hideActionToolTip();
                    } else {
                        int n = PlotPickerPanel.this.fFilteredResultsTable.getSelectedRow();
                        if (n < 0 || !SwingUtilities.isRectangleContainingRectangle(PlotPickerPanel.this.fFilteredResultsTable.getVisibleRect(), PlotPickerPanel.this.fFilteredResultsTable.getCellRect(n, 0, false))) {
                            PlotPickerPanel.this.fFilteredResultsTable.hideActionToolTip();
                        }
                    }
                }
            }
        });
        this.fFilteredResultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fFilteredResultsPanel.setWheelScrollingEnabled(false);
        this.fAllPlotResultsPanel = new MJScrollPane((Component)((Object)this.fAllPlotResultsTable));
        jScrollBar = this.fAllPlotResultsPanel.getVerticalScrollBar();
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (adjustmentEvent.getValue() != 0) {
                    if (PlotPickerPanel.this.fAllPlotResultsTable.isToolTipShowing()) {
                        PlotPickerPanel.this.fAllPlotResultsTable.hideActionToolTip();
                    } else {
                        int n = PlotPickerPanel.this.fAllPlotResultsTable.getSelectedRow();
                        if (n < 0 || !SwingUtilities.isRectangleContainingRectangle(PlotPickerPanel.this.fAllPlotResultsTable.getVisibleRect(), PlotPickerPanel.this.fAllPlotResultsTable.getCellRect(n, 0, false))) {
                            PlotPickerPanel.this.fAllPlotResultsTable.hideActionToolTip();
                        }
                    }
                }
            }
        });
        this.fAllPlotResultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fAllPlotResultsPanel.setWheelScrollingEnabled(false);
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (PlotPickerPanel.this.fTabPanel.getSelectedIndex() == 0) {
                    PlotPickerPanel.this.fFilteredResultsPanel.removeMouseWheelListener((MouseWheelListener)this);
                    PlotPickerPanel.this.fFilteredResultsPanel.setWheelScrollingEnabled(true);
                    MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent((Component)((Object)PlotPickerPanel.this.fFilteredResultsTable), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), false, mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                    PlotPickerPanel.this.fFilteredResultsTable.dispatchScrollEvent(mouseWheelEvent2);
                    PlotPickerPanel.this.fFilteredResultsPanel.setWheelScrollingEnabled(false);
                    PlotPickerPanel.this.fFilteredResultsPanel.addMouseWheelListener((MouseWheelListener)this);
                } else {
                    PlotPickerPanel.this.fAllPlotResultsPanel.removeMouseWheelListener((MouseWheelListener)this);
                    PlotPickerPanel.this.fAllPlotResultsPanel.setWheelScrollingEnabled(true);
                    PlotPickerPanel.this.fAllPlotResultsTable.dispatchScrollEvent(mouseWheelEvent);
                    PlotPickerPanel.this.fAllPlotResultsPanel.setWheelScrollingEnabled(false);
                    PlotPickerPanel.this.fAllPlotResultsPanel.addMouseWheelListener((MouseWheelListener)this);
                }
            }
        };
        this.fAllPlotResultsPanel.addMouseWheelListener(mouseWheelListener);
        this.fFilteredResultsPanel.addMouseWheelListener(mouseWheelListener);
        this.addMouseWheelListener(mouseWheelListener);
        this.fEmptyAllResultsPanel = new EmptyPlotPanel();
        this.fEmptyFilteredResultsPanel = new EmptyPlotPanel();
        this.fSearchBox = new SearchTextField(resources.getString("PlotPickerPanel.SearchMsg"));
        this.fIntelliHints = new SearchTextFieldIntelliHints(this.fSearchBox);
        this.fSearchBox.getComponent().setName("FunctionBrowserPanel:fSearchBox");
        this.fSearchBox.addSearchTextFieldListener(new SearchTextField.Listener(){
            private boolean iShouldCloseOnClear = true;

            public void search(String string) {
                this.iShouldCloseOnClear = false;
                PlotPickerPanel.this.update();
            }

            public void searchCleared() {
                if (this.iShouldCloseOnClear) {
                    SwingUtilities.getWindowAncestor((Component)((Object)PlotPickerPanel.this)).setVisible(false);
                }
                this.iShouldCloseOnClear = true;
            }

            public void searchTextChanged(String string) {
                this.iShouldCloseOnClear = false;
                if (string == null || string.length() == 0) {
                    PlotPickerPanel.this.fTimer.stop();
                    PlotPickerPanel.this.update();
                    return;
                }
                if (PlotPickerPanel.this.fTimer.isRunning()) {
                    PlotPickerPanel.this.fTimer.restart();
                    return;
                }
                PlotPickerPanel.this.fTimer.start();
            }
        });
        this.initColors();
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        mJPanel2.setBackground(SEARCHPANEL_BACKGROUND);
        mJPanel2.add((Component)this.fSearchBox.getComponent(), (Object)"Center");
        this.add((Component)mJPanel2, "North");
        this.fAllPlotsCardLayout = new CardLayout();
        this.fAllPlotsCardLayoutPanel = new MJPanel((LayoutManager)this.fAllPlotsCardLayout);
        this.fAllPlotsCardLayoutPanel.add((Component)this.fAllPlotResultsPanel, (Object)"plotResults");
        this.fAllPlotsCardLayoutPanel.add((Component)((Object)this.fEmptyAllResultsPanel), (Object)"emptyResults");
        this.fAllPlotsCardLayout.show((Container)this.fAllPlotsCardLayoutPanel, "emptyResults");
        this.fFilteredPlotsCardLayout = new CardLayout();
        this.fFilteredPlotsCardLayoutPanel = new MJPanel((LayoutManager)this.fFilteredPlotsCardLayout);
        this.fFilteredPlotsCardLayoutPanel.add((Component)this.fFilteredResultsPanel, (Object)"plotResults");
        this.fFilteredPlotsCardLayoutPanel.add((Component)((Object)this.fEmptyFilteredResultsPanel), (Object)"emptyResults");
        this.fFilteredPlotsCardLayout.show((Container)this.fFilteredPlotsCardLayoutPanel, "emptyResults");
        this.fTabPanel = new MJTabbedPane();
        this.add((Component)this.fTabPanel, "Center");
        this.fTabPanel.addTab(null, (Component)this.fFilteredPlotsCardLayoutPanel);
        this.fTabPanel.setTabComponentAt(0, (Component)new MJLabel("<html>" + PlotPicker.getResourceString("PlotPickerPanel", "PlotsFor") + " " + PlotPickerPanel.createVarArgs(this.fSelectedVars, true) + "</html>"));
        this.fTabPanel.addTab(null, (Component)this.fAllPlotsCardLayoutPanel);
        this.fTabPanel.setTabComponentAt(1, (Component)new MJLabel(PlotPicker.getResourceString("PlotPickerPanel", "AllPlots")));
        this.fTabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PlotPickerPanel.this.fFilteredResultsTable != null) {
                    PlotPickerPanel.this.fFilteredResultsTable.hideActionToolTip();
                }
                if (PlotPickerPanel.this.fAllPlotResultsTable != null) {
                    PlotPickerPanel.this.fAllPlotResultsTable.hideActionToolTip();
                }
            }
        });
        this.fTimer = new Timer(750, this);
        this.fTimer.setRepeats(false);
        if (ModelStateFactory.isReady()) {
            this.setVariableSelection();
        } else {
            ModelStateFactory.addParseCompletionListener(new ModelStateFactory.ParseCompleteListener(){

                @Override
                public void parseComplete() {
                    PlotPickerPanel.this.setVariableSelection();
                }
            });
        }
        if (Matlab.isMatlabAvailable()) {
            MatlabWorkspaceListener.addWorkspaceChangeObserver(this);
        }
    }

    public void cleanup() {
        MatlabWorkspaceListener.removeWorkspaceChangeObserver(this);
        ModelStateFactory.removeModelChangeListener(this);
        this.fModelStateLookup.clear();
    }

    void selectAllSearchText() {
        this.fSearchBox.selectAllSearchText();
    }

    void update() {
        this.fTimer.stop();
        this.setCurrentSearchString("");
        this.find(this.fSearchBox.getSearchText());
    }

    PlotPickerTreeTable getFunctionTable() {
        if (this.fTabPanel.getSelectedIndex() == 0) {
            return this.fFilteredResultsTable;
        }
        return this.fAllPlotResultsTable;
    }

    void initColors() {
        Color color = PlotPickerTreeTable.TABLE_BACKGROUND_COLOR;
        if (MJUtilities.isHighContrast()) {
            color = Color.black;
        } else if (!Prefs.getBooleanPref((String)"ColorsUseSystem", (boolean)true)) {
            color = ColorPrefs.getBackgroundColor();
        }
        this.setBackground(color);
        this.fFilteredResultsTable.setBackground(color);
        this.fAllPlotResultsTable.setBackground(color);
        this.fFilteredResultsPanel.setBackground(color);
        this.fAllPlotResultsPanel.setBackground(color);
        JViewport jViewport = this.fFilteredResultsPanel.getViewport();
        if (jViewport != null) {
            jViewport.setBackground(color);
        }
        if ((jViewport = this.fAllPlotResultsPanel.getViewport()) != null) {
            jViewport.setBackground(color);
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fTimer.stop();
        String string = this.fSearchBox.getSearchText().trim();
        this.find(string);
        if (string != null && string.length() > 2) {
            this.fIntelliHints.addCurrentTextAsHint();
        }
    }

    public void find(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        if (string == null) {
            return;
        }
        string = string.replaceAll("^\\**", "");
        String string2 = (string = string.replaceAll("\\**$", "")).trim();
        if (string2.length() <= 1) {
            this.emptyFindCallback();
            return;
        }
        if (this.fCurrentSearchString.equals(string2)) {
            return;
        }
        this.setCurrentSearchString(string2);
        this.fAllPlotResultsTable.setSearchString(string2);
        this.fFilteredResultsTable.setSearchString(string2);
        this.setVariableSelection();
    }

    static String createVarArgs(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = bl ? " <font color=#4187D3>" + stringArray[0] : stringArray[0];
        if (stringArray.length == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        if (bl) {
            stringBuilder.append("</font>");
        }
        return stringBuilder.toString();
    }

    private void emptyFindCallback() {
        assert (SwingUtilities.isEventDispatchThread());
        this.setCurrentSearchString("");
        this.fFilteredResultsTable.setSearchString(this.fCurrentSearchString);
        this.fAllPlotResultsTable.setSearchString(this.fCurrentSearchString);
        this.setVariableSelection();
    }

    String[] getSelectedVarNames() {
        return this.fSelectedVars;
    }

    public boolean setVarNames(String[] stringArray) {
        Object[] objectArray = new String[]{};
        if (this.fSelectedVars != null) {
            objectArray = (String[])this.fSelectedVars.clone();
            Arrays.sort(objectArray);
        }
        Object[] objectArray2 = new String[]{};
        if (stringArray != null) {
            objectArray2 = (String[])stringArray.clone();
            Arrays.sort(objectArray2);
        }
        if (Arrays.equals(objectArray2, objectArray)) {
            return false;
        }
        this.fSelectedVars = stringArray;
        MJLabel mJLabel = new MJLabel("<html>" + PlotPicker.getResourceString("PlotPickerPanel", "PlotsFor") + " " + PlotPickerPanel.createVarArgs(stringArray, true) + "</html>");
        int n = PlotPickerDialog.DEFAULT_SIZE.width;
        if (mJLabel.getPreferredSize().width > 2 * n / 3) {
            mJLabel.setText(PlotPicker.getResourceString("PlotPickerPanel", "PlotsFor") + PlotPickerPanel.createVarArgs(stringArray, false));
            mJLabel.setPreferredSize(new Dimension(2 * n / 3, mJLabel.getPreferredSize().height));
        }
        this.fTabPanel.setTabComponentAt(0, (Component)mJLabel);
        this.fFilteredResultsTable.setVarNames(stringArray);
        this.fAllPlotResultsTable.setVarNames(stringArray);
        this.fSearchBox.setSearchText("");
        this.setCurrentSearchString("");
        this.setVariableSelection();
        this.resetDefaultTab();
        return true;
    }

    private static class ScrollablePanel
    extends MJPanel
    implements Scrollable {
        private final JTable iTable;

        private ScrollablePanel(JTable jTable) {
            super((LayoutManager)new BorderLayout());
            this.add(jTable);
            this.iTable = jTable;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.iTable.getScrollableTracksViewportHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.iTable.getScrollableTracksViewportWidth();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.iTable.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.iTable.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.iTable.getScrollableUnitIncrement(rectangle, n, n2);
        }
    }
}

