/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ReferencePageInfo;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.util.productinfo.HelpAddonItem;
import com.mathworks.mlwidgets.util.productinfo.InfoListener;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpInfo {
    private static final Pattern TOOLBOX_PATTERN = Pattern.compile("\\btoolbox[\\\\/]([^\\\\/]*)[\\\\/]");
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo");
    private static Product[] sProducts = null;
    private static Map<Integer, HelpInfoItem> sProductHashtable = new Hashtable<Integer, HelpInfoItem>();
    private static Map<String, HelpInfoItem> sProductsByShortName = new Hashtable<String, HelpInfoItem>();
    private static Map<String, HelpInfoItem> sProductsByAltShortName = new Hashtable<String, HelpInfoItem>();
    private static Map<String, HelpInfoItem> sProductsByName = new Hashtable<String, HelpInfoItem>();
    private static List<ActionListener> sListeners = new ArrayList<ActionListener>();
    private static HelpInfoItem[] sHelpInfo = null;
    private static boolean sAddonsExist = false;
    private static HelpInfoItem[] sToplevelProducts = null;
    private static HelpInfoItem[] sThirdPartyHelpInfo = null;
    private static boolean sLogging = false;

    private HelpInfo() {
    }

    public static HelpInfoItem getHelpInfoItemAtPathPos(int n) {
        return sProductHashtable.get(n);
    }

    public static HelpInfoItem getHelpInfoItemByName(String string) {
        if (string != null) {
            return sProductsByName.get(string);
        }
        return null;
    }

    public static HelpInfoItem getHelpInfoItemByShortName(String string) {
        HelpInfoItem helpInfoItem = null;
        if (string != null && (helpInfoItem = sProductsByShortName.get(string)) == null) {
            helpInfoItem = sProductsByAltShortName.get(string);
        }
        return helpInfoItem;
    }

    public static synchronized void addHelpInfoChangedListener(ActionListener actionListener) {
        sListeners.add(actionListener);
    }

    public static synchronized void removeHelpInfoChangedListener(ActionListener actionListener) {
        sListeners.remove(actionListener);
    }

    static void resetInstalledProducts() {
        if (HelpInfo.isLogging()) {
            System.out.println("In HelpInfo.resetInstalledProducts()");
        }
        Vector<Object> vector = new Vector<Object>();
        sProductHashtable.clear();
        sProductsByName.clear();
        sProductsByShortName.clear();
        sProductsByAltShortName.clear();
        sToplevelProducts = null;
        String string = HelpInfo.getPathToInstallAndRelNotes();
        if (string != null) {
            Object object;
            String object2 = HelpUtils.getLocalizedFilename(string + "relnotes");
            if (object2 != null) {
                object = new HelpInfoItem(sRes.getString("product.relnotes"), object2, null, "matlab");
                ((HelpInfoItem)object).setHasRefPages(false);
                vector.add(object);
                sProductsByName.put(((HelpInfoItem)object).getProductName(), (HelpInfoItem)object);
                sProductsByShortName.put(((HelpInfoItem)object).getShortName(), (HelpInfoItem)object);
            }
            if ((object = HelpUtils.getLocalizedFilename(string + "install")) != null) {
                HelpInfoItem helpInfoItem = new HelpInfoItem(sRes.getString("product.installer"), (String)object, null, "matlab");
                helpInfoItem.setHasRefPages(false);
                vector.add(helpInfoItem);
                sProductsByName.put(helpInfoItem.getProductName(), helpInfoItem);
                sProductsByShortName.put(helpInfoItem.getShortName(), helpInfoItem);
            }
        }
        sProducts = ProductInfoUtils.getAllProductsInMatlabSimulinkGroupInfo();
        sAddonsExist = false;
        for (Product product : sProducts) {
            String string2 = product.getHelpLoc();
            if (string2.length() == 0) continue;
            String string3 = HelpUtils.getLocalizedFilename(string2);
            String string4 = string3 == null ? string2 : string3;
            String string5 = product.getFullName();
            HelpInfoItem helpInfoItem = new HelpInfoItem(string5, string4, product.getHelpIconLoc(), product.getCategory(), ProductInfoUtils.getPathPosition(product));
            vector.add(helpInfoItem);
            sProductHashtable.put(ProductInfoUtils.getPathPosition(product), helpInfoItem);
            sProductsByName.put(helpInfoItem.getProductName(), helpInfoItem);
            sProductsByShortName.put(helpInfoItem.getShortName(), helpInfoItem);
            Set<String> set = HelpInfo.getAltShortNames(helpInfoItem, product);
            if (helpInfoItem.getShortName().equals("matlab")) {
                set.add("local");
                set.add("techdoc");
            }
            helpInfoItem.setAlternateShortNames(set);
            for (String string6 : set) {
                sProductsByAltShortName.put(string6, helpInfoItem);
            }
            HelpAddonItem[] helpAddonItemArray = product.getHelpAddonItems();
            if (helpAddonItemArray == null) continue;
            HelpInfoItem[] helpInfoItemArray = new HelpInfoItem[helpAddonItemArray.length];
            for (int i = 0; i < helpAddonItemArray.length; ++i) {
                helpInfoItemArray[i] = new HelpInfoItem(helpAddonItemArray[i].getName(), helpAddonItemArray[i].getLocation(), null, helpAddonItemArray[i].getCategory());
                helpInfoItemArray[i].setToplevel(helpAddonItemArray[i].isProductLevel());
                if (!helpAddonItemArray[i].isProductLevel()) {
                    helpInfoItemArray[i].setParent(helpInfoItem);
                    vector.add(helpInfoItemArray[i]);
                    sProductsByName.put(helpInfoItemArray[i].getProductName(), helpInfoItemArray[i]);
                    sProductsByShortName.put(helpInfoItemArray[i].getShortName(), helpInfoItemArray[i]);
                }
                sAddonsExist = true;
            }
            helpInfoItem.addHelpAddons(helpInfoItemArray);
        }
        HelpInfoItem[] helpInfoItemArray = new HelpInfoItem[vector.size()];
        sHelpInfo = vector.toArray(helpInfoItemArray);
        sThirdPartyHelpInfo = HelpInfo.getThirdPartyHelpInfoArray(sHelpInfo);
        if (HelpInfo.isLogging()) {
            System.out.print("Installed products:");
            for (HelpInfoItem helpInfoItem : sHelpInfo) {
                System.out.print(" " + helpInfoItem.getShortName());
            }
            System.out.println();
            System.out.print("Third party products:");
            for (HelpInfoItem helpInfoItem : sThirdPartyHelpInfo) {
                System.out.print(" " + helpInfoItem.getShortName());
            }
            System.out.println();
        }
    }

    private static HelpInfoItem[] getThirdPartyHelpInfoArray(HelpInfoItem[] helpInfoItemArray) {
        Vector<HelpInfoItem> vector = new Vector<HelpInfoItem>();
        for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
            if (!helpInfoItem.isToplevel() || HelpUtils.isUnderDocroot(helpInfoItem.getHelpLoc())) continue;
            vector.add(helpInfoItem);
        }
        HelpInfoItem[] helpInfoItemArray2 = new HelpInfoItem[vector.size()];
        HelpInfoItem[] helpInfoItemArray3 = vector.toArray(helpInfoItemArray2);
        return helpInfoItemArray3;
    }

    private static String getPathToInstallAndRelNotes() {
        String string = MLHelpServices.getDocRoot();
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MLHelpServices.getDocRoot()).append(File.separator);
        File file = new File(string);
        File file2 = new File(file, "base");
        if (file2.exists()) {
            stringBuilder.append("base").append(File.separator);
            return stringBuilder.toString();
        }
        File file3 = new File(file, HelpUtils.getDocDirectoryName());
        if (file3.exists()) {
            File file4 = new File(file3, "base");
            if (file4.exists()) {
                stringBuilder.append(HelpUtils.getDocDirectoryName()).append(File.separator).append("base").append(File.separator);
                return stringBuilder.toString();
            }
            stringBuilder.append(HelpUtils.getDocDirectoryName()).append(File.separator);
            return stringBuilder.toString();
        }
        return null;
    }

    private static Set<String> getAltShortNames(HelpInfoItem helpInfoItem, Product product) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = product.getFilename();
        if (string != null) {
            Object object;
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && (object = file2.getName()) != null && !helpInfoItem.getShortName().equals(object)) {
                hashSet.add((String)object);
            }
            if (((Matcher)(object = TOOLBOX_PATTERN.matcher(string))).find()) {
                String string2 = ((Matcher)object).group(1);
                if (!helpInfoItem.getShortName().equals(string2)) {
                    hashSet.add(string2);
                }
            }
        }
        return hashSet;
    }

    public static HelpInfoItem[] getToplevelProductHelpInfo() {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sAddonsExist) {
            if (sToplevelProducts == null) {
                int n = 0;
                for (HelpInfoItem helpInfoItem : sHelpInfo) {
                    if (!helpInfoItem.isToplevel()) continue;
                    ++n;
                }
                sToplevelProducts = new HelpInfoItem[n];
                int n2 = 0;
                for (HelpInfoItem helpInfoItem : sHelpInfo) {
                    if (!helpInfoItem.isToplevel()) continue;
                    HelpInfo.sToplevelProducts[n2++] = helpInfoItem;
                }
            }
            return sToplevelProducts;
        }
        return sHelpInfo;
    }

    public static HelpInfoItem[] getInstalledProductHelpInfo() {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        return sHelpInfo;
    }

    public static int getNumProductsInstalled() {
        if (sProducts == null) {
            return 0;
        }
        return sProducts.length;
    }

    public static HelpInfoItem[] getThirdPartyProductHelpInfo() {
        if (sThirdPartyHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        return sThirdPartyHelpInfo;
    }

    public static int getNumThirdPartyProducts() {
        if (sThirdPartyHelpInfo == null) {
            return 0;
        }
        return sThirdPartyHelpInfo.length;
    }

    public static String getProductShortName(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null && (helpInfoItem = HelpInfo.getHelpInfoItemByName(string)) != null) {
            return helpInfoItem.getShortName();
        }
        return null;
    }

    public static boolean shouldShowProduct(String string) {
        return HelpInfo.shouldShowProduct(string, true);
    }

    public static boolean shouldShowProduct(String string, boolean bl) {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (HelpPrefs.getProductFilterEnabled() && sHelpInfo != null) {
            HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByName(string);
            if (helpInfoItem != null) {
                return helpInfoItem.isSelected();
            }
            return bl;
        }
        return true;
    }

    public static String getRelativePath(String string) {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null) {
            for (HelpInfoItem helpInfoItem : sHelpInfo) {
                String string2 = helpInfoItem.getHelpLoc();
                String string3 = HelpInfo.getLocalizedOrAlternateRelativePath(string, string2);
                if (string3 == null) continue;
                return string3;
            }
        }
        return null;
    }

    private static String getLocalizedOrAlternateRelativePath(String string, String string2) {
        String string3 = HTMLUtils.getCanonicalUrl(string);
        string3 = HelpUtils.convertFromUrlPrefix(string3);
        HelpUtils.RelativePathFilter relativePathFilter = new HelpUtils.RelativePathFilter(string3);
        return HelpUtils.findLocalizedOrAlternateFile(string2, relativePathFilter);
    }

    public static String getProductNameForFilename(String string) {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null) {
            for (HelpInfoItem helpInfoItem : sHelpInfo) {
                String string2 = helpInfoItem.getHelpLoc();
                if (!HelpInfo.checkLocationAndAlternateLocation(string, string2)) continue;
                return helpInfoItem.getProductName();
            }
        }
        return null;
    }

    private static boolean checkLocationAndAlternateLocation(String string, String string2) {
        return HelpInfo.getLocalizedOrAlternateRelativePath(string, string2) != null;
    }

    public static String getPrefixForProductShortName(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null && (helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string)) != null) {
            return helpInfoItem.getUrlPrefix();
        }
        return null;
    }

    public static String getPrefixForProductName(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null && (helpInfoItem = HelpInfo.getHelpInfoItemByName(string)) != null) {
            return helpInfoItem.getUrlPrefix();
        }
        return null;
    }

    public static String getHelpLocation(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null && (helpInfoItem = HelpInfo.getHelpInfoItemByName(string)) != null) {
            return helpInfoItem.getHelpLoc();
        }
        return null;
    }

    public static String getHelpLocationForShortName(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null && (helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string)) != null) {
            return helpInfoItem.getHelpLoc();
        }
        return null;
    }

    public static String getProductNameForHelpLocation(String string) {
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if (sHelpInfo != null) {
            for (HelpInfoItem helpInfoItem : sHelpInfo) {
                if (helpInfoItem == null || !helpInfoItem.getHelpLoc().equals(string)) continue;
                return helpInfoItem.getProductName();
            }
        }
        return null;
    }

    public static String getProductPageForShortName(String string) {
        HelpInfoItem helpInfoItem;
        if (sHelpInfo == null) {
            HelpInfo.getInstalledProducts();
        }
        if ((helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string)) != null) {
            String string2 = helpInfoItem.getUrlPrefix();
            Collection<String> collection = helpInfoItem.getAllPossibleShortNames();
            for (String string3 : collection) {
                String string4 = string2 + string3 + "_product_page.html";
                if (!HTMLUtils.doesFileExist(string4)) continue;
                return string4;
            }
        }
        return null;
    }

    @Deprecated
    public static String getDocCommandArg(String string, boolean bl) {
        int n = string.indexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        String string3 = n > -1 ? string.substring(0, n) : null;
        try {
            return SearchUtils.findDocCommandArg(string2, string3, bl);
        }
        catch (SearchException searchException) {
            return null;
        }
    }

    public static String getReferencePageUrl(String string, boolean bl) {
        ReferencePageInfo[] referencePageInfoArray = HelpInfo.getAllReferencePageUrls(string, bl);
        if (referencePageInfoArray != null && referencePageInfoArray.length > 0) {
            return referencePageInfoArray[0].getFullUrl();
        }
        return null;
    }

    public static ReferencePageInfo[] getAllReferencePageUrls(String string, boolean bl) {
        int n = string.indexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        String string3 = n > -1 ? string.substring(0, n) : null;
        try {
            ReferencePageInfo[] referencePageInfoArray = SearchUtils.findReferencePages(string2, string3, bl);
            if (referencePageInfoArray != null && referencePageInfoArray.length > 0) {
                return referencePageInfoArray;
            }
            return null;
        }
        catch (SearchException searchException) {
            return null;
        }
    }

    public static String getReferencePageUrl(String string) {
        return HelpInfo.getReferencePageUrl(string, false);
    }

    public static boolean isInstalledProductHelpLocation(String string) {
        HelpInfoItem[] helpInfoItemArray = HelpInfo.getInstalledProductHelpInfo();
        File file = new File(string);
        if (file.exists()) {
            for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                File file2 = new File(helpInfoItem.getHelpLoc());
                try {
                    if (file2.getCanonicalPath().equals(file.getCanonicalPath())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static Product[] getInstalledProducts() {
        if (sProducts == null) {
            if (HelpInfo.isLogging()) {
                System.out.println("Initializing installed products.");
            }
            HelpInfo.resetInstalledProducts();
        }
        return sProducts;
    }

    public static synchronized void notifyListeners(Object object) {
        ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>(sListeners);
        for (ActionListener actionListener : arrayList) {
            actionListener.actionPerformed(new ActionEvent(object, 0, ""));
        }
    }

    public static void setLogging(boolean bl) {
        sLogging = bl;
    }

    public static boolean isLogging() {
        return sLogging;
    }

    static {
        HelpInfo.getInstalledProducts();
        ProductInfoUtils.registerInfoListener(new HelpInfoListener());
    }

    private static class HelpInfoListener
    implements InfoListener {
        private HelpInfoListener() {
        }

        @Override
        public void infoChanged(Product[] productArray) {
            if (HelpInfo.isLogging()) {
                System.out.println("Resetting installed products due to product list change.");
            }
            HelpInfo.resetInstalledProducts();
            HelpInfo.notifyListeners(this);
        }
    }
}

