/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.DemoSearchField;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.ExactPhraseSearchExpression;
import com.mathworks.mlwidgets.help.search.PartialWordSearchExpression;
import com.mathworks.mlwidgets.help.search.SearchConstants;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchField;
import com.mathworks.mlwidgets.help.search.SearchStringParseException;
import com.mathworks.mlwidgets.help.search.SimpleSearchExpression;
import com.mathworks.mlwidgets.help.search.UnarySearchExpression;
import com.mathworks.mlwidgets.help.search.WeightedSearchField;
import com.mathworks.mlwidgets.help.search.WildcardSearchExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchStringParser {
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final char JAPANESE_FULL_WIDTH_CHAR = '\u3000';
    private static final String FIND_SEARCH_FIELD_REGEXP = "(?:([^:\\s]*):)?";
    private static final String SEARCH_TERM_REGEXP = "(\\([^\\(\\)]+\\)|\"[^\"]+\"|\\S+)";
    private static final Pattern SEARCH_TERM_PATTERN = Pattern.compile("(\\([^\\(\\)]+\\)|\"[^\"]+\"|\\S+)");
    private static final Pattern SEARCH_EXPRESSION_PATTERN = Pattern.compile("(?:([+-])\\()?(?:([^:\\s]*):)?(\\([^\\(\\)]+\\)|\"[^\"]+\"|\\S+)\\)?");
    private static final Pattern SEARCH_FIELD_PATTERN = Pattern.compile(";?([+-]?)(\\w+)(?:,([\\d\\.]+))?");
    private static final Set<String> sCommonWords = new HashSet<String>();

    private SearchStringParser() {
    }

    public static SearchCriteria buildSearchCriteria(String string) throws SearchStringParseException {
        SearchExpression searchExpression = SearchStringParser.buildExpression(string);
        return new SearchCriteria(searchExpression);
    }

    public static SearchCriteria buildDocSearchCriteria(String string) throws SearchStringParseException {
        return SearchStringParser.buildSearchCriteria(string, new SearchFieldProvider(){

            @Override
            public SearchField getSearchField(String string) {
                return DocSearchField.getFieldByName(string);
            }
        });
    }

    public static SearchCriteria buildDemoSearchCriteria(String string) throws SearchStringParseException {
        return SearchStringParser.buildSearchCriteria(string, new SearchFieldProvider(){

            @Override
            public SearchField getSearchField(String string) {
                return DemoSearchField.getFieldByName(string);
            }
        });
    }

    public static SearchCriteria buildSearchCriteria(String string, SearchFieldProvider searchFieldProvider) throws SearchStringParseException {
        Matcher matcher = SEARCH_EXPRESSION_PATTERN.matcher(string);
        ArrayList<SearchExpression> arrayList = new ArrayList<SearchExpression>();
        while (matcher.find()) {
            BooleanSearchOperator booleanSearchOperator = SearchStringParser.getBooleanSearchOperator(matcher.group(1));
            String string2 = matcher.group(2);
            WeightedSearchField[] weightedSearchFieldArray = SearchStringParser.getSearchFields(string2, searchFieldProvider);
            String string3 = matcher.group(3);
            string3 = string3.replaceAll("^\\((.*)\\)$", "$1");
            SearchExpression searchExpression = SearchStringParser.buildExpression(string3, booleanSearchOperator, weightedSearchFieldArray);
            arrayList.add(searchExpression);
        }
        if (arrayList.size() == 1) {
            return new SearchCriteria((SearchExpression)arrayList.get(0));
        }
        return new SearchCriteria(new CompoundSearchExpression(arrayList));
    }

    public static SearchExpression buildExpression(String string, BooleanSearchOperator booleanSearchOperator, SearchField ... searchFieldArray) throws SearchStringParseException {
        SearchExpression searchExpression = SearchStringParser.buildExpression(string);
        searchExpression.setBooleanOperator(booleanSearchOperator);
        if (searchFieldArray != null) {
            for (SearchField searchField : searchFieldArray) {
                searchExpression.addSearchField(searchField);
            }
        }
        return searchExpression;
    }

    public static SearchExpression buildExpression(String string, BooleanSearchOperator booleanSearchOperator, WeightedSearchField ... weightedSearchFieldArray) throws SearchStringParseException {
        SearchExpression searchExpression = SearchStringParser.buildExpression(string);
        searchExpression.setBooleanOperator(booleanSearchOperator);
        if (weightedSearchFieldArray != null) {
            for (WeightedSearchField weightedSearchField : weightedSearchFieldArray) {
                searchExpression.addSearchField(weightedSearchField);
            }
        }
        return searchExpression;
    }

    public static SearchExpression buildExpression(String string) throws SearchStringParseException {
        String string2 = SearchStringParser.adjustSearchString(string);
        ArrayList<SearchExpression> arrayList = new ArrayList<SearchExpression>();
        Matcher matcher = SEARCH_TERM_PATTERN.matcher(string2);
        UnarySearchExpression[] unarySearchExpressionArray = null;
        CompoundSearchExpression compoundSearchExpression = null;
        boolean bl = false;
        boolean bl2 = false;
        while (matcher.find()) {
            String string3 = matcher.group();
            if (string3.equals(NOT)) {
                bl = true;
            } else {
                if (string3.equals(OR)) {
                    if (compoundSearchExpression == null) {
                        compoundSearchExpression = new CompoundSearchExpression();
                    }
                    if (unarySearchExpressionArray != null) {
                        for (UnarySearchExpression unarySearchExpression : unarySearchExpressionArray) {
                            unarySearchExpression.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
                            compoundSearchExpression.addExpression(unarySearchExpression);
                        }
                    }
                } else if (!string3.equals(AND) && !sCommonWords.contains(string3.toLowerCase())) {
                    UnarySearchExpression[] unarySearchExpressionArray2 = SearchStringParser.buildUnaryExpressions(string3, bl);
                    if (!bl2) {
                        if (compoundSearchExpression != null) {
                            compoundSearchExpression.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
                            arrayList.add(compoundSearchExpression);
                            compoundSearchExpression = null;
                        }
                        if (unarySearchExpressionArray != null) {
                            arrayList.addAll(Arrays.asList(unarySearchExpressionArray));
                        }
                        unarySearchExpressionArray = unarySearchExpressionArray2;
                    } else if (compoundSearchExpression != null) {
                        for (UnarySearchExpression unarySearchExpression : unarySearchExpressionArray2) {
                            unarySearchExpression.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
                            compoundSearchExpression.addExpression(unarySearchExpression);
                        }
                        unarySearchExpressionArray = null;
                    }
                }
                bl = false;
            }
            bl2 = string3.equals(OR);
        }
        if (compoundSearchExpression != null) {
            arrayList.add(compoundSearchExpression);
        }
        if (unarySearchExpressionArray != null) {
            arrayList.addAll(Arrays.asList(unarySearchExpressionArray));
        }
        if (arrayList.size() == 1) {
            return (SearchExpression)arrayList.get(0);
        }
        return new CompoundSearchExpression(arrayList);
    }

    private static String adjustSearchString(String string) {
        String string2 = string;
        if (string.indexOf(12288) > -1) {
            string2 = string2.replace('\u3000', ' ');
        }
        return string2;
    }

    private static UnarySearchExpression[] buildUnaryExpressions(String string, boolean bl) throws SearchStringParseException {
        BooleanSearchOperator booleanSearchOperator = bl ? BooleanSearchOperator.MUST_NOT_OCCUR : BooleanSearchOperator.MUST_OCCUR;
        String string2 = string;
        if (string2.length() > 1 && string2.startsWith("\"") && string2.endsWith("\"")) {
            if (string2.indexOf(42) > -1) {
                throw new SearchStringParseException(4);
            }
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.indexOf(34) > -1) {
            throw new SearchStringParseException(0);
        }
        if ((string2 = string2.replaceAll("[^\\p{L}\\p{N}\\*]+", " ").trim()).length() == 0) {
            throw new SearchStringParseException(1);
        }
        if (string2.indexOf(32) > -1) {
            if (string2.indexOf(42) > -1) {
                String[] stringArray = string2.split("\\s");
                UnarySearchExpression[] unarySearchExpressionArray = new UnarySearchExpression[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    unarySearchExpressionArray[i] = SearchStringParser.buildUnaryExpressions(stringArray[i], bl)[0];
                }
                return unarySearchExpressionArray;
            }
            return new UnarySearchExpression[]{new ExactPhraseSearchExpression(string2, booleanSearchOperator)};
        }
        if (string2.indexOf(42) > -1) {
            UnarySearchExpression unarySearchExpression = SearchStringParser.handleWildcardExpression(string2, booleanSearchOperator);
            return new UnarySearchExpression[]{unarySearchExpression};
        }
        return new UnarySearchExpression[]{new SimpleSearchExpression(string2, booleanSearchOperator)};
    }

    private static UnarySearchExpression handleWildcardExpression(String string, BooleanSearchOperator booleanSearchOperator) throws SearchStringParseException {
        char c = '*';
        if (string.charAt(0) == c) {
            throw new SearchStringParseException(5);
        }
        if (!string.matches("([^" + c + "]\\" + c + "*){2,}")) {
            throw new SearchStringParseException(2);
        }
        if (string.indexOf(42) == string.length() - 1) {
            String string2 = string.substring(0, string.length() - 1);
            return new PartialWordSearchExpression(string2, booleanSearchOperator);
        }
        return new WildcardSearchExpression(string, booleanSearchOperator);
    }

    private static WeightedSearchField[] getSearchFields(String string, SearchFieldProvider searchFieldProvider) throws SearchStringParseException {
        if (string != null) {
            ArrayList<WeightedSearchField> arrayList = new ArrayList<WeightedSearchField>();
            Matcher matcher = SEARCH_FIELD_PATTERN.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(2);
                if (string2 == null || string2.length() <= 0) continue;
                SearchField searchField = searchFieldProvider.getSearchField(string2);
                if (searchField != null) {
                    BooleanSearchOperator booleanSearchOperator = SearchStringParser.getBooleanSearchOperator(matcher.group(1));
                    float f = 1.0f;
                    String string3 = matcher.group(3);
                    if (string3 != null) {
                        try {
                            f = Float.parseFloat(string3);
                        }
                        catch (Exception exception) {
                            throw new SearchStringParseException(6, (Throwable)exception);
                        }
                    }
                    arrayList.add(new WeightedSearchField(searchField, f, booleanSearchOperator));
                    continue;
                }
                throw new SearchStringParseException(7);
            }
            if (!arrayList.isEmpty()) {
                return arrayList.toArray(new WeightedSearchField[arrayList.size()]);
            }
        }
        return null;
    }

    private static BooleanSearchOperator getBooleanSearchOperator(String string) {
        if (string != null && string.length() == 1) {
            char c = string.charAt(0);
            switch (c) {
                case '+': {
                    return BooleanSearchOperator.MUST_OCCUR;
                }
                case '-': {
                    return BooleanSearchOperator.MUST_NOT_OCCUR;
                }
            }
        }
        return BooleanSearchOperator.SHOULD_OCCUR;
    }

    static {
        sCommonWords.addAll(Arrays.asList(SearchConstants.COMMON_WORDS));
    }

    public static interface SearchFieldProvider {
        public SearchField getSearchField(String var1);
    }
}

