/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.search.DemoSearchEngine;
import com.mathworks.mlwidgets.help.search.DemoSearchResult;
import com.mathworks.mlwidgets.help.search.EmptySearchResults;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchUnavailableException;
import com.mathworks.mlwidgets.help.search.lucene.DemoIndexSearcher;
import com.mathworks.mlwidgets.help.search.lucene.DemoMultiSearcher;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDemoSearchResults;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDemoSearchVisitor;
import com.mathworks.mlwidgets.help.search.lucene.MWHitCollector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneDemoSearchEngine
extends DemoSearchEngine {
    private Map<DemoProductInfo, DemoIndexSearcher> fAllSearchers;
    private boolean fIsPopulating = false;
    private Map<SearchCriteria, SearchCompletionObserver<DemoSearchResult>> fPendingSearches;
    private Searcher fProdFilterSearcher;
    private Searcher fAllProductsSearcher;

    @Override
    public synchronized void cleanup() {
        if (this.fAllSearchers != null) {
            for (DemoIndexSearcher demoIndexSearcher : this.fAllSearchers.values()) {
                try {
                    demoIndexSearcher.close();
                }
                catch (IOException iOException) {}
            }
            this.fAllSearchers = null;
            this.fAllProductsSearcher = null;
            this.fProdFilterSearcher = null;
            this.fIsPopulating = false;
        }
    }

    @Override
    public void search(final SearchCriteria searchCriteria, final SearchCompletionObserver<DemoSearchResult> searchCompletionObserver) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LuceneDemoSearchEngine.this.doSearch(searchCriteria, searchCompletionObserver);
            }
        };
        new Thread(runnable).start();
    }

    @Override
    protected synchronized void prodFilterChanged() {
        this.fProdFilterSearcher = null;
    }

    @Override
    protected synchronized void demosDataChanged() {
        this.cleanup();
        new Thread(new Runnable(){

            @Override
            public void run() {
                LuceneDemoSearchEngine.this.openSearchIndexes();
            }
        }).start();
    }

    private synchronized Searcher getSearcher(SearchCriteria searchCriteria) throws SearchException {
        String[] stringArray = searchCriteria.getProducts();
        if (stringArray != null && stringArray.length > 0) {
            return this.getSearcherForProducts(stringArray);
        }
        if (searchCriteria.getUseProductFilter() && HelpPrefs.getProductFilterEnabled()) {
            return this.getProductFilterSearcher();
        }
        return this.getAllProductsSearcher();
    }

    private synchronized Searcher getSearcherForProducts(String[] stringArray) throws SearchException {
        ArrayList<DemoIndexSearcher> arrayList = new ArrayList<DemoIndexSearcher>();
        for (String string : stringArray) {
            HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
            DemoProductInfo demoProductInfo = new DemoProductInfo(helpInfoItem.getProductName(), helpInfoItem.getCategory());
            DemoIndexSearcher demoIndexSearcher = this.fAllSearchers.get(demoProductInfo);
            if (demoIndexSearcher == null) continue;
            arrayList.add(demoIndexSearcher);
        }
        return LuceneDemoSearchEngine.buildProductsSearcher(arrayList);
    }

    private synchronized Searcher getProductFilterSearcher() throws SearchException {
        if (this.fProdFilterSearcher == null) {
            ArrayList<DemoIndexSearcher> arrayList = new ArrayList<DemoIndexSearcher>();
            for (DemoProductInfo demoProductInfo : this.fAllSearchers.keySet()) {
                DemoIndexSearcher demoIndexSearcher;
                if (!DemoInfoUtils.shouldShowDemoProduct(DemoInfoUtils.getDemoProductFullName(demoProductInfo.getProductName(), demoProductInfo.getProductType())) || (demoIndexSearcher = this.fAllSearchers.get(demoProductInfo)) == null) continue;
                arrayList.add(demoIndexSearcher);
            }
            this.fProdFilterSearcher = LuceneDemoSearchEngine.buildProductsSearcher(arrayList);
        }
        return this.fProdFilterSearcher;
    }

    private synchronized Searcher getAllProductsSearcher() throws SearchException {
        if (this.fAllProductsSearcher == null) {
            this.fAllProductsSearcher = LuceneDemoSearchEngine.buildProductsSearcher(this.fAllSearchers.values());
        }
        return this.fAllProductsSearcher;
    }

    private static Searcher buildProductsSearcher(Collection<DemoIndexSearcher> collection) throws SearchException {
        try {
            if (collection.size() > 1) {
                DemoIndexSearcher[] demoIndexSearcherArray = collection.toArray(new DemoIndexSearcher[collection.size()]);
                return new DemoMultiSearcher(demoIndexSearcherArray);
            }
            if (collection.size() == 1) {
                return (Searcher)collection.iterator().next();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new SearchUnavailableException(1);
        }
    }

    private synchronized void openSearchIndexes() {
        this.fAllSearchers = null;
        this.fIsPopulating = true;
        List<String> list = DemosData.getDemosXmlFiles();
        if (list != null) {
            new Thread(new FinishPopulateThread(list)).start();
        }
    }

    private synchronized void doSearch(SearchCriteria searchCriteria, SearchCompletionObserver<DemoSearchResult> searchCompletionObserver) {
        if (this.fAllSearchers == null) {
            if (this.fPendingSearches == null) {
                this.fPendingSearches = new LinkedHashMap<SearchCriteria, SearchCompletionObserver<DemoSearchResult>>();
            }
            this.fPendingSearches.put(searchCriteria, searchCompletionObserver);
            if (!this.fIsPopulating) {
                this.openSearchIndexes();
            }
        } else {
            LuceneDemoSearchVisitor luceneDemoSearchVisitor = new LuceneDemoSearchVisitor();
            try {
                searchCriteria.getExpression().accept(luceneDemoSearchVisitor);
                Query query = luceneDemoSearchVisitor.getBaseQuery();
                MWHitCollector mWHitCollector = new MWHitCollector();
                Searcher searcher = this.getSearcher(searchCriteria);
                if (searcher != null) {
                    searcher.search(query, (HitCollector)mWHitCollector);
                    searchCompletionObserver.searchComplete(new LuceneDemoSearchResults(mWHitCollector, searcher));
                } else {
                    searchCompletionObserver.searchComplete(new EmptySearchResults());
                }
            }
            catch (IOException iOException) {
                searchCompletionObserver.searchFailed(new SearchUnavailableException(1));
            }
            catch (SearchException searchException) {
                searchCompletionObserver.searchFailed(searchException);
            }
        }
    }

    private synchronized void searchIndexesOpen(Map<DemoProductInfo, DemoIndexSearcher> map) {
        this.fAllSearchers = map;
        this.fIsPopulating = false;
        if (this.fPendingSearches != null) {
            for (SearchCriteria searchCriteria : this.fPendingSearches.keySet()) {
                this.doSearch(searchCriteria, this.fPendingSearches.get(searchCriteria));
            }
            this.fPendingSearches.clear();
        }
    }

    private class DemoProductInfo {
        private final String iProductName;
        private final String iProductType;

        private DemoProductInfo(String string, String string2) {
            this.iProductName = string;
            this.iProductType = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DemoProductInfo)) {
                return false;
            }
            DemoProductInfo demoProductInfo = (DemoProductInfo)object;
            if (!demoProductInfo.getProductName().equals(this.iProductName)) {
                return false;
            }
            if (this.iProductType == null || demoProductInfo.getProductType() == null) {
                return this.iProductType == null && demoProductInfo.getProductType() == null;
            }
            return demoProductInfo.getProductType().equals(this.iProductType);
        }

        public int hashCode() {
            if (this.iProductType != null) {
                return this.iProductName.hashCode() + this.iProductType.hashCode();
            }
            return this.iProductName.hashCode();
        }

        private String getProductType() {
            return this.iProductType;
        }

        private String getProductName() {
            return this.iProductName;
        }
    }

    private class FinishPopulateThread
    implements Runnable {
        private List<String> iDemoFiles;

        private FinishPopulateThread(List<String> list) {
            this.iDemoFiles = list;
        }

        @Override
        public void run() {
            HashMap<DemoProductInfo, DemoIndexSearcher> hashMap = new HashMap<DemoProductInfo, DemoIndexSearcher>();
            if (this.iDemoFiles != null) {
                String string;
                String string2;
                File file;
                Iterator<String> iterator = this.iDemoFiles.iterator();
                while (iterator.hasNext() && (file = new File(string2 = DemoInfoUtils.getLocalizedDemoFilename(string = iterator.next()))).exists()) {
                    File file2 = new File(file.getParentFile(), "demosearch");
                    if (!file2.exists()) continue;
                    try {
                        FSDirectory fSDirectory = FSDirectory.getDirectory((File)file2, (boolean)false);
                        if (IndexReader.isLocked((Directory)fSDirectory)) {
                            IndexReader.unlock((Directory)fSDirectory);
                        }
                        DemoIndexSearcher demoIndexSearcher = new DemoIndexSearcher((Directory)fSDirectory, string2);
                        DemoProductInfo demoProductInfo = new DemoProductInfo(demoIndexSearcher.getProductName(), demoIndexSearcher.getProductType());
                        hashMap.put(demoProductInfo, demoIndexSearcher);
                    }
                    catch (IOException iOException) {}
                }
            }
            LuceneDemoSearchEngine.this.searchIndexesOpen(hashMap);
        }
    }
}

