/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

class MWIndexWriter {
    private IndexWriter fUnderlyingWriter;
    private static final String METADATA_FILENAME = "metadata";
    private IndexOutput fMetadataOutput;

    MWIndexWriter(Directory directory, Analyzer analyzer, boolean bl) throws IOException {
        this.fUnderlyingWriter = new IndexWriter(directory, analyzer, bl);
        MWIndexWriter.configureWriter(this.fUnderlyingWriter);
    }

    private static void configureWriter(IndexWriter indexWriter) {
        indexWriter.setUseCompoundFile(true);
        indexWriter.setMaxFieldLength(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addIndex(Directory directory) throws IOException {
        this.fUnderlyingWriter.addIndexes(new Directory[]{directory});
        IndexInput indexInput = directory.openInput(METADATA_FILENAME);
        if (indexInput != null) {
            IndexOutput indexOutput = null;
            try {
                indexOutput = this.fUnderlyingWriter.getDirectory().createOutput(METADATA_FILENAME);
                int n = (int)indexInput.length();
                byte[] byArray = new byte[n];
                indexInput.readBytes(byArray, 0, n);
                indexOutput.writeBytes(byArray, n);
                indexOutput.flush();
            }
            finally {
                if (indexOutput != null) {
                    indexOutput.close();
                }
                indexInput.close();
            }
        }
    }

    synchronized void addMetaData(String string, String string2) throws IOException {
        if (this.fMetadataOutput == null) {
            this.fMetadataOutput = this.fUnderlyingWriter.getDirectory().createOutput(METADATA_FILENAME);
        }
        this.fMetadataOutput.writeString(string + "=" + string2 + "\n");
        this.fMetadataOutput.flush();
    }

    synchronized void optimize() throws IOException {
        this.fUnderlyingWriter.optimize();
    }

    synchronized void addDocument(Document document) throws IOException {
        this.fUnderlyingWriter.addDocument(document);
    }

    public synchronized void close() throws IOException {
        this.fUnderlyingWriter.close();
        if (this.fMetadataOutput != null) {
            this.fMetadataOutput.close();
        }
    }
}

