/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.HTMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CharsetDetectionStrategy {
    public abstract Charset getCharset(String var1);

    public abstract Charset getCharset(File var1);

    public static CharsetDetectionStrategy getDefaultCharsetStrategy() {
        return new DefaultCharsetStrategy();
    }

    public static CharsetDetectionStrategy getAutoDetectStrategy() {
        return CharsetDetectionStrategy.getAutoDetectStrategy(Charset.defaultCharset());
    }

    public static CharsetDetectionStrategy getAutoDetectStrategy(Charset charset) {
        return new AutoDetectCharsetStrategy(charset);
    }

    public static CharsetDetectionStrategy getCharsetStrategy(Charset charset) {
        return new ExplicitCharsetStrategy(charset);
    }

    public static CharsetDetectionStrategy getCharsetStrategy(String string) throws UnsupportedEncodingException {
        return new ExplicitCharsetStrategy(string);
    }

    private static class ExplicitCharsetStrategy
    extends CharsetDetectionStrategy {
        private final Charset fCharset;

        private ExplicitCharsetStrategy(String string) throws UnsupportedEncodingException {
            this(Charset.forName(string));
        }

        private ExplicitCharsetStrategy(Charset charset) {
            this.fCharset = charset;
        }

        @Override
        public Charset getCharset(String string) {
            return this.fCharset;
        }

        @Override
        public Charset getCharset(File file) {
            return this.fCharset;
        }
    }

    private static class AutoDetectCharsetStrategy
    extends CharsetDetectionStrategy {
        private static final Pattern CHARSET_PATTERN = Pattern.compile("<meta[^>]+content=\"text/html;\\s*charset=([^\"]+)");
        private static final Pattern END_HEAD_TAG_PATTERN = Pattern.compile("</head>", 2);
        private final Charset iFallbackCharset;

        private AutoDetectCharsetStrategy(Charset charset) {
            this.iFallbackCharset = charset;
        }

        @Override
        public Charset getCharset(String string) {
            return this.getCharset(HTMLUtils.getInputStreamForUrl(string));
        }

        @Override
        public Charset getCharset(File file) {
            try {
                return this.getCharsetForFile(file);
            }
            catch (IOException iOException) {
                return this.iFallbackCharset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Charset getCharsetForFile(File file) throws IOException {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                Charset charset = this.getCharset(fileInputStream);
                return charset;
            }
            finally {
                fileInputStream.close();
            }
        }

        private Charset getCharset(InputStream inputStream) {
            try {
                Charset charset = AutoDetectCharsetStrategy.autoDetectEncoding(inputStream);
                if (charset != null) {
                    return charset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.iFallbackCharset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Charset autoDetectEncoding(InputStream inputStream) throws IOException, UnsupportedCharsetException {
            if (inputStream == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                StringBuilder stringBuilder = new StringBuilder();
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuilder.append(string);
                    Charset charset = AutoDetectCharsetStrategy.findEncoding(stringBuilder.toString());
                    if (charset != null) {
                        Charset charset2 = charset;
                        return charset2;
                    }
                    if (END_HEAD_TAG_PATTERN.matcher(stringBuilder.toString()).find()) {
                        Charset charset3 = null;
                        return charset3;
                    }
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
            return null;
        }

        private static Charset findEncoding(String string) throws UnsupportedCharsetException {
            Matcher matcher = CHARSET_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                return Charset.forName(string2);
            }
            return null;
        }
    }

    private static class DefaultCharsetStrategy
    extends CharsetDetectionStrategy {
        private DefaultCharsetStrategy() {
        }

        @Override
        public Charset getCharset(String string) {
            return Charset.defaultCharset();
        }

        @Override
        public Charset getCharset(File file) {
            return Charset.defaultCharset();
        }
    }
}

