/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import javax.swing.SwingUtilities;

class HTMLPrinterJob
implements Printable {
    private Viewport fView;
    private String fTitle;
    private StormPrinter fStormPrinter;
    private float printScale = 0.75f;
    private int lastPage = -1;
    private Viewport fMainViewport;
    private ActionListener fPrintingCompletedListener;

    public HTMLPrinterJob(Viewport viewport, String string, Viewport viewport2) {
        this.fView = viewport;
        this.fTitle = string;
        this.fMainViewport = viewport2;
    }

    public void print(ActionListener actionListener) {
        this.fPrintingCompletedListener = actionListener;
        SwingUtilities.invokeLater(new HTMLPrintClass(this.fView, this.fTitle));
    }

    private boolean printThePilot(Pilot pilot, String string, boolean bl) {
        if (pilot == null) {
            return false;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        printerJob.setPrintable(this);
        printerJob.setJobName(string);
        int n = 0;
        this.fStormPrinter = pilot.createPrinter();
        this.fStormPrinter.setPageSize((int)(pageFormat.getImageableWidth() / (double)this.printScale), (int)(pageFormat.getImageableHeight() / (double)this.printScale));
        while (this.fStormPrinter.layoutNextPage()) {
            ++n;
        }
        printerJob.setPageable(new MyPageable(this, pageFormat, n));
        boolean bl2 = false;
        if (!bl || printerJob.printDialog()) {
            try {
                this.fStormPrinter = pilot.createPrinter();
                this.fStormPrinter.setPageSize((int)(pageFormat.getImageableWidth() / (double)this.printScale), (int)(pageFormat.getImageableHeight() / (double)this.printScale));
                this.lastPage = -1;
                printerJob.print();
                bl2 = true;
            }
            catch (Exception exception) {
                System.out.println("Error printing: " + exception);
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.scale(this.printScale, this.printScale);
        while (this.lastPage < n) {
            this.fStormPrinter.layoutNextPage();
            ++this.lastPage;
        }
        if (this.lastPage != n) {
            if (!this.fStormPrinter.layoutNextPage()) {
                this.lastPage = -1;
                return 1;
            }
            this.lastPage = n;
        }
        this.fStormPrinter.printPage(graphics);
        return 0;
    }

    private class MyPageable
    implements Pageable {
        private Printable fPrintable;
        private PageFormat fPageFormat;
        private int fNumPages;

        public MyPageable(Printable printable, PageFormat pageFormat, int n) {
            this.fPrintable = printable;
            this.fPageFormat = pageFormat;
            this.fNumPages = n;
        }

        @Override
        public int getNumberOfPages() {
            return this.fNumPages;
        }

        @Override
        public PageFormat getPageFormat(int n) {
            return this.fPageFormat;
        }

        @Override
        public Printable getPrintable(int n) {
            return this.fPrintable;
        }
    }

    private class HTMLPrintClass
    implements Runnable {
        private Viewport fPrintView;
        private String fPrintTitle;

        private HTMLPrintClass(Viewport viewport, String string) {
            this.fPrintView = viewport;
            this.fPrintTitle = string;
        }

        @Override
        public void run() {
            this.printMethod(this.fPrintView, this.fPrintTitle);
        }

        private void printMethod(Viewport viewport, String string) {
            Enumeration enumeration = viewport.getChildren();
            if (enumeration != null) {
                Viewport viewport2;
                Pilot pilot;
                boolean bl;
                int n = 0;
                while (enumeration.hasMoreElements() && (bl = HTMLPrinterJob.this.printThePilot(pilot = (viewport2 = (Viewport)enumeration.nextElement()).getPilot(), string, n == 0))) {
                    ++n;
                }
            } else {
                Pilot pilot = viewport.getPilot();
                if (pilot == null) {
                    this.printMethod(HTMLPrinterJob.this.fMainViewport, string);
                } else {
                    HTMLPrinterJob.this.printThePilot(pilot, string, true);
                }
            }
            if (HTMLPrinterJob.this.fPrintingCompletedListener != null) {
                HTMLPrinterJob.this.fPrintingCompletedListener.actionPerformed(new ActionEvent(this, 0, "Completed"));
            }
        }
    }
}

