/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class HTMLRendererActions {
    private HTMLRenderer fRenderer;
    public OpenSelectionAction fOpenSelectionAction;
    public HelpSelectionAction fHelpSelectionAction;
    public EvalSelectionAction fEvalSelectionAction;
    public GoBackAction fGoBackAction;
    public GoForwardAction fGoForwardAction;
    public ReloadAction fReloadAction;
    public CopyAction fCopyAction;
    public PrintAction fPrintAction;
    public FindAction fFindAction;
    public ViewSourceAction fViewSourceAction;
    public HomeAction fHomeAction;
    public SaveAsAction fSaveAsAction;
    private List<MJAbstractAction> fAllActions = new ArrayList<MJAbstractAction>();
    static final String HTML_RENDERER_CONTEXT = "HTMLRenderer";

    public HTMLRendererActions(HTMLRenderer hTMLRenderer, boolean bl) {
        this.fRenderer = hTMLRenderer;
        if (Matlab.isMatlabAvailable()) {
            this.fEvalSelectionAction = new EvalSelectionAction();
            this.fOpenSelectionAction = new OpenSelectionAction();
            this.fHelpSelectionAction = new HelpSelectionAction();
        }
        if (bl) {
            this.fGoBackAction = new GoBackAction();
            this.fGoForwardAction = new GoForwardAction();
        }
        this.fReloadAction = new ReloadAction();
        this.fCopyAction = new CopyAction();
        this.fPrintAction = new PrintAction();
        this.fHomeAction = new HomeAction();
        this.fFindAction = new FindAction();
        this.fViewSourceAction = new ViewSourceAction();
        this.fSaveAsAction = new SaveAsAction();
    }

    List<MJAbstractAction> getAllActions() {
        return this.fAllActions;
    }

    class FindAction
    extends MJAbstractAction {
        private FindAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "find-and-replace", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.doFindDialog();
            }
        }

        public void setEnabled(boolean bl) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.setupFindInterface();
            }
            super.setEnabled(bl);
        }
    }

    class ViewSourceAction
    extends MJAbstractAction {
        private ViewSourceAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "view-page-source", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.viewSource();
            }
        }
    }

    class SaveAsAction
    extends MJAbstractAction {
        private SaveAsAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "save-as", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.saveAs();
            }
        }
    }

    class HomeAction
    extends MJAbstractAction {
        private HomeAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "go-home", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.goHome();
            }
        }
    }

    class PrintAction
    extends MJAbstractAction {
        private PrintAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "print", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.doPrint();
            }
        }
    }

    class CopyAction
    extends MJAbstractAction {
        private CopyAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "copy-to-clipboard", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.doCopy();
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }
    }

    class ReloadAction
    extends MJAbstractAction {
        private boolean iProcessAll = true;
        private boolean iProcessed = false;

        private ReloadAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "refresh", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                if (this.iProcessAll || !this.iProcessed) {
                    HTMLRendererActions.this.fRenderer.reload();
                    if (!this.iProcessAll) {
                        this.iProcessed = true;
                    }
                }
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }

        void processOnceUntilReset() {
            this.iProcessAll = false;
        }

        void reset() {
            this.iProcessAll = true;
            this.iProcessed = false;
        }
    }

    class GoForwardAction
    extends MJAbstractAction {
        private GoForwardAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "jump-list-next", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.goForward();
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }
    }

    class GoBackAction
    extends MJAbstractAction {
        private GoBackAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "jump-list-prev", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.goBack();
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }
    }

    class HelpSelectionAction
    extends MJAbstractAction {
        private HelpSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "help-on-selection", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.doHelpOnSelection();
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }
    }

    class OpenSelectionAction
    extends MJAbstractAction {
        private OpenSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "open-selection", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                HTMLRendererActions.this.fRenderer.doOpenSelection();
            }
        }
    }

    class EvalSelectionAction
    extends MJAbstractAction {
        private boolean iProcessAll = true;
        private boolean iProcessed = false;

        private EvalSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HTMLRendererActions.HTML_RENDERER_CONTEXT, "evaluate-selection", (ExtendedAction)this);
            this.setEnabled(false);
            HTMLRendererActions.this.fAllActions.add(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HTMLRendererActions.this.fRenderer != null) {
                if (this.iProcessAll || !this.iProcessed) {
                    HTMLRendererActions.this.fRenderer.doEvalSelection();
                    if (!this.iProcessAll) {
                        this.iProcessed = true;
                    }
                }
                HTMLRendererActions.this.fRenderer.requestFocusInWindow();
            }
        }

        void processOnceUntilReset() {
            this.iProcessAll = false;
        }

        void reset() {
            this.iProcessAll = true;
            this.iProcessed = false;
        }
    }
}

