/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;

public class MatlabHtmlComponentBridge {
    private final HtmlComponent fComponent;
    private final List<HtmlDataReceivedListener> fListeners = new LinkedList<HtmlDataReceivedListener>();

    public MatlabHtmlComponentBridge(HtmlComponent htmlComponent) {
        this.fComponent = htmlComponent;
    }

    public void setCurrentLocation(String string) {
        this.fComponent.setCurrentLocation(string);
    }

    public String getCurrentLocation() {
        return this.fComponent.getCurrentLocation();
    }

    public void setHtmlText(String string) {
        this.fComponent.setHtmlText(string);
    }

    public String getHtmlText() {
        return this.fComponent.getHtmlText();
    }

    public void executeScript(String string) {
        this.fComponent.executeScript(string, (HtmlDataListener)new ScriptListenerAdapter());
    }

    public void addHtmlDataReceivedListener(HtmlDataReceivedListener htmlDataReceivedListener) {
        this.fListeners.add(htmlDataReceivedListener);
    }

    public void removeHtmlDataReceivedListener(HtmlDataReceivedListener htmlDataReceivedListener) {
        this.fListeners.remove(htmlDataReceivedListener);
    }

    public static interface HtmlDataReceivedListener
    extends EventListener {
        public void htmlDataReceived(HtmlDataEvent var1);
    }

    public static class HtmlDataEvent
    extends EventObject {
        private final String fData;

        public HtmlDataEvent(HtmlComponent htmlComponent, String string) {
            super(htmlComponent);
            this.fData = string;
        }

        public String getData() {
            return this.fData;
        }
    }

    private class ScriptListenerAdapter
    implements HtmlDataListener<String> {
        private ScriptListenerAdapter() {
        }

        public void dataRetrieved(String string) {
            HtmlDataEvent htmlDataEvent = new HtmlDataEvent(MatlabHtmlComponentBridge.this.fComponent, string);
            for (HtmlDataReceivedListener htmlDataReceivedListener : MatlabHtmlComponentBridge.this.fListeners) {
                htmlDataReceivedListener.htmlDataReceived(htmlDataEvent);
            }
        }
    }
}

