/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.importtool.HeaderRowExcludeRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.SpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarDouble;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

abstract class AbstractFileTableModel
extends AbstractTableModel {
    protected int ROWBLOCKSIZE = 100;
    protected int COLUMNBLOCKSIZE = 64;
    protected static final int[] NONWINDOWED_SHEETSIZE = new int[]{5000, 100};
    protected static final int MAX_BLOCKS = 10;
    protected volatile int[] fDimensions = new int[]{0, 0};
    protected volatile int[] fStartCell = new int[]{0, 0};
    protected HashMap<Point, SpreadsheetDataSection> fBlockCache;
    protected volatile boolean fTableStructureInitialized = false;
    protected volatile MatlabUpdateRequest fQueuedUpdateRequest;
    protected volatile boolean fMatlabBusy = false;
    protected volatile Point fCurrentMatlabBlock;
    protected SpreadsheetDataSection fTemporaryBlockCache;
    protected volatile boolean fTransitionaryValue = false;
    protected List<WorksheetRule> fRules = new ArrayList<WorksheetRule>();
    protected List<WorksheetCachedDataListener> fWorksheetCachedDataListeners = new Vector<WorksheetCachedDataListener>();
    protected List<Integer> fExcludedRows = new ArrayList<Integer>();
    protected List<Integer> fExcludedColumns = new ArrayList<Integer>();
    protected HashMap<Integer, WorksheetRule> fExcludedRowsRuleMap = new HashMap();
    protected HashMap<Integer, WorksheetRule> fExcludedColumnsRuleMap = new HashMap();
    protected List<int[]> fCachedSelectedRowIntervals = new ArrayList<int[]>();
    protected List<int[]> fCachedSelectedColumnIntervals = new ArrayList<int[]>();
    protected int[] fInitialSelection;
    protected ImportClient.TargetType fTargetType = ImportClient.TargetType.COLUMNVECTORS;

    AbstractFileTableModel() {
    }

    protected abstract List<WorksheetRule> getDefaultWorksheetRuleList();

    abstract Object[] importData(String[] var1, String[] var2, String var3, String[][] var4, int var5) throws Exception;

    protected abstract void rebuild(int var1, int var2);

    abstract Integer getTopHeaderRow();

    abstract void setHeaderRow(int var1);

    boolean areRulesActive(ImportTable importTable) {
        if (this.fRules == null) {
            return false;
        }
        for (WorksheetRule worksheetRule : this.fRules) {
            if (!importTable.isRuleClassAppliedToSelection(worksheetRule.getClass())) continue;
            return true;
        }
        return false;
    }

    boolean areRulesActive(ImportTable importTable, WorksheetRule.RuleType ruleType) {
        if (this.fRules == null) {
            return false;
        }
        for (WorksheetRule worksheetRule : this.fRules) {
            if (worksheetRule.getType() != ruleType || !importTable.isRuleClassAppliedToSelection(worksheetRule.getClass())) continue;
            return true;
        }
        return false;
    }

    void setTargetType(ImportClient.TargetType targetType) {
        this.fTargetType = targetType;
    }

    protected SpreadsheetDataSection getClosestSpreadsheetDataSection(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = null;
        Point point = this.getPointForIndices(n, n2);
        double d = Double.MAX_VALUE;
        for (Point point2 : this.fBlockCache.keySet()) {
            double d2 = point2.distance(point) + (double)this.getColumnCount() * (point2.y - point.y > 0 ? 1.0 : 0.0);
            double d3 = this.getRowCount();
            double d4 = point2.x - point.x > 0 ? 1.0 : 0.0;
            double d5 = d2 + d3 * d4;
            if (!(d5 < d)) continue;
            spreadsheetDataSection = this.fBlockCache.get(point2);
            d = d5;
        }
        return spreadsheetDataSection;
    }

    void setWorksheetRules(List<WorksheetRule> list) {
        this.fRules = list;
        this.fCachedSelectedRowIntervals.clear();
        this.fCachedSelectedColumnIntervals.clear();
        this.fCachedSelectedRowIntervals.clear();
        this.fCachedSelectedColumnIntervals.clear();
    }

    List<WorksheetRule> getWorksheetRules() {
        return this.fRules;
    }

    protected void setInitialSelection(int n, int n2, int n3, int n4) {
        this.fInitialSelection = new int[]{n, n2, n3, n4};
    }

    int[] getInitialSelection() {
        return this.fInitialSelection;
    }

    boolean isTransitionaryValue() {
        return this.fTransitionaryValue;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        this.fTransitionaryValue = false;
        Object object2 = "";
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection == null || spreadsheetDataSection.isRulesDirty()) {
            if (spreadsheetDataSection != null && spreadsheetDataSection.isRulesDirty()) {
                object2 = spreadsheetDataSection.getValueAt(n, n2);
            } else {
                this.fTransitionaryValue = true;
                object = this.getPointForIndices(n, n2);
                if (this.fTemporaryBlockCache == null) {
                    this.fTemporaryBlockCache = this.getClosestSpreadsheetDataSection(n, n2);
                }
                if (this.fTemporaryBlockCache != null) {
                    Point point = new Point(this.fTemporaryBlockCache.getStartRow() / this.ROWBLOCKSIZE, this.fTemporaryBlockCache.getStartColumn() / this.COLUMNBLOCKSIZE);
                    object2 = this.fTemporaryBlockCache.getValueAt(n + this.ROWBLOCKSIZE * (-((Point)object).x + point.x), n2 + this.COLUMNBLOCKSIZE * (-((Point)object).y + point.y));
                    object2 = new TempData(object2);
                }
            }
            if (n < this.getRowCount() && n2 < this.getColumnCount()) {
                this.requestValueFromMatlab(this.getStartOfRowBlock(n) + 1, this.getStartOfColumnBlock(n2) + 1, this.getEndOfRowBlock(n) + 1, this.getEndOfColumnBlock(n2) + 1);
            }
        } else if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            object2 = spreadsheetDataSection.getValueAt(n, n2);
            if (!this.fMatlabBusy) {
                this.fTemporaryBlockCache = null;
            }
        }
        if (object2 instanceof double[] && ((double[])object2).length == 1) {
            object = (double[])object2;
            object2 = ComplexScalarDouble.valueOf((double)object[0]);
        }
        return object2;
    }

    Object getConvertedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            return spreadsheetDataSection.getConvertedValueAt(n, n2);
        }
        return null;
    }

    Object getReplacedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            return spreadsheetDataSection.getReplacedValueAt(n, n2);
        }
        return null;
    }

    abstract Object getParsedValueAt(int var1, int var2);

    Class getRuleClassAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            return spreadsheetDataSection.getRuleClassAt(n, n2);
        }
        return null;
    }

    private static boolean compareIntArrayLists(List<int[]> list, List<int[]> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (Arrays.equals(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void updateExclusions(IntervalSelectionModel intervalSelectionModel, IntervalSelectionModel intervalSelectionModel2) {
        if (AbstractFileTableModel.compareIntArrayLists(this.fCachedSelectedRowIntervals, intervalSelectionModel.getSelectedIntervals()) && AbstractFileTableModel.compareIntArrayLists(this.fCachedSelectedColumnIntervals, intervalSelectionModel2.getSelectedIntervals())) {
            return;
        }
        this.fCachedSelectedRowIntervals = intervalSelectionModel.getSelectedIntervals();
        this.fCachedSelectedColumnIntervals = intervalSelectionModel2.getSelectedIntervals();
        this.fExcludedRows.clear();
        this.fExcludedColumns.clear();
        this.fExcludedRowsRuleMap.clear();
        this.fExcludedColumnsRuleMap.clear();
        for (WorksheetRule worksheetRule : this.fRules) {
            if (!worksheetRule.isRowExcludeType() && !worksheetRule.isColumnExcludeType()) continue;
            if (worksheetRule instanceof HeaderRowExcludeRule) {
                this.fExcludedRows.add(this.getTopHeaderRow());
                this.fExcludedRowsRuleMap.put(this.getTopHeaderRow(), worksheetRule);
                continue;
            }
            for (SpreadsheetDataSection spreadsheetDataSection : this.fBlockCache.values()) {
                if (spreadsheetDataSection.isRulesDirty()) continue;
                for (int i = spreadsheetDataSection.getStartRow(); i <= spreadsheetDataSection.getEndRow(); ++i) {
                    if (!intervalSelectionModel.isSelectedIndex(i)) continue;
                    for (int j = spreadsheetDataSection.getStartColumn(); j <= spreadsheetDataSection.getEndColumn(); ++j) {
                        int n;
                        if (!intervalSelectionModel2.isSelectedIndex(j)) continue;
                        if (worksheetRule.isRowExcludeType()) {
                            n = Collections.binarySearch(this.fExcludedRows, i);
                            if (n >= 0 || Collections.binarySearch(this.fExcludedColumns, j) >= 0 || !spreadsheetDataSection.getRowExcludedRuleAt(i, j)) continue;
                            this.fExcludedRows.add(-1 - n, i);
                            if (this.fExcludedRowsRuleMap.containsKey(i)) continue;
                            this.fExcludedRowsRuleMap.put(i, worksheetRule);
                            continue;
                        }
                        if (!worksheetRule.isColumnExcludeType() || Collections.binarySearch(this.fExcludedColumns, j) >= 0) continue;
                        n = Collections.binarySearch(this.fExcludedColumns, j);
                        if (!intervalSelectionModel.isSelectedIndex(i) || Collections.binarySearch(this.fExcludedRows, i) >= 0 || !spreadsheetDataSection.getColumnExcludedRuleAt(i, j)) continue;
                        this.fExcludedColumns.add(-1 - n, j);
                        if (this.fExcludedColumnsRuleMap.containsKey(j)) continue;
                        this.fExcludedColumnsRuleMap.put(j, worksheetRule);
                    }
                }
            }
        }
    }

    int getExcludedRowCount(IntervalSelectionModel intervalSelectionModel, IntervalSelectionModel intervalSelectionModel2) {
        if (!this.isSelectionInCachedArray(intervalSelectionModel, intervalSelectionModel2)) {
            return -1;
        }
        this.updateExclusions(intervalSelectionModel, intervalSelectionModel2);
        return this.fExcludedRows.size();
    }

    int getExcludedColumnCount(IntervalSelectionModel intervalSelectionModel, IntervalSelectionModel intervalSelectionModel2) {
        if (!this.isSelectionInCachedArray(intervalSelectionModel, intervalSelectionModel2)) {
            return -1;
        }
        this.updateExclusions(intervalSelectionModel, intervalSelectionModel2);
        return this.fExcludedColumns.size();
    }

    ExcludedState isRowExcluded(int n, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
        boolean bl = false;
        for (WorksheetRule object : this.fRules) {
            if (!object.isRowExcludeType()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return ExcludedState.INCLUDED;
        }
        if (listSelectionModel2.getMaxSelectionIndex() - listSelectionModel2.getMinSelectionIndex() > this.COLUMNBLOCKSIZE) {
            return ExcludedState.UNKNOWN;
        }
        this.updateExclusions((IntervalSelectionModel)listSelectionModel, (IntervalSelectionModel)listSelectionModel2);
        if (Collections.binarySearch(this.fExcludedRows, n) >= 0) {
            return ExcludedState.EXCLUDED;
        }
        for (SpreadsheetDataSection spreadsheetDataSection : this.fBlockCache.values()) {
            if (spreadsheetDataSection.isRulesDirty() || spreadsheetDataSection.getStartRow() > n || spreadsheetDataSection.getEndRow() < n) continue;
            return ExcludedState.INCLUDED;
        }
        return ExcludedState.UNKNOWN;
    }

    WorksheetRule getRowExclusionRule(int n) {
        if (this.fExcludedRowsRuleMap.containsKey(n)) {
            return this.fExcludedRowsRuleMap.get(n);
        }
        return null;
    }

    WorksheetRule getColumnExclusionRule(int n) {
        if (this.fExcludedColumnsRuleMap.containsKey(n)) {
            return this.fExcludedColumnsRuleMap.get(n);
        }
        return null;
    }

    protected boolean isColumnExcludeRules() {
        for (WorksheetRule worksheetRule : this.fRules) {
            if (!worksheetRule.isColumnExcludeType()) continue;
            return true;
        }
        return false;
    }

    boolean allowColumnExcludeRuleEvaluation(ListSelectionModel listSelectionModel) {
        return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() <= this.ROWBLOCKSIZE;
    }

    ExcludedState isColumnExcluded(int n, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
        if (!this.isColumnExcludeRules()) {
            return ExcludedState.INCLUDED;
        }
        if (!this.allowColumnExcludeRuleEvaluation(listSelectionModel)) {
            return ExcludedState.UNKNOWN;
        }
        this.updateExclusions((IntervalSelectionModel)listSelectionModel, (IntervalSelectionModel)listSelectionModel2);
        if (Collections.binarySearch(this.fExcludedColumns, n) >= 0) {
            return ExcludedState.EXCLUDED;
        }
        for (SpreadsheetDataSection spreadsheetDataSection : this.fBlockCache.values()) {
            if (spreadsheetDataSection.isRulesDirty() || spreadsheetDataSection.getStartColumn() > n || spreadsheetDataSection.getEndColumn() < n) continue;
            return ExcludedState.INCLUDED;
        }
        return ExcludedState.UNKNOWN;
    }

    void reset() {
        SpreadsheetDataSection spreadsheetDataSection2;
        for (SpreadsheetDataSection spreadsheetDataSection2 : this.fBlockCache.values()) {
            spreadsheetDataSection2.setRulesDirty(true);
        }
        Point point = this.fCurrentMatlabBlock;
        spreadsheetDataSection2 = null;
        if (point != null) {
            spreadsheetDataSection2 = this.fBlockCache.get(point);
        }
        this.fCurrentMatlabBlock = null;
        if (Matlab.isMatlabAvailable()) {
            if (spreadsheetDataSection2 != null) {
                this.requestValueFromMatlab(spreadsheetDataSection2.getStartRow() + 1, spreadsheetDataSection2.getStartColumn() + 1, spreadsheetDataSection2.getEndRow() + 1, spreadsheetDataSection2.getEndColumn() + 1);
            } else {
                this.requestValueFromMatlab(this.getStartOfRowBlock(0) + 1, this.getStartOfColumnBlock(0) + 1, this.getEndOfRowBlock(0) + 1, this.getEndOfColumnBlock(0) + 1);
            }
        }
    }

    protected abstract void requestValueFromMatlab(int var1, int var2, int var3, int var4);

    protected synchronized void setQueuedItem(MatlabUpdateRequest matlabUpdateRequest) {
        this.fQueuedUpdateRequest = matlabUpdateRequest;
    }

    private synchronized MatlabUpdateRequest getQueuedUpdateRequest() {
        return this.fQueuedUpdateRequest;
    }

    protected abstract void makeCallToMatlab(MatlabUpdateRequest var1);

    protected Point getPointForIndices(int n, int n2) {
        return new Point(n / this.ROWBLOCKSIZE, n2 / this.COLUMNBLOCKSIZE);
    }

    private int getStartOfRowBlock(int n) {
        return n / this.ROWBLOCKSIZE * this.ROWBLOCKSIZE;
    }

    private int getEndOfRowBlock(int n) {
        return this.getStartOfRowBlock(n + this.ROWBLOCKSIZE) - 1;
    }

    private int getStartOfColumnBlock(int n) {
        return n / this.COLUMNBLOCKSIZE * this.COLUMNBLOCKSIZE;
    }

    private int getEndOfColumnBlock(int n) {
        return this.getStartOfColumnBlock(n + this.COLUMNBLOCKSIZE) - 1;
    }

    protected SpreadsheetDataSection getValueDataSection(int n, int n2) {
        Point point = this.getPointForIndices(n, n2);
        if (this.fBlockCache.containsKey(point)) {
            return this.fBlockCache.get(point);
        }
        return null;
    }

    void addWorksheetCachedDataListener(WorksheetCachedDataListener worksheetCachedDataListener) {
        if (!this.fWorksheetCachedDataListeners.contains(worksheetCachedDataListener)) {
            this.fWorksheetCachedDataListeners.add(worksheetCachedDataListener);
        }
    }

    void removeWorksheetCachedDataListener(WorksheetCachedDataListener worksheetCachedDataListener) {
        this.fWorksheetCachedDataListeners.remove(worksheetCachedDataListener);
    }

    void fireWorksheetCachedDataListeners(EventObject eventObject) {
        if (this.fWorksheetCachedDataListeners.isEmpty()) {
            return;
        }
        for (WorksheetCachedDataListener worksheetCachedDataListener : this.fWorksheetCachedDataListeners.toArray(new WorksheetCachedDataListener[1])) {
            worksheetCachedDataListener.worksheetCachedDataChanged(eventObject);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.fDimensions[1];
    }

    @Override
    public String getColumnName(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    public int getRowCount() {
        return this.fDimensions[0];
    }

    protected void setSheetDimensions(int n, int n2, int n3, int n4) {
        this.fDimensions[0] = n;
        this.fDimensions[1] = n2;
        this.fStartCell[0] = n3;
        this.fStartCell[1] = n4;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    boolean isUntreatedAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null && !spreadsheetDataSection.isRulesDirty()) {
            return spreadsheetDataSection.isUntreatedAt(n, n2);
        }
        return false;
    }

    boolean containsUntreatedCells(IntervalSelectionModel intervalSelectionModel, IntervalSelectionModel intervalSelectionModel2) {
        List<int[]> list = intervalSelectionModel.getSelectedIntervals();
        List<int[]> list2 = intervalSelectionModel2.getSelectedIntervals();
        for (int[] nArray : list) {
            for (int[] nArray2 : list2) {
                for (SpreadsheetDataSection spreadsheetDataSection : this.fBlockCache.values()) {
                    int n;
                    Rectangle rectangle = new Rectangle(nArray[0], nArray2[0], nArray[1] - nArray[0] + 1, nArray2[1] - nArray2[0] + 1);
                    Rectangle rectangle2 = new Rectangle(spreadsheetDataSection.getStartRow(), spreadsheetDataSection.getStartColumn(), spreadsheetDataSection.getEndRow() - spreadsheetDataSection.getStartRow() + 1, spreadsheetDataSection.getEndColumn() - spreadsheetDataSection.getStartColumn() + 1);
                    Rectangle rectangle3 = rectangle2.intersection(rectangle);
                    if (rectangle3 == null) continue;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (n = (int)rectangle3.getMinY(); n < (int)rectangle3.getMaxY(); ++n) {
                        if (this.isColumnExcluded(n, intervalSelectionModel, intervalSelectionModel2) != ExcludedState.INCLUDED) continue;
                        arrayList.add(n);
                    }
                    for (n = (int)rectangle3.getMinX(); n < (int)rectangle3.getMaxX(); ++n) {
                        if (this.isRowExcluded(n, intervalSelectionModel, intervalSelectionModel2) != ExcludedState.INCLUDED) continue;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            int n2 = (Integer)iterator.next();
                            if (!this.isUntreatedAt(n, n2)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    boolean isSelectionInCachedArray(IntervalSelectionModel intervalSelectionModel, IntervalSelectionModel intervalSelectionModel2) {
        List<int[]> list = intervalSelectionModel.getSelectedIntervals();
        List<int[]> list2 = intervalSelectionModel2.getSelectedIntervals();
        for (int[] nArray : list) {
            for (int[] nArray2 : list2) {
                int n = 0;
                for (SpreadsheetDataSection spreadsheetDataSection : this.fBlockCache.values()) {
                    n += spreadsheetDataSection.getInterectingCellCount(nArray[0], nArray2[0], nArray[1] - nArray[0] + 1, nArray2[1] - nArray2[0] + 1);
                }
                if (n >= (nArray[1] - nArray[0] + 1) * (nArray2[1] - nArray2[0] + 1)) continue;
                return false;
            }
        }
        return true;
    }

    protected void updateBlockCache(SpreadsheetDataSection spreadsheetDataSection) {
        int n = spreadsheetDataSection.getStartRow();
        int n2 = spreadsheetDataSection.getStartColumn();
        this.fBlockCache.put(this.getPointForIndices(n, n2), spreadsheetDataSection);
    }

    void matlabCallback(SpreadsheetDataSection spreadsheetDataSection) {
        assert (SwingUtilities.isEventDispatchThread());
        if (spreadsheetDataSection != null) {
            this.updateBlockCache(spreadsheetDataSection);
        }
        if (!this.fTableStructureInitialized) {
            this.fireTableStructureChanged();
            if (this.fQueuedUpdateRequest == null) {
                this.fTableStructureInitialized = true;
            }
        }
        this.fCachedSelectedRowIntervals.clear();
        this.fCachedSelectedColumnIntervals.clear();
        this.fireWorksheetCachedDataListeners(new EventObject(this));
        MatlabUpdateRequest matlabUpdateRequest = this.getQueuedUpdateRequest();
        if (matlabUpdateRequest != null) {
            this.fMatlabBusy = true;
            this.setQueuedItem(null);
            Matlab.whenMatlabReady((Runnable)new MatlabRunnable(this, matlabUpdateRequest));
        } else {
            this.fMatlabBusy = false;
        }
    }

    protected static Pair<Class[], Object[]> getRuleResults(Object[] objectArray, double[] dArray, List<WorksheetRule> list, int n, List<Integer> list2) {
        Class[] classArray = new Class[objectArray.length];
        Object[] objectArray2 = new Object[objectArray.length];
        for (WorksheetRule worksheetRule : list) {
            try {
                boolean[] blArray;
                if (worksheetRule.getType() == WorksheetRule.RuleType.COLUMNEXCLUDE || worksheetRule.getType() == WorksheetRule.RuleType.ROWEXCLUDE) {
                    blArray = (boolean[])Matlab.mtFeval((String)"feval", (Object[])new Object[]{worksheetRule.getApplyFcn(), worksheetRule, dArray, objectArray}, (int)1);
                    for (int i = 0; i < blArray.length; ++i) {
                        if (list2.contains(i / n)) {
                            blArray[i] = false;
                            continue;
                        }
                        if (classArray[i] != null || !blArray[i]) continue;
                        classArray[i] = worksheetRule.getClass();
                    }
                    continue;
                }
                Object[] objectArray3 = (Object[])Matlab.mtFeval((String)"feval", (Object[])new Object[]{worksheetRule.getApplyFcn(), worksheetRule, dArray, objectArray}, (int)2);
                if (!(objectArray3[0] instanceof double[])) continue;
                double[] dArray2 = (double[])objectArray3[0];
                if (!(objectArray3[1] instanceof boolean[])) continue;
                blArray = (boolean[])objectArray3[1];
                for (int i = 0; i < blArray.length; ++i) {
                    if (list2.contains(i / n)) {
                        blArray[i] = false;
                        continue;
                    }
                    if (classArray[i] != null || !blArray[i]) continue;
                    classArray[i] = worksheetRule.getClass();
                    objectArray2[i] = dArray2[i];
                }
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
        }
        return new Pair((Object)classArray, (Object)objectArray2);
    }

    protected abstract String[] getDefaultColumnVarNames(int var1);

    protected static abstract class MatlabUpdateRequest {
        protected int iStartRow = -1;
        protected int iEndRow = -1;
        protected int iStartCol = -1;
        protected int iEndCol = -1;
        protected List<WorksheetRule> iRules = new ArrayList<WorksheetRule>();

        protected MatlabUpdateRequest() {
        }

        protected abstract SpreadsheetDataSection mtFeval();
    }

    static interface WorksheetCachedDataListener {
        public void worksheetCachedDataChanged(EventObject var1);
    }

    static class TempData {
        Object iData;

        TempData(Object object) {
            if (object instanceof double[] && ((double[])object).length == 1) {
                double[] dArray = (double[])object;
                this.iData = ComplexScalarDouble.valueOf((double)dArray[0]);
            } else {
                this.iData = object;
            }
        }

        Object getData() {
            return this.iData;
        }

        public String toString() {
            if (this.iData != null) {
                return this.iData.toString();
            }
            return "";
        }
    }

    private static class MatlabRunnable
    implements Runnable {
        private MatlabUpdateRequest iQueuedUpdateRequest;
        private AbstractFileTableModel iReqester;

        MatlabRunnable(AbstractFileTableModel abstractFileTableModel, MatlabUpdateRequest matlabUpdateRequest) {
            this.iReqester = abstractFileTableModel;
            this.iQueuedUpdateRequest = matlabUpdateRequest;
        }

        @Override
        public void run() {
            try {
                final SpreadsheetDataSection spreadsheetDataSection = this.iQueuedUpdateRequest.mtFeval();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MatlabRunnable.this.iReqester.matlabCallback(spreadsheetDataSection);
                    }
                });
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
        }
    }

    static enum ExcludedState {
        EXCLUDED,
        INCLUDED,
        UNKNOWN;

    }
}

