/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;

class FloatingComponentLayout
implements LayoutManager {
    private HashMap<Component, Point> fFloatingPanels = new HashMap();
    private Insets fInsets;
    public static String FLOATING = "floating";

    FloatingComponentLayout() {
    }

    void setInsets(Insets insets) {
        this.fInsets = insets;
    }

    public void setFloatingComponentAt(Component component, Point point) {
        this.fFloatingPanels.put(component, point);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (FLOATING.equals(string)) {
            Rectangle rectangle = component.getBounds();
            this.setFloatingComponentAt(component, new Point(rectangle.x, rectangle.y));
        }
    }

    @Override
    public void layoutContainer(Container container) {
        int n = 0;
        for (Component component : container.getComponents()) {
            Cloneable cloneable;
            if (!this.fFloatingPanels.containsKey(component)) {
                cloneable = container.getBounds();
                component.setBounds(0, 0, cloneable.width, cloneable.height);
                container.setComponentZOrder(component, this.fFloatingPanels.size());
                continue;
            }
            cloneable = this.fFloatingPanels.get(component);
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component.getMaximumSize();
            if (dimension2 != null && dimension2.width < dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2 != null && dimension2.height < dimension.height) {
                dimension.height = dimension2.height;
            }
            if (this.fInsets != null) {
                Rectangle rectangle = new Rectangle(((Point)cloneable).x, ((Point)cloneable).y, dimension.width, dimension.height);
                Rectangle rectangle2 = container.getBounds();
                rectangle2.x = this.fInsets.left;
                rectangle2.y = this.fInsets.top;
                rectangle2.width = rectangle2.width - this.fInsets.left - this.fInsets.right;
                rectangle2.height = rectangle2.height - this.fInsets.top - this.fInsets.bottom;
                component.setBounds(rectangle.intersection(new Rectangle(rectangle2)));
            } else {
                component.setBounds(new Rectangle(((Point)cloneable).x, ((Point)cloneable).y, dimension.width, dimension.height));
            }
            container.setComponentZOrder(component, n);
            ++n;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            n = n < component.getMinimumSize().height ? component.getMinimumSize().height : n;
            n2 = n2 < component.getMinimumSize().width ? component.getMinimumSize().width : n2;
        }
        return new Dimension(n2, n);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            n = n < component.getPreferredSize().height ? component.getPreferredSize().height : n;
            n2 = n2 < component.getPreferredSize().width ? component.getPreferredSize().width : n2;
        }
        return new Dimension(n2, n);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.fFloatingPanels.remove(component);
    }

    public void clearChildrenOpacity(JComponent jComponent) {
        jComponent.setOpaque(false);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent) || this.fFloatingPanels.containsKey(component)) continue;
            this.clearChildrenOpacity((JComponent)component);
        }
    }
}

