/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportCodeFactory;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NumericParsingRule;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.TextImportUIState;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.ArrayList;
import java.util.List;

public class TextCodeFactory
extends ImportCodeFactory {
    private TextCodeFactory() {
    }

    public static void generateScript(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        TextCodeFactory.generateCode(generatedCode, textImportUIState, CodeType.SCRIPT, null);
    }

    public static void generateFunction(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        TextCodeFactory.generateCode(generatedCode, textImportUIState, CodeType.FUNCTION, string);
    }

    private static void generateCode(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType, String string) {
        if (codeType == CodeType.SCRIPT) {
            TextCodeFactory.generateMatlabScriptCommentHeader(generatedCode, textImportUIState.getFile().getPath());
        } else {
            TextCodeFactory.generateFunctionHeader(generatedCode, textImportUIState, string);
        }
        TextCodeFactory.generateMatlabVariableInitialization(generatedCode, textImportUIState, codeType);
        TextCodeFactory.generateCodeBody(generatedCode, textImportUIState, codeType);
        TextCodeFactory.splitNumericCellColumns(generatedCode, textImportUIState);
        if (!textImportUIState.useFastPath()) {
            TextCodeFactory.generateRulePostProcess(generatedCode, textImportUIState, codeType);
        }
        if (codeType == CodeType.SCRIPT) {
            TextCodeFactory.generateScriptOutputAllocation(generatedCode, textImportUIState);
        } else {
            TextCodeFactory.generateFunctionOutputAllocation(generatedCode, textImportUIState);
        }
        if (codeType == CodeType.SCRIPT && generatedCode.hasVariablesToClear()) {
            generatedCode.addCode("%% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.clearvars"));
            generatedCode.addCode("\n");
            generatedCode.addClearCode();
        }
    }

    public static void generateMatlabScriptCommentHeader(GeneratedCode generatedCode, String string) {
        generatedCode.addCode("%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.scriptcellheader"));
        generatedCode.addCode("\n");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.scriptheading"));
        generatedCode.addCode("\n%\n%    ");
        generatedCode.addCode(string);
        generatedCode.addCode("\n%\n% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.extendcommentline"));
        generatedCode.addCode("\n");
        generatedCode.addCode(TextCodeFactory.getTimeStampComment());
        generatedCode.addCode("\n");
    }

    public static void generateMatlabVariableInitialization(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        List<int[]> list = textImportUIState.getSelectedRowIntervals();
        int[] nArray = textImportUIState.getDimensions();
        int n = nArray[0];
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.initVars")));
        if (codeType == CodeType.SCRIPT) {
            generatedCode.addCode(String.format("filename = '%s';%n", textImportUIState.getFile().getPath()));
            generatedCode.addNewVariableName("filename");
        }
        if (!textImportUIState.isFixedWidth()) {
            generatedCode.addCode(String.format("delimiter = %s;%n", TextCodeFactory.getDelimiterString(textImportUIState.getDelimiters())));
            generatedCode.addNewVariableName("delimiter");
        }
        if (codeType == CodeType.FUNCTION) {
            generatedCode.addCode("if nargin<=2\n");
        }
        if (list.size() == 1 && (codeType == CodeType.FUNCTION || list.get(0)[0] > 0)) {
            generatedCode.addCode(String.format("startRow = %d;%n", list.get(0)[0] + 1));
            generatedCode.addNewVariableName("startRow");
        } else if (list.size() > 1) {
            generatedCode.addCode(String.format("startRow = %s;%n", TextCodeFactory.getStartRowString(list)));
            generatedCode.addNewVariableName("startRow");
        }
        if (list.size() == 1 && (codeType == CodeType.FUNCTION || list.get(0)[1] < n - 1)) {
            if (list.get(0)[1] >= n - 1) {
                generatedCode.addCode("endRow = inf;\n");
            } else {
                generatedCode.addCode(String.format("endRow = %s;%n", Integer.toString(list.get(0)[1] + 1)));
            }
            generatedCode.addNewVariableName("endRow");
        } else if (list.size() > 1) {
            generatedCode.addCode(String.format("endRow = %s;%n", TextCodeFactory.getStartRowString(list)));
            generatedCode.addNewVariableName("endRow");
        }
        if (codeType == CodeType.FUNCTION) {
            generatedCode.addCode("end\n");
        }
        generatedCode.addCode(String.format("%n", new Object[0]));
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatComment")));
            int[] nArray2 = textImportUIState.getSelectedColumns();
            for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
                String string;
                String string2 = string = i % 2 == 0 ? "   " : "\t";
                if (textImportUIState.getSelectedColumnParseRules().get(i) instanceof NumericParsingRule) {
                    generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%5$s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.double"), textImportUIState.getSelectedColumnParseRules().get(i).getTextscanFormat()));
                    continue;
                }
                if (textImportUIState.getSelectedColumnParseRules().get(i) instanceof DateParsingRule) {
                    generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%5$s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.datestrings"), textImportUIState.getSelectedColumnParseRules().get(i).getTextscanFormat()));
                    continue;
                }
                generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%%s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.text")));
            }
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanDocComment")));
        } else {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatStringComment")));
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanDocComment")));
        }
        generatedCode.addCode(String.format("formatSpec = '%s';%n%n", textImportUIState.getTextscanFormat()));
        generatedCode.addNewVariableName("formatSpec");
    }

    static void generateFunctionHeader(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        String string2 = TextCodeFactory.getStartRowString(textImportUIState.getSelectedRowIntervals());
        String string3 = TextCodeFactory.getEndRowString(textImportUIState.getSelectedRowIntervals());
        generatedCode.addNewVariableName("filename");
        generatedCode.addNewVariableName("startRows");
        generatedCode.addNewVariableName("endRows");
        String string4 = "";
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string5 = "";
        if (textImportUIState.isColumnVectors()) {
            String[] stringArray = textImportUIState.getSelectedColumnNames();
            string5 = TextCodeFactory.stringArrayToOutputArray(stringArray);
            stringBuilder.append(String.format("%1$s = %2$s(filename, startRow, endRow)%n", string5, string));
            stringBuilder2.append(String.format("%1$s = %2$s('", string5, string));
            generatedCode.addCode(String.format("function %s", stringBuilder.toString()));
            stringBuilder2.append(textImportUIState.getFile().getName());
            stringBuilder2.append(String.format("',%1$s, %2$s);%n", string2, string3));
            string4 = ImportToolUtils.getResourceString("textCodeGen.h1columnvectors");
        } else if (textImportUIState.isMatrix() || textImportUIState.isCellArray() || textImportUIState.isDataset()) {
            string5 = textImportUIState.getGlobalVariableName();
            generatedCode.addOutputVariableName(string5);
            stringBuilder.append(String.format("%1$s = %2$s(filename, startRow, endRow)%n", string5, string));
            stringBuilder2.append(String.format("%1$s = %2$s('", string5, string));
            generatedCode.addCode(String.format("function %s", stringBuilder.toString()));
            stringBuilder2.append(textImportUIState.getFile().getName());
            stringBuilder2.append(String.format("', %1$s, %2$s);%n", string2, string3));
            string4 = ImportToolUtils.getResourceString("textCodeGen.h1matrix");
        }
        generatedCode.addCode("%");
        generatedCode.addCode(string.toUpperCase());
        generatedCode.addCode(" ");
        generatedCode.addCode(string4);
        generatedCode.addCode("\n");
        generatedCode.addCode(String.format("%%   %1$s = %2$s(FILENAME)%n", string5.toUpperCase(), string.toUpperCase()));
        generatedCode.addCode(String.format("%%   %s%n", ImportToolUtils.getResourceString("textCodeGen.fcnhelpdefaultselection")));
        generatedCode.addCode("%\n");
        generatedCode.addCode(String.format("%%   %s", stringBuilder.toString().toUpperCase()));
        generatedCode.addCode(String.format("%%   %s%n", ImportToolUtils.getResourceString("textCodeGen.fcnhelp")));
        generatedCode.addCode("%\n");
        generatedCode.addCode(String.format("%% Example:%n%%   ", new Object[0]));
        generatedCode.addCode(stringBuilder2.toString());
        generatedCode.addCode(String.format("%%%n%%    %s%n", ImportToolUtils.getResourceString("textCodeGen.seealso")));
        generatedCode.addCode(TextCodeFactory.getTimeStampComment());
        generatedCode.addCode("\n");
    }

    public static void generateCodeBody(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        boolean bl;
        Double d;
        List<int[]> list = textImportUIState.getSelectedRowIntervals();
        int[] nArray = textImportUIState.getDimensions();
        int n = nArray[0];
        boolean bl2 = textImportUIState.useFastPath();
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.openComment")));
        generatedCode.addCode(String.format("fileID = fopen(filename,'r');%n%n", new Object[0]));
        generatedCode.addNewVariableName("fileID");
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatReadComment")));
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanreuse")));
        String string = textImportUIState.isFixedWidth() ? "'Delimiter', '', 'WhiteSpace', '', " : (textImportUIState.isMultipleDelimsAsOne() ? "'Delimiter', delimiter, 'MultipleDelimsAsOne', true, " : "'Delimiter', delimiter, ");
        if (bl2 && (d = WorksheetReplacementRule.getSingleReplacementValueFromRules(textImportUIState.getActiveRules())) != null) {
            string = string + "'EmptyValue' ," + Double.toString(d) + ",";
        }
        boolean bl3 = bl = textImportUIState.getEmptyRowCount() > 0;
        if (codeType == CodeType.SCRIPT && list.size() == 1) {
            if (list.get(0)[0] == 0 && list.get(0)[1] == n - 1) {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s 'ReturnOnError', false);%n%n", string));
            } else if (list.get(0)[1] == n - 1) {
                if (bl) {
                    generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow-1, 'ReturnOnError', false);\n");
                    generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s'ReturnOnError', false);%n%n", string));
                } else {
                    generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s'HeaderLines' ,startRow-1, 'ReturnOnError', false);%n%n", string));
                }
            } else if (list.get(0)[0] == 0) {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow, %1$s'ReturnOnError', false);%n%n", string));
            } else if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow-startRow+1, %1$s'ReturnOnError', false);%n%n", string));
            } else {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow-startRow+1, %1$s'HeaderLines', startRow-1, 'ReturnOnError', false);%n%n", string));
            }
        } else {
            if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow(1)-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, %1$s'ReturnOnError', false);%n", string));
            } else {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, %1$s'HeaderLines', startRow(1)-1, 'ReturnOnError', false);%n", string));
            }
            generatedCode.addCode(String.format("for block=2:length(startRow)%n", new Object[0]));
            generatedCode.addNewVariableName("block");
            generatedCode.addCode("frewind(fileID);\n");
            if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow(block)-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, %1$s'ReturnOnError', false);%n", string));
            } else {
                generatedCode.addCode(String.format("dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, %1$s'HeaderLines', startRow(block)-1, 'ReturnOnError', false);%n", string));
            }
            generatedCode.addNewVariableName("dataArrayBlock");
            if (textImportUIState.getSelectedColumns().length > 1) {
                generatedCode.addCode(String.format("for col=1:length(dataArray)%n", new Object[0]));
                generatedCode.addNewVariableName("col");
                generatedCode.addCode(String.format("dataArray{col} = [dataArray{col};dataArrayBlock{col}];%nend%nend%n", new Object[0]));
            } else {
                generatedCode.addCode(String.format("dataArray{1} = [dataArray{1};dataArrayBlock{1}];%nend%n", new Object[0]));
            }
            generatedCode.addCode(String.format("%n", new Object[0]));
        }
        generatedCode.addNewVariableName("dataArray");
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.closeComment")));
        generatedCode.addNewVariableName("ans");
        generatedCode.addCode(String.format("fclose(fileID);%n%n", new Object[0]));
        if (bl2) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.norules")));
            generatedCode.addCode(String.format("%% %s%n%n", ImportToolUtils.getResourceString("textCodeGen.norulesmsg")));
            TextCodeFactory.generatFastPathPostProcessing(generatedCode, textImportUIState);
        } else {
            TextCodeFactory.generatSlowPathPostProcessing(generatedCode, textImportUIState);
        }
    }

    private static void generateRulePostProcess(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        if (!TextCodeFactory.getCellColumns(textImportUIState).isEmpty()) {
            generatedCode.setRawCellArray("rawNumericColumns");
        }
        for (WorksheetRule worksheetRule : textImportUIState.getActiveRules()) {
            worksheetRule.generateMatlabCode(textImportUIState.getActiveRules(), generatedCode);
            if (!worksheetRule.isRowExcludeType() || TextCodeFactory.getCellColumns(textImportUIState).isEmpty()) continue;
            generatedCode.addCode(String.format("rawCellColumns(%s,:) = [];%n", generatedCode.getRowExclusionIndex()));
        }
        generatedCode.addCode("\n");
    }

    private static void generatSlowPathPostProcessing(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertNumericColumns")));
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.replaceWithNaN")));
        List<ParseRule> list = textImportUIState.getSelectedColumnParseRules();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof NumericParsingRule) {
                arrayList.add(i);
                continue;
            }
            if (!(list.get(i) instanceof DateParsingRule)) continue;
            arrayList2.add(i);
            arrayList3.add(((DateParsingRule)list.get(i)).getFormat());
        }
        if (!arrayList.isEmpty()) {
            generatedCode.addNewVariableName("raw");
            if (textImportUIState.isFixedWidth()) {
                generatedCode.addNewVariableName("col");
                generatedCode.addCode("raw = repmat({''},length(dataArray{1}),length(dataArray));\n");
                generatedCode.addCode("for col=1:length(dataArray)-1\n");
                generatedCode.addCode("raw(1:length(dataArray{col}),col) = dataArray{col};\nend\n");
            } else {
                generatedCode.addCode("raw = [dataArray{:,1:end-1}];\n");
            }
        }
        generatedCode.addNewVariableName("numericData");
        generatedCode.addCode("numericData = NaN(size(dataArray{1},1),size(dataArray,2));\n\n");
        if (!arrayList.isEmpty()) {
            if (arrayList.size() >= 2) {
                generatedCode.addNewVariableName("col");
                generatedCode.addCode("for col=");
                generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(arrayList, 1));
                generatedCode.addCode("\n");
                TextCodeFactory.generateNumericParse(generatedCode, textImportUIState, "col");
                generatedCode.addCode("end\n");
            } else {
                TextCodeFactory.generateNumericParse(generatedCode, textImportUIState, Integer.toString((Integer)arrayList.get(0) + 1));
            }
            generatedCode.addCode("\n");
        }
        if (!arrayList2.isEmpty()) {
            if (arrayList2.size() >= 2) {
                String string = (String)arrayList3.get(0);
                String string2 = "{" + (String)arrayList3.get(0) + ", ";
                boolean bl = true;
                for (int i = 1; i < arrayList3.size(); ++i) {
                    string2 = string2 + ", " + (String)arrayList3.get(i);
                    if (string.equals(arrayList3.get(i))) continue;
                    bl = false;
                }
                string2 = string2 + "}";
                if (!bl) {
                    generatedCode.addNewVariableName("dateFormats");
                    generatedCode.addCode("dateFormats = " + string2 + ";\n");
                    string = "dateFormats{col}";
                }
                generatedCode.addNewVariableName("col");
                generatedCode.addCode("for col=");
                generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(arrayList2, 1));
                TextCodeFactory.generateDateParse(generatedCode, "col", string);
                generatedCode.addCode("end\n");
            } else {
                TextCodeFactory.generateDateParse(generatedCode, Integer.toString((Integer)arrayList2.get(0) + 1), "'" + (String)arrayList3.get(0) + "'");
            }
            generatedCode.addCode("\n");
        }
    }

    private static List<Integer> getNumericColumns(TextImportUIState textImportUIState) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
            if (textImportUIState.getSelectedColumnParseRules().get(i) == null) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static List<Integer> getCellColumns(TextImportUIState textImportUIState) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
            if (textImportUIState.getSelectedColumnParseRules().get(i) != null) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static void splitNumericCellColumns(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        if (textImportUIState.useFastPath()) {
            return;
        }
        List<Integer> list = TextCodeFactory.getCellColumns(textImportUIState);
        if (list.isEmpty()) {
            return;
        }
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.numericCellSplit")));
        generatedCode.addNewVariableName("rawNumericColumns");
        generatedCode.addCode("rawNumericColumns = raw(:, ");
        generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(TextCodeFactory.getNumericColumns(textImportUIState), 1));
        generatedCode.addCode(");\n");
        generatedCode.addNewVariableName("rawCellColumns");
        generatedCode.addCode("rawCellColumns = raw(:, ");
        generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(list, 1));
        generatedCode.addCode(");\n\n");
    }

    private static void generateNumericParse(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        String string2 = textImportUIState.getDecimalSeparator();
        String string3 = ".".equals(string2) ? "," : ".";
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.parseToNums")));
        generatedCode.addNewVariableName("rawData");
        generatedCode.addCode(String.format("rawData = dataArray{%s};%n", string));
        generatedCode.addNewVariableName("row");
        generatedCode.addCode("for row=1:size(rawData, 1);\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.createRegex")));
        generatedCode.addNewVariableName("regexstr");
        generatedCode.addCode(String.format("regexstr = '(?<prefix>.*?)(?<numbers>([-]*(\\d+[\\%2$s]*)+[\\%1$s]{0,1}\\d*[eEdD]{0,1}[-+]*\\d*[i]{0,1})|([-]*(\\d+[\\%2$s]*)*[\\%1$s]{1,1}\\d+[eEdD]{0,1}[-+]*\\d*[i]{0,1}))(?<suffix>.*)';%n", string2, string3));
        generatedCode.addCode("try\n");
        generatedCode.addNewVariableName("result");
        generatedCode.addCode("result = regexp(rawData{row}, regexstr, 'names');\n");
        generatedCode.addNewVariableName("numbers");
        generatedCode.addCode("numbers = result.numbers;\n\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.detectedThousands")));
        generatedCode.addNewVariableName("invalidThousandsSeparator");
        generatedCode.addCode("invalidThousandsSeparator = false;\n");
        generatedCode.addCode(String.format("if any(numbers=='%s');%n", string3));
        generatedCode.addNewVariableName("thousandsRegExp");
        generatedCode.addCode(String.format("thousandsRegExp = '^\\d+?(\\%2$s\\d{3})*\\%1$s{0,1}\\d*$';%n", string2, string3));
        generatedCode.addCode(String.format("if isempty(regexp(thousandsRegExp, '%s', 'once'));%n", string3));
        generatedCode.addCode("numbers = NaN;\n");
        generatedCode.addCode("invalidThousandsSeparator = true;\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertNumbers")));
        generatedCode.addCode("if ~invalidThousandsSeparator;\n");
        if (",".equals(string2)) {
            generatedCode.addCode("numbers = strrep(numbers, '.', '');\n");
            generatedCode.addCode("numbers = strrep(numbers, ',', '.');\n");
            generatedCode.addCode("numbers = textscan(numbers, '%f');\n");
        } else {
            generatedCode.addCode(String.format("numbers = textscan(strrep(numbers, '%s', ''), '%%f');%n", string3));
        }
        generatedCode.addCode(String.format("numericData(row, %s) = numbers{1};%n", string));
        generatedCode.addCode(String.format("raw{row, %s} = numbers{1};%n", string));
        generatedCode.addCode("end\n");
        generatedCode.addNewVariableName("me");
        generatedCode.addCode("catch me\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode("end\n");
    }

    public static void generateDateParse(GeneratedCode generatedCode, String string, String string2) {
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertDates")));
        generatedCode.addNewVariableName("row");
        generatedCode.addCode("for row=1:size(rawData, 1);\n");
        generatedCode.addCode("try\n");
        generatedCode.addCode(String.format("numericData(row, %1$s) = datenum(dataArray{%1$s}{row}, %2$s);%n", string, string2));
        generatedCode.addCode(String.format("raw{row, %1$s} = numericData(row, %1$s);%n", string));
        generatedCode.addNewVariableName("me");
        generatedCode.addCode("catch me\n");
        generatedCode.addCode("end\nend\n");
    }

    private static void generatFastPathPostProcessing(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        String[] stringArray = TextCodeFactory.getDateFormats(textImportUIState.getSelectedColumnParseRules());
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (!bl) {
                generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.dateConvertComment")));
                bl = true;
            }
            generatedCode.addCode(String.format("dataArray{%1$d} = datenum(dataArray{%1$d}, '%2$s');%n", i + 1, stringArray[i]));
        }
        if (bl) {
            generatedCode.addCode(String.format("%n", new Object[0]));
        }
    }

    private static void generateDatsetAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        String string = textImportUIState.getGlobalVariableName();
        generatedCode.addOutputVariableName(string);
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%s = dataset(dataArray{1:end-1}, 'VarNames', %s);%n", string, TextCodeFactory.stringArrayToCellArray(textImportUIState.getSelectedColumnNames())));
        } else {
            generatedCode.addCode(String.format("%s = dataset;%n", string));
            TextCodeFactory.generateVectorAllocation(generatedCode, textImportUIState, string + ".");
        }
    }

    private static void generateCellArrayAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        String string = textImportUIState.getGlobalVariableName();
        generatedCode.addOutputVariableName(string);
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        if (textImportUIState.useFastPath()) {
            List<Integer> list = TextCodeFactory.getNumericColumns(textImportUIState);
            if (!list.isEmpty()) {
                String string2;
                if (TextCodeFactory.getCellColumns(textImportUIState).isEmpty()) {
                    string2 = "";
                } else if (list.size() == 1) {
                    string2 = "(" + Integer.toString(list.get(0) + 1) + ")";
                } else {
                    string2 = "([" + Integer.toString(list.get(0) + 1);
                    for (int i = 1; i < list.size(); ++i) {
                        string2 = string2 + ", " + Integer.toString(list.get(i) + 1);
                    }
                    string2 = string2 + "])";
                }
                generatedCode.addCode(String.format("dataArray%1$s = cellfun(@(x) num2cell(x), dataArray%1$s, 'UniformOutput', false);%n", string2));
            }
            generatedCode.addCode(String.format("%s = [dataArray{1:end-1}];%n", string));
        } else {
            generatedCode.addCode(String.format("%s = raw;%n", string));
        }
    }

    private static void generateMatrixAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        String string = textImportUIState.getGlobalVariableName();
        generatedCode.addOutputVariableName(string);
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%s = [dataArray{1:end-1}];%n", string));
        } else {
            generatedCode.addCode(String.format("%s = cell2mat(raw);%n", string));
        }
    }

    private static void generateVectorAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        List<Integer> list = TextCodeFactory.getCellColumns(textImportUIState);
        String[] stringArray = textImportUIState.getSelectedColumnNames();
        int n = 1;
        int n2 = 1;
        boolean bl = textImportUIState.getActiveColumnExclusionRuleCount() > 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (textImportUIState.useFastPath()) {
                generatedCode.addCode(String.format("%1$s%2$s = dataArray{:, %3$d};%n", string, stringArray[i], i + 1));
                continue;
            }
            if (list.isEmpty()) {
                if (bl) {
                    generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getColumnExclusionIndex(), i + 1));
                    generatedCode.addCode(String.format("%1$s%2$s = cell2mat(raw(:, columnIndices(%3$d)));%n", string, stringArray[i], i + 1));
                    generatedCode.addCode("end\n");
                    continue;
                }
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(raw(:, %3$d));%n", string, stringArray[i], i + 1));
                continue;
            }
            if (list.contains(i)) {
                generatedCode.addCode(String.format("%1$s%2$s = rawCellColumns(:, %3$d);%n", string, stringArray[i], n2));
                ++n2;
                continue;
            }
            if (bl) {
                generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getColumnExclusionIndex(), n));
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(rawNumericColumns(:, columnIndices(%3$d)));%n", string, stringArray[i], n));
                generatedCode.addCode("end\n");
            } else {
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(rawNumericColumns(:, %3$d));%n", string, stringArray[i], n));
            }
            ++n;
        }
    }

    private static void generateColumnAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        String[] stringArray;
        for (String string : stringArray = textImportUIState.getSelectedColumnNames()) {
            generatedCode.addOutputVariableName(string);
        }
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.allocheading")));
        TextCodeFactory.generateVectorAllocation(generatedCode, textImportUIState, "");
        generatedCode.addCode("\n");
    }

    public static void generateFunctionOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        if (textImportUIState.isColumnVectors() && textImportUIState.getActiveColumnExclusionRuleCount() > 0) {
            String[] stringArray = textImportUIState.getSelectedColumnNames();
            List<Integer> list = TextCodeFactory.getNumericColumns(textImportUIState);
            for (int n : list) {
                generatedCode.addCode(String.format("%s = [];%n", stringArray[n]));
            }
        }
        TextCodeFactory.generateOutputAllocation(generatedCode, textImportUIState);
    }

    public static void generateScriptOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        TextCodeFactory.generateOutputAllocation(generatedCode, textImportUIState);
    }

    public static void generateOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        if (textImportUIState.getActiveColumnExclusionRuleCount() > 0) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.columnOutputDeclare")));
            generatedCode.addNewVariableName("columnIndices");
            generatedCode.addCode("columnIndices = cumsum(~");
            generatedCode.addCode(generatedCode.getColumnExclusionIndex());
            generatedCode.addCode(");\n\n");
        }
        if (textImportUIState.isColumnVectors()) {
            TextCodeFactory.generateColumnAllocation(generatedCode, textImportUIState);
        } else if (textImportUIState.isMatrix()) {
            TextCodeFactory.generateMatrixAllocation(generatedCode, textImportUIState);
        } else if (textImportUIState.isCellArray()) {
            TextCodeFactory.generateCellArrayAllocation(generatedCode, textImportUIState);
        } else if (textImportUIState.isDataset()) {
            TextCodeFactory.generateDatsetAllocation(generatedCode, textImportUIState);
        }
    }

    public static String stringArrayToCellArray(String[] stringArray) {
        String string = "{";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + "'" + stringArray[i] + "',";
        }
        string = string + "'" + stringArray[stringArray.length - 1] + "'}";
        return string;
    }

    private static String getDelimiterString(List<String> list) {
        String string;
        if (list.size() == 1) {
            String string2 = list.get(0);
            string2 = string2.replaceAll("'", "''");
            string2 = string2.replace("\\", "\\\\");
            string2 = string2.replace("\t", "\\t");
            string = "'" + string2 + "'";
        } else {
            String string3;
            string = "{";
            for (int i = 0; i < list.size() - 1; ++i) {
                string3 = list.get(i);
                string3 = string3.replaceAll("'", "''");
                string3 = string3.replace("\\", "\\\\");
                string3 = string3.replace("\t", "\\t");
                string = string + "'" + string3 + "',";
            }
            string3 = list.get(list.size() - 1);
            string3 = string3.replaceAll("'", "''");
            string3 = string3.replace("\\", "\\\\");
            string3 = string3.replace("\t", "\\t");
            string = string + "'" + string3 + "'}";
        }
        return string;
    }

    private static String[] getDateFormats(List<ParseRule> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof DateParsingRule)) continue;
            stringArray[i] = ((DateParsingRule)list.get(i)).getFormat();
        }
        return stringArray;
    }

    static enum CodeType {
        SCRIPT,
        FUNCTION;

    }
}

