/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.FixedWidthPane;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportDataSource;
import com.mathworks.mlwidgets.importtool.ImportScrollPane;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.Importer;
import com.mathworks.mlwidgets.importtool.SnapshotPane;
import com.mathworks.mlwidgets.importtool.TextFileTableModel;
import com.mathworks.mlwidgets.importtool.TextImportClient;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextToolstripTab;
import com.mathworks.mlwidgets.importtool.VariableNamePanel;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.widgets.desk.DTClientBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TextFilePane
extends JRootPane
implements WorksheetRuleListener,
ListSelectionListener,
WorksheetSelectionListener,
AbstractFileTableModel.WorksheetCachedDataListener,
Importer,
HeaderRowListenerInterface {
    private List<WorksheetSelectionListener> fRangeSelectionListeners = new ArrayList<WorksheetSelectionListener>();
    private List<WorksheetRule> fRules;
    private File fFile;
    private TextTable fWorksheetTable;
    private ImportScrollPane fImportScrollPane;
    private FixedWidthPane fFixedWidthPane;
    private VariableNamePanel fVariableNamePanel;
    private MJLayeredPane fLayeredPane;
    private SnapshotPane fSnapshotPane = new SnapshotPane(this);

    void addWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
        this.fRangeSelectionListeners.add(worksheetSelectionListener);
    }

    TextFileTableModel getWorksheetTableModel() {
        return (TextFileTableModel)this.fWorksheetTable.getModel();
    }

    void removeWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
    }

    @Override
    public void importData(ImportDataSource importDataSource) {
        this.fWorksheetTable.importData(importDataSource);
    }

    @Override
    public void generateMatlabFunction(String string) {
        this.fWorksheetTable.generateMatlabFunction(string);
    }

    @Override
    public void generateMatlabScript() {
        this.fWorksheetTable.generateMatlabScript();
    }

    TextTable getTextTable() {
        return this.fWorksheetTable;
    }

    void cleanup() {
        this.setFixedWidthView(false);
        this.fFixedWidthPane.setVisible(false);
        this.fWorksheetTable.cleanup();
    }

    TextFilePane(File file, List<WorksheetRule> list, ImportClient.TargetType targetType) {
        this.setWaitCursor();
        this.getContentPane().setLayout(new BorderLayout());
        this.fFile = file;
        this.fWorksheetTable = new TextTable(new TextFileTableModel(this.fFile, list));
        this.fWorksheetTable.getSelectionModel().addListSelectionListener(this);
        this.fWorksheetTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.fWorksheetTable.addWorksheetCachedDataListener(this);
        this.fWorksheetTable.setHorizontalAutoScrollEnabled(false);
        this.fWorksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                TextFilePane.this.fWorksheetTable.getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                TextFilePane.this.setDefaultCursor();
            }
        });
        this.fImportScrollPane = new ImportScrollPane((JTable)((Object)this.fWorksheetTable));
        String string = this.fFile.getName();
        int n = string.indexOf(".");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((string = string.replaceAll("^[^a-zA-Z]*|[^a-zA-Z0-9]", "")).isEmpty()) {
            string = "Untitled";
        }
        this.fWorksheetTable.validateVariableName(string, true, new ImportTable.VariableNameValidationCallback(){

            @Override
            public void nameValidated(String string, boolean bl) {
                TextFilePane.this.fVariableNamePanel.setVariableName(string);
                TextFilePane.this.fWorksheetTable.setDefaultMatrixVariableName(string);
            }
        });
        this.fVariableNamePanel = this.fWorksheetTable.createVariableNamePanel(this.fImportScrollPane, string);
        this.fLayeredPane = new MJLayeredPane();
        VariableNamePanel.VariableNamePanelLayout variableNamePanelLayout = new VariableNamePanel.VariableNamePanelLayout(this.fVariableNamePanel, (JTable)((Object)this.fWorksheetTable));
        this.fLayeredPane.setLayout((LayoutManager)variableNamePanelLayout);
        this.fLayeredPane.add((Component)((Object)this.fImportScrollPane), (Object)MJLayeredPane.DEFAULT_LAYER);
        this.fLayeredPane.add((Component)((Object)this.fVariableNamePanel), (Object)MJLayeredPane.PALETTE_LAYER);
        this.getContentPane().add((Component)this.fLayeredPane, "Center");
        this.fFixedWidthPane = new FixedWidthPane(this, this.fWorksheetTable);
        this.setGlassPane((Component)((Object)this.fFixedWidthPane));
        this.fWorksheetTable.setParentGlassPane(this.fFixedWidthPane);
        this.fWorksheetTable.setTargetType(targetType);
        this.fRules = list;
    }

    List<WorksheetRule> getRules() {
        return this.fRules;
    }

    void setRules(List<WorksheetRule> list) {
        this.fRules = list;
    }

    void rebuild() {
        this.fWorksheetTable.rebuild();
    }

    @Override
    public void ruleChanged(List<WorksheetRule> list) {
        this.setWaitCursor();
        if (this.fWorksheetTable != null) {
            this.setRules(list);
            this.fWorksheetTable.setWorksheetRules(list);
        }
    }

    boolean isImportableData() {
        int[] nArray = this.fWorksheetTable.getSelectionSizeAfterExclusion();
        return nArray != null && nArray.length >= 2 && nArray[0] > 0 && nArray[1] > 0 && !this.fWorksheetTable.isUntreatedDataInSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = this.fWorksheetTable.getSelectedRange();
        for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
            worksheetSelectionListener.selectedDataChanged(string, listSelectionEvent.getValueIsAdjusting());
        }
    }

    @Override
    public void worksheetCachedDataChanged(EventObject eventObject) {
        DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, this);
        this.setDefaultCursor();
        if (this.fWorksheetTable != null && this.fWorksheetTable.getModel() == eventObject.getSource()) {
            String string = this.fWorksheetTable.getSelectedRange();
            for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
                worksheetSelectionListener.selectedDataChanged(string);
            }
        }
    }

    @Override
    public void selectedDataChanged(String string) {
        if (this.fWorksheetTable != null) {
            this.fWorksheetTable.setSelectedRanges(string);
        }
    }

    @Override
    public void temporarySelectionDataChanged(String string) {
        if (this.fWorksheetTable != null) {
            this.fWorksheetTable.setTemporarySelectedRanges(string);
            this.fWorksheetTable.repaint();
        }
    }

    @Override
    public void selectedDataChanged(String string, boolean bl) {
        if (this.fWorksheetTable != null) {
            this.fWorksheetTable.setSelectedRanges(string);
        }
    }

    @Override
    public void setHeaderRow(int n) {
        if (this.fWorksheetTable != null) {
            this.fWorksheetTable.setHeaderRow(n);
        }
    }

    void setDecimalSeparator(String string) {
        if (this.fWorksheetTable != null && this.fWorksheetTable.getWorksheetTableModel() instanceof TextFileTableModel) {
            this.bufferPaneUntilUpdate();
            ((TextFileTableModel)this.fWorksheetTable.getWorksheetTableModel()).setDecimalSeparator(string);
        }
    }

    void setDelimiters(final List<String> list, final TextImportClient textImportClient) {
        final TextFileTableModel textFileTableModel = (TextFileTableModel)this.fWorksheetTable.getModel();
        this.bufferPaneUntilUpdate();
        MatlabWorker<List<String>> matlabWorker = new MatlabWorker<List<String>>(){

            public List<String> runOnMatlabThread() {
                List<String> list2 = textFileTableModel.getDelimiters();
                if (((Object)list).equals(list2)) {
                    return null;
                }
                textFileTableModel.setDelimiters(list);
                return list;
            }

            public void runOnAWTEventDispatchThread(List<String> list2) {
                if (list2 == null) {
                    TextFilePane.this.clearScreenBuffer();
                    return;
                }
                ((TextToolstripTab)textImportClient.getImportToolstripTab()).getDelimiterComboBox().setWaitCursorEnabled(true);
                TextFilePane.this.fWorksheetTable.rebuild();
                TextFilePane.this.setWaitCursor();
                TextFilePane.this.fWorksheetTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (textImportClient == null || textImportClient.getImportToolstripTab() == null) {
                            return;
                        }
                        ((TextToolstripTab)textImportClient.getImportToolstripTab()).getDelimiterComboBox().setWaitCursorEnabled(false);
                        TextFilePane.this.setDefaultCursor();
                        TextFilePane.this.fWorksheetTable.getModel().removeTableModelListener(this);
                    }
                });
            }
        };
        matlabWorker.start();
    }

    private void clearScreenBuffer() {
        this.fSnapshotPane.bufferUpdateEventOccurred();
        if (!this.fSnapshotPane.isBufferingImage()) {
            this.fSnapshotPane.setVisible(false);
            this.setDefaultCursor();
            this.setGlassPane((Component)((Object)this.fFixedWidthPane));
        }
    }

    private void bufferPaneUntilUpdate() {
        if (this.fSnapshotPane == null) {
            this.fSnapshotPane = new SnapshotPane(this);
        }
        this.setWaitCursor();
        this.fWorksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                TextFilePane.this.fWorksheetTable.getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                TextFilePane.this.clearScreenBuffer();
            }
        });
        this.setGlassPane((Component)((Object)this.fSnapshotPane));
        this.fSnapshotPane.setVisible(true);
        this.fSnapshotPane.bufferScreenUntilTableUpdate();
    }

    private void setWaitCursor() {
        DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, this);
        if (dTClientBase != null) {
            dTClientBase.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        DTClientBase dTClientBase = (DTClientBase)SwingUtilities.getAncestorOfClass(DTClientBase.class, this);
        if (dTClientBase != null) {
            dTClientBase.setCursor(null);
        }
        this.setCursor(null);
    }

    void setTargetType(ImportClient.TargetType targetType) {
        this.fWorksheetTable.setTargetType(targetType);
        this.fVariableNamePanel.setVisible(targetType != ImportClient.TargetType.COLUMNVECTORS);
        this.revalidate();
        this.repaint();
    }

    public void setFixedWidth(boolean bl) {
        this.getWorksheetTableModel().setFixedWidth(bl);
        this.setFixedWidthView(bl);
        this.fWorksheetTable.rebuild();
    }

    public void setVariableNamesHighlightRow(int n) {
        this.fWorksheetTable.setVariableNamesHighlightRow(n);
        this.fWorksheetTable.repaint();
        this.fWorksheetTable.getTableHeader().repaint();
    }

    public void setFixedWidthView(boolean bl) {
        this.fWorksheetTable.setFixedWidthView(bl);
        if (bl) {
            this.fFixedWidthPane.setVisible(true);
            this.fFixedWidthPane.requestFocus();
            this.fFixedWidthPane.requestFocusInWindow();
        } else {
            this.fFixedWidthPane.setVisible(false);
        }
    }

    public void setCoalesceDelimiters(boolean bl) {
        this.bufferPaneUntilUpdate();
        this.getWorksheetTableModel().setMultipleDelimsAsOne(bl);
    }

    public void setRowDelimiters(String[] stringArray) {
    }
}

