/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.guiutils;

import java.awt.Color;
import org.apache.commons.lang.StringUtils;

public enum ColorSpec {
    BLUE(Color.BLUE, "blue"),
    BLACK(Color.BLACK, "black"),
    WHITE(Color.WHITE, "white"),
    RED(Color.RED, "red"),
    YELLOW(Color.YELLOW, "yellow"),
    MAGENTA(Color.MAGENTA, "magenta"),
    CYAN(Color.CYAN, "cyan"),
    GREEN(Color.GREEN, "green");

    private final Color color;
    private final String name;

    private ColorSpec(Color color, String string2) {
        this.color = color;
        this.name = string2;
    }

    public String toString() {
        return this.name;
    }

    public Color colorValue() {
        return this.color;
    }

    private static Color getColorByPrefix(String string) {
        ColorSpec[] colorSpecArray;
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (ColorSpec colorSpec : colorSpecArray = ColorSpec.values()) {
            if (!colorSpec.toString().toLowerCase().startsWith(string.toLowerCase())) continue;
            return colorSpec.colorValue();
        }
        return null;
    }

    public static Color toColor(String string) throws IllegalArgumentException {
        String string2 = StringUtils.stripToNull((String)string);
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid color name: " + string);
        }
        if ("k".equals(string2)) {
            return Color.BLACK;
        }
        if ("b".equals(string2)) {
            return Color.BLUE;
        }
        Color color = ColorSpec.getColorByPrefix(string);
        if (color == null) {
            throw new IllegalArgumentException("Invalid color name: " + string);
        }
        return color;
    }
}

