/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;

public class GeneralPrefsPanel
extends MJPanel {
    private MJCheckBox fUsePathCache;
    private MJCheckBox fUsePathCacheDiag;
    private MJButton fUpdatePathCache;
    private static final boolean DEFAULT_TOOLBOX_CACHE = true;
    private static final boolean DEFAULT_TOOLBOX_CACHE_DIAG = false;
    private MJRadioButton fUseDefaultCheckbox;
    private MJRadioButton fUseBlackAndWhiteCheckbox;
    private MJRadioButton fUseColorCheckbox;
    private static boolean sUseDefault = true;
    private static boolean sUseBlackAndWhite = true;
    private MJRadioButton fRecycle;
    private MJRadioButton fPermanent;
    public static final SettingPath matlabNode = new SettingPath(new String[]{"matlab"});
    Setting<Boolean> deleteSetting = GeneralPrefsPanel.createBooleanSetting(matlabNode, "DeleteFilesPermanently");
    private static Matlab sMatlab = new Matlab();
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static GeneralPrefsPanel sPrefsPanel = null;
    private GPListener fGPListener;

    private static Setting<Boolean> createBooleanSetting(SettingPath settingPath, String string) {
        try {
            return new Setting(settingPath, Boolean.class, string);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private static void setPrintColorChoice() {
        if (PlatformInfo.isWindows() && Matlab.isMatlabAvailable()) {
            int n = -1;
            if (!sUseDefault) {
                n = sUseBlackAndWhite ? 0 : 1;
            }
            sMatlab.evalNoOutput("system_dependent('setprintcolorchoice', " + n + ")");
        }
    }

    public static int getToolboxCacheLevel() {
        if (!Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)true)) {
            return 0;
        }
        if (Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false)) {
            return 2;
        }
        return 1;
    }

    public static void setToolboxCache(boolean bl) {
        Prefs.setBooleanPref((String)"GeneralUseToolboxCache", (boolean)bl);
        if (sPrefsPanel != null) {
            GeneralPrefsPanel.sPrefsPanel.fUsePathCache.setSelected(bl);
            sPrefsPanel.enablePathCacheItems();
        }
    }

    private GeneralPrefsPanel() {
        ButtonGroup buttonGroup;
        this.setName("GeneralPrefsPanel");
        this.fUsePathCache = new MJCheckBox(sRes.getString("gtlp.usetoolboxcache"));
        this.fUsePathCache.setName("gtlp.usetoolboxcache");
        this.fUsePathCacheDiag = new MJCheckBox(sRes.getString("gtlp.usetoolboxcachediag"));
        this.fUsePathCacheDiag.setName("gtlp.usetoolboxcachediag");
        this.fUpdatePathCache = new MJButton(sRes.getString("gtlp.updatetoolboxcache"));
        this.fUpdatePathCache.setName("gtlp.updatetoolboxcache");
        this.fUpdatePathCache.setActionCommand("UpdateCache");
        this.fGPListener = new GPListener();
        this.fUpdatePathCache.addActionListener((ActionListener)this.fGPListener);
        this.fUsePathCache.setSelected(Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)true));
        this.fUsePathCacheDiag.setSelected(Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false));
        this.enablePathCacheItems();
        this.fUsePathCache.addItemListener((ItemListener)this.fGPListener);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("gtlp.toolboxcachepanel")));
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.add((Component)this.fUpdatePathCache, (Object)"West");
        mJPanel.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        mJPanel2.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        mJPanel.add((Component)this.fUsePathCache);
        mJPanel2.add((Component)this.fUsePathCacheDiag);
        mJPanel2.add((Component)mJPanel3);
        mJPanel.add((Component)mJPanel2);
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("gtlp.figwinprinting")));
        if (PlatformInfo.isWindows()) {
            buttonGroup = new ButtonGroup();
            this.fUseDefaultCheckbox = new MJRadioButton(sRes.getString("gtlp.usedefaults"), sUseDefault);
            this.fUseDefaultCheckbox.setName("gtlp.usedefaults");
            this.fUseBlackAndWhiteCheckbox = new MJRadioButton(sRes.getString("gtlp.alwaysbw"), !sUseDefault && sUseBlackAndWhite);
            this.fUseBlackAndWhiteCheckbox.setName("gtlp.alwaysbw");
            this.fUseColorCheckbox = new MJRadioButton(sRes.getString("gtlp.alwayscolor"), !sUseDefault && !sUseBlackAndWhite);
            this.fUseColorCheckbox.setName("gtlp.alwayscolor");
            buttonGroup.add((AbstractButton)this.fUseDefaultCheckbox);
            buttonGroup.add((AbstractButton)this.fUseBlackAndWhiteCheckbox);
            buttonGroup.add((AbstractButton)this.fUseColorCheckbox);
            mJPanel4.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
            mJPanel4.add((Component)new MJLabel(sRes.getString("gtlp.bworcolor")));
            mJPanel4.add((Component)this.fUseDefaultCheckbox);
            mJPanel4.add((Component)this.fUseBlackAndWhiteCheckbox);
            mJPanel4.add((Component)this.fUseColorCheckbox);
        }
        buttonGroup = new MJPanel((LayoutManager)new BorderLayout());
        buttonGroup.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        buttonGroup.setBorder(BorderFactory.createTitledBorder(sRes.getString("gtlp.deletepanel")));
        String string = "";
        if (PlatformInfo.isWindows()) {
            buttonGroup.add((Component)new MJMultilineLabel(sRes.getString("gtlp.explanation.windows")));
            string = sRes.getString("gtlp.recycle.windows");
        } else {
            buttonGroup.add((Component)new MJLabel(sRes.getString("gtlp.explanation.macunix")));
            string = PlatformInfo.isMacintosh() ? sRes.getString("gtlp.recycle.macintosh") : sRes.getString("gtlp.recycle.unix");
        }
        this.fRecycle = new MJRadioButton(string);
        this.fRecycle.setName("gtlp.recycle.platform");
        this.fPermanent = new MJRadioButton(sRes.getString("gtlp.recycle.permanent"));
        this.fPermanent.setName("gtlp.recycle.permanent");
        buttonGroup.add((Component)this.fRecycle);
        buttonGroup.add((Component)this.fPermanent);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this.fRecycle);
        buttonGroup2.add((AbstractButton)this.fPermanent);
        try {
            if (((Boolean)this.deleteSetting.get()).booleanValue()) {
                this.fPermanent.setSelected(true);
            } else {
                this.fRecycle.setSelected(true);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.add((Component)mJPanel);
        if (PlatformInfo.isWindows()) {
            this.add((Component)mJPanel4);
        }
        this.add((Component)((Object)buttonGroup));
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new GeneralPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    private void savePrefs() {
        Prefs.setBooleanPref((String)"GeneralUseToolboxCache", (boolean)this.fUsePathCache.isSelected());
        Prefs.setBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)this.fUsePathCacheDiag.isSelected());
        if (PlatformInfo.isWindows()) {
            boolean bl = this.fUseDefaultCheckbox.isSelected();
            boolean bl2 = this.fUseBlackAndWhiteCheckbox.isSelected();
            Prefs.setBooleanPref((String)"GeneralUseDefaultColors", (boolean)bl);
            Prefs.setBooleanPref((String)"GeneralUseBlackAndWhite", (boolean)bl2);
            if (bl != sUseDefault || bl2 != sUseBlackAndWhite) {
                sUseDefault = bl;
                sUseBlackAndWhite = bl2;
                GeneralPrefsPanel.setPrintColorChoice();
            }
        }
        try {
            if (((Boolean)this.deleteSetting.get()).booleanValue() == this.fRecycle.isSelected()) {
                if (this.fRecycle.isSelected()) {
                    sMatlab.evalNoOutput("recycle on");
                } else {
                    sMatlab.evalNoOutput("recycle off");
                }
                this.deleteSetting.set((Object)(!this.fRecycle.isSelected() ? 1 : 0));
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void rehashToolboxCache() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        sMatlab.eval("rehash toolboxcache;", (CompletionObserver)this.fGPListener);
    }

    private void enablePathCacheItems() {
        this.fUsePathCacheDiag.setEnabled(this.fUsePathCache.isSelected());
        this.fUpdatePathCache.setEnabled(this.fUsePathCache.isSelected());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_general_prefs"};
    }

    static {
        if (PlatformInfo.isWindows()) {
            sUseDefault = Prefs.getBooleanPref((String)"GeneralUseDefaultColors", (boolean)true);
            sUseBlackAndWhite = Prefs.getBooleanPref((String)"GeneralUseBlackAndWhite", (boolean)true);
            GeneralPrefsPanel.setPrintColorChoice();
        }
    }

    private class GPListener
    implements ItemListener,
    CompletionObserver,
    ActionListener {
        private GPListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            GeneralPrefsPanel.this.enablePathCacheItems();
        }

        public void completed(int n, Object object) {
            GeneralPrefsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            if (Matlab.getExecutionStatus((int)n) != 0) {
                MJOptionPane.showMessageDialog((Component)GeneralPrefsPanel.this.fUsePathCache, (Object)sRes.getString("gtlpcd.createfailed"), (String)sRes.getString("gtlpcd.title"), (int)2);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("UpdateCache")) {
                GeneralPrefsPanel.this.rehashToolboxCache();
            }
        }
    }
}

