/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLCommandWindowServices;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.SyntaxDelimiterPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class KeyboardPrefsPanel
extends MJPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static KeyboardPrefsPanel sPrefsPanel = null;
    private MJCheckBox fCWTabCompletionCheckbox;
    private MJCheckBox fEditorTabCompletionCheckbox;
    private MJCheckBox fTabNarrowsCheckbox;
    private MJCheckBox fCWFunctionHintsCheckbox;
    private MJCheckBox fEditorFunctionHintsCheckbox;
    private SyntaxDelimiterPanel fDelimiterPanel;

    public KeyboardPrefsPanel() {
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 6, 5, 131072));
        this.setName("KeyboardPrefPanel");
        this.getAccessibleContext().setAccessibleName("Keyboard Prefs Panel");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 3dlu:grow, p", "p, 3dlu, p, 3dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fCWTabCompletionCheckbox = new MJCheckBox(sRes.getString("cwkp.tabcompletion.check"));
        this.fCWTabCompletionCheckbox.setSelected(KeyboardPrefs.isCmdWinTabCompletionEnabled());
        this.fCWTabCompletionCheckbox.setName("CWTabCompletionCheckbox");
        this.fEditorTabCompletionCheckbox = new MJCheckBox(sRes.getString("editor.tabcompletion.check"));
        this.fEditorTabCompletionCheckbox.setSelected(KeyboardPrefs.isEditorTabCompletionEnabled());
        this.fEditorTabCompletionCheckbox.setName("EditorTabCompletionCheckbox");
        this.fEditorTabCompletionCheckbox.setEnabled(Matlab.isMatlabAvailable());
        this.fTabNarrowsCheckbox = new MJCheckBox(sRes.getString("cwkp.tabnarrows"));
        this.fTabNarrowsCheckbox.setSelected(KeyboardPrefs.isTabCompletionNarrowing());
        this.fTabNarrowsCheckbox.setName("TabCompletionNarrowsCheckbox");
        this.fTabNarrowsCheckbox.setEnabled(Matlab.isMatlabAvailable());
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(MessageFormat.format(sRes.getString("tabindents.message"), MessageFormat.format("<a href=\".\">{0}</a>", sRes.getString("area.commandwindow") + " " + sRes.getString("tabindents.message.link"))), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)sRes.getString("area.commandwindow"));
            }
        }, false, "CWPrefLink", "Link to Command Window tab prefs.");
        HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel(MessageFormat.format(sRes.getString("tabindents.message"), MessageFormat.format("<a href=\".\">{0}</a>", sRes.getString("area.editordebugger") + " " + sRes.getString("tabindents.message.link"))), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)(sRes.getString("area.editordebugger") + "." + sRes.getString("area.editordebugger.keyboardandindenting")));
            }
        }, false, "EditorPrefLink", "Link to Editor tab prefs.");
        panelBuilder.add((Component)this.fCWTabCompletionCheckbox, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)hyperlinkTextLabel.getComponent(), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fEditorTabCompletionCheckbox, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)hyperlinkTextLabel2.getComponent(), cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.fTabNarrowsCheckbox, cellConstraints.xy(1, 5));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setName("TabKeyPanel");
        jPanel.getAccessibleContext().setAccessibleName(sRes.getString("cwkp.tabkey.groupbox"));
        jPanel.setBorder(BorderFactory.createTitledBorder(sRes.getString("cwkp.tabkey.groupbox")));
        this.add(jPanel);
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 6, 5, 131072));
        mJPanel.setName("FuncHintsKeyPanel");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("cwkp.functionhints.groupbox")));
        this.fCWFunctionHintsCheckbox = new MJCheckBox(sRes.getString("cwkp.functionhints.check"));
        this.fCWFunctionHintsCheckbox.setSelected(KeyboardPrefs.isCmdWinFunctionHintsEnabled());
        this.fCWFunctionHintsCheckbox.setName("CWFunctionHintsCheckbox");
        mJPanel.add((Component)this.fCWFunctionHintsCheckbox);
        this.fEditorFunctionHintsCheckbox = new MJCheckBox(sRes.getString("editor.functionhints.check"));
        this.fEditorFunctionHintsCheckbox.setSelected(KeyboardPrefs.isEditorFunctionHintsEnabled());
        this.fEditorFunctionHintsCheckbox.setName("EditorFunctionHintsCheckbox");
        mJPanel.add((Component)this.fEditorFunctionHintsCheckbox);
        this.add((Component)mJPanel);
        this.fCWTabCompletionCheckbox.setEnabled(MLCommandWindowServices.isJavaCWInitialized() && Matlab.isMatlabAvailable());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        mJPanel2.setName("DelimiterPrefPanel");
        mJPanel2.getAccessibleContext().setAccessibleName(sRes.getString("keyboard.delimitermatching.title"));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("keyboard.delimitermatching.title")));
        this.fDelimiterPanel = new SyntaxDelimiterPanel(KeyboardPrefs.isDelimMatchingWhileTyping(), KeyboardPrefs.getDelimMatchTypeWhileTyping(), KeyboardPrefs.getDelimMismatchTypeWhileTyping(), KeyboardPrefs.isDelimMatchingWhileMousing(), KeyboardPrefs.getDelimMatchTypeWhileMousing(), KeyboardPrefs.getDelimMismatchTypeWhileMousing());
        this.fDelimiterPanel.setName("DelimiterPanel");
        this.fDelimiterPanel.getAccessibleContext().setAccessibleName(sRes.getString("keyboard.delimitermatching.title"));
        mJPanel2.add((Component)this.fDelimiterPanel);
        this.add((Component)mJPanel2);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new KeyboardPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        if (this.fCWTabCompletionCheckbox.isSelected() != KeyboardPrefs.isCmdWinTabCompletionEnabled()) {
            KeyboardPrefs.setCmdWinTabCompletionEnabled((boolean)this.fCWTabCompletionCheckbox.isSelected());
        }
        if (this.fEditorTabCompletionCheckbox.isSelected() != KeyboardPrefs.isEditorTabCompletionEnabled()) {
            KeyboardPrefs.setEditorTabCompletionEnabled((boolean)this.fEditorTabCompletionCheckbox.isSelected());
        }
        if (this.fTabNarrowsCheckbox.isSelected() != KeyboardPrefs.isTabCompletionNarrowing()) {
            KeyboardPrefs.setTabNarrows((boolean)this.fTabNarrowsCheckbox.isSelected());
        }
        if (this.fCWFunctionHintsCheckbox.isSelected() != KeyboardPrefs.isCmdWinFunctionHintsEnabled()) {
            KeyboardPrefs.setCmdWinFunctionHintsEnabled((boolean)this.fCWFunctionHintsCheckbox.isSelected());
        }
        if (this.fEditorFunctionHintsCheckbox.isSelected() != KeyboardPrefs.isEditorFunctionHintsEnabled()) {
            KeyboardPrefs.setEditorFunctionHintsEnabled((boolean)this.fEditorFunctionHintsCheckbox.isSelected());
        }
        KeyboardPrefs.setDelimMatchingWhileTyping((boolean)this.fDelimiterPanel.isDelimMatchingWhileTyping());
        KeyboardPrefs.setDelimMatchingWhileMousing((boolean)this.fDelimiterPanel.isDelimMatchingWhileMousing());
        KeyboardPrefs.setDelimMatchTypeWhileTyping((int)this.fDelimiterPanel.getDelimMatchTypeWhileTyping());
        KeyboardPrefs.setDelimMismatchTypeWhileTyping((int)this.fDelimiterPanel.getDelimMismatchTypeWhileTyping());
        KeyboardPrefs.setDelimMatchTypeWhileMousing((int)this.fDelimiterPanel.getDelimMatchTypeWhileMousing());
        KeyboardPrefs.setDelimMismatchTypeWhileMousing((int)this.fDelimiterPanel.getDelimMismatchTypeWhileMousing());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_keyboard_prefs"};
    }
}

