/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.jidesoft.shortcut.KeyboardShortcut;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.prefs.binding.CustomShortcutField;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingPanelUtils;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingSetEntry;
import com.mathworks.mlwidgets.prefs.binding.TabActionHandler;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.checkboxlist.CheckBoxList;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ButtonFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultFocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class ShortcutModifierPanel {
    private final JComponent fPanel;
    private final MJTable fShortcutTable;
    private final ShortcutTableModel fShortcutTableModel;
    private final KeyBindingManager fManager;
    private KeyBindingSetEntry fSetInProgress;
    private String fSelectedActionName;
    private MPopup fContextPopup;
    private CheckBoxList fContextCheckBoxList;
    private ActionData fActionBeingEdited;
    private final MJLabel fTableLabel = new MJLabel();
    private final KeyStrokeEditor fKeyStrokeEditor;
    private final MJButton fAddButton = new MJButton((Icon)MiscellaneousIcon.ADD_ENTRY.getIcon());
    private final MJButton fRemoveButton = new MJButton((Icon)MiscellaneousIcon.REMOVE_ENTRY.getIcon());
    private Action fTabAction;
    private Action fShiftTabAction;
    private final TabActionHandler fTabActionHandler;
    private static final int CONFLICT_COLUMN = 0;
    private static final int SHORTCUT_FIELD_COLUMN = 1;
    private static final int CONTEXT_LIST_COLUMN = 2;
    private static final Border ACTIVE_EDITOR_BORDER = BorderFactory.createLineBorder(UIManager.getColor("List.selectionBackground"), 1);
    private static final Border FOCUS_CELL_BORDER = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final String CONTEX_LIST_ACC_NAME = "Selectable list of tools with action";

    ShortcutModifierPanel(KeyBindingManager keyBindingManager) {
        this.fManager = keyBindingManager;
        this.fTabActionHandler = new TabActionHandler(){

            @Override
            public void handleKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9 && (keyEvent.getModifiers() == 0 || keyEvent.getModifiers() == 1)) {
                    boolean bl;
                    keyEvent.consume();
                    ShortcutModifierPanel.this.fShortcutTable.removeEditor();
                    boolean bl2 = bl = keyEvent.getModifiers() == 1;
                    if (bl || !ShortcutModifierPanel.this.isLastCellSelected()) {
                        ShortcutModifierPanel.this.fShortcutTable.requestFocusInWindow();
                    }
                    Action action = bl ? ShortcutModifierPanel.this.fShiftTabAction : ShortcutModifierPanel.this.fTabAction;
                    action.actionPerformed(new ActionEvent(ShortcutModifierPanel.this.fShortcutTable, 0, keyEvent.toString()));
                }
            }
        };
        this.fKeyStrokeEditor = new KeyStrokeEditor(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ShortcutModifierPanel.this.getActiveRowIndex();
                if (n != -1) {
                    ShortcutModifierPanel.this.acceptNewBinding(n);
                    ShortcutModifierPanel.this.fShortcutTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        }, this.fTabActionHandler);
        this.fShortcutTableModel = new ShortcutTableModel();
        this.fShortcutTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                String string = ShortcutModifierPanel.this.fSelectedActionName == null ? KeyBindingPanelUtils.lookup("shortcutPanel.selectAction") : MessageFormat.format(KeyBindingPanelUtils.lookup("shortcutPanel.Title"), ShortcutModifierPanel.this.fSelectedActionName);
                ShortcutModifierPanel.this.fTableLabel.setText(string);
            }
        });
        this.fShortcutTable = new ShortcutTable(this.fShortcutTableModel);
        this.fShortcutTable.setAccessibleTextProvider(new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                if (n2 == 0) {
                    return KeyBindingPanelUtils.getConflictDescription(ShortcutModifierPanel.this.fManager, (KeyBindingSet)ShortcutModifierPanel.this.fSetInProgress.getModifiableSet(), ShortcutModifierPanel.this.fActionBeingEdited, ShortcutModifierPanel.this.fShortcutTableModel.getShortcut(n), ShortcutModifierPanel.this.addContextFollowingComponentsToList(ShortcutModifierPanel.this.fShortcutTableModel.getContextList(n).getSelectedContexts(), ShortcutModifierPanel.this.fActionBeingEdited));
                }
                if (n2 == 2) {
                    return ShortcutModifierPanel.CONTEX_LIST_ACC_NAME;
                }
                return "Field for typing keyboard shortcut";
            }
        });
        this.fPanel = this.layoutPanel();
        this.fAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutModifierPanel.this.addNewShortcut();
            }
        });
        this.fAddButton.getAccessibleContext().setAccessibleName("Add new shortcut");
        this.fRemoveButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ShortcutModifierPanel.this.getActiveRowIndex();
                assert (n != -1) : "The remove button should be disabled if there is no selection";
                assert (ShortcutModifierPanel.this.fActionBeingEdited != null) : "The remove button should be disabled if no action is selected";
                ActionData actionData = ShortcutModifierPanel.this.fActionBeingEdited;
                KeyStrokeList keyStrokeList = ShortcutModifierPanel.this.fShortcutTableModel.getShortcut(n);
                ContextListModel contextListModel = ShortcutModifierPanel.this.fShortcutTableModel.getContextList(n);
                ShortcutModifierPanel.this.fShortcutTableModel.removeEntryFromTable(n);
                try {
                    ShortcutModifierPanel.this.fSetInProgress.suspendEventFiring();
                    if (contextListModel.fIsSharedShortcut) {
                        if (keyStrokeList != null) {
                            ShortcutModifierPanel.this.removeGlobalBinding(actionData, n, keyStrokeList);
                        }
                        if (ShortcutModifierPanel.this.fShortcutTable.getRowCount() > 0 && n == ShortcutModifierPanel.this.fShortcutTableModel.getKnownSharedIndex() && !((ActionShortcut)ShortcutModifierPanel.this.fShortcutTableModel.fTableEntries.get(n)).isSharedShortcut()) {
                            ShortcutModifierPanel.this.changeToGlobal(n, ((ActionShortcut)ShortcutModifierPanel.this.fShortcutTableModel.fTableEntries.get(n)).getSelectedContexts(), actionData);
                            ShortcutModifierPanel.this.updateAllOtherRows(n, actionData);
                        }
                    } else if (keyStrokeList != null) {
                        ShortcutModifierPanel.this.removeNonGlobalBinding(contextListModel.getSelectedContexts(), actionData, n, keyStrokeList);
                    }
                }
                finally {
                    ShortcutModifierPanel.this.fSetInProgress.resumeEventFiring();
                }
                if (ShortcutModifierPanel.this.fShortcutTable.getRowCount() > 0) {
                    int n2 = Math.min(n, ShortcutModifierPanel.this.fShortcutTable.getRowCount() - 1);
                    ShortcutModifierPanel.this.fShortcutTable.setRowSelectionInterval(n2, n2);
                    ShortcutModifierPanel.this.fRemoveButton.requestFocusInWindow();
                }
            }
        });
        this.fRemoveButton.getAccessibleContext().setAccessibleName("Delete selected shortcut");
    }

    JComponent getComponent() {
        return this.fPanel;
    }

    void selectedActionChanged(ActionData actionData, KeyBindingSetEntry keyBindingSetEntry) {
        assert (keyBindingSetEntry != null) : "KeyBindingSetEntry cannot be null";
        this.fSetInProgress = keyBindingSetEntry;
        this.fActionBeingEdited = actionData;
        this.fTableLabel.setToolTipText(actionData == null ? "" : KeyBindingPanelUtils.getActionDescription(actionData));
        this.fKeyStrokeEditor.populateShortcutFields(this.fShortcutTableModel.updateSelectedAction());
        this.fSelectedActionName = actionData != null ? actionData.getPreferencePanelLabel() : null;
        this.fShortcutTableModel.fireTableDataChanged();
        this.fAddButton.setEnabled(actionData != null);
        this.updateRemoveButtonState();
    }

    void setChanged() {
        for (int i = 0; i < this.fShortcutTable.getRowCount(); ++i) {
            this.fShortcutTableModel.fireTableCellUpdated(i, 0);
        }
    }

    void addNewShortcut() {
        assert (this.fActionBeingEdited != null) : "This method should not be called if no action is selected";
        this.editRowEntry(this.fShortcutTableModel.addNewEntryToTable(this.fActionBeingEdited));
    }

    void editFirstShortcut() {
        assert (this.fActionBeingEdited != null) : "This method should not be called if no action is selected";
        assert (this.fShortcutTable.getRowCount() > 0) : "This method should not be called if no shortcuts exist";
        this.editRowEntry(0);
    }

    private JPanel layoutPanel() {
        this.fAddButton.setName("AddShortcutButton");
        this.fRemoveButton.setName("RemoveShortcutButton");
        return KeyBindingPanelUtils.layoutTablePanel(this.fTableLabel, this.fShortcutTable, ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fAddButton, this.fRemoveButton}), false);
    }

    private int getActiveRowIndex() {
        return Math.max(this.fShortcutTable.getSelectedRow(), this.fShortcutTable.getEditingRow());
    }

    private void updateRemoveButtonState() {
        this.fRemoveButton.setEnabled(this.fShortcutTable.getSelectedRowCount() > 0 || this.fShortcutTable.isEditing());
    }

    private void changeToGlobal(int n, List<Context> list, ActionData actionData) {
        KeyStrokeList keyStrokeList = this.fShortcutTableModel.getShortcut(n);
        if (keyStrokeList != null) {
            this.addGlobalBinding(actionData, n, keyStrokeList);
            this.removeNonGlobalBinding(this.fShortcutTableModel.getContextList(n).getSelectedContexts(), actionData, n, keyStrokeList);
        }
        this.fShortcutTableModel.updateSharedProperty(n, true);
        this.fShortcutTableModel.updateActionShortcut(n, list);
    }

    private void changeToNonGlobal(int n, List<Context> list, ActionData actionData) {
        KeyStrokeList keyStrokeList = this.fShortcutTableModel.getShortcut(n);
        if (keyStrokeList != null) {
            this.removeGlobalBinding(actionData, n, keyStrokeList);
            for (Context context : list) {
                this.addNonGlobalBinding(context, actionData, n, keyStrokeList);
            }
        }
        this.fShortcutTableModel.updateSharedProperty(n, false);
        this.fShortcutTableModel.updateActionShortcut(n, list);
    }

    private void updateAllOtherRows(int n, ActionData actionData) {
        for (int i = 0; i != this.fShortcutTableModel.getRowCount(); ++i) {
            ContextListModel contextListModel;
            if (i == n || this.wasSharedShortcutAndStillIs(contextListModel = this.fShortcutTableModel.getContextList(i), i)) continue;
            if (this.wasSharedShortcutButNoLongerIs(contextListModel, i)) {
                this.changeToNonGlobal(i, contextListModel.getSelectedContexts(), actionData);
                continue;
            }
            if (!this.wasNonSharedButNowIsShared(contextListModel, i)) continue;
            this.changeToGlobal(i, contextListModel.getSelectedContexts(), actionData);
        }
    }

    private boolean wasSharedShortcutAndStillIs(ContextListModel contextListModel, int n) {
        return contextListModel.fIsSharedShortcut && (n == this.fShortcutTableModel.getKnownSharedIndex() || this.selectedEntriesSameAsShared(contextListModel, n));
    }

    private boolean wasSharedShortcutButNoLongerIs(ContextListModel contextListModel, int n) {
        if (!contextListModel.fIsSharedShortcut || n == this.fShortcutTableModel.getKnownSharedIndex()) {
            return false;
        }
        return !this.selectedEntriesSameAsShared(contextListModel, n);
    }

    private boolean wasNonSharedButNowIsShared(ContextListModel contextListModel, int n) {
        return n == this.fShortcutTableModel.getKnownSharedIndex() || !contextListModel.fIsSharedShortcut && this.selectedEntriesSameAsShared(contextListModel, n);
    }

    private boolean selectedEntriesSameAsShared(ContextListModel contextListModel, int n) {
        List<Context> list = this.fShortcutTable.getEditingRow() == n ? this.getCheckedContexts(contextListModel, n) : contextListModel.getSelectedContexts();
        return ShortcutModifierPanel.containsSameElements(list, this.fShortcutTableModel.getSharedEntry().getSelectedContexts());
    }

    private static boolean containsSameElements(List<Context> list, List<Context> list2) {
        return list.size() == list2.size() && list.containsAll(list2);
    }

    private List<Context> getCheckedContexts(ContextListModel contextListModel, int n) {
        assert (this.fContextCheckBoxList != null) : "The context checkbox list is null";
        assert (n == this.fShortcutTable.getEditingRow()) : "The row specified is not the row being edited: " + n;
        int[] nArray = this.fContextCheckBoxList.getCheckedIndicies();
        LinkedList<Context> linkedList = new LinkedList<Context>();
        for (int n2 : nArray) {
            linkedList.add((Context)contextListModel.fAllContexts.get(n2));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptNewBinding(int n) {
        assert (this.fActionBeingEdited != null) : "Should not be able to edit keybinding if no action selected";
        ActionData actionData = this.fActionBeingEdited;
        ActionShortcut actionShortcut = (ActionShortcut)this.fShortcutTableModel.fTableEntries.get(n);
        KeyStrokeList keyStrokeList = this.fKeyStrokeEditor.getCellEditorValue();
        KeyStrokeList keyStrokeList2 = actionShortcut.getShortcut();
        if (keyStrokeList2 == null || !keyStrokeList2.equals((Object)keyStrokeList)) {
            try {
                this.fSetInProgress.suspendEventFiring();
                if (actionShortcut.isSharedShortcut()) {
                    if (keyStrokeList2 != null) {
                        this.removeGlobalBinding(actionData, n, keyStrokeList2);
                    }
                    if (keyStrokeList != null) {
                        this.addGlobalBinding(actionData, n, keyStrokeList);
                        for (Context context : actionShortcut.getSelectedContexts()) {
                            if (this.fSetInProgress.followsGlobalContext(context, (ActionDataID)actionData)) continue;
                            this.fSetInProgress.changeFollowsGlobal(context, (ActionDataID)actionData, true);
                        }
                    }
                } else {
                    if (keyStrokeList2 != null) {
                        this.removeNonGlobalBinding(actionShortcut.getSelectedContexts(), actionData, n, keyStrokeList2);
                    }
                    if (keyStrokeList != null) {
                        for (Context context : actionShortcut.getSelectedContexts()) {
                            this.addNonGlobalBinding(context, actionData, n, keyStrokeList);
                        }
                    }
                }
                actionShortcut.setShortcut(keyStrokeList);
                this.fShortcutTableModel.fireTableRowsUpdated(n, n);
            }
            finally {
                this.fSetInProgress.resumeEventFiring();
            }
        }
    }

    private void addGlobalBinding(ActionData actionData, int n, KeyStrokeList keyStrokeList) {
        this.fSetInProgress.addGlobalBinding(actionData, keyStrokeList);
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>();
        for (int i = 0; i != this.fShortcutTableModel.getRowCount(); ++i) {
            ActionShortcut actionShortcut = (ActionShortcut)this.fShortcutTableModel.fTableEntries.get(i);
            if (i == n) {
                ShortcutModifierPanel.addBindingIfNonNull(arrayList, keyStrokeList);
                continue;
            }
            if (!actionShortcut.isSharedShortcut()) continue;
            ShortcutModifierPanel.addBindingIfNonNull(arrayList, actionShortcut.getShortcut());
        }
        this.fSetInProgress.prioritizeGlobalBindings(actionData, arrayList);
    }

    private void removeGlobalBinding(ActionData actionData, int n, KeyStrokeList keyStrokeList) {
        for (int i = 0; i != this.fShortcutTableModel.getRowCount(); ++i) {
            ActionShortcut actionShortcut;
            if (i == n || !(actionShortcut = (ActionShortcut)this.fShortcutTableModel.fTableEntries.get(i)).isSharedShortcut() || !keyStrokeList.equals((Object)actionShortcut.getShortcut())) continue;
            return;
        }
        this.fSetInProgress.removeGlobalBinding(keyStrokeList, actionData);
    }

    private void addNonGlobalBinding(Context context, ActionData actionData, int n, KeyStrokeList keyStrokeList) {
        this.fSetInProgress.addCustomKeyBinding(context, (ActionDataID)actionData, keyStrokeList);
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>();
        for (int i = 0; i != this.fShortcutTableModel.getRowCount(); ++i) {
            ActionShortcut actionShortcut = (ActionShortcut)this.fShortcutTableModel.fTableEntries.get(i);
            if (i == n) {
                ShortcutModifierPanel.addBindingIfNonNull(arrayList, keyStrokeList);
                continue;
            }
            if (actionShortcut.isSharedShortcut() || !actionShortcut.getSelectedContexts().contains(context)) continue;
            ShortcutModifierPanel.addBindingIfNonNull(arrayList, actionShortcut.getShortcut());
        }
        this.fSetInProgress.prioritizeCustomBindings(context, actionData, arrayList);
    }

    private void removeNonGlobalBinding(List<Context> list, ActionData actionData, int n, KeyStrokeList keyStrokeList) {
        for (Context context : list) {
            boolean bl = true;
            for (int i = 0; i != this.fShortcutTableModel.getRowCount(); ++i) {
                ActionShortcut actionShortcut;
                if (i == n || (actionShortcut = (ActionShortcut)this.fShortcutTableModel.fTableEntries.get(i)).isSharedShortcut() || !keyStrokeList.equals((Object)actionShortcut.getShortcut()) || !actionShortcut.getSelectedContexts().contains(context)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.fSetInProgress.removeCustomKeyBinding(keyStrokeList, context, (ActionDataID)actionData);
        }
    }

    private static void addBindingIfNonNull(List<KeyStrokeList> list, KeyStrokeList keyStrokeList) {
        if (keyStrokeList != null) {
            list.add(keyStrokeList);
        }
    }

    private List<Context> addContextFollowingComponentsToList(List<Context> list, ActionData actionData) {
        LinkedList<Context> linkedList = new LinkedList<Context>(list);
        for (Context context : this.fManager.getContextsWithAction((ActionDataID)actionData)) {
            if (linkedList.contains(context) || !list.contains(this.fSetInProgress.getModifiableSet().getFollowsContext(context, (ActionDataID)actionData))) continue;
            linkedList.add(context);
        }
        return linkedList;
    }

    private boolean isLastCellSelected() {
        return this.fShortcutTable.getRowCount() > 0 && this.fShortcutTable.getSelectedRow() == this.fShortcutTable.getRowCount() - 1 && this.fShortcutTable.getSelectedColumn() == 2;
    }

    private boolean isFirstCellSelected() {
        return this.fShortcutTable.getSelectedRow() == 0 && this.fShortcutTable.getSelectedColumn() == 0;
    }

    private boolean isTableEmpty() {
        return this.fShortcutTable.getRowCount() == 0;
    }

    private void editRowEntry(int n) {
        this.fShortcutTable.addRowSelectionInterval(n, n);
        this.fShortcutTable.scrollRectToVisible(this.fShortcutTable.getCellRect(n, 1, true));
        this.fShortcutTable.editCellAt(n, 1);
        this.fKeyStrokeEditor.requestFocusInActiveEditor();
    }

    void setContextSelected(Context context, boolean bl, int n) {
        TableCellEditor tableCellEditor = this.selectCellAndEdit(n, 2);
        assert (tableCellEditor instanceof ContextListEditor);
        ContextListModel contextListModel = (ContextListModel)tableCellEditor.getCellEditorValue();
        for (int i = 0; i != contextListModel.getAllContexts().size(); ++i) {
            Context context2 = contextListModel.getAllContexts().get(i);
            if (!context2.equals((Object)context)) continue;
            if (bl) {
                assert (!contextListModel.getSelectedContexts().contains(context)) : "Context is already selected";
                assert (!this.fContextCheckBoxList.getCheckModel().isIndexChecked(i)) : "Checkbox list is already selected";
                this.fContextCheckBoxList.getCheckModel().checkIndex(i);
                continue;
            }
            assert (contextListModel.getSelectedContexts().contains(context)) : "Context isn't selected";
            assert (this.fContextCheckBoxList.getCheckModel().isIndexChecked(i)) : "Checkbox list should be selected";
            this.fContextCheckBoxList.getCheckModel().uncheckIndex(i);
        }
        this.fShortcutTable.editingStopped(null);
    }

    void changeBinding(KeyStrokeList keyStrokeList, int n) {
        TableCellEditor tableCellEditor = this.selectCellAndEdit(n, 1);
        assert (tableCellEditor instanceof KeyStrokeEditor) : "Editor is wrong " + tableCellEditor;
        CustomShortcutField customShortcutField = ((KeyStrokeEditor)tableCellEditor).fActiveField;
        customShortcutField.typeKeyBinding(keyStrokeList);
    }

    KeyStrokeList getBinding(int n) {
        return (KeyStrokeList)this.fShortcutTable.getValueAt(n, 1);
    }

    void clearGlobalBinding() {
        this.changeBinding(null, 0);
    }

    int getShortcutTableNumRows() {
        return this.fShortcutTable.getRowCount();
    }

    private TableCellEditor selectCellAndEdit(int n, int n2) {
        this.fShortcutTable.setRowSelectionInterval(n, n);
        this.fShortcutTable.setColumnSelectionInterval(n2, n2);
        this.fShortcutTable.editCellAt(n, n2);
        return this.fShortcutTable.getCellEditor();
    }

    boolean isAddButtonEnabled() {
        return this.fAddButton.isEnabled();
    }

    boolean isDeleteButtonEnabled() {
        return this.fRemoveButton.isEnabled();
    }

    void addNewBinding(KeyStrokeList keyStrokeList) {
        assert (this.isAddButtonEnabled()) : "Can't add a new binding if the add button is disabled";
        int n = this.fShortcutTable.getRowCount();
        this.fAddButton.doClick();
        assert (this.fShortcutTable.getRowCount() > n) : "A row should have been added to the table after pressing the add button";
        this.changeBinding(keyStrokeList, this.fShortcutTable.getRowCount() - 1);
    }

    void deleteBinding() {
        assert (this.isDeleteButtonEnabled()) : "Can't delete the binding if the delete button is disabled";
        int n = this.fShortcutTable.getRowCount();
        assert (n > 0) : "Must be at least one row to delete";
        this.fRemoveButton.doClick();
        assert (this.fShortcutTable.getRowCount() <= n - 1) : "A row should have been deleted to the table after pressing the add button";
    }

    void selectKeybindingEntry(int n) {
        this.fShortcutTable.setRowSelectionInterval(n, n);
    }

    private class ConflictTableRenderer
    extends KeyBindingPanelUtils.ConflictRenderer {
        private ConflictTableRenderer() {
        }

        @Override
        public KeyBindingPanelUtils.ConflictType getConflictType(int n) {
            assert (ShortcutModifierPanel.this.fActionBeingEdited != null) : "No entries should exist in the table if an action is not selected";
            return KeyBindingPanelUtils.getConflictType(ShortcutModifierPanel.this.fManager, (KeyBindingSet)ShortcutModifierPanel.this.fSetInProgress.getModifiableSet(), ShortcutModifierPanel.this.fActionBeingEdited, ShortcutModifierPanel.this.fShortcutTableModel.getShortcut(n), ShortcutModifierPanel.this.addContextFollowingComponentsToList(ShortcutModifierPanel.this.fShortcutTableModel.getContextList(n).getSelectedContexts(), ShortcutModifierPanel.this.fActionBeingEdited));
        }
    }

    private static class ContextListEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ContextListModel fCurrentValue;

        private ContextListEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.fCurrentValue = (ContextListModel)object;
            MJLabel mJLabel = new MJLabel(this.fCurrentValue.toString());
            mJLabel.setFocusable(false);
            return mJLabel;
        }

        @Override
        public ContextListModel getCellEditorValue() {
            return this.fCurrentValue;
        }
    }

    public static class ContextListRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jComponent.setOpaque(false);
            jComponent.setForeground(KeyBindingPanelUtils.getTableForegroundColor(jTable, bl));
            MJLabel mJLabel = new MJLabel((Icon)MiscellaneousIcon.DROP_DOWN_ARROW_5x3.getIcon());
            mJLabel.setOpaque(false);
            mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.setBackground(KeyBindingPanelUtils.getTableBackgroundColor(jTable, n, bl));
            mJPanel.add((Component)jComponent, (Object)"West");
            mJPanel.add((Component)mJLabel, (Object)"East");
            return mJPanel;
        }
    }

    private static class ContextListModel
    extends AbstractListModel {
        private final List<Context> fAllContexts;
        private List<Context> fSelectedContexts;
        private boolean fIsSharedShortcut;

        private ContextListModel(Collection<Context> collection, List<Context> list, boolean bl) {
            this.fAllContexts = new ArrayList<Context>(collection);
            Collections.sort(this.fAllContexts);
            this.setSelectedContexts(list);
            this.fIsSharedShortcut = bl;
        }

        List<Context> getAllContexts() {
            return Collections.unmodifiableList(this.fAllContexts);
        }

        List<Context> getSelectedContexts() {
            return Collections.unmodifiableList(this.fSelectedContexts);
        }

        void setSelectedContexts(List<Context> list) {
            assert (this.fAllContexts.containsAll(list)) : "The selected contexts should be a subset of all contexts";
            this.fSelectedContexts = Collections.unmodifiableList(list);
        }

        void addSelectedContext(Context context) {
            assert (this.getAllContexts().contains(context)) : "The specified context must be in the list of all contexts supporting this action";
            ArrayList<Context> arrayList = new ArrayList<Context>(this.fSelectedContexts);
            arrayList.add(context);
            this.fSelectedContexts = Collections.unmodifiableList(arrayList);
        }

        List<Integer> getSelectedIndexes() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i != this.fAllContexts.size(); ++i) {
                if (!this.fSelectedContexts.contains(this.fAllContexts.get(i))) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        public String toString() {
            if (this.fSelectedContexts.containsAll(this.fAllContexts) && this.fAllContexts.size() > 1) {
                return KeyBindingPanelUtils.lookup("contextList.allContexts");
            }
            return KeyBindingPanelUtils.makeContextList(this.fSelectedContexts);
        }

        @Override
        public int getSize() {
            return this.fAllContexts.size();
        }

        @Override
        public String getElementAt(int n) {
            return this.fAllContexts.get(n).getName();
        }
    }

    private class ShortcutTableModel
    extends AbstractTableModel {
        private List<ActionShortcut> fTableEntries = new LinkedList<ActionShortcut>();

        private ShortcutTableModel() {
        }

        List<ActionShortcut> updateSelectedAction() {
            ActionData actionData;
            List<Context> list;
            this.fTableEntries = new LinkedList<ActionShortcut>();
            if (ShortcutModifierPanel.this.fActionBeingEdited != null && !(list = this.getContextsNotFollowingComponentWithAction(actionData = ShortcutModifierPanel.this.fActionBeingEdited)).isEmpty()) {
                LinkedList<Context> linkedList = new LinkedList<Context>();
                for (Context context : list) {
                    if (!ShortcutModifierPanel.this.fSetInProgress.followsGlobalContext(context, (ActionDataID)actionData)) continue;
                    linkedList.add(context);
                }
                for (KeyStrokeList keyStrokeList : ShortcutModifierPanel.this.fSetInProgress.getActionGlobalKeyBindings(actionData)) {
                    this.fTableEntries.add(new ActionShortcut(keyStrokeList, linkedList, list, true));
                }
                for (Context context : list) {
                    this.addNonGlobalBindings(this.fTableEntries, actionData, context, list);
                }
            }
            return Collections.unmodifiableList(this.fTableEntries);
        }

        private void addNonGlobalBindings(List<ActionShortcut> list, ActionData actionData, Context context, Collection<Context> collection) {
            for (KeyStrokeList keyStrokeList : ShortcutModifierPanel.this.fSetInProgress.getNonGlobalKeyBindings(context, (ActionDataID)actionData)) {
                boolean bl = false;
                for (ActionShortcut actionShortcut : list) {
                    if (actionShortcut.isSharedShortcut() || !actionShortcut.getShortcut().equals((Object)keyStrokeList)) continue;
                    actionShortcut.addEntryToSelectedContexts(context);
                    bl = true;
                    break;
                }
                if (bl) continue;
                list.add(new ActionShortcut(keyStrokeList, Arrays.asList(context), collection, false));
            }
        }

        int addNewEntryToTable(ActionData actionData) {
            LinkedList<Context> linkedList = new LinkedList<Context>(this.getContextsNotFollowingComponentWithAction(actionData));
            boolean bl = !this.hasSharedEntry() || ShortcutModifierPanel.containsSameElements(this.getSharedEntry().getSelectedContexts(), linkedList);
            ActionShortcut actionShortcut = new ActionShortcut(null, linkedList, linkedList, bl);
            this.fTableEntries.add(actionShortcut);
            ShortcutModifierPanel.this.fKeyStrokeEditor.addNewField(actionShortcut);
            int n = this.fTableEntries.size() - 1;
            this.fireTableRowsInserted(n, n);
            return n;
        }

        void removeEntryFromTable(int n) {
            assert (n < this.fTableEntries.size()) : "Specified row is out of range";
            this.fTableEntries.remove(n);
            ShortcutModifierPanel.this.fKeyStrokeEditor.removeField(n);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public int getRowCount() {
            return this.fTableEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int n) {
            return n == 1 ? KeyStrokeList.class : (n == 2 ? ContextListModel.class : String.class);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 1 ? this.getShortcut(n) : (n2 == 2 ? this.getContextList(n) : "");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        void updateActionShortcut(int n, List<Context> list) {
            this.fTableEntries.get(n).setSelectedContexts(list);
        }

        void updateSharedProperty(int n, boolean bl) {
            this.fTableEntries.get(n).setIsSharedShortcut(bl);
        }

        KeyStrokeList getShortcut(int n) {
            return this.fTableEntries.get(n).getShortcut();
        }

        ContextListModel getContextList(int n) {
            return this.fTableEntries.get(n).fContextListModel;
        }

        ContextListModel getSharedEntry() {
            return this.hasSharedEntry() ? this.getContextList(this.getKnownSharedIndex()) : null;
        }

        boolean hasSharedEntry() {
            return this.getRowCount() > 0;
        }

        int getKnownSharedIndex() {
            return 0;
        }

        private List<Context> getContextsNotFollowingComponentWithAction(ActionData actionData) {
            Collection collection = ShortcutModifierPanel.this.fManager.getContextsWithAction((ActionDataID)actionData);
            ArrayList<Context> arrayList = new ArrayList<Context>();
            for (Context context : collection) {
                if (ShortcutModifierPanel.this.fSetInProgress.getFollowsComponentContext(context, (ActionDataID)actionData)) continue;
                arrayList.add(context);
            }
            return arrayList;
        }
    }

    private class ShortcutTable
    extends MJTable {
        ShortcutTable(TableModel tableModel) {
            super(tableModel);
            this.setName("ShortcutModifierTable");
            Object object = this.getInputMap(1).get(KeyStroke.getKeyStroke(9, 0));
            final Action action = this.getActionMap().get(object);
            ShortcutModifierPanel.this.fTabAction = (Action)new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ShortcutModifierPanel.this.isTableEmpty() || ShortcutModifierPanel.this.isLastCellSelected()) {
                        ShortcutModifierPanel.this.fAddButton.requestFocusInWindow();
                    } else {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(object, ShortcutModifierPanel.this.fTabAction);
            Object object2 = this.getInputMap(1).get(KeyStroke.getKeyStroke(9, 1));
            final Action action2 = this.getActionMap().get(object2);
            ShortcutModifierPanel.this.fShiftTabAction = (Action)new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ShortcutModifierPanel.this.isTableEmpty() || ShortcutModifierPanel.this.isFirstCellSelected()) {
                        DefaultFocusManager.getCurrentManager().focusPreviousComponent();
                    } else {
                        action2.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(object2, ShortcutModifierPanel.this.fShiftTabAction);
            this.setTerminateEditOnFocusLost(true);
            this.setSurrendersFocusOnKeystroke(true);
            this.setDefaultEditor(KeyStrokeList.class, ShortcutModifierPanel.this.fKeyStrokeEditor);
            this.setDefaultRenderer(KeyStrokeList.class, new KeyStrokeRenderer(ShortcutModifierPanel.this.fTabActionHandler));
            this.setDefaultEditor(ContextListModel.class, new ContextListEditor());
            this.setDefaultRenderer(ContextListModel.class, new ContextListRenderer());
            TableColumnModel tableColumnModel = this.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(2);
            tableColumn.setPreferredWidth(260);
            tableColumn.setHeaderValue(KeyBindingPanelUtils.lookup("conflictPanel.table.componentsHeader"));
            tableColumnModel.getColumn(1).setHeaderValue(KeyBindingPanelUtils.lookup("conflictPanel.table.shortcutHeader"));
            TableColumn tableColumn2 = tableColumnModel.getColumn(0);
            tableColumn2.setHeaderValue("");
            tableColumn2.setCellRenderer(new ConflictTableRenderer());
            tableColumn2.setMaxWidth(KeyBindingPanelUtils.getConflictColumnWidth());
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ShortcutModifierPanel.this.updateRemoveButtonState();
                }
            });
            if (KeyBindingPanelUtils.SPACING_IS_TIGHT) {
                this.setRowHeight(this.getRowHeight() + 1);
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            return new Dimension((int)dimension.getWidth(), this.getRowHeight() * 3);
        }

        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            Component component = super.prepareEditor(tableCellEditor, n, n2);
            if (n2 == 2) {
                this.setTerminateEditOnFocusLost(false);
                this.showContextPopup(n, tableCellEditor);
            }
            return component;
        }

        public void removeEditor() {
            if (this.getEditingColumn() == 2) {
                this.hideContextPopup();
                this.setTerminateEditOnFocusLost(true);
            }
            super.removeEditor();
        }

        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (n2 == 0) {
                    assert (ShortcutModifierPanel.this.fActionBeingEdited != null) : "No shortcut table entries should exist if an action is not selected";
                    String string = KeyBindingPanelUtils.getConflictDescription(ShortcutModifierPanel.this.fManager, (KeyBindingSet)ShortcutModifierPanel.this.fSetInProgress.getModifiableSet(), ShortcutModifierPanel.this.fActionBeingEdited, ShortcutModifierPanel.this.fShortcutTableModel.getShortcut(n), ShortcutModifierPanel.this.addContextFollowingComponentsToList(ShortcutModifierPanel.this.fShortcutTableModel.getContextList(n).getSelectedContexts(), ShortcutModifierPanel.this.fActionBeingEdited));
                    jComponent.setToolTipText(string);
                }
            }
            return component;
        }

        private void setTerminateEditOnFocusLost(boolean bl) {
            this.putClientProperty("terminateEditOnFocusLost", bl);
        }

        private void showContextPopup(int n, final TableCellEditor tableCellEditor) {
            assert (tableCellEditor instanceof ContextListEditor) : "Should only go into showContextPopup with a ContextListEditor " + tableCellEditor;
            ContextListModel contextListModel = (ContextListModel)tableCellEditor.getCellEditorValue();
            final Rectangle rectangle = ShortcutModifierPanel.this.fShortcutTable.getCellRect(n, 2, true);
            final MJScrollPane mJScrollPane = new MJScrollPane();
            mJScrollPane.setBorder(ACTIVE_EDITOR_BORDER);
            ShortcutModifierPanel.this.fContextCheckBoxList = new CheckBoxList(contextListModel){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    int n = 0;
                    if (mJScrollPane.getBorder() != null) {
                        n = mJScrollPane.getBorder().getBorderInsets((Component)new CheckBoxList()).right;
                    }
                    return new Dimension(rectangle.width - n, dimension.height);
                }

                protected void processKeyEvent(KeyEvent keyEvent) {
                    ShortcutModifierPanel.this.fTabActionHandler.handleKeyEvent(keyEvent);
                    if (!keyEvent.isConsumed()) {
                        super.processKeyEvent(keyEvent);
                    }
                }
            };
            ShortcutModifierPanel.this.fContextCheckBoxList.getAccessibleContext().setAccessibleName(ShortcutModifierPanel.CONTEX_LIST_ACC_NAME);
            MJAbstractAction mJAbstractAction = new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutModifierPanel.this.fShortcutTable.removeEditor();
                    ShortcutModifierPanel.this.fShortcutTable.requestFocusInWindow();
                }
            };
            ShortcutModifierPanel.this.fContextCheckBoxList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "hide-context-popup");
            ShortcutModifierPanel.this.fContextCheckBoxList.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "hide-context-popup");
            ShortcutModifierPanel.this.fContextCheckBoxList.getActionMap().put("hide-context-popup", (Action)mJAbstractAction);
            ShortcutModifierPanel.this.fContextCheckBoxList.setFocusTraversalKeysEnabled(false);
            Object object = contextListModel.getSelectedIndexes().iterator();
            while (object.hasNext()) {
                int n2 = object.next();
                ShortcutModifierPanel.this.fContextCheckBoxList.getCheckModel().checkIndex(n2);
            }
            mJScrollPane.setViewportView((Component)ShortcutModifierPanel.this.fContextCheckBoxList);
            ShortcutModifierPanel.this.fContextCheckBoxList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    tableCellEditor.stopCellEditing();
                }
            });
            ShortcutModifierPanel.this.fContextCheckBoxList.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ShortcutTable.this.setTerminateEditOnFocusLost(true);
                        }
                    });
                }
            });
            ShortcutModifierPanel.this.fContextCheckBoxList.setVisibleRowCount(Math.min(10, contextListModel.getSize()));
            object = rectangle.getLocation();
            SwingUtilities.convertPointToScreen((Point)object, (Component)ShortcutModifierPanel.this.fShortcutTable);
            Insets insets = mJScrollPane.getBorder().getBorderInsets((Component)ShortcutModifierPanel.this.fContextCheckBoxList);
            if (PlatformInfo.isMacintosh()) {
                ShortcutModifierPanel.this.fContextPopup = MPopup.getResizablePopup((Component)ShortcutModifierPanel.this.fShortcutTable, (Component)mJScrollPane, (int)(((Point)object).x - insets.left), (int)(((Point)object).y - insets.top));
                Window window = SwingUtilities.windowForComponent((Component)mJScrollPane);
                if (window != null) {
                    window.setFocusableWindowState(true);
                }
            } else {
                ShortcutModifierPanel.this.fContextPopup = MPopup.getPopup((Component)ShortcutModifierPanel.this.fShortcutTable, (Component)mJScrollPane, (int)(((Point)object).x - insets.left), (int)(((Point)object).y - insets.top));
            }
            ShortcutModifierPanel.this.fContextPopup.show();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShortcutModifierPanel.this.fContextCheckBoxList.requestFocusInWindow();
                    ShortcutModifierPanel.this.fContextCheckBoxList.setSelectionInterval(0, 0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hideContextPopup() {
            assert (ShortcutModifierPanel.this.fContextPopup != null) : "Should not go into hiding the context popup if it is null";
            assert (ShortcutModifierPanel.this.fActionBeingEdited != null) : "The context popup should not have been displayed if no action is selected";
            ActionData actionData = ShortcutModifierPanel.this.fActionBeingEdited;
            TableCellEditor tableCellEditor = ShortcutModifierPanel.this.fShortcutTable.getCellEditor();
            assert (tableCellEditor instanceof ContextListEditor) : "Wrong editor type returned " + tableCellEditor;
            int n = ShortcutModifierPanel.this.fShortcutTable.getEditingRow();
            assert (n != -1) : "We are removing the editor, so getEditingRow can not return -1";
            try {
                ShortcutModifierPanel.this.fSetInProgress.suspendEventFiring();
                KeyStrokeList keyStrokeList = ShortcutModifierPanel.this.fShortcutTableModel.getShortcut(n);
                ContextListModel contextListModel = (ContextListModel)tableCellEditor.getCellEditorValue();
                List list = ShortcutModifierPanel.this.getCheckedContexts(contextListModel, n);
                if (ShortcutModifierPanel.this.wasSharedShortcutAndStillIs(contextListModel, n)) {
                    for (Context context : contextListModel.fAllContexts) {
                        if (contextListModel.fSelectedContexts.contains(context) == list.contains(context)) continue;
                        ShortcutModifierPanel.this.fSetInProgress.changeFollowsGlobal(context, (ActionDataID)actionData, list.contains(context));
                    }
                    ShortcutModifierPanel.this.fShortcutTableModel.updateActionShortcut(n, list);
                    ShortcutModifierPanel.this.updateAllOtherRows(n, actionData);
                } else if (ShortcutModifierPanel.this.wasSharedShortcutButNoLongerIs(contextListModel, n)) {
                    ShortcutModifierPanel.this.changeToNonGlobal(n, ShortcutModifierPanel.this.getCheckedContexts(contextListModel, n), actionData);
                } else if (ShortcutModifierPanel.this.wasNonSharedButNowIsShared(contextListModel, n)) {
                    ShortcutModifierPanel.this.changeToGlobal(n, ShortcutModifierPanel.this.getCheckedContexts(contextListModel, n), actionData);
                } else {
                    if (keyStrokeList != null) {
                        for (Context context : contextListModel.getAllContexts()) {
                            if (contextListModel.getSelectedContexts().contains(context) && !list.contains(context)) {
                                ShortcutModifierPanel.this.removeNonGlobalBinding(Arrays.asList(context), actionData, n, keyStrokeList);
                                continue;
                            }
                            if (contextListModel.getSelectedContexts().contains(context) || !list.contains(context)) continue;
                            ShortcutModifierPanel.this.addNonGlobalBinding(context, actionData, n, keyStrokeList);
                        }
                    }
                    ShortcutModifierPanel.this.fShortcutTableModel.updateActionShortcut(n, list);
                }
            }
            finally {
                ShortcutModifierPanel.this.fSetInProgress.resumeEventFiring();
            }
            ShortcutModifierPanel.this.fContextPopup.hide();
        }
    }

    private static class KeyStrokeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final List<CustomShortcutField> fKeyBindingFields = new ArrayList<CustomShortcutField>();
        private CustomShortcutField fActiveField;
        private final ChangeListener fActiveFieldChangeListener;
        private final TabActionHandler fTabActionHandler;

        KeyStrokeEditor(ChangeListener changeListener, TabActionHandler tabActionHandler) {
            assert (changeListener != null) : "ChangeListener cannot be null";
            this.fActiveFieldChangeListener = changeListener;
            this.fTabActionHandler = tabActionHandler;
        }

        void populateShortcutFields(List<ActionShortcut> list) {
            this.fKeyBindingFields.clear();
            for (ActionShortcut actionShortcut : list) {
                this.addNewField(actionShortcut);
            }
        }

        void addNewField(ActionShortcut actionShortcut) {
            this.stopCellEditing();
            final CustomShortcutField customShortcutField = this.createEditor(actionShortcut.getShortcut());
            FocusAdapter focusAdapter = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (focusEvent.getComponent() == customShortcutField) {
                        customShortcutField.getTextField().requestFocusInWindow();
                    } else if (focusEvent.getComponent() == customShortcutField.getTextField()) {
                        customShortcutField.getTextField().selectAll();
                    }
                }
            };
            customShortcutField.getTextField().addFocusListener(focusAdapter);
            customShortcutField.addFocusListener(focusAdapter);
            this.fKeyBindingFields.add(customShortcutField);
        }

        private CustomShortcutField createEditor(KeyStrokeList keyStrokeList) {
            CustomShortcutField customShortcutField = new CustomShortcutField(keyStrokeList, this.fTabActionHandler);
            customShortcutField.setBorder(ACTIVE_EDITOR_BORDER);
            return customShortcutField;
        }

        void removeField(int n) {
            this.stopCellEditing();
            this.fKeyBindingFields.remove(n);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.updateActiveField(n);
            return this.fActiveField;
        }

        private void updateActiveField(int n) {
            assert (n < this.fKeyBindingFields.size()) : "The list of CustomShortcutFields does not match the table size";
            if (this.fActiveField != null) {
                this.fActiveField.removeChangeListener(this.fActiveFieldChangeListener);
            }
            this.fActiveField = this.fKeyBindingFields.get(n);
            this.fActiveField.addChangeListener(this.fActiveFieldChangeListener);
        }

        public KeyStrokeList getCellEditorValue() {
            assert (this.fActiveField != null) : "No active field has been set";
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)this.fActiveField.getShortcut();
            return keyboardShortcut == null || keyboardShortcut.getCount() == 0 ? null : new KeyStrokeList(keyboardShortcut.getKeyStrokes());
        }

        void requestFocusInActiveEditor() {
            assert (this.fActiveField != null) : "No active field has been set";
            this.fActiveField.getTextField().requestFocusInWindow();
        }
    }

    private static class KeyStrokeRenderer
    extends DefaultTableCellRenderer {
        private final TabActionHandler fTabActionHandler;

        KeyStrokeRenderer(TabActionHandler tabActionHandler) {
            this.fTabActionHandler = tabActionHandler;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.createRenderer((KeyStrokeList)object, KeyBindingPanelUtils.getTableBackgroundColor(jTable, n, bl), KeyBindingPanelUtils.getTableForegroundColor(jTable, bl), bl2);
        }

        private CustomShortcutField createRenderer(KeyStrokeList keyStrokeList, Color color, Color color2, boolean bl) {
            CustomShortcutField customShortcutField = new CustomShortcutField(keyStrokeList, this.fTabActionHandler);
            customShortcutField.setBorder(BorderFactory.createEmptyBorder(0, ACTIVE_EDITOR_BORDER.getBorderInsets((Component)((Object)customShortcutField)).left, 0, 0));
            customShortcutField.setForeground(color2);
            customShortcutField.getTextField().setForeground(color2);
            customShortcutField.setBackground(color);
            customShortcutField.getTextField().setBackground(color);
            if (bl) {
                customShortcutField.setBorder(FOCUS_CELL_BORDER);
            }
            return customShortcutField;
        }
    }

    private static class ActionShortcut {
        private KeyStrokeList fBinding;
        private final ContextListModel fContextListModel;

        private ActionShortcut(KeyStrokeList keyStrokeList, List<Context> list, Collection<Context> collection, boolean bl) {
            this.fBinding = keyStrokeList;
            this.fContextListModel = new ContextListModel(collection, list, bl);
        }

        KeyStrokeList getShortcut() {
            return this.fBinding;
        }

        void setShortcut(KeyStrokeList keyStrokeList) {
            this.fBinding = keyStrokeList;
        }

        boolean isSharedShortcut() {
            return this.fContextListModel.fIsSharedShortcut;
        }

        void setIsSharedShortcut(boolean bl) {
            this.fContextListModel.fIsSharedShortcut = bl;
        }

        void addEntryToSelectedContexts(Context context) {
            this.fContextListModel.addSelectedContext(context);
        }

        List<Context> getSelectedContexts() {
            return this.fContextListModel.getSelectedContexts();
        }

        void setSelectedContexts(List<Context> list) {
            this.fContextListModel.setSelectedContexts(list);
        }
    }
}

