/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ImportFileChooser {
    private static MJFileChooserPerPlatform sMJFCPP;

    private ImportFileChooser() {
    }

    public static void showImportFileDialog(Component component) {
        sMJFCPP.setCurrentDirectory(new File(MatlabPath.getCWD()));
        sMJFCPP.showOpenDialog((Component)MJFrame.getFrame((Component)component));
    }

    public static File getSelectedFile() {
        return sMJFCPP.getSelectedFile();
    }

    public static int getState() {
        return sMJFCPP.getState();
    }

    static {
        ImportFileFilter importFileFilter = new ImportFileFilter("Recognized Data Files", new String[]{".gif", ".cur", ".hdf", ".ico", ".jpg", ".jpeg", ".mat", ".avi", ".png", ".au", ".snd", ".wav", ".csv", ".xls", ".xlsx", ".wk1", ".tif", ".tiff", ".txt", ".dat", ".dlm", ".tab", ".bmp", ".pcx"}, false);
        ImportFileFilter[] importFileFilterArray = new ImportFileFilter[]{new ImportFileFilter("CompuServe Graphics Interchange", new String[]{".gif"}), new ImportFileFilter("Cursor Format", new String[]{".cur"}), new ImportFileFilter("HDF or HDF-EOS", new String[]{".hdf"}), new ImportFileFilter("Icon Format", new String[]{".ico"}), new ImportFileFilter("JPEG Compilant", new String[]{".jpg", ".jpeg"}), new ImportFileFilter("MATLAB Data File", new String[]{".mat"}), new ImportFileFilter("Movie", new String[]{".avi"}), new ImportFileFilter("Portable Network Graphics", new String[]{".png"}), new ImportFileFilter("Sound", new String[]{".au", ".snd", ".wav"}), new ImportFileFilter("Spreadsheet", new String[]{".csv", ".xls", ".xlsx", ".wk1"}), new ImportFileFilter("Tagged Image File Format", new String[]{".tif", ".tiff"}), new ImportFileFilter("Text", new String[]{".txt", ".dat", ".dlm", ".tab"}), new ImportFileFilter("Windows or OS/2 Bitmap", new String[]{".bmp"}), new ImportFileFilter("Zsoft Paintbrush", new String[]{".pcx"})};
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPath.getCWD());
        mJFileChooserPerPlatform.setDialogTitle(WorkspaceResources.getResource("dialog.import.title"));
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)importFileFilter);
        for (ImportFileFilter importFileFilter2 : importFileFilterArray) {
            mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)importFileFilter2);
        }
        sMJFCPP = mJFileChooserPerPlatform;
    }

    private static class ImportFileFilter
    extends FileFilter
    implements FilePatternFilter {
        private String fDescription;
        private String[] fExtensions;
        private boolean fShow;

        private ImportFileFilter(String string, String[] stringArray) {
            this(string, stringArray, true);
        }

        private ImportFileFilter(String string, String[] stringArray, boolean bl) {
            this.fDescription = string;
            this.fExtensions = stringArray;
            this.fShow = bl;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean bl = false;
            String string = file.getName();
            for (String string2 : this.fExtensions) {
                bl |= string.endsWith(string2);
            }
            return bl;
        }

        @Override
        public String getDescription() {
            String string;
            if (!this.fShow) {
                return this.fDescription;
            }
            if (this.fExtensions.length == 1) {
                string = '*' + this.fExtensions[0];
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.fExtensions.length; ++i) {
                    stringBuilder.append('*').append(this.fExtensions[i]);
                    if (i >= this.fExtensions.length - 1) continue;
                    stringBuilder.append(", ");
                }
                string = stringBuilder.toString();
            }
            return this.fDescription + " (" + string + ')';
        }

        public String[] getPatterns() {
            int n = this.fExtensions.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = '*' + this.fExtensions[i];
            }
            return stringArray;
        }
    }
}

