/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;

public class WorkspacePrefs {
    private static final String CLEAR_KEY = "WorkspaceBrowserClearConfirmation";
    private static final String USE_NANS_KEY = "WorkspaceBrowserUseNaNs";
    private static final String STAT_NUMEL_LIMIT = "WorkspaceBrowserStatNumelLimit";
    private static final int STAT_NUMEL_LIMIT_DEFAULT = 500000;

    private WorkspacePrefs() {
    }

    public static String getDeleteConfirmationKey() {
        return CLEAR_KEY;
    }

    public static void setUseNaNsForStatCalculations(boolean bl) {
        Prefs.setBooleanPref((String)USE_NANS_KEY, (boolean)bl);
    }

    public static boolean getUseNaNsForStatCalculations() {
        return Prefs.getBooleanPref((String)USE_NANS_KEY, (boolean)true);
    }

    public static void addUseNaNsForStatCalculationsListener(PrefListener prefListener) {
        Prefs.addListener((PrefListener)prefListener, (String)USE_NANS_KEY);
    }

    public static void removeUseNaNsForStatCalculationsListener(PrefListener prefListener) {
        Prefs.removeListener((PrefListener)prefListener, (String)USE_NANS_KEY);
    }

    public static void setStatCalculationsNumelLimit(int n) {
        Prefs.setIntegerPref((String)STAT_NUMEL_LIMIT, (int)n);
    }

    public static int getStatCalculationsNumelLimit() {
        return Prefs.getIntegerPref((String)STAT_NUMEL_LIMIT, (int)500000);
    }

    public static void addStatCalculationsNumelLimitListener(PrefListener prefListener) {
        Prefs.addListener((PrefListener)prefListener, (String)STAT_NUMEL_LIMIT);
    }

    public static void removeStatCalculationsNumelLimitListener(PrefListener prefListener) {
        Prefs.removeListener((PrefListener)prefListener, (String)STAT_NUMEL_LIMIT);
    }
}

