/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace.graphics;

import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.DebugUtils;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GraphingActionFactory {
    private static Collection<WeakReference<IGraphingActionListener>> sGraphingActionListeners = new Vector<WeakReference<IGraphingActionListener>>();
    private static String[] sCachedVariableNamesForGraphingActions;
    private static MJAbstractAction[] sCachedGraphingActions;
    private static final Object GAL_LOCK;

    private GraphingActionFactory() {
    }

    public static MJAbstractAction getNewFigureAction() {
        GraphingAction graphingAction = new GraphingAction("new-figure", "figure;", "NewFigure");
        graphingAction.setName(WorkspaceResources.getBundle().getString("Action.new-figure.Label"));
        return graphingAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGraphingActionListener(IGraphingActionListener iGraphingActionListener) {
        Object object = GAL_LOCK;
        synchronized (object) {
            sGraphingActionListeners.add(new WeakReference<IGraphingActionListener>(iGraphingActionListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGraphingActionListener(IGraphingActionListener iGraphingActionListener) {
        Vector<WeakReference<IGraphingActionListener>> vector;
        Iterator iterator = GAL_LOCK;
        synchronized (iterator) {
            vector = new Vector<WeakReference<IGraphingActionListener>>(sGraphingActionListeners);
        }
        for (WeakReference weakReference : vector) {
            if (weakReference.get() == null || !((IGraphingActionListener)weakReference.get()).equals(iGraphingActionListener)) continue;
            Object object = GAL_LOCK;
            synchronized (object) {
                sGraphingActionListeners.remove(weakReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireGraphingActionsChanged() {
        Vector<WeakReference<IGraphingActionListener>> vector;
        Iterator iterator = GAL_LOCK;
        synchronized (iterator) {
            vector = new Vector<WeakReference<IGraphingActionListener>>(sGraphingActionListeners);
        }
        for (WeakReference weakReference : vector) {
            if (weakReference.get() == null) continue;
            ((IGraphingActionListener)weakReference.get()).graphingActionsChanged();
        }
    }

    public static MJAbstractAction getNewPlotToolAction() {
        return new GraphingAction("plot-tools", "figure; plottools;", "NewPlotTool");
    }

    public static MJAbstractAction[] getGraphingActions(final String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return new GraphingAction[0];
        }
        if (!bl && Arrays.equals(stringArray, sCachedVariableNamesForGraphingActions)) {
            return sCachedGraphingActions;
        }
        Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<List<String[]>>(){

            public void callOnEdt(List<String[]> list, boolean bl) {
            }

            public List<String[]> call() throws Exception {
                return ModelStateFactory.getGraphingPlotActions(stringArray);
            }
        });
        try {
            Object v = future.get(3000L, TimeUnit.MILLISECONDS);
            if (v instanceof List) {
                List list = (List)v;
                MJAbstractAction[] mJAbstractActionArray = new GraphingAction[list.size()];
                for (int i = 0; i < mJAbstractActionArray.length; ++i) {
                    String[] stringArray2 = (String[])list.get(i);
                    mJAbstractActionArray[i] = new GraphingAction(stringArray2[0], stringArray2[1]);
                    mJAbstractActionArray[i].setComponentName(stringArray2[0]);
                }
                sCachedGraphingActions = mJAbstractActionArray;
                sCachedVariableNamesForGraphingActions = stringArray;
                return mJAbstractActionArray;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
            assert (DebugUtils.outputException((Throwable)new ExecutionException(executionException)));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return new GraphingAction[0];
    }

    static {
        sCachedGraphingActions = new GraphingAction[0];
        GAL_LOCK = new Object();
    }

    private static class GraphingAction
    extends MJAbstractAction {
        private String fCommand = null;

        private GraphingAction(String string, String string2) {
            this.setName(string);
            this.setTip(string);
            this.fCommand = string2;
        }

        private GraphingAction(String string, String string2, String string3) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("WorkspaceBrowser", string, (ExtendedAction)this);
            this.setComponentName(string3);
            this.fCommand = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLExecuteServices.executeCommand((String)this.fCommand);
        }
    }
}

